/*
 * Decompiled with CFR 0.152.
 */
package jun.db.rpc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import jun.db.core.Logger;
import jun.db.util.TimeMark;
import jun.db.util.ZDataParser;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class DBF {
    private static Hashtable poolMap = new Hashtable();
    private static SimpleDateFormat SDF = new SimpleDateFormat("dd\u65e5HH:mm:ss");
    private static DBF dbf = null;
    private static int Count = 0;

    private DBF() {
    }

    public static void clearPoolMap() {
        poolMap.clear();
    }

    public static DBF getInstance() {
        DBF dbf = new DBF();
        return dbf;
    }

    public static void GetPool(String name) {
        if (name.equals("default") || name.equals("")) {
            name = "jdbc/wisestudio_oa";
        }
        if (poolMap == null) {
            poolMap = new Hashtable();
        }
        if (poolMap.containsKey(name)) {
            return;
        }
        Context env = null;
        try {
            env = (Context)new InitialContext().lookup("java:comp/env");
            DataSource _pool = (DataSource)env.lookup(name);
            if (_pool == null) {
                throw new Exception("not found database");
            }
            poolMap.put(name, _pool);
        }
        catch (Exception e) {
            Logger.error("GetPool\u53d1\u751f\u5f02\u5e38\uff1aname=" + name + "  \u9519\u8bef\u4e3a\uff1a" + e.getMessage());
        }
    }

    public Connection getConnection() {
        return this.getConnection("default");
    }

    public Connection getConnection(int timeOutSecond) {
        return this.getConnection("default", timeOutSecond, 1);
    }

    public Connection getConnection(String name) {
        return this.getConnection(name, 6000, 1);
    }

    public Connection getConnection(String name, int timeOutSecond, int tryTimes) {
        DataSource _pool;
        block19: {
            if (name.equals("default") || name.equals("")) {
                name = "jdbc/wisestudio_oa";
            }
            if (name.startsWith("<")) {
                return this.createConnection(name);
            }
            try {
                String[] aliases = ProxoolFacade.getAliases();
                boolean exists = false;
                int i = 0;
                while (i < aliases.length) {
                    if (aliases[i].equals(name)) {
                        exists = true;
                        break;
                    }
                    ++i;
                }
                if (exists) {
                    Class.forName("org.logicalcobwebs.proxool.ProxoolDriver");
                    Connection con = DriverManager.getConnection("proxool." + name);
                    return con;
                }
            }
            catch (Exception e) {
                if (tryTimes > 5) {
                    Logger.info(String.valueOf(e.getClass().getName()) + "\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff1a" + name + " \u5728 " + SDF.format(new Date()) + ":" + e.getMessage());
                }
                try {
                    String s = "\u6ca1\u6709\u83b7\u5f97\u8fde\u63a5\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage() + "   \u91cd\u65b0\u7b2c" + ++tryTimes + "\u6b21\u7533\u8bf7";
                    Thread.sleep(2000L);
                    Connection ret = this.getConnection(name, timeOutSecond, tryTimes);
                    if (ret != null) {
                        s = String.valueOf(s) + "      \u7b2c" + tryTimes + "\u6b21\u91cd\u65b0\u7533\u8bf7\u8fde\u63a5\u6210\u529f\u3002";
                    }
                    return ret;
                }
                catch (Exception s) {
                    // empty catch block
                }
            }
            try {
                TimeMark tm = new TimeMark();
                DBF.GetPool(name);
                _pool = null;
                if (poolMap.containsKey(name)) {
                    _pool = (DataSource)poolMap.get(name);
                }
                if (_pool != null) break block19;
                Throwable obj = new Throwable();
                obj.printStackTrace();
                return null;
            }
            catch (Exception e) {
                if (tryTimes > 3) {
                    Logger.error(String.valueOf(e.getClass().getName()) + "\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff1a" + name + " \u5728 " + SDF.format(new Date()) + ":" + e.getMessage());
                } else {
                    try {
                        Thread.sleep(500L);
                        Logger.error("\u6ca1\u6709\u83b7\u5f97\u8fde\u63a5\uff0c\u91cd\u65b0\u7b2c" + ++tryTimes + "\u6b21\u7533\u8bf7");
                        return this.getConnection(name, timeOutSecond, tryTimes);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
        Connection con = _pool.getConnection();
        this.setAutoCommit(con, true);
        ++Count;
        return con;
    }

    private Connection createConnection(String name) {
        ZDataParser zdp = new ZDataParser(name);
        String driver = zdp.get("driver", "");
        String url = zdp.get("url", "");
        String username = zdp.get("username", "");
        String password = zdp.get("password", "");
        try {
            Class.forName(driver);
            Connection con = DriverManager.getConnection(url, username, password);
            return con;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return null;
        }
    }

    public synchronized void ReleaseConnection(Connection con) {
        if (con == null) {
            return;
        }
        try {
            if (con.isClosed()) {
                return;
            }
            --Count;
            con.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAutoCommit(Connection con, boolean bool) {
        try {
            boolean b = con.getAutoCommit();
            if (b != bool) {
                con.setAutoCommit(bool);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit(Connection con) {
        try {
            con.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setAutoCommit(con, true);
    }

    public void rollback(Connection con) {
        try {
            con.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setAutoCommit(con, true);
    }

    public static String getConnectionProperty(String name, String propertyName, String defaultValue) {
        if (name.equals("default") || name.equals("")) {
            name = "jdbc/wisestudio_oa";
        }
        try {
            Properties p = ProxoolFacade.getConnectionPoolDefinition((String)name).getCompleteInfo();
            return p.getProperty(propertyName, defaultValue);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return defaultValue;
        }
    }

    public static String getConnectionDatabaseCharset(String name) {
        return DBF.getConnectionProperty(name, "proxool.database-charset", "");
    }

    public static String getConnectionClientCharset(String name) {
        return DBF.getConnectionProperty(name, "proxool.client-charset", "");
    }

    public static int getConnectMaximumActiveTime(String name) {
        String s = DBF.getConnectionProperty(name, "proxool.maximum-active-time", "0");
        try {
            return new Integer(s) / 1000;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

