/*
 * Decompiled with CFR 0.152.
 */
package jun.db.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jun.db.core.ColumnProperty;
import jun.db.core.DataAdapter;
import jun.db.core.DataBuffer;
import jun.db.core.DataStore;
import jun.db.core.DataStoreEventManager;
import jun.db.core.DsRow;
import jun.db.core.DsSqlInfo;
import jun.db.core.ErrorInfo;
import jun.db.core.FilterRole;
import jun.db.core.Logger;
import jun.db.core.ObjectTool;
import jun.db.core.SqlRunInfo;
import jun.db.impl.AutoCheckConfig;
import jun.db.impl.ColumnProperty_;
import jun.db.impl.DataAdapterDefault;
import jun.db.impl.DataAdapterH2;
import jun.db.impl.DataAdapterHypersonicSQL;
import jun.db.impl.DataAdapterJConnect;
import jun.db.impl.DataAdapterJTDS;
import jun.db.impl.DataAdapterMySQL;
import jun.db.impl.DataAdapterOracle;
import jun.db.impl.DataAdapterPostgres;
import jun.db.impl.DataAdapterSQLServer;
import jun.db.impl.DataBuffer_;
import jun.db.impl.DataStoreEventManager_;
import jun.db.impl.DataStoreFactory;
import jun.db.impl.DsItem;
import jun.db.impl.DsRow_;
import jun.db.impl.ErrorInfo_;
import jun.db.impl.OrderByConfig;
import jun.db.impl.Sequence;
import jun.db.rpc.DataStoreRemoteFactory;
import jun.db.rpc.RPC;
import jun.db.rpc.RPCParameter;
import jun.db.util.Base64Coder;
import jun.db.util.FileTools;
import jun.db.util.TimeMark;
import jun.db.util.ZDataParser;
import jun.xml.write.XmlWriter;
import org.apache.regexp.RE;
import org.json.JSONObject;

class DataStore_
extends Throwable
implements Serializable,
DataStore,
Cloneable {
    private static final long serialVersionUID = 3499565368543214097L;
    private static final String WITHLASTSELECT = "@WITH-LAST-SELECT@";
    private String gguid = DataStoreFactory.newGUID();
    private transient DataStoreEventManager_ m_Event = null;
    private transient ResultSet m_RS = null;
    private transient Connection m_Connection = null;
    private boolean m_autoDeleteNoDataRow = true;
    private int guardLine = 200000;
    private boolean needNotifyAggregateAndUnsureComputerInvalid = true;
    private DataAdapter m_DataAdapter = null;
    ErrorInfo m_Error;
    DataBuffer_ m_PrimaryBuffer = new DataBuffer_(0, this);
    DataBuffer_ m_DeleteBuffer = new DataBuffer_(0, this);
    DataBuffer_ m_FilterBuffer = new DataBuffer_(0, this);
    ArrayList m_ColumnProperty = new ArrayList();
    Hashtable m_ColumnName2Index = new Hashtable();
    HashMap m_Express2DependList = new HashMap();
    HashMap m_DepentList2DependCol = new HashMap();
    private int m_FieldCount = 0;
    HashMap m_Tag = new HashMap();
    ArrayList m_OrderByConfig = new ArrayList();
    boolean m_Updatable = false;
    String m_UpdateTable = "";
    String m_PrimaryKey = "";
    String m_UpdatableColumns = "";
    String m_WhereClauseColumns = "";
    String m_Select = "";
    String m_SelectLastRetrieved = "";
    String m_AdditionalWhere = "";
    ArrayList m_AdditionalParam = new ArrayList();
    String m_NameInScript = "";
    String m_OrderBy = "";
    String m_FilterBy = "";
    boolean m_SetValueWithRiskMode = false;
    boolean m_SetValueWithTrigger = true;
    boolean m_HadParsedColumnProperty = false;
    boolean m_CloseResultsetAfterRetrieveOnce = true;
    boolean m_AutoResetBeforeRetrieve = true;
    Hashtable m_MaxIDMap = new Hashtable();
    ArrayList m_VectorAutoCheck = new ArrayList();
    HashMap<String, HashMap<String, Integer>> m_QuickValue2Row = null;
    String m_GroupRules = "";
    ArrayList m_VectorGroupCols = new ArrayList();
    ArrayList m_VectorGroups = new ArrayList();
    Hashtable m_MapGroups = new Hashtable();
    String m_ListSeparator = ",";
    int m_absolute = 1;
    int m_OnceRetrieveCount = 0;
    int m_OnceRetrieveTimeout = 0;
    int m_retrieveTimes = 0;
    Integer m_DBRowCount = null;
    String m_DBCharset = null;
    String m_Charset = null;
    boolean m_CharsetAutoConvert = false;
    String RemoteFactoryURL = "";
    String DBPoolName = "";
    boolean m_AutoTrim = true;
    boolean m_IsProcedure = false;
    String m_ProcedureName = "";
    ArrayList m_ProcedureParamType;
    String m_AsNoDataIfOnlySuchColumnsHoldData = "id|gguid|inner_xh|wiseoalastmodifydate|wise_parent_id";
    ArrayList sqlBatch = new ArrayList();
    ArrayList sqlBatch2 = new ArrayList();
    boolean m_blobUnRetrieve = false;
    private transient ArrayList needReleaseCmdList = new ArrayList();
    int m_timeout = 0;
    int m_currentFocusRow = -1;
    WeakReference<DataStore> mirrorFrom = null;

    public DataStore_() {
        this.Init();
    }

    public void setTimeout(int t) {
        this.m_timeout = Math.max(0, t);
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void InsureJEPisValid() {
    }

    private void Init() {
        this.m_Event = new DataStoreEventManager_();
        this.m_Error = new ErrorInfo_();
        this.InsureJEPisValid();
    }

    public DataStore_(Connection con, String sql) {
        this.Init();
        this.setConnection(con);
        this.setSelect(sql);
    }

    public void clearBuffer() {
        this.m_PrimaryBuffer.clear();
        this.m_DeleteBuffer.clear();
        this.m_FilterBuffer.clear();
        this.sqlBatch.clear();
        this.sqlBatch2.clear();
    }

    public void reset() {
        this.m_retrieveTimes = 0;
        this.m_PrimaryBuffer.clear();
        this.m_DeleteBuffer.clear();
        this.m_FilterBuffer.clear();
        this.close();
        this.sqlBatch.clear();
        this.sqlBatch2.clear();
        this.m_DBRowCount = null;
        this.m_QuickValue2Row = null;
        this.getEvent().fireAfterReset();
    }

    public void setUpdateProperty(String table, String primaryKey, String updatableCols, String whereClauseCols) {
        this.setUpdatable(true);
        this.setUpdatableTable(table);
        this.setPrimaryKey(primaryKey);
        this.setUpdatableColumns(updatableCols);
        this.setUpdateWhereClauseColumns(whereClauseCols);
    }

    public ErrorInfo getError() {
        if (this.m_Error == null) {
            this.m_Error = new ErrorInfo_();
        }
        return this.m_Error;
    }

    private void ClearError() {
        if (this.m_Error != null) {
            this.m_Error.clear();
        }
    }

    private void ResetColumnInfo() {
        this.m_ColumnName2Index.clear();
        this.m_ColumnProperty.clear();
        this.m_VectorAutoCheck.clear();
        this.m_MaxIDMap.clear();
        this.m_Express2DependList.clear();
        this.m_DepentList2DependCol.clear();
        this.m_AsNoDataIfOnlySuchColumnsHoldData = "";
    }

    private void AssumeConnectionIsValid() throws Exception {
        if (this.m_Connection == null) {
            throw new Exception("\u8bf7\u5148\u8bbe\u7f6e\u6570\u636e\u5e93\u8fde\u63a5");
        }
    }

    public void setConnection(Connection con) {
        this.m_Connection = con;
        this.setDataAdapter(DataStore_.createDataAdapter(con, this));
    }

    public static DataAdapter createDataAdapter(Connection con) {
        return DataStore_.createDataAdapter(con, null);
    }

    public static DataAdapter createDataAdapter(Connection con, DataStore_ ds) {
        String drv = "";
        try {
            drv = con.getMetaData().getDriverName();
        }
        catch (Exception e_) {
            e_.printStackTrace();
        }
        if (drv.equals("SQLServer")) {
            return new DataAdapterSQLServer(ds);
        }
        if (drv.equals("HypersonicSQL")) {
            return new DataAdapterHypersonicSQL(ds);
        }
        if (drv.equals("H2 JDBC Driver")) {
            return new DataAdapterH2(ds);
        }
        if (drv.startsWith("jTDS")) {
            return new DataAdapterJTDS(ds);
        }
        if (drv.startsWith("jConnect")) {
            return new DataAdapterJConnect(ds);
        }
        if (drv.startsWith("JDBC-ODBC Bridge")) {
            return new DataAdapterSQLServer(ds);
        }
        if (drv.startsWith("Oracle JDBC driver")) {
            return new DataAdapterOracle(ds);
        }
        if (drv.startsWith("PostgreSQL")) {
            return new DataAdapterPostgres(ds);
        }
        if (drv.startsWith("MySQL")) {
            return new DataAdapterMySQL(ds);
        }
        Logger.error("\u7cfb\u7edf\u5e76\u672a\u63d0\u4f9b\u5bf9" + drv + "\u7684\u7279\u522b\u652f\u6301\uff0c\u5c06\u4f7f\u7528\u7f3a\u7701\u7684DataAdapter");
        return new DataAdapterDefault(ds);
    }

    public Connection getConnection() {
        return this.m_Connection;
    }

    private void ReParseColumnTableProperty(ResultSetMetaData rsmd) {
        int colCount = 0;
        try {
            this.m_FieldCount = colCount = rsmd.getColumnCount();
            int i = 1;
            while (i <= colCount) {
                String colName = rsmd.getColumnLabel(i);
                if (colName == null) {
                    colName = "";
                }
                colName = colName.trim().toLowerCase();
                ColumnProperty_ cp = (ColumnProperty_)this.getColumnProperty(colName);
                cp.m_DBTable = cp.m_DBTable.trim();
                ++i;
            }
        }
        catch (SQLException sqlErr) {
            this.m_Error.parseError(sqlErr, this.getEvent());
        }
    }

    private boolean ParseColumnProperty(ResultSetMetaData rsmd) {
        int colCount = 0;
        try {
            this.m_FieldCount = colCount = rsmd.getColumnCount();
            int i = 1;
            while (i <= colCount) {
                String colName = rsmd.getColumnLabel(i);
                if (colName == null) {
                    colName = "";
                }
                colName = colName.trim().toLowerCase();
                ColumnProperty_ cp = new ColumnProperty_(this);
                cp.m_Name = colName;
                try {
                    cp.m_DBTable = rsmd.getTableName(i);
                    if (cp.m_DBTable == null) {
                        cp.m_DBTable = "";
                    }
                }
                catch (Exception te) {
                    cp.m_DBTable = "";
                }
                cp.m_DBTable = cp.m_DBTable.trim();
                cp.m_DBName = rsmd.getColumnName(i);
                cp.m_DBName = cp.m_DBName == null ? "" : cp.m_DBName.trim();
                cp.m_DatabaseName = rsmd.getSchemaName(i);
                if (rsmd.isWritable(i) || !rsmd.isWritable(i) && rsmd.isAutoIncrement(i)) {
                    cp.m_ObjType = 0;
                } else {
                    cp.m_ObjType = 1;
                    if (colName.equals("")) {
                        long ci = 0L;
                        while (this.m_ColumnName2Index.containsKey(colName = "compute_" + String.valueOf(ci))) {
                            ++ci;
                        }
                    }
                }
                if (this.m_ColumnName2Index.containsKey(colName)) {
                    colName = cp.m_Name = String.valueOf(cp.m_DBTable) + "_" + cp.m_DBName;
                }
                if (this.m_ColumnName2Index.containsKey(colName)) {
                    String t = colName;
                    long ci = 1L;
                    while (this.m_ColumnName2Index.containsKey(colName = String.valueOf(t) + String.valueOf(ci))) {
                        ++ci;
                    }
                }
                this.m_ColumnName2Index.put(colName, new Integer(i - 1));
                cp.m_UpdateWhereClause = false;
                cp.m_Updatable = false;
                cp.m_DataType = rsmd.getColumnType(i);
                cp.m_UniformDataType = ObjectTool.DataType2Uniform(cp.m_DataType);
                cp.m_ColumnLabel = rsmd.getColumnLabel(i);
                cp.m_DataTypeName = rsmd.getColumnTypeName(i);
                cp.ColumnDisplaySize = rsmd.getColumnDisplaySize(i);
                try {
                    cp.Precision = rsmd.getPrecision(i);
                }
                catch (Exception err) {
                    cp.Precision = 0;
                }
                cp.Scale = Math.max(0, rsmd.getScale(i));
                cp.Nullable = rsmd.isNullable(i) == 1;
                cp.m_ColumnClassName = rsmd.getColumnClassName(i);
                if (cp.Precision == 0) {
                    cp.Precision = cp.ColumnDisplaySize;
                }
                this.m_ColumnProperty.add(cp);
                ++i;
            }
            this.m_HadParsedColumnProperty = true;
        }
        catch (SQLException sqlErr) {
            this.m_Error.parseError(sqlErr, this.getEvent());
            return false;
        }
        this.m_PrimaryBuffer.InitColumnCount(colCount);
        this.m_FilterBuffer.InitColumnCount(colCount);
        this.m_DeleteBuffer.InitColumnCount(colCount);
        return colCount > 0;
    }

    public ColumnProperty getColumnProperty(int col) {
        if (col < 0) {
            return null;
        }
        return (ColumnProperty_)this.m_ColumnProperty.get(col);
    }

    public ColumnProperty getColumnProperty(String col) {
        int colindex = this.col2Index(col);
        return this.getColumnProperty(colindex);
    }

    public String getSelect() {
        return this.m_Select;
    }

    public String getSelectLastRetrieved() {
        return this.m_SelectLastRetrieved;
    }

    public void setSelectLastRetrieved(String sql) {
        this.m_SelectLastRetrieved = sql;
    }

    public String getAdditionalWhere() {
        return this.m_AdditionalWhere;
    }

    public void replaceSelect(String select) {
        this.m_Select = select;
    }

    public void setSelect(String sqlString) {
        block22: {
            this.ClearError();
            this.reset();
            this.ResetColumnInfo();
            this.m_ProcedureParamType = new ArrayList();
            try {
                this.AssumeConnectionIsValid();
            }
            catch (Exception e) {
                this.m_Error.parseError(e, this.getEvent());
                return;
            }
            String t = sqlString.trim();
            if (t.charAt(t.length() - 1) == ';') {
                t = t.substring(0, t.length() - 1);
            }
            this.m_Select = t;
            this.m_AdditionalWhere = "";
            this.m_AdditionalParam = new ArrayList();
            this.m_OrderBy = "";
            this.m_OrderByConfig.clear();
            String sql = this.m_Select.trim();
            Statement proc = null;
            try {
                try {
                    if (sql.toLowerCase().startsWith("select ")) {
                        this.m_IsProcedure = false;
                        sql = DataStoreFactory.LinkUpWhere(sql, "1=2");
                        sql = this.parseInnerParameter(sql, true);
                        sql = this.getDataAdapter().toLocalSyntax(sql);
                        if (this.m_CharsetAutoConvert) {
                            sql = DataStoreFactory.stringCharsetConvert(sql, this.m_Charset, this.m_DBCharset);
                        }
                        String drv = this.m_Connection.getMetaData().getDriverName();
                        int ct = 1005;
                        this.ParseColumn(sql, ct);
                        break block22;
                    }
                    this.m_IsProcedure = true;
                    t = this.m_Select.trim();
                    if (t.toLowerCase().startsWith("exec ")) {
                        t = t.substring("exec ".length()).trim();
                    } else if (t.toLowerCase().startsWith("execute ")) {
                        t = t.substring("execute ".length()).trim();
                    }
                    t = String.valueOf(t) + " ";
                    int p1 = t.indexOf(" ");
                    int p2 = t.indexOf("(");
                    if (p2 < 0) {
                        p2 = p1;
                    }
                    int p = Math.min(p1, p2);
                    this.m_ProcedureName = t.substring(0, p);
                    proc = this.m_Connection.prepareCall("  exec sp_sproc_columns  '" + this.m_ProcedureName + "' ");
                    ResultSet rs = proc.executeQuery();
                    rs.next();
                    while (rs.next()) {
                        int paramType = rs.getInt(6);
                        int javaParamType = ObjectTool.DataType2Uniform(paramType);
                        this.m_ProcedureParamType.add(new Integer(javaParamType));
                    }
                    rs.close();
                    rs = null;
                    this.ParseProcedureColumn();
                }
                catch (Exception sqlErr) {
                    Logger.error(String.valueOf(sql) + sqlErr.getMessage());
                    this.getError().parseError(sqlErr, this.getEvent());
                    if (proc == null) break block22;
                    try {
                        proc.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (proc != null) {
                    try {
                        proc.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public String parseInnerParameter(String sql, boolean useDetault) {
        RE re = new RE("\\s*(:\\s*([^\\{]+)\\s*\\{\\s*([^\\}]+)\\s*\\})\\s*");
        int startPos = 0;
        try {
            while (re.match(sql, startPos)) {
                String defaultValue;
                int i = 0;
                while (i < re.getParenCount()) {
                    ++i;
                }
                String parameterName = sql.substring(re.getParenStart(2), re.getParenEnd(2));
                String value = defaultValue = sql.substring(re.getParenStart(3), re.getParenEnd(3));
                if (!useDetault && (value = this.getEvent().fireParseInnerParameter(parameterName)) == null) {
                    value = defaultValue;
                }
                Logger.info("\u53c2\u6570\u540d\uff1a" + parameterName + "  \u7f3a\u7701\u503c\uff1a" + defaultValue + "\u5f53\u524d\u4f7f\u7528\u503c\uff1a" + value);
                sql = String.valueOf(sql.substring(0, re.getParenStart(1))) + value + sql.substring(re.getParenEnd(1));
                startPos = re.getParenStart(1) + value.length();
            }
            return sql;
        }
        catch (Exception e) {
            e.printStackTrace();
            return sql;
        }
    }

    boolean ParseColumn(String sql, int resultSetType) throws Exception {
        ResultSet rs = null;
        Statement cmd = null;
        try {
            boolean ret;
            ResultSetMetaData rsmd = null;
            cmd = this.m_Connection.createStatement();
            rs = cmd.executeQuery(sql);
            rsmd = rs.getMetaData();
            boolean bl = ret = this.ParseColumnProperty(rsmd);
            return bl;
        }
        catch (Exception sqlErr) {
            throw sqlErr;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                try {
                    rs.next();
                    rs.close();
                }
                catch (Exception exception) {}
            }
            rs = null;
            try {
                cmd.close();
            }
            catch (Exception exception) {}
        }
    }

    boolean ParseProcedureColumn() {
        ResultSet rs = null;
        Statement proc = null;
        try {
            String sql;
            String dbSql = sql = this.m_Select;
            if (this.m_CharsetAutoConvert) {
                dbSql = DataStoreFactory.stringCharsetConvert(sql, this.m_Charset, this.m_DBCharset);
            }
            dbSql = this.parseInnerParameter(dbSql, true);
            proc = this.m_Connection.prepareCall(dbSql);
            try {
                int i = 0;
                while (i < this.m_ProcedureParamType.size()) {
                    int pt = (Integer)this.m_ProcedureParamType.get(i);
                    switch (pt) {
                        case 4: {
                            proc.setDate(i + 1, new Date(new java.util.Date().getTime()));
                            break;
                        }
                        case 1: {
                            proc.setInt(i + 1, 1);
                            break;
                        }
                        case 2: {
                            proc.setBigDecimal(i + 1, new BigDecimal("1.2"));
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 99: {
                            proc.setString(i + 1, "a");
                        }
                    }
                    ++i;
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            this.m_RS = proc.executeQuery();
            ResultSetMetaData rsmd = this.m_RS.getMetaData();
            boolean bl = this.ParseColumnProperty(rsmd);
            return bl;
        }
        catch (Exception sqlErr) {
            Logger.error(sqlErr.getMessage());
            return false;
        }
        finally {
            try {
                if (proc != null) {
                    proc.close();
                }
            }
            catch (Exception e) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                try {
                    rs.next();
                    rs.close();
                }
                catch (Exception exception) {}
            }
            rs = null;
        }
    }

    public int retrieve(ArrayList data) {
        return this.retrieve(data, this.m_AutoResetBeforeRetrieve, false);
    }

    public int retrieve(ArrayList data, boolean append) {
        return this.retrieve(data, append, false);
    }

    public int retrieve(ArrayList data, boolean append, boolean withLastSelect) {
        this.m_Error.clear();
        if (!append) {
            this.reset();
        }
        if (data == null) {
            return 0;
        }
        int rowcount = 0;
        int ColCount = this.m_ColumnName2Index.size();
        HashMap m_RS = null;
        try {
            int row = 0;
            while (row < data.size()) {
                m_RS = (HashMap)data.get(row);
                DsRow_ tempRow = new DsRow_(ColCount, this);
                this.m_PrimaryBuffer.push_back(tempRow);
                tempRow.m_RowStatus = 0;
                int i = 0;
                while (i < ColCount) {
                    String colName = this.getColumnName(i);
                    Object v = m_RS.get(colName);
                    if (v != null) {
                        DsItem item = new DsItem();
                        item.m_CurrentValue = v;
                        item.m_OriginalValue = v;
                        item.m_ItemStatus = 0;
                        tempRow.set(i, item);
                    }
                    ++i;
                }
                ++row;
            }
        }
        catch (Exception e) {
            this.m_Error.parseError(e, this.getEvent());
        }
        this.reCreateGroups();
        this.m_PrimaryBuffer.notifyAggregateAndUnsureComputerInvalid();
        rowcount = this.getRowCount();
        this.getEvent().fireRetrieveOnceMoreEnd(this.m_retrieveTimes, rowcount);
        this.getEvent().fireRetrieveEnd(rowcount, withLastSelect);
        return rowcount;
    }

    public int retrieve(Object[] objects) {
        ArrayList<Object> p = new ArrayList<Object>();
        int i = 0;
        while (i < objects.length) {
            Object obj = objects[i];
            p.add(obj);
            ++i;
        }
        int n = this.retrieveProcedure(p);
        p.clear();
        return n;
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12, Object p13, Object p14, Object p15, Object p16, Object p17, Object p18, Object p19, Object p20) {
        ArrayList<Object> p = new ArrayList<Object>();
        p.add(p1);
        p.add(p2);
        p.add(p3);
        p.add(p4);
        p.add(p5);
        p.add(p6);
        p.add(p7);
        p.add(p8);
        p.add(p9);
        p.add(p10);
        p.add(p11);
        p.add(p12);
        p.add(p13);
        p.add(p14);
        p.add(p15);
        p.add(p16);
        p.add(p17);
        p.add(p18);
        p.add(p19);
        p.add(p20);
        return this.retrieveProcedure(p);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12, Object p13, Object p14, Object p15, Object p16, Object p17, Object p18, Object p19) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12, Object p13, Object p14, Object p15, Object p16, Object p17, Object p18) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12, Object p13, Object p14, Object p15, Object p16, Object p17) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12, Object p13, Object p14, Object p15, Object p16) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12, Object p13, Object p14, Object p15) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12, Object p13, Object p14) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12, Object p13) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, null, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, null, null, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, null, null, null, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, p9, null, null, null, null, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, p8, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, p7, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.retrieve(p1, p2, p3, p4, p5, p6, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.retrieve(p1, p2, p3, p4, p5, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3, Object p4) {
        return this.retrieve(p1, p2, p3, p4, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2, Object p3) {
        return this.retrieve(p1, p2, p3, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1, Object p2) {
        return this.retrieve(p1, p2, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public int retrieve(Object p1) {
        if (p1.toString().equals(WITHLASTSELECT)) {
            return this.retrieveProcedure(this.m_AdditionalParam, true);
        }
        return this.retrieve(p1, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public String test(Object obj) {
        return null;
    }

    public int importData(ArrayList data) {
        if (data == null) {
            return 0;
        }
        int rowcount = data.size();
        HashMap m_RS = null;
        try {
            int row = 0;
            while (row < rowcount) {
                m_RS = (HashMap)data.get(row);
                int newRow = this.insertRow(99999);
                for (String colName : m_RS.keySet()) {
                    Object v = m_RS.get(colName);
                    if (v == null) continue;
                    this.setValue(newRow, colName, v);
                }
                ++row;
            }
        }
        catch (Exception e) {
            this.m_Error.parseError(e, this.getEvent());
        }
        this.BuildAllAsOneGroup(this.m_VectorGroups);
        this.m_PrimaryBuffer.notifyAggregateAndUnsureComputerInvalid();
        return rowcount;
    }

    public int retrieve() {
        if (this.m_IsProcedure) {
            return this.retrieveProcedure(new ArrayList());
        }
        return this.retrieve("");
    }

    private void addToNeedReleaseCmdList(Statement cmd) {
        if (this.needReleaseCmdList == null) {
            this.needReleaseCmdList = new ArrayList();
        }
        this.needReleaseCmdList.add(cmd);
    }

    public int retrieveWithLastSelect() {
        return this.retrieve(WITHLASTSELECT);
    }

    public int retrieve(String where) {
        if (this.m_IsProcedure) {
            return this.retrieve((Object)where);
        }
        if (!this.RemoteFactoryURL.equals("")) {
            return this.retrieveRemote(where);
        }
        this.m_Error.clear();
        if (this.m_AutoResetBeforeRetrieve) {
            this.reset();
        }
        int rowcount = 0;
        if (this.m_Select.equals("")) {
            this.m_Error.parseError("\u8bf7\u5148\u8bbe\u7f6e Select ", this.getEvent());
            return 0;
        }
        try {
            this.AssumeConnectionIsValid();
        }
        catch (Exception e) {
            this.m_Error.parseError(e, this.getEvent());
            return 0;
        }
        String sql = this.m_Select;
        Statement cmd = null;
        try {
            try {
                String drv = this.m_Connection.getMetaData().getDriverName();
                if (!where.equals(WITHLASTSELECT)) {
                    this.m_AdditionalWhere = where;
                    sql = DataStoreFactory.LinkUpWhere(sql, this.m_AdditionalWhere);
                    sql = this.parseInnerParameter(sql, false);
                    sql = this.getDataAdapter().toLocalSyntax(sql);
                    if (this.m_CharsetAutoConvert) {
                        sql = DataStoreFactory.stringCharsetConvert(sql, this.m_Charset, this.m_DBCharset);
                    }
                    this.m_SelectLastRetrieved = sql;
                } else {
                    sql = this.m_SelectLastRetrieved;
                }
                DataStoreFactory.addToSQLHistory(this.gguid, new DsSqlInfo(sql, this.m_Connection.toString()));
                cmd = this.m_Connection.createStatement();
                DataAdapter da = this.getDataAdapter();
                da.setFetchSize(cmd);
                this.addToNeedReleaseCmdList(cmd);
                if (this.m_timeout > 0) {
                    try {
                        cmd.setQueryTimeout(this.m_timeout);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ExecutorService executor = Executors.newSingleThreadExecutor();
                FutureStatement futureCmd = new FutureStatement(cmd, sql, this.m_absolute, this.m_OnceRetrieveCount, da, this.isCloseResultsetAfterRetrieveOnce());
                Future future = executor.submit(futureCmd);
                long sqlRunStartAt = System.currentTimeMillis();
                try {
                    try {
                        this.m_RS = this.m_timeout > 0 ? (ResultSet)future.get(this.m_timeout, TimeUnit.SECONDS) : (ResultSet)future.get();
                    }
                    catch (InterruptedException e) {
                        future.cancel(true);
                        throw e;
                    }
                    catch (ExecutionException e) {
                        future.cancel(true);
                        throw e;
                    }
                    catch (TimeoutException e) {
                        Logger.error("\u6267\u884c\u8d85\u65f6\uff0c\u7cfb\u7edf\u5f3a\u5236\u7ec8\u6b62\u67e5\u8be2");
                        future.cancel(true);
                        throw e;
                    }
                }
                finally {
                    executor.shutdown();
                }
                da.moveToAbsolutePosition(this.m_RS, this.m_absolute);
                if (DataStoreFactory.includeInnerParamInFrom(this.m_Select)) {
                    ResultSetMetaData rsmd = this.m_RS.getMetaData();
                    this.ReParseColumnTableProperty(rsmd);
                }
                rowcount = this.retrieveOnceMore();
                long sqlRunEndAt = System.currentTimeMillis();
                DataStoreFactory.logSqlRunInfo(new SqlRunInfo(this.getSelectLastRetrieved(), sqlRunStartAt, sqlRunEndAt));
                if (this.m_absolute <= 1 && this.m_OnceRetrieveCount == 0) {
                    this.m_DBRowCount = new Integer(rowcount);
                }
            }
            catch (Exception sqlErr) {
                this.close();
                Logger.error(sqlErr.getMessage());
                this.getError().parseError(sqlErr, this.getEvent());
                DataStoreFactory.removeFromSQLHistory(this.gguid);
                return 0;
            }
        }
        finally {
            DataStoreFactory.removeFromSQLHistory(this.gguid);
        }
        this.BuildAllAsOneGroup(this.m_VectorGroups);
        this.m_PrimaryBuffer.notifyAggregateAndUnsureComputerInvalid();
        this.getEvent().fireRetrieveEnd(rowcount, where.equals(WITHLASTSELECT));
        return rowcount;
    }

    public int retrieveProcedure(ArrayList param) {
        return this.retrieveProcedure(param, false);
    }

    public int retrieveProcedure(ArrayList param, boolean withLastParams) {
        if (!this.m_IsProcedure) {
            if (param.size() == 0) {
                return this.retrieve();
            }
            Object p = param.get(0);
            if (p == null) {
                return this.retrieve();
            }
            return this.retrieve(p.toString());
        }
        this.m_AdditionalParam = param;
        if (!this.RemoteFactoryURL.equals("")) {
            return this.retrieveProcedureRemote(param, withLastParams);
        }
        String sql = this.m_Select;
        int rowcount = 0;
        Statement cmd = null;
        try {
            try {
                sql = this.parseInnerParameter(sql, false);
                if (this.m_CharsetAutoConvert) {
                    sql = DataStoreFactory.stringCharsetConvert(sql, this.m_Charset, this.m_DBCharset);
                }
                this.m_SelectLastRetrieved = sql;
                cmd = this.m_Connection.prepareCall(sql);
                int i = 0;
                while (i < this.m_ProcedureParamType.size() - param.size()) {
                    param.add(null);
                    ++i;
                }
                try {
                    i = 0;
                    while (i < this.m_ProcedureParamType.size()) {
                        int pt = (Integer)this.m_ProcedureParamType.get(i);
                        switch (pt) {
                            case 4: {
                                cmd.setDate(i + 1, new Date(((java.util.Date)ObjectTool.ChangeType(param.get(i), "java.sql.Date")).getTime()));
                                break;
                            }
                            case 1: {
                                cmd.setInt(i + 1, (Integer)ObjectTool.ChangeType(param.get(i), "java.lang.Integer"));
                                break;
                            }
                            case 2: {
                                cmd.setBigDecimal(i + 1, (BigDecimal)ObjectTool.ChangeType(param.get(i), "java.math.BigDecimal"));
                                break;
                            }
                            case 3: 
                            case 5: 
                            case 6: 
                            case 99: {
                                cmd.setString(i + 1, (String)ObjectTool.ChangeType(param.get(i), "java.lang.String"));
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception i2) {
                    // empty catch block
                }
                this.addToNeedReleaseCmdList(cmd);
                if (this.m_timeout > 0) {
                    try {
                        cmd.setQueryTimeout(this.m_timeout);
                    }
                    catch (Exception i2) {
                        // empty catch block
                    }
                }
                long sqlRunStartAt = System.currentTimeMillis();
                ExecutorService executor = Executors.newSingleThreadExecutor();
                FutureStatement futureCmd = new FutureStatement(cmd, "");
                Future future = executor.submit(futureCmd);
                try {
                    try {
                        this.m_RS = this.m_timeout > 0 ? (ResultSet)future.get(this.m_timeout, TimeUnit.SECONDS) : (ResultSet)future.get();
                    }
                    catch (InterruptedException e) {
                        future.cancel(true);
                        throw e;
                    }
                    catch (ExecutionException e) {
                        future.cancel(true);
                        throw e;
                    }
                    catch (TimeoutException e) {
                        Logger.error("\u6267\u884c\u8d85\u65f6\uff0c\u7cfb\u7edf\u5f3a\u5236\u7ec8\u6b62\u67e5\u8be2");
                        future.cancel(true);
                        throw e;
                    }
                }
                finally {
                    executor.shutdown();
                }
                if (this.getColumnCount() == 0) {
                    ResultSetMetaData rsmd = this.m_RS.getMetaData();
                    this.ParseColumnProperty(rsmd);
                }
                if (this.m_absolute > 1) {
                    int ci = 1;
                    while (ci < this.m_absolute) {
                        this.m_RS.next();
                        ++ci;
                    }
                }
                rowcount = this.retrieveOnceMore();
                long sqlRunEndAt = System.currentTimeMillis();
                DataStoreFactory.logSqlRunInfo(new SqlRunInfo(this.getSelectLastRetrieved(), sqlRunStartAt, sqlRunEndAt));
                this.m_DBRowCount = new Integer(rowcount);
            }
            catch (Exception sqlErr) {
                this.close();
                this.getError().parseError(sqlErr, this.getEvent());
                if (cmd != null) {
                    try {
                        cmd.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return 0;
            }
        }
        finally {
            if (cmd != null) {
                try {
                    cmd.close();
                }
                catch (Exception exception) {}
            }
        }
        this.BuildAllAsOneGroup(this.m_VectorGroups);
        this.m_PrimaryBuffer.notifyAggregateAndUnsureComputerInvalid();
        this.getEvent().fireRetrieveEnd(rowcount, withLastParams);
        return rowcount;
    }

    public int retrieveRemote(String where) {
        if (this.RemoteFactoryURL.equals("")) {
            return this.retrieve(where);
        }
        if (!where.equals(WITHLASTSELECT)) {
            this.m_AdditionalWhere = where;
        }
        TimeMark tm = new TimeMark(false);
        this.m_Error.clear();
        this.getEvent().fireBeforeRetrieve();
        if (this.m_AutoResetBeforeRetrieve) {
            this.reset();
        }
        RPCParameter p = new RPCParameter();
        String sql = this.m_Select;
        sql = this.parseInnerParameter(sql, false);
        p.put("replaceSelect", where.equals(WITHLASTSELECT) ? this.getSelectLastRetrieved() : sql);
        p.put("datastore", this);
        p.put("timeout", this.m_timeout);
        p.put("dbpool", this.DBPoolName);
        p.put("selectlastretrieved", this.getSelectLastRetrieved());
        p.put("where", where.equals(WITHLASTSELECT) ? "" : where);
        p.put("onceretrievecount", this.m_OnceRetrieveCount);
        p.put("absolute", this.m_absolute);
        System.out.println("retrieveRemote select=" + this.m_Select + "where=" + where + "    onceretrieveCount=" + this.m_OnceRetrieveCount + "  absolute =" + this.m_absolute);
        p = RPC.Call(String.valueOf(this.RemoteFactoryURL) + "servlet/jun.db.rpc.DataStoreRemoteFactory", "retrieveRemote", p);
        tm.stamp("\u8fdc\u7a0b\u8c03\u7528 \u7ed3\u675f");
        if (p.isSuccess()) {
            ArrayList data = (ArrayList)p.get("data");
            this.retrieve(data, false, where.equals(WITHLASTSELECT));
            this.setSelectLastRetrieved(p.get("SelectLastRetrieved", ""));
            tm.stamp(" \u5bfc\u5165\u6570\u636e\u7ed3\u675f");
        } else {
            this.reset();
            this.getError().parseError(p.getErrorText(), this.getEvent());
        }
        int rowcount = this.getRowCount();
        return rowcount;
    }

    public int retrieveProcedureRemote(ArrayList param, boolean withLastParams) {
        if (this.RemoteFactoryURL.equals("")) {
            return this.retrieveProcedure(param, withLastParams);
        }
        this.m_Error.clear();
        this.getEvent().fireBeforeRetrieve();
        if (this.m_AutoResetBeforeRetrieve) {
            this.reset();
        }
        RPCParameter p = new RPCParameter();
        String sql = this.m_Select;
        sql = this.parseInnerParameter(sql, false);
        p.put("replaceSelect", sql);
        p.put("timeout", this.m_timeout);
        p.put("datastore", this);
        p.put("dbpool", this.DBPoolName);
        p.put("param", param);
        p.put("onceretrievecount", this.m_OnceRetrieveCount);
        p.put("absolute", this.m_absolute);
        p.put("recreate", this.getColumnCount() == 0 ? 1 : 0);
        p = RPC.Call(String.valueOf(this.RemoteFactoryURL) + "servlet/jun.db.rpc.DataStoreRemoteFactory", "retrieveProcedureRemote", p);
        if (p.isSuccess()) {
            if (this.getColumnCount() == 0) {
                HashMap map = (HashMap)p.get("columninfo");
                this.setColumnInfo(map);
            }
            ArrayList data = (ArrayList)p.get("data");
            this.retrieve(data, false, withLastParams);
        } else {
            this.reset();
            this.getError().parseError(p.getErrorText(), this.getEvent());
        }
        int rowcount = this.getRowCount();
        return rowcount;
    }

    public void close() {
        block11: {
            if (this.m_RS != null) {
                try {
                    try {
                        this.m_RS.close();
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage());
                        this.m_RS = null;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    this.m_RS = null;
                    throw throwable;
                }
                this.m_RS = null;
            }
        }
        if (this.needReleaseCmdList != null) {
            int i = 0;
            while (i < this.needReleaseCmdList.size()) {
                Statement cmd = (Statement)this.needReleaseCmdList.get(i);
                if (cmd != null) {
                    try {
                        cmd.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.needReleaseCmdList.clear();
                }
                ++i;
            }
        }
    }

    public int retrieveOnceMore() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Integer> future = executor.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Integer v = DataStore_.this.$retrieveOnceMore();
                return v;
            }
        });
        try {
            if (this.m_timeout > 0) {
                int n = future.get(this.m_timeout, TimeUnit.SECONDS);
                return n;
            }
            int n = future.get();
            return n;
        }
        catch (InterruptedException e) {
            Logger.error("retrieveOnceMore \u6267\u884c\u5f02\u5e38 InterruptedException : \n" + e.getMessage() + "\uff0c\u7cfb\u7edf\u5f3a\u5236\u7ec8\u6b62\u67e5\u8be2");
            future.cancel(true);
            return 0;
        }
        catch (ExecutionException e) {
            Logger.error("retrieveOnceMore \u6267\u884c\u5f02\u5e38 ExecutionException : \n" + e.getMessage() + "\uff0c\u7cfb\u7edf\u5f3a\u5236\u7ec8\u6b62\u67e5\u8be2");
            future.cancel(true);
            return 0;
        }
        catch (TimeoutException e) {
            Logger.error("retrieveOnceMore \u6267\u884c\u8d85\u65f6\uff0c\u7cfb\u7edf\u5f3a\u5236\u7ec8\u6b62\u67e5\u8be2");
            future.cancel(true);
            return 0;
        }
        finally {
            executor.shutdown();
        }
    }

    public Integer $retrieveOnceMore() {
        if (!this.RemoteFactoryURL.equals("")) {
            return this.retrieveOnceMoreRemote();
        }
        if (this.m_RS == null) {
            this.m_Error.parseError("\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9519\u8bef\uff0c\u53ea\u662f\u4e00\u4e2a\u63d0\u9192\uff1am_RS\u5df2\u7ecf\u5173\u95ed\uff0c\u65e0\u6cd5 retrieve once more", this.getEvent());
            return 0;
        }
        this.getEvent().fireBeforeRetrieve();
        int rowcount = 0;
        try {
            if (this.getColumnCount() == 0) {
                ResultSetMetaData rsmd = this.m_RS.getMetaData();
                this.ParseColumnProperty(rsmd);
            }
        }
        catch (Exception rsmd) {
            // empty catch block
        }
        int ColCount = this.m_ColumnName2Index.size();
        int[] colType = new int[ColCount];
        int i = 0;
        while (i < ColCount) {
            colType[i] = this.getColumnProperty(i).getDataType();
            ++i;
        }
        DataAdapter adapter = this.getDataAdapter();
        long startTime = 0L;
        if (this.m_OnceRetrieveTimeout > 0) {
            startTime = System.currentTimeMillis();
        }
        try {
            while (this.m_RS.next()) {
                long now;
                if (++rowcount >= this.guardLine) {
                    Logger.error("\u6570\u636e\u884c\u6570\u592a\u5927\uff0c\u6240\u4ee5\u6570\u636e\u68c0\u7d22\u88ab\u5f3a\u5236\u4e2d\u6b62\uff0c\u8d85\u8fc7\u4e86\u8b66\u6212\u6761\u6570\uff1a" + rowcount + "\n" + this.m_Select);
                    break;
                }
                DsRow_ tempRow = new DsRow_(ColCount, this);
                this.m_PrimaryBuffer.push_back(tempRow);
                tempRow.m_RowStatus = 0;
                Object v = null;
                int i2 = 0;
                while (i2 < ColCount) {
                    v = null;
                    if (i2 <= this.m_FieldCount) {
                        try {
                            v = this.m_blobUnRetrieve && (colType[i2] == 2005 || colType[i2] == 2004 || colType[i2] == -4 || colType[i2] == -1) ? null : adapter.getDataFromResultSet(this.m_RS, i2 + 1, colType[i2]);
                        }
                        catch (Exception e) {
                            v = null;
                        }
                        if (!this.m_RS.wasNull() && v != null) {
                            if (v instanceof String) {
                                if (this.m_CharsetAutoConvert) {
                                    v = DataStoreFactory.stringCharsetConvert(v.toString(), this.m_DBCharset, this.m_Charset);
                                }
                                if (this.m_AutoTrim) {
                                    v = ((String)v).trim();
                                }
                            }
                            DsItem item = new DsItem();
                            item.m_CurrentValue = v;
                            item.m_OriginalValue = v;
                            item.m_ItemStatus = 0;
                            tempRow.set(i2, item);
                        }
                    }
                    ++i2;
                }
                if (rowcount == this.m_OnceRetrieveCount && this.m_OnceRetrieveCount != 0 || this.m_OnceRetrieveTimeout > 0 && (now = System.currentTimeMillis()) - startTime >= (long)this.m_OnceRetrieveTimeout) break;
            }
            boolean eof = false;
            try {
                eof = this.m_RS.isAfterLast();
            }
            catch (Exception e1) {
                eof = false;
            }
            if (eof) {
                this.close();
            }
            if (rowcount == 0) {
                this.close();
            }
            if (this.m_CloseResultsetAfterRetrieveOnce) {
                this.close();
            }
        }
        catch (Exception e) {
            this.close();
            this.m_Error.parseError(e, this.getEvent());
        }
        this.BuildAllAsOneGroup(this.m_VectorGroups);
        this.m_PrimaryBuffer.notifyAggregateAndUnsureComputerInvalid();
        ++this.m_retrieveTimes;
        this.getEvent().fireRetrieveOnceMoreEnd(this.m_retrieveTimes, rowcount);
        return rowcount;
    }

    private int retrieveOnceMoreRemote() {
        int ret = 0;
        if (this.RemoteFactoryURL.equals("")) {
            return this.retrieveOnceMore();
        }
        TimeMark tm = new TimeMark(false);
        this.m_Error.clear();
        this.getEvent().fireBeforeRetrieve();
        RPCParameter p = new RPCParameter();
        String sql = this.m_Select;
        sql = this.parseInnerParameter(sql, false);
        p.put("replaceSelect", sql);
        p.put("datastore", this);
        p.put("dbpool", this.DBPoolName);
        p.put("where", this.m_AdditionalWhere);
        p.put("onceretrievecount", this.m_OnceRetrieveCount);
        p.put("absolute", this.getRowCount());
        p.put("timeout", this.m_timeout);
        p = RPC.Call(String.valueOf(this.RemoteFactoryURL) + "servlet/jun.db.rpc.DataStoreRemoteFactory", "retrieveRemote", p);
        tm.stamp("\u8fdc\u7a0b\u8c03\u7528 \u7ed3\u675f");
        if (p.isSuccess()) {
            ArrayList data = (ArrayList)p.get("data");
            ret = data.size();
            this.retrieve(data, true, false);
            this.setSelectLastRetrieved(p.get("SelectLastRetrieved", ""));
            tm.stamp(" \u8fdc\u7a0b\u8ffd\u52a0\u68c0\u7d22\u6570\u636e\u7ed3\u675f");
        } else {
            this.reset();
            this.getError().parseError(p.getErrorText(), this.getEvent());
        }
        return ret;
    }

    void BuildAllAsOneGroup(ArrayList VectorGroups) {
        ArrayList<Integer> pGroupRows;
        if (VectorGroups.size() == 1 && (pGroupRows = (ArrayList<Integer>)VectorGroups.get(0)).size() == 1 && (Integer)pGroupRows.get(0) == 0) {
            return;
        }
        this.ResetGroupsInfo();
        this.m_QuickValue2Row = null;
        pGroupRows = new ArrayList<Integer>();
        pGroupRows.add(new Integer(0));
        VectorGroups.add(pGroupRows);
    }

    public void setOrderBy(String OrderBy) {
        this.m_Error.clear();
        this.m_OrderByConfig.clear();
        StringTokenizer st = new StringTokenizer(OrderBy, ",");
        while (st.hasMoreTokens()) {
            String R;
            String L;
            String s = st.nextToken().trim();
            if (s.equals("")) continue;
            StringTokenizer tk = new StringTokenizer(s, " ");
            if (tk.countTokens() == 2) {
                L = tk.nextToken().trim().toLowerCase();
                R = tk.nextToken().trim().toLowerCase();
            } else {
                L = tk.nextToken().trim().toLowerCase();
                R = "asc";
            }
            int colIndex = this.col2Index(L);
            if (colIndex < 0) {
                this.m_Error.parseError("\u6392\u5e8f\u8bed\u6cd5\u4e0d\u6b63\u786e \uff0c \u6307\u5b9a\u7684\u5217" + L + "\u4e0d\u5b58\u5728", this.getEvent());
                return;
            }
            boolean exist = false;
            int i = 0;
            while (i < this.m_OrderByConfig.size()) {
                OrderByConfig ob = (OrderByConfig)this.m_OrderByConfig.get(i);
                if (ob.colNo == colIndex) {
                    exist = true;
                    break;
                }
                ++i;
            }
            if (exist) continue;
            OrderByConfig pOB = new OrderByConfig();
            pOB.col = L;
            pOB.colNo = colIndex;
            pOB.byAsc = R.equals("asc");
            this.m_OrderByConfig.add(pOB);
        }
        this.m_OrderBy = OrderBy;
    }

    public void sort() {
        int n = this.m_PrimaryBuffer.size();
        int i = 0;
        while (i < n) {
            ((DsRow_)this.m_PrimaryBuffer.getRow((int)i)).m_OriginalOrder = i;
            ++i;
        }
        int cn = this.m_OrderByConfig.size();
        i = 0;
        while (i < cn) {
            int col = ((OrderByConfig)this.m_OrderByConfig.get((int)i)).colNo;
            ColumnProperty_ pCP = (ColumnProperty_)this.m_ColumnProperty.get(col);
            if (pCP.m_ObjType == 2) {
                this.ReCalculateComputer(col);
            }
            ++i;
        }
        this.m_PrimaryBuffer.Sort();
        this.BuildAllAsOneGroup(this.m_VectorGroups);
        this.m_PrimaryBuffer.notifyAggregateAndUnsureComputerInvalid();
        this.getEvent().fireAfterSort();
    }

    public void reCreateGroups() {
        this.createGroups(this.m_GroupRules);
    }

    public String getGroupRole() {
        return this.m_GroupRules;
    }

    public void createGroups(String rule) {
        String sort;
        int RowCount = this.getRowCount();
        this.m_GroupRules = rule.trim();
        this.ResetGroupsInfo();
        if (RowCount == 0 && this.m_GroupRules.equals("")) {
            this.BuildAllAsOneGroup(this.m_VectorGroups);
            this.ConvertGroupsInfo();
        }
        if ((sort = this.m_GroupRules).equals("")) {
            sort = this.m_OrderBy;
        } else {
            if ((sort = sort.replaceAll("[|]", ",").trim()).substring(0, 1).equals(",")) {
                sort = sort.substring(1);
            }
            if (!sort.endsWith(",")) {
                sort = sort.concat(",");
            }
            sort = sort.replaceAll(",", " asc , ");
            sort = String.valueOf(sort) + this.m_OrderBy;
        }
        this.setOrderBy(sort);
        this.sort();
        if (this.m_GroupRules.equals("")) {
            return;
        }
        String s = this.m_GroupRules;
        int p = -1;
        s = String.valueOf(s) + ",";
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            if (t.equals("")) continue;
            this.m_VectorGroupCols.add(t);
        }
        if (this.m_VectorGroupCols.size() == 0) {
            this.BuildAllAsOneGroup(this.m_VectorGroups);
        }
        int i = 0;
        while (i < this.m_VectorGroupCols.size()) {
            this.BuildGroupInfo((String)this.m_VectorGroupCols.get(i), this.m_VectorGroups);
            ++i;
        }
        this.ConvertGroupsInfo();
        this.m_PrimaryBuffer.notifyAggregateAndUnsureComputerInvalid();
    }

    void ResetGroupsInfo() {
        this.m_VectorGroupCols.clear();
        this.m_VectorGroups.clear();
        this.m_MapGroups.clear();
    }

    void ConvertGroupsInfo() {
        int rc = this.getRowCount();
        int n = this.m_VectorGroups.size();
        int i = 0;
        while (i < n) {
            ArrayList pVector = (ArrayList)this.m_VectorGroups.get(i);
            int m = pVector.size();
            int j = 1;
            while (j < m) {
                this.AddGroupsMap((Integer)pVector.get(j) - 1, i);
                ++j;
            }
            this.AddGroupsMap(rc - 1, i);
            ++i;
        }
    }

    void AddGroupsMap(int row, int groupNo) {
        ArrayList pVec;
        Integer key = new Integer(row);
        if (!this.m_MapGroups.containsKey(key)) {
            pVec = new ArrayList();
            this.m_MapGroups.put(key, pVec);
        } else {
            pVec = (ArrayList)this.m_MapGroups.get(key);
        }
        pVec.add(new Integer(groupNo));
    }

    void BuildGroupInfo(String groupByCols, ArrayList VectorGroups) {
        ArrayList<Integer> ColIndexs = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(groupByCols, "|");
        while (st.hasMoreTokens()) {
            int index;
            String col = st.nextToken().trim();
            if (col.equals("") || (index = this.col2Index(col)) < 0) continue;
            ColIndexs.add(new Integer(index));
            this.m_PrimaryBuffer.InsureColumnValueValid(index);
        }
        ArrayList<Integer> pGroupRows = new ArrayList<Integer>();
        int row = 0;
        int rc = this.getRowCount();
        do {
            pGroupRows.add(new Integer(row));
            int lastRow = row;
            row = this.FindNextDifferentRow(ColIndexs, lastRow, rc);
            while ((lastRow = this.FintLowerRow(lastRow, row, VectorGroups)) != row) {
                pGroupRows.add(new Integer(lastRow));
                if (row < rc) continue;
            }
        } while (row < rc);
        VectorGroups.add(pGroupRows);
    }

    int FintLowerRow(int startRow, int endRow, ArrayList VectorGroups) {
        int n = VectorGroups.size();
        int ret = endRow;
        int i = 0;
        while (i < n) {
            ArrayList list = (ArrayList)VectorGroups.get(i);
            int m = list.size();
            int j = 0;
            while (j < m) {
                int row = (Integer)list.get(j);
                if (row > startRow) {
                    if (row >= endRow) break;
                    ret = Math.min(ret, row);
                }
                ++j;
            }
            ++i;
        }
        Logger.info("find row " + ret);
        return ret;
    }

    int FindNextDifferentRow(ArrayList ColIndexs, int row, int rc) {
        int i = row + 1;
        while (i < rc) {
            if (!this.TwoRowIsEqualOnSomeColumns(ColIndexs, row, i)) {
                return i;
            }
            ++i;
        }
        return rc + 1;
    }

    boolean TwoRowIsEqualOnSomeColumns(ArrayList ColIndexs, int row1, int row2) {
        DsRow_ r1 = (DsRow_)this.m_PrimaryBuffer.getRow(row1);
        DsRow_ r2 = (DsRow_)this.m_PrimaryBuffer.getRow(row2);
        int n = ColIndexs.size();
        int i = 0;
        while (i < n) {
            int col = (Integer)ColIndexs.get(i);
            DsItem pDI1 = r1.GetAt(col);
            DsItem pDI2 = r2.GetAt(col);
            if (pDI1 != null || pDI2 != null) {
                if (pDI1 == null && pDI2 != null) {
                    return false;
                }
                if (pDI1 != null && pDI2 == null) {
                    return false;
                }
                if (pDI1.m_ItemStatus == 5) {
                    this.m_PrimaryBuffer.GetUserComputerValue(row1, col);
                }
                Object pv1 = pDI1.m_CurrentValue;
                if (pDI2.m_ItemStatus == 5) {
                    this.m_PrimaryBuffer.GetUserComputerValue(row2, col);
                }
                Object pv2 = pDI2.m_CurrentValue;
                if (pv1 != null || pv2 != null) {
                    boolean b;
                    if (pv1 == null && pv2 != null) {
                        return false;
                    }
                    if (pv1 != null && pv2 == null) {
                        return false;
                    }
                    boolean bl = b = this.m_PrimaryBuffer.ObjectCompare(pv1, pv2) == 0;
                    if (!b) {
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    void ReCalculateComputer(int col) {
        if (col < 0 || col + 1 > this.getColumnCount()) {
            return;
        }
        ColumnProperty_ pCP = (ColumnProperty_)this.m_ColumnProperty.get(col);
        if (pCP.m_ObjType != 2) {
            return;
        }
        int rc = this.getRowCount();
        int row = 0;
        while (row < rc) {
            DsItem pItem = this.m_PrimaryBuffer.getItem(row, col);
            if (pItem == null) {
                pItem = this.m_PrimaryBuffer.NEW_ITEM(pItem, (DsRow_)this.m_PrimaryBuffer.getRow(row), col);
                pItem.m_ItemStatus = (byte)5;
            }
            if (pItem.m_ItemStatus != 4) {
                this.m_PrimaryBuffer.InternalRecalculateComputer(pItem, pCP.m_Formula, pCP.m_DependMap, row);
            }
            ++row;
        }
    }

    public Object getValue(int row, int col) {
        return this.m_PrimaryBuffer.getValue(row, col);
    }

    public Object getValue(int row, String col) {
        int colIndex = this.col2Index(col);
        if (colIndex < 0) {
            return null;
        }
        return this.getValue(row, colIndex);
    }

    public Object getValue(int row, int col, boolean original) {
        return this.m_PrimaryBuffer.getValue(row, col, original);
    }

    public Object getValue(int row, String col, boolean original) {
        int colIndex = this.col2Index(col);
        if (colIndex < 0) {
            return null;
        }
        return this.getValue(row, colIndex, original);
    }

    public int getInt(int row, int col) {
        return this.getInt(row, col, 0);
    }

    public int getInt(int row, int col, int defaultValue) {
        try {
            Object obj = this.getValue(row, col);
            if (obj == null) {
                return defaultValue;
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            return new Integer(obj.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getInt(int row, String col) {
        return this.getInt(row, col, 0);
    }

    public int getInt(int row, String col, int defaultValue) {
        try {
            Object obj = this.getValue(row, col);
            if (obj == null) {
                return defaultValue;
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            return new Integer(obj.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getString(int row, int col) {
        return this.getString(row, col, "");
    }

    public String getString(int row, int col, String defaultValue) {
        String v = this.getFormatedValue(row, col, false, false);
        if (v.equalsIgnoreCase("null")) {
            return defaultValue;
        }
        return v;
    }

    public String getString(int row, String col) {
        return this.getString(row, col, "");
    }

    public String getString(int row, String col, String defaultValue) {
        String v = this.getFormatedValue(row, col, false, false);
        if (v.equalsIgnoreCase("null")) {
            return defaultValue;
        }
        return v;
    }

    public String getString(int row, int col, String defaultValue, boolean original) {
        try {
            Object obj = this.getValue(row, col, original);
            if (obj == null) {
                return defaultValue;
            }
            String format = this.getColumnProperty(col).getFormat();
            String ret = (String)ObjectTool.ChangeType(obj, "java.lang.String", this.getColumnProperty(col).getFormat());
            return ret;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public java.util.Date getDate(int row, int col) {
        return this.getDate(row, col, null);
    }

    public java.util.Date getDate(int row, int col, java.util.Date defaultValue) {
        try {
            Object obj = this.getValue(row, col);
            if (obj == null) {
                return defaultValue;
            }
            if (obj instanceof java.util.Date) {
                return (java.util.Date)obj;
            }
            ObjectTool.ChangeType(obj, "java.util.Date");
            return (java.util.Date)obj;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public java.util.Date getDate(int row, String col) {
        return this.getDate(row, col, null);
    }

    public java.util.Date getDate(int row, String col, java.util.Date defaultValue) {
        try {
            Object obj = this.getValue(row, col);
            if (obj == null) {
                return defaultValue;
            }
            if (obj instanceof java.util.Date) {
                return (java.util.Date)obj;
            }
            ObjectTool.ChangeType(obj, "java.util.Date");
            return (java.util.Date)obj;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double getDouble(int row, int col) {
        return this.getDouble(row, col, 0.0);
    }

    public double getDouble(int row, int col, double defaultValue) {
        try {
            Object obj = this.getValue(row, col);
            if (obj == null) {
                return defaultValue;
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            return Double.valueOf(obj.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double getDouble(int row, String col) {
        return this.getDouble(row, col, 0.0);
    }

    public double getDouble(int row, String col, double defaultValue) {
        try {
            Object obj = this.getValue(row, col);
            if (obj == null) {
                return defaultValue;
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            return Double.valueOf(obj.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Object evaluate(String expression, int row) {
        return this.m_PrimaryBuffer.evaluate(expression, row);
    }

    public int col2Index(String col) {
        if (col == null) {
            return -1;
        }
        if (this.m_ColumnName2Index.containsKey(col = col.trim().toLowerCase())) {
            return (Integer)this.m_ColumnName2Index.get(col);
        }
        return -1;
    }

    public boolean setValue(int row, int col, Object v) {
        return this.m_PrimaryBuffer.setValue(row, col, v);
    }

    public boolean setValue(int row, String col, Object v) {
        int colIndex = this.col2Index(col);
        if (colIndex < 0) {
            return false;
        }
        return this.setValue(row, colIndex, v);
    }

    public boolean SetValue(int row, String col, int v) {
        return this.setValue(row, col, (Object)new Integer(v));
    }

    public boolean setValue(int row, String col, double v) {
        return this.setValue(row, col, (Object)new Double(v));
    }

    public void assembleDependColumns(String expression_, ArrayList dependColList) {
        int n = this.m_ColumnProperty.size();
        String expression = expression_.toLowerCase();
        if (this.m_Express2DependList.containsKey(expression)) {
            ArrayList al = (ArrayList)this.m_Express2DependList.get(expression);
            dependColList.addAll(al);
            return;
        }
        int i = 0;
        while (i < n) {
            int p;
            ColumnProperty_ pcp = (ColumnProperty_)this.m_ColumnProperty.get(i);
            String t = pcp.m_Name.trim().toLowerCase();
            int colLen = t.length();
            String s = expression;
            int sumP = 0;
            while ((p = s.indexOf(t)) >= 0) {
                sumP += p + colLen;
                int c1 = 32;
                if (p > 0) {
                    c1 = s.charAt(p - 1);
                }
                if (c1 == 95 || c1 >= 97 && c1 <= 122 || c1 >= 65 && c1 <= 90 || c1 >= 48 && c1 <= 57) {
                    s = s.substring(p + colLen);
                    continue;
                }
                int c2 = 32;
                if (p + colLen < s.length()) {
                    c2 = s.charAt(p + colLen);
                }
                if (c2 == 95 || c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90 || c2 >= 48 && c2 <= 57) {
                    s = s.substring(p + colLen);
                    continue;
                }
                String m = expression.substring(sumP);
                int k = m.length();
                if (Math.abs(k -= (m = m.replaceAll("\"", "")).length()) % 2 == 1) {
                    s = s.substring(p + colLen);
                    continue;
                }
                dependColList.add(t);
                break;
            }
            ++i;
        }
        this.m_Express2DependList.put(expression, dependColList);
    }

    public boolean createComputer(String name, String expression) {
        ColumnProperty_ pCP;
        this.m_Error.clear();
        String s = name.trim().toLowerCase();
        int colIndex = this.col2Index(s);
        if (colIndex >= 0) {
            pCP = (ColumnProperty_)this.getColumnProperty(colIndex);
            Logger.info(String.valueOf(name) + "\u5df2\u7ecf\u5b58\u5728\uff0c\u5b83\u5c06\u88ab\u91cd\u65b0\u5b9a\u4e49\u3002");
        } else {
            pCP = new ColumnProperty_(this);
            this.m_ColumnProperty.add(pCP);
            this.m_ColumnName2Index.put(s, new Integer(this.m_ColumnName2Index.size()));
            this.m_PrimaryBuffer.AppendColumn();
            this.m_DeleteBuffer.AppendColumn();
            this.m_FilterBuffer.AppendColumn();
        }
        pCP.m_Name = s;
        pCP.m_DBName = "";
        pCP.m_DBTable = "";
        pCP.m_ObjType = 2;
        pCP.m_UpdateWhereClause = false;
        pCP.m_Updatable = false;
        pCP.m_ColumnLabel = s;
        pCP.m_DataType = -9999;
        pCP.m_DataTypeName = "unknown";
        pCP.m_IncludeUnsureFunction = this.IncludeUnsureFunction(expression);
        pCP.m_Formula = expression;
        ColumnProperty_ pDependCP = null;
        ArrayList dc = new ArrayList();
        this.assembleDependColumns(expression, dc);
        int n = dc.size();
        int i = 0;
        while (i < n) {
            String t2 = (String)dc.get(i);
            if (!t2.equals("")) {
                colIndex = this.col2Index(t2);
                if (colIndex < 0) {
                    this.m_Error.parseError("\u4e0d\u5b58\u5728\u5217" + t2, this.getEvent());
                    return false;
                }
                pDependCP = (ColumnProperty_)this.m_ColumnProperty.get(colIndex);
                if (pDependCP.m_AffectMap == null) {
                    pDependCP.m_AffectMap = new Hashtable();
                }
                if (pCP.m_DependMap == null) {
                    pCP.m_DependMap = new Hashtable();
                }
                pDependCP.m_AffectMap.put(pCP.m_Name, new Boolean(true));
                pCP.m_DependMap.put(pDependCP.m_Name, new Boolean(true));
            }
            ++i;
        }
        return true;
    }

    private boolean IncludeUnsureFunction(String Expression) {
        boolean retval = false;
        Vector<String> UnsureFunction = new Vector<String>();
        UnsureFunction.add("thisrow");
        UnsureFunction.add("rowcount");
        int n = UnsureFunction.size();
        String expression = Expression.toLowerCase();
        int i = 0;
        while (i < n) {
            int p;
            String t = UnsureFunction.get(i).toString();
            t = t.trim().toLowerCase();
            int colLen = t.length();
            String s = expression;
            int sumP = 0;
            while ((p = s.indexOf(t)) >= 0) {
                sumP += p + colLen;
                int c1 = 32;
                if (p > 0) {
                    c1 = s.charAt(p - 1);
                }
                if (c1 == 95 || c1 >= 97 && c1 <= 122 || c1 >= 65 && c1 <= 90 || c1 >= 48 && c1 <= 57) {
                    s = s.substring(p + colLen);
                    continue;
                }
                int c2 = 32;
                if (p + colLen < s.length()) {
                    c2 = s.charAt(p + colLen);
                }
                if (c2 == 95 || c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90 || c2 >= 48 && c2 <= 57) {
                    s = s.substring(p + colLen);
                    continue;
                }
                retval = true;
                return retval;
            }
            ++i;
        }
        return false;
    }

    public boolean createAggregate(int aType, int groupNo, String name, String expression) {
        this.m_Error.clear();
        boolean b = this.createComputer(name, expression);
        if (!b) {
            return b;
        }
        int colIndex = this.col2Index(name);
        if (colIndex < 0) {
            this.m_Error.parseError("\u975e\u6cd5\u7684\u805a\u5408\u5217", this.getEvent());
            return false;
        }
        ColumnProperty_ pCP = (ColumnProperty_)this.m_ColumnProperty.get(colIndex);
        pCP.m_ObjType = 8;
        pCP.m_AggregateDefine.m_AggregateType = aType;
        pCP.m_AggregateDefine.m_GroupNo = groupNo;
        return true;
    }

    public int insertRow(int beforeRow) {
        int rc = this.getRowCount();
        int cc = this.m_PrimaryBuffer.getColumnCount();
        if (beforeRow < 0) {
            beforeRow = 0;
        }
        if (beforeRow >= rc) {
            beforeRow = rc;
        }
        if (!this.getEvent().fireInsertRowPermit(beforeRow)) {
            return -1;
        }
        DsRow_ tempRow = new DsRow_(cc, this);
        tempRow.m_RowStatus = 2;
        int thisRow = this.m_PrimaryBuffer.InsertRow(beforeRow, tempRow);
        this.BuildAllAsOneGroup(this.m_VectorGroups);
        this.m_PrimaryBuffer.notifyAggregateAndUnsureComputerInvalid();
        int i = 0;
        while (i < cc) {
            ColumnProperty pCP = this.getColumnProperty(i);
            Object defaultValue = pCP.getDefaultValue();
            if (defaultValue != null) {
                String s = defaultValue.toString().trim();
                if (s.startsWith("=")) {
                    defaultValue = this.evaluate(s.substring(1, s.length()), thisRow);
                }
                Logger.info(String.valueOf(this.getUpdatableTable()) + "\uff1a" + thisRow + "," + pCP.getName() + "\u8bbe\u7f6e\u7f3a\u7701\u503c\uff1a" + defaultValue);
                this.setValue(thisRow, i, defaultValue);
            }
            ++i;
        }
        this.getEvent().fireAfterInsertRow(thisRow);
        return thisRow;
    }

    public boolean deleteRow(int row) {
        return this.deleteRow(row, false);
    }

    public boolean deleteRow(int row, boolean onlyFromBuffer) {
        this.m_Error.clear();
        int rc = this.getRowCount();
        if (row < 0 || row >= rc) {
            this.m_Error.parseError("DeleteRow \u884c\u53f7\u8d85\u754c.", this.getEvent());
            return false;
        }
        this.getEvent().fireBeforeDeleteRow(row);
        boolean permit = this.getEvent().fireDeleteRowPermit(row);
        if (!permit) {
            return false;
        }
        DsRow_ dr = (DsRow_)this.m_PrimaryBuffer.getRow(row);
        if (!onlyFromBuffer && dr.m_RowStatus != 2 && dr.m_RowStatus != 3) {
            this.m_DeleteBuffer.push_back(dr);
        }
        this.m_PrimaryBuffer.EraseRow(row);
        this.BuildAllAsOneGroup(this.m_VectorGroups);
        this.m_PrimaryBuffer.notifyAggregateAndUnsureComputerInvalid();
        this.getEvent().fireAfterDeleteRow(row);
        return true;
    }

    public void setUpdatable(boolean b) {
        this.m_Updatable = b;
    }

    public boolean isUpdatable() {
        return this.m_Updatable;
    }

    public void setUpdatableTable(String table) {
        this.m_UpdateTable = table.trim();
        int i = 0;
        while (i < this.m_ColumnProperty.size()) {
            ColumnProperty_ cp = (ColumnProperty_)this.m_ColumnProperty.get(i);
            if (cp.m_ObjType == 0 && cp.m_DBTable.equals("")) {
                cp.m_DBTable = table;
            }
            ++i;
        }
    }

    public String getUpdatableTable() {
        return this.m_UpdateTable;
    }

    public void setPrimaryKey(String pk) {
        String s = pk;
        s = s.replaceAll("     ", "");
        s = s.replaceAll("    ", "");
        s = s.replaceAll("   ", "");
        s = s.replaceAll("  ", "");
        this.m_PrimaryKey = s = s.replaceAll(" ", "");
    }

    public String getPrimaryKey() {
        return this.m_PrimaryKey;
    }

    private void AssumeColumnPropertyHadParsed() {
        if (!this.m_HadParsedColumnProperty) {
            this.m_Error.parseError("\u8bf7\u5148\u8fd0\u884cSetSelect\u51fd\u6570", this.getEvent());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setUpdatableColumns(String cols) {
        this.m_Error.clear();
        if (this.m_UpdateTable.equals("")) {
            this.m_Error.parseError("\u8bbe\u7f6e UpdatableColumns\u524d,\u5148\u8bbe\u7f6eUpdateTable", this.getEvent());
            return;
        }
        this.AssumeColumnPropertyHadParsed();
        s = cols;
        s = s.replaceAll("     ", "");
        s = s.replaceAll("    ", "");
        s = s.replaceAll("   ", "");
        s = s.replaceAll("  ", "");
        s = s.replaceAll(" ", "");
        s = s.trim().toLowerCase();
        if (!s.startsWith("|")) {
            s = "|" + s;
        }
        if (!s.endsWith("|")) {
            s = String.valueOf(s) + "|";
        }
        this.m_UpdatableColumns = s;
        pcp = null;
        n = this.m_ColumnProperty.size();
        da = this.getDataAdapter();
        caseSensitive = da.caseSensitive();
        i = 0;
        while (i < n) {
            block8: {
                block9: {
                    pcp = (ColumnProperty_)this.m_ColumnProperty.get(i);
                    if (pcp.m_ObjType != 0) break block8;
                    if (!caseSensitive) break block9;
                    if (pcp.m_DBTable.equals(this.m_UpdateTable) || (String.valueOf(pcp.m_DatabaseName) + "." + pcp.m_DBTable).equals(this.m_UpdateTable)) ** GOTO lbl-1000
                    pcp.m_Updatable = false;
                    break block8;
                }
                if (!pcp.m_DBTable.equalsIgnoreCase(this.m_UpdateTable) && !(String.valueOf(pcp.m_DatabaseName) + "." + pcp.m_DBTable).equalsIgnoreCase(this.m_UpdateTable)) {
                    pcp.m_Updatable = false;
                } else lbl-1000:
                // 2 sources

                {
                    t2 = t = pcp.m_Name;
                    t = "|" + t + "|";
                    t2 = "|~" + t2 + "|";
                    if (s.indexOf(t) >= 0 || s.indexOf("*") >= 0) {
                        pcp.m_Updatable = true;
                    }
                    if (s.indexOf(t2) >= 0) {
                        pcp.m_Updatable = false;
                    }
                }
            }
            ++i;
        }
    }

    public String getUpdatableColumns() {
        String ret = "";
        ColumnProperty_ pcp = null;
        int n = this.m_ColumnProperty.size();
        int i = 0;
        while (i < n) {
            pcp = (ColumnProperty_)this.m_ColumnProperty.get(i);
            if (pcp.m_Updatable) {
                ret = ret.equals("") ? pcp.m_Name : String.valueOf(ret) + "|" + pcp.m_Name;
            }
            ++i;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public void setUpdateWhereClauseColumns(String cols) {
        this.m_Error.clear();
        if (this.m_UpdateTable.equals("")) {
            this.m_Error.parseError("\u5148\u8bbe\u7f6eUpdateTable", this.getEvent());
            return;
        }
        this.AssumeColumnPropertyHadParsed();
        s = cols;
        s = s.replaceAll("     ", "");
        s = s.replaceAll("    ", "");
        s = s.replaceAll("   ", "");
        s = s.replaceAll("  ", "");
        s = s.replaceAll(" ", "");
        da = this.getDataAdapter();
        caseSensitive = da.caseSensitive();
        s = s.trim().toLowerCase();
        if (!s.startsWith("|")) {
            s = "|" + s;
        }
        if (!s.endsWith("|")) {
            s = String.valueOf(s) + "|";
        }
        this.m_UpdatableColumns = s;
        pcp = null;
        n = this.m_ColumnProperty.size();
        i = 0;
        while (i < n) {
            block9: {
                block8: {
                    pcp = (ColumnProperty_)this.m_ColumnProperty.get(i);
                    if (!caseSensitive) break block8;
                    if (pcp.m_DBTable.equals(this.m_UpdateTable)) ** GOTO lbl-1000
                    pcp.m_UpdateWhereClause = false;
                    break block9;
                }
                if (!pcp.m_DBTable.equalsIgnoreCase(this.m_UpdateTable)) {
                    pcp.m_UpdateWhereClause = false;
                } else lbl-1000:
                // 2 sources

                {
                    t = pcp.m_Name;
                    t2 = t = t.toLowerCase();
                    t = "|" + t + "|";
                    t2 = "|~" + t2 + "|";
                    if (s.indexOf(t) >= 0 || s.indexOf("*") >= 0) {
                        pcp.m_UpdateWhereClause = true;
                    }
                    if (s.indexOf(t2) >= 0) {
                        pcp.m_UpdateWhereClause = false;
                    }
                }
            }
            ++i;
        }
    }

    public String getUpdateWhereClauseColumns() {
        String ret = "";
        ColumnProperty_ pcp = null;
        int n = this.m_ColumnProperty.size();
        int i = 0;
        while (i < n) {
            pcp = (ColumnProperty_)this.m_ColumnProperty.get(i);
            if (pcp.m_UpdateWhereClause) {
                ret = ret.equals("") ? pcp.m_Name : String.valueOf(ret) + "|" + pcp.m_Name;
            }
            ++i;
        }
        return ret;
    }

    public boolean update(boolean resetFlag) {
        return this.update(resetFlag, false);
    }

    public boolean update(boolean resetFlag, boolean printSQL) {
        if (!this.RemoteFactoryURL.equals("")) {
            return this.updateRemote(resetFlag, printSQL);
        }
        boolean ret = false;
        this.m_Error.clear();
        ArrayList vectorSql = new ArrayList();
        if (!this.getUpdateSQL(vectorSql)) {
            return false;
        }
        String sql = "";
        int n = vectorSql.size();
        Statement cmd = null;
        int i = 0;
        try {
            try {
                cmd = this.m_Connection.createStatement();
                boolean batch = false;
                i = 0;
                while (i < n) {
                    sql = this.m_Connection.nativeSQL(vectorSql.get(i).toString());
                    if (sql.equals("")) {
                        throw new Exception("\u600e\u4e48\u53ef\u80fd\uff0cSQL\u8bed\u53e5\u5c45\u7136\u4e3a'' ");
                    }
                    if (printSQL) {
                        Logger.info(sql);
                    }
                    this.getEvent().fireSqlPreview(sql);
                    if (sql.startsWith("updateblob")) {
                        ZDataParser zdp = new ZDataParser(sql.substring(10));
                        String table = zdp.get("table", "");
                        String col = zdp.get("col", "");
                        String where = zdp.get("where", "");
                        String value = zdp.get("value", "");
                        this.getDataAdapter().clobModify(this.m_Connection, table, col, where, value, printSQL);
                    } else if (batch) {
                        cmd.addBatch(sql);
                    } else {
                        cmd.execute(sql);
                    }
                    ++i;
                }
                if (batch) {
                    cmd.executeBatch();
                }
            }
            catch (Exception e) {
                this.m_Error.parseError("\u7b2c" + i + "\u884c:" + sql + "\n\u9519\u8bef\u662f\uff1a" + e.getMessage(), this.getEvent());
                try {
                    cmd.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                cmd.close();
            }
            catch (Exception exception) {}
        }
        vectorSql.clear();
        if (resetFlag) {
            this.resetUpdate();
        }
        return true;
    }

    public boolean updateRemote(boolean resetFlag) {
        return this.updateRemote(resetFlag, false);
    }

    public boolean updateRemote(boolean resetFlag, boolean printSQL) {
        if (this.RemoteFactoryURL.equals("")) {
            return this.update(resetFlag);
        }
        ArrayList list = new ArrayList();
        if (!this.getUpdateSQL(list)) {
            return false;
        }
        RPCParameter p = new RPCParameter();
        p.put("dbpool", this.DBPoolName);
        p.put("sqllist", list);
        p.put("timeout", this.m_timeout);
        p.put("printSQL", printSQL);
        if (printSQL) {
            for (String sql : list) {
                System.out.println(sql);
            }
        }
        if ((p = RPC.Call(String.valueOf(this.RemoteFactoryURL) + "servlet/jun.db.rpc.DataStoreRemoteFactory", "updateRemote", p)).isSuccess()) {
            if (resetFlag) {
                this.resetUpdate();
            }
            return true;
        }
        this.getError().parseError(p.getErrorText(), this.getEvent());
        return p.isSuccess();
    }

    public int nextSequence(String name) {
        if (!this.RemoteFactoryURL.equals("")) {
            return this.nextSequenceRemote(name);
        }
        return Sequence.NextSequence(this.getConnection(), name);
    }

    public int nextSequenceRemote(String name) {
        if (this.RemoteFactoryURL.equals("")) {
            return this.nextSequence(name);
        }
        RPCParameter p = new RPCParameter();
        p.put("dbpool", this.DBPoolName);
        p.put("name", name);
        p.put("timeout", this.m_timeout);
        p = RPC.Call(String.valueOf(this.RemoteFactoryURL) + "servlet/jun.db.rpc.DataStoreRemoteFactory", "nextSequenceRemote", p);
        if (p.isSuccess()) {
            return p.get("sequence", -1);
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getUpdateSQL(ArrayList vectorSql) {
        try {
            String s;
            String sql = "";
            DsRow_ pRow = null;
            if (vectorSql == null) {
                return false;
            }
            int i = 0;
            while (i < this.sqlBatch.size()) {
                s = (String)this.sqlBatch.get(i);
                s = this.m_DataAdapter.toLocalSyntax(s);
                vectorSql.add(s);
                ++i;
            }
            if (this.m_Updatable && !this.m_IsProcedure) {
                this.m_MaxIDMap.clear();
                int n = this.m_DeleteBuffer.size();
                int row = 0;
                while (row < n) {
                    sql = this.m_DeleteBuffer.AsserbleSQLDelete(row);
                    if (!sql.equals("")) {
                        if (this.m_CharsetAutoConvert) {
                            sql = DataStoreFactory.stringCharsetConvert(sql, this.m_Charset, this.m_DBCharset);
                        }
                        if (!vectorSql.contains(sql)) {
                            vectorSql.add(sql);
                        }
                    }
                    ++row;
                }
                n = this.m_PrimaryBuffer.size();
                row = 0;
                while (row < n) {
                    ArrayList sqlList = new ArrayList();
                    pRow = (DsRow_)this.m_PrimaryBuffer.getRow(row);
                    switch (pRow.m_RowStatus) {
                        case 0: 
                        case 2: {
                            break;
                        }
                        case 3: {
                            if (this.isTheRowHoldNoDataExceptSuchColumns(row)) break;
                            boolean validateOk = this.getEvent().fireValidate(row);
                            if (!validateOk) {
                                this.getError().parseError("validate \u6821\u9a8c\u5931\u8d25", this.getEvent());
                                return false;
                            }
                            if (!this.AutoCheck(row)) {
                                this.getError().parseError("AutoCheck \u6821\u9a8c\u5931\u8d25", this.getEvent());
                                return false;
                            }
                            sqlList = this.m_PrimaryBuffer.AsserbleSQLInsert(row);
                            break;
                        }
                        case 1: {
                            boolean validateOk;
                            if (this.isTheRowHoldNoDataExceptSuchColumns(row) && this.isAutoDeleteNoDataRow()) {
                                validateOk = this.getEvent().fireDeleteRowPermit(row);
                                if (!validateOk) {
                                    return false;
                                }
                                sql = this.m_PrimaryBuffer.AsserbleSQLDelete(row);
                                Logger.info("\u7b2c" + row + "\u884c\u662f\u68c0\u7d22\u51fa\u6765\u7684\u6570\u636e\uff0c\u5728\u88ab\u4fee\u6539\u540e\u53ef\u88ab\u89c6\u4e3a\u65e0\u6570\u636e\u7684\u884c\uff0c\u56e0\u6b64\u672c\u884c\u88ab\u5220\u9664\u3002");
                                sqlList.add(sql);
                                break;
                            }
                            validateOk = this.getEvent().fireValidate(row);
                            if (!validateOk) {
                                this.getError().parseError("validate \u6821\u9a8c\u5931\u8d25", this.getEvent());
                                return false;
                            }
                            if (!this.AutoCheck(row)) {
                                this.getError().parseError("AutoCheck \u6821\u9a8c\u5931\u8d25", this.getEvent());
                                return false;
                            }
                            sqlList = this.m_PrimaryBuffer.AsserbleSQLUpdate(row);
                            break;
                        }
                    }
                    int k = 0;
                    while (k < sqlList.size()) {
                        sql = (String)sqlList.get(k);
                        if (this.m_CharsetAutoConvert) {
                            sql = DataStoreFactory.stringCharsetConvert(sql, this.m_Charset, this.m_DBCharset);
                        }
                        if (!vectorSql.contains(sql)) {
                            vectorSql.add(sql);
                        }
                        ++k;
                    }
                    ++row;
                }
            }
            i = 0;
            while (i < this.sqlBatch2.size()) {
                s = (String)this.sqlBatch2.get(i);
                s = this.m_DataAdapter.toLocalSyntax(s);
                vectorSql.add(s);
                ++i;
            }
            final ArrayList $list = vectorSql;
            Thread t = new Thread(){

                public void run() {
                    int i = 0;
                    while (i < $list.size()) {
                        DataStore_.this.getEvent().fireSqlPreview((String)$list.get(i));
                        ++i;
                    }
                }
            };
            t.start();
            return true;
        }
        catch (Exception e) {
            this.getError().parseError(e, this.getEvent());
            return false;
        }
    }

    public boolean isSaveNeeded() {
        int rowStatus;
        if (this.m_DeleteBuffer.size() > 0) {
            return true;
        }
        int n = this.m_PrimaryBuffer.size();
        int i = 0;
        while (i < n) {
            rowStatus = this.m_PrimaryBuffer.getRow(i).getRowStatus();
            if (rowStatus == 3 && !this.isTheRowHoldNoDataExceptSuchColumns(i)) {
                return true;
            }
            if (rowStatus == 1) {
                return true;
            }
            ++i;
        }
        n = this.m_FilterBuffer.size();
        i = 0;
        while (i < n) {
            rowStatus = this.m_FilterBuffer.getRow(i).getRowStatus();
            if (rowStatus == 3 && !this.isTheRowHoldNoDataExceptSuchColumns(i)) {
                return true;
            }
            if (rowStatus == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean AutoCheck(int row) {
        int RC = this.getRowCount();
        int i = 0;
        while (i < this.m_VectorAutoCheck.size()) {
            AutoCheckConfig acc = (AutoCheckConfig)this.m_VectorAutoCheck.get(i);
            switch (acc.m_CheckType) {
                case 1: {
                    boolean ret = false;
                    if (this.getValue(row, acc.m_ColIndex) != null && !this.getString(row, acc.m_ColIndex).trim().equals("")) {
                        ret = true;
                    }
                    if (ret) break;
                    ColumnProperty CP = this.getColumnProperty(acc.m_ColIndex);
                    String info = "\u5fc5\u987b\u5f55\u5165" + (RC == 1 ? "" : "\u7b2c" + (row + 1) + "\u884c\u4e2d\u7684") + CP.getColumnLabel();
                    Logger.info(info);
                    this.m_Event.fireAutoCheckError(this.getUpdatableTable(), row, this.getColumnName(acc.m_ColIndex), acc.m_CheckType, info);
                    return false;
                }
                default: {
                    this.m_Event.fireAutoCheckError(this.getUpdatableTable(), row, this.getColumnName(acc.m_ColIndex), acc.m_CheckType, "\u5c1a\u672a\u5b9e\u73b0\u7684\u81ea\u52a8\u6821\u9a8c\u529f\u80fd\uff1a" + acc.toString());
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean isColNeedCheckNull(String col) {
        int colIndex = this.col2Index(col);
        if (colIndex < 0) {
            return false;
        }
        int i = 0;
        while (i < this.m_VectorAutoCheck.size()) {
            AutoCheckConfig acc = (AutoCheckConfig)this.m_VectorAutoCheck.get(i);
            if (acc.m_ColIndex == colIndex && acc.m_CheckType == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addAutoCheck(String col, int checkType, String where, String find) {
        int colIndex = this.col2Index(col);
        this.addAutoCheck(colIndex, checkType, where, find);
    }

    public void addAutoCheck(int col, int checkType, String where, String find) {
        int ct = checkType;
        AutoCheckConfig pACC = null;
        if (col < 0) {
            return;
        }
        if (col >= this.getColumnCount()) {
            return;
        }
        if (ct == 2 || ct == 4) {
            this.addAutoCheck(col, 1, "", "");
        }
        boolean haveRegister = false;
        int n = this.m_VectorAutoCheck.size();
        int i = 0;
        while (i < n) {
            pACC = (AutoCheckConfig)this.m_VectorAutoCheck.get(i);
            if (pACC.m_ColIndex == col && pACC.m_CheckType == ct) {
                haveRegister = true;
                break;
            }
            ++i;
        }
        if (!haveRegister) {
            pACC = new AutoCheckConfig();
            this.m_VectorAutoCheck.add(pACC);
        }
        pACC.m_ColIndex = col;
        pACC.m_CheckType = ct;
        pACC.m_Where = where;
        pACC.m_Find = find;
    }

    void ResetUpdate(DataBuffer Buffer) {
        int rc = Buffer.getRowCount();
        int cc = Buffer.getColumnCount();
        int row = 0;
        while (row < rc) {
            DsRow_ pRow = (DsRow_)Buffer.getRow(row);
            if (!(pRow.m_RowStatus == 2 || pRow.m_RowStatus == 3 && this.isTheRowHoldNoDataExceptSuchColumns(Buffer, row))) {
                DsItem pItem;
                int col;
                if (pRow.m_RowStatus == 1 && this.isTheRowHoldNoDataExceptSuchColumns(Buffer, row)) {
                    pRow.m_RowStatus = 3;
                    col = 0;
                    while (col < cc) {
                        pItem = pRow.GetAt(col);
                        if (pItem != null) {
                            pItem.m_OriginalValue = null;
                            pItem.m_ItemStatus = pItem.m_CurrentValue == null ? (byte)2 : (byte)3;
                        }
                        ++col;
                    }
                } else {
                    pRow.m_RowStatus = 0;
                    col = 0;
                    while (col < cc) {
                        pItem = pRow.GetAt(col);
                        if (pItem != null) {
                            if (pItem.m_ItemStatus == 1 || pItem.m_ItemStatus == 3) {
                                pItem.m_OriginalValue = pItem.m_CurrentValue;
                            }
                            pItem.m_ItemStatus = 0;
                        }
                        ++col;
                    }
                }
            }
            ++row;
        }
    }

    public void resetUpdate() {
        this.sqlBatch.clear();
        this.sqlBatch2.clear();
        this.ResetUpdate(this.m_PrimaryBuffer);
        this.ResetUpdate(this.m_FilterBuffer);
        this.m_DeleteBuffer.clear();
    }

    public String getFormatedValue(int row, String col) {
        return this.getFormatedValue(row, col, false);
    }

    public String getFormatedValue(int row, int col) {
        return this.getFormatedValue(row, col, false);
    }

    public String getFormatedValue(int row, String col, boolean original) {
        return this.getFormatedValue(row, col, original, true);
    }

    public String getFormatedValue(int row, String col, boolean original, boolean withAffix) {
        int colIndex = this.col2Index(col);
        if (colIndex < 0) {
            return "null";
        }
        return this.getFormatedValue(row, colIndex, original, withAffix);
    }

    public String getFormatedValue(int row, int col, boolean original) {
        return this.getFormatedValue(row, col, original, true);
    }

    public String getFormatedValue(int row, int col, boolean original, boolean withAffix) {
        DsItem item = this.m_PrimaryBuffer.getItem(row, col);
        ColumnProperty_ cp = (ColumnProperty_)this.m_ColumnProperty.get(col);
        return this.m_PrimaryBuffer.GetFormatedTextValue(item, cp, original, withAffix);
    }

    public int getRowCount() {
        return this.m_PrimaryBuffer.getRowCount();
    }

    public String getColumnName(int index) {
        if (index < 0 || index > this.m_ColumnProperty.size()) {
            return "";
        }
        ColumnProperty_ pCP = (ColumnProperty_)this.m_ColumnProperty.get(index);
        return pCP.m_Name;
    }

    public int getColumnCount() {
        return this.m_PrimaryBuffer.getColumnCount();
    }

    public DataAdapter getDataAdapter() {
        if (this.m_DataAdapter == null) {
            this.m_DataAdapter = new DataAdapterSQLServer(this);
        }
        return this.m_DataAdapter;
    }

    public void setDataAdapter(DataAdapter da) {
        this.m_DataAdapter = da;
    }

    public DataStoreEventManager getEvent() {
        if (this.m_Event == null) {
            this.m_Event = new DataStoreEventManager_();
        }
        return this.m_Event;
    }

    public DataBuffer getPrimaryBuffer() {
        return this.m_PrimaryBuffer;
    }

    public DataBuffer getDeleteBuffer() {
        return this.m_DeleteBuffer;
    }

    public DataBuffer getFilterBuffer() {
        return this.m_FilterBuffer;
    }

    public Object getFriendlyProperty(String name) {
        if (name.equals("m_MapGroups")) {
            return this.m_MapGroups;
        }
        if (name.equals("m_VectorGroups")) {
            return this.m_VectorGroups;
        }
        if (name.equals("m_ColumnProperty")) {
            return this.m_ColumnProperty;
        }
        if (name.equals("m_VectorGroupCols")) {
            return this.m_VectorGroupCols;
        }
        return null;
    }

    public boolean saveAsTxt(String file) {
        return this.saveAsTxt(file, false);
    }

    public boolean saveAsTxt(String file, boolean withHead) {
        return this.m_PrimaryBuffer.SaveAsTxt(file, withHead);
    }

    public boolean saveAsDBF(String file) {
        return this.m_PrimaryBuffer.SaveAsDBF(file);
    }

    public boolean saveAsTxt(Writer w) {
        return this.saveAsTxt(w, false);
    }

    public boolean saveAsTxt(Writer w, boolean withHead) {
        return this.m_PrimaryBuffer.SaveAsTxt(w, withHead);
    }

    public int importTxtFile(String file) {
        return this.importTxtFile(file, 0);
    }

    public int importTxtFile(String file, int skipRow) {
        int rc = this.m_PrimaryBuffer.ImportTxtFile(file, skipRow);
        int rowcount = this.getRowCount();
        this.getEvent().fireRetrieveEnd(rowcount, false);
        return rc;
    }

    public int importTxtSource(String string) {
        int rc = this.m_PrimaryBuffer.ImportTxt(new StringReader(string), 0);
        int rowcount = this.getRowCount();
        this.getEvent().fireRetrieveEnd(rowcount, false);
        return rc;
    }

    public int importCSVFile(String file) {
        return this.importCSVFile(file, ',', false);
    }

    public int importDBFFile(String file) {
        return this.importDBFFile(file, "{}");
    }

    public int importDBFFile(String file, String colMap) {
        int rc = this.m_PrimaryBuffer.ImportDBFFile(file, colMap);
        int rowcount = this.getRowCount();
        this.getEvent().fireRetrieveEnd(rowcount, false);
        return rc;
    }

    public int importCSVFile(String file, char delimiter, boolean includeHeader) {
        int rc = this.m_PrimaryBuffer.ImportCSVFile(file, delimiter, includeHeader);
        int rowcount = this.getRowCount();
        this.getEvent().fireRetrieveEnd(rowcount, false);
        return rc;
    }

    public int importCSVSource(String string) {
        return this.importCSVSource(string, ',');
    }

    public int importCSVSource(String string, char delimiter) {
        int rc = this.m_PrimaryBuffer.ImportCSV(new StringReader(string), delimiter, false);
        int rowcount = this.getRowCount();
        this.getEvent().fireRetrieveEnd(rowcount, false);
        return rc;
    }

    public boolean saveAsXML(String file) {
        return this.m_PrimaryBuffer.SaveAsXML(file);
    }

    public boolean saveAsXML(Writer w) {
        return this.m_PrimaryBuffer.SaveAsXML(w);
    }

    public String saveAsXML() {
        StringWriter sw = new StringWriter();
        this.m_PrimaryBuffer.SaveAsXML(sw);
        return sw.toString();
    }

    public int importXMLFile(String file) {
        return this.importXMLFile(file, "");
    }

    public int importXMLFile(String file, String charset) {
        int rc = this.m_PrimaryBuffer.ImportXMLFile(file, charset);
        int rowcount = this.getRowCount();
        this.getEvent().fireRetrieveEnd(rowcount, false);
        return rc;
    }

    public int importXMLSource(String xmlSource) {
        int rc = this.m_PrimaryBuffer.ImportXMLSource(xmlSource);
        int rowcount = this.getRowCount();
        this.getEvent().fireRetrieveEnd(rowcount, false);
        return rc;
    }

    public int importBigTxtFileAndSave(String file, int skipRows, String splitChar, int onceSaveCount) {
        return this.m_PrimaryBuffer.ImportBigTxtFileAndSave(file, skipRows, splitChar, onceSaveCount);
    }

    public String exportSyntax() {
        try {
            StringWriter writer = new StringWriter();
            XmlWriter xml = new XmlWriter(writer);
            xml.S("datastore").A("ver", "1.0").A("author", "zengjun").E();
            xml.S("select").W(this.m_Select).E();
            int i = 0;
            while (i < this.m_ColumnProperty.size()) {
                ((ColumnProperty)this.m_ColumnProperty.get(i)).serializerToXML(xml);
                ++i;
            }
            xml.close();
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            this.getError().parseError(e, this.getEvent());
            return "";
        }
    }

    public void setFilterBy(String filterBy) {
        this.m_FilterBy = filterBy;
    }

    public String getFilterBy() {
        return this.m_FilterBy;
    }

    public void fastFilter(String col, Object value) {
        final int colIndex = this.col2Index(col);
        final Object v2 = value;
        if (colIndex < 0) {
            return;
        }
        FilterRole role = new FilterRole(){

            public boolean filterRole(int row) {
                Object v1 = DataStore_.this.m_PrimaryBuffer.getValue(row, colIndex);
                if (v1 == null && v2 == null) {
                    return true;
                }
                if (v1 == null) {
                    return false;
                }
                if (v2 == null) {
                    return false;
                }
                boolean bv = DataStore_.this.m_PrimaryBuffer.ObjectCompare(v1, v2) == 0;
                return bv;
            }
        };
        this.filter(role);
    }

    public void filter() {
        FilterRole expressionRole = new FilterRole(){

            public boolean filterRole(int row) {
                boolean bv;
                if (DataStore_.this.m_FilterBy.equals("")) {
                    return true;
                }
                Object v = DataStore_.this.m_PrimaryBuffer.evaluate(DataStore_.this.m_FilterBy, row);
                try {
                    bv = (Boolean)ObjectTool.ChangeType(v, "java.lang.Boolean");
                }
                catch (Exception e) {
                    bv = true;
                }
                return bv;
            }
        };
        this.filter(expressionRole);
    }

    public void filter(FilterRole role) {
        this.m_PrimaryBuffer.GetBuffer().addAll(this.m_FilterBuffer.GetBuffer());
        this.m_FilterBuffer.GetBuffer().clear();
        int n = this.m_PrimaryBuffer.getRowCount();
        int i = 0;
        while (i < n) {
            boolean bv = role.filterRole(i);
            if (bv) {
                ++i;
                continue;
            }
            this.m_FilterBuffer.push_back(this.m_PrimaryBuffer.getRow(i));
            this.m_PrimaryBuffer.GetBuffer().remove(i);
            --n;
        }
        this.BuildAllAsOneGroup(this.m_VectorGroups);
        this.m_PrimaryBuffer.notifyAggregateAndUnsureComputerInvalid();
        this.m_FilterBuffer.notifyAggregateAndUnsureComputerInvalid();
        this.getEvent().fireAfterFilter(this.m_PrimaryBuffer.getRowCount(), this.m_FilterBuffer.getRowCount());
    }

    public String assembleRetrieve(String col, String Operator, Object value) {
        Object val;
        String ret = "";
        int colIndex = this.col2Index(col);
        if (colIndex < 0) {
            Logger.error(String.valueOf(this.m_Select) + "AssembleRetrieve\u7684\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e0d\u662f\u5408\u6cd5\u7684\u5217");
            return "";
        }
        ColumnProperty_ pCP = (ColumnProperty_)this.getColumnProperty(colIndex);
        try {
            val = ObjectTool.ChangeType(value, this.getDataAdapter().DTN2JTN(pCP.m_DataTypeName, pCP));
        }
        catch (Exception e) {
            val = null;
        }
        String colDBName = pCP.m_DBName;
        String svalue = this.getDataAdapter().getFormatedTextValue(val, pCP.m_DataType, pCP.Scale);
        String operator = Operator.trim().toLowerCase();
        if (operator.equals("=") && pCP.getUniformDataType() == 4 && svalue.endsWith("00:00:00'")) {
            String s2 = svalue.replaceAll("00:00:00", "23:59:59");
            ret = "  ( " + colDBName + " >=" + svalue + " and " + colDBName + " <" + s2 + " )";
            return ret;
        }
        if (operator.equals("is") || svalue.toLowerCase().trim().equals("'null'")) {
            ret = "  ( " + colDBName + " is null )";
            if (!operator.equals("is not")) {
                return ret;
            }
        }
        if (operator.equals("is not")) {
            ret = "  ( not " + colDBName + " is null)  ";
            return ret;
        }
        if (svalue.trim().equals("")) {
            ret = " (" + colDBName + " " + Operator + ") ";
            return ret;
        }
        if (operator.equals("like")) {
            try {
                svalue = svalue.substring(1, svalue.length() - 1);
                if (!svalue.substring(0, 1).equals("%")) {
                    svalue = "%" + svalue;
                }
                if (!svalue.substring(svalue.length() - 1).equals("%")) {
                    svalue = String.valueOf(svalue) + "%";
                }
            }
            catch (Exception e) {
                svalue = "";
            }
            return " ( " + colDBName + " like  '" + svalue + "' ) ";
        }
        ret = " (" + colDBName + "  " + operator + "  " + svalue + ") ";
        return ret;
    }

    public String getCreateTableSyntax() throws Exception {
        return this.getCreateTableSyntax(false);
    }

    public String getCreateTableSyntax(String tableName, String primaryKey) throws Exception {
        return this.getCreateTableSyntax(tableName, primaryKey, true);
    }

    public String getCreateTableSyntax(boolean AllColumnIgnoreType) throws Exception {
        return this.getCreateTableSyntax(this.m_UpdateTable, this.m_PrimaryKey, AllColumnIgnoreType);
    }

    public String getCreateTableSyntax(String tableName, String primaryKey, boolean AllColumnIgnoreType) throws Exception {
        StringBuffer ret = new StringBuffer(1024);
        if (tableName.equals("")) {
            throw new Exception("\u5148\u7528SetUpdateTable\u8bbe\u7f6e\u53ef\u66f4\u65b0\u8868\u7684\u540d\u5b57");
        }
        if (primaryKey.equals("")) {
            throw new Exception("\u5148\u7528SetPrimaryKey\u8bbe\u7f6e\u4e3b\u952e\uff0c\u591a\u4e2a\u5217\u4e4b\u95f4\u7528,\u5206\u9694");
        }
        ret.append("create table " + tableName + " (\r\n");
        int cn = this.m_ColumnProperty.size();
        DataAdapter da = this.getDataAdapter();
        int i = 0;
        while (i < cn) {
            ColumnProperty_ pCP = (ColumnProperty_)this.m_ColumnProperty.get(i);
            if (pCP.m_ObjType == 0 || AllColumnIgnoreType) {
                try {
                    ret.append(" " + pCP.m_Name + " " + da.assembleColumnType(pCP.getDataTypeName(), pCP.getPrecision(), pCP.getScale(), pCP.getColumnTypeRedefine()));
                }
                catch (Exception e) {
                    Logger.error(String.valueOf(this.m_Select) + e.getMessage());
                }
                ret.append(pCP.isNullable() ? "  null" : " not null");
                ret.append(", \r\n");
            }
            ++i;
        }
        try {
            String pk = primaryKey;
            if (pk.charAt(0) == ',') {
                pk = pk.substring(1, pk.length() - 1);
            }
            if (pk.charAt(pk.length() - 1) == ',') {
                pk = pk.substring(0, pk.length() - 1);
            }
            ret.append(" primary  key (" + pk + "))");
        }
        catch (Exception e) {
            ret.append(" primary key(?))");
        }
        return ret.toString();
    }

    public Object clone() {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream(1024);
            ObjectOutputStream oo = new ObjectOutputStream(bao);
            oo.writeObject(this);
            oo.flush();
            oo.close();
            ByteArrayInputStream bai = new ByteArrayInputStream(bao.toByteArray());
            ObjectInputStream oi = new ObjectInputStream(bai);
            return (DataStore)oi.readObject();
        }
        catch (IOException e) {
            return this;
        }
        catch (ClassNotFoundException e) {
            return this;
        }
    }

    public int find(String expression, int startRow, int endRow) {
        int findResult = -1;
        this.m_Error.clear();
        int rc = this.m_PrimaryBuffer.size();
        Object v = null;
        int row = startRow;
        boolean findForward = startRow <= endRow;
        boolean bv = false;
        while (row >= 0 && row < rc) {
            v = this.m_PrimaryBuffer.evaluate(expression, row);
            if (this.m_Error.somethingIsWrong()) {
                if (expression == null) {
                    expression = " \u8868\u8fbe\u5f0f\u4e3anull";
                }
                Logger.error("find\u51fa\u73b0\u5f02\u5e38\uff1a" + this.m_Error.getMessage() + " \u8868\u8fbe\u5f0f\u662f\uff1a" + expression + " row=" + row);
                return -1;
            }
            try {
                bv = (Boolean)ObjectTool.ChangeType(v, "java.lang.Boolean");
            }
            catch (Exception e) {
                bv = false;
            }
            if (bv) {
                return row;
            }
            if (!(findForward ? ++row > endRow : --row < endRow)) continue;
            return -1;
        }
        return findResult;
    }

    public int fastFind(String col, Object v) {
        try {
            HashMap<String, Integer> map;
            col = col.toLowerCase();
            String vs = (String)ObjectTool.ChangeType(v, "java.lang.String");
            if (this.m_QuickValue2Row == null) {
                this.m_QuickValue2Row = new HashMap();
            }
            if ((map = this.m_QuickValue2Row.get(col)) == null) {
                map = new HashMap();
                this.m_QuickValue2Row.put(col, map);
                int rc = this.getRowCount();
                int i = 0;
                while (i < rc) {
                    String t = this.getString(i, col);
                    map.put(t, i);
                    ++i;
                }
            }
            if (map.containsKey(vs)) {
                return map.get(vs);
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setAbsolute(int row) {
        this.m_absolute = Math.max(1, row);
    }

    public void ignoreTopRow(int ir) {
        this.setAbsolute(ir + 1);
    }

    public int getAbsolute() {
        return Math.max(1, this.m_absolute);
    }

    public void setOnceRetrieveCount(int rc) {
        this.m_OnceRetrieveCount = Math.max(0, rc);
    }

    public int getOnceRetrieveCount() {
        return this.m_OnceRetrieveCount;
    }

    public void setOnceRetrieveTimeout(int rc) {
        this.m_OnceRetrieveTimeout = Math.max(0, rc);
        this.m_CloseResultsetAfterRetrieveOnce = this.m_OnceRetrieveTimeout > 0;
    }

    public int getOnceRetrieveTimeout() {
        return this.m_OnceRetrieveTimeout;
    }

    public int getDBRowCount() {
        if (this.m_DBRowCount != null) {
            return this.m_DBRowCount;
        }
        if (!this.RemoteFactoryURL.equals("")) {
            return this.getDBRowCountRemote();
        }
        this.m_DBRowCount = new Integer(0);
        if (this.m_Select.equals("")) {
            this.m_Error.parseError("\u8bf7\u5148\u8bbe\u7f6e Select ", this.getEvent());
            return 0;
        }
        try {
            this.AssumeConnectionIsValid();
        }
        catch (Exception e) {
            this.m_Error.parseError(e, this.getEvent());
            return 0;
        }
        String sql = this.m_Select;
        sql = DataStoreFactory.LinkUpWhere(sql, this.m_AdditionalWhere);
        sql = this.parseInnerParameter(sql, false);
        sql = this.getDataAdapter().toLocalSyntax(sql);
        if (this.m_CharsetAutoConvert) {
            sql = DataStoreFactory.stringCharsetConvert(sql, this.m_Charset, this.m_DBCharset);
        }
        try {
            this.m_DBRowCount = new Integer(DataStoreRemoteFactory.getRowCount(sql, this.m_Connection, this.m_timeout));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_DBRowCount;
    }

    private int getDBRowCountRemote() {
        if (this.RemoteFactoryURL.equals("")) {
            return this.getDBRowCountRemote();
        }
        RPCParameter p = new RPCParameter();
        String sql = this.m_Select;
        sql = this.parseInnerParameter(sql, false);
        p.put("dbpool", this.DBPoolName);
        p.put("select", sql);
        p.put("where", this.m_AdditionalWhere);
        p.put("CharsetAutoConvert", this.m_CharsetAutoConvert);
        p.put("Charset", this.m_Charset);
        p.put("DBCharset", this.m_DBCharset);
        p.put("timeout", this.m_timeout);
        p = RPC.Call(String.valueOf(this.RemoteFactoryURL) + "servlet/jun.db.rpc.DataStoreRemoteFactory", "getDBRowCountRemote", p);
        if (p.isSuccess()) {
            return p.get("count", 0);
        }
        this.getError().parseError(p.getErrorText(), this.getEvent());
        return 0;
    }

    public ArrayList getData() {
        return this.getData(0, this.getRowCount());
    }

    public ArrayList getData(int beginRow, int rowCount) {
        ArrayList data = new ArrayList();
        HashMap<String, Object> rowData = null;
        int start = beginRow;
        int end = Math.min(beginRow + rowCount, this.getRowCount());
        int i = start;
        while (i < end) {
            rowData = new HashMap<String, Object>();
            data.add(rowData);
            int j = 0;
            while (j < this.getColumnCount()) {
                rowData.put(this.getColumnName(j), this.getValue(i, j));
                ++j;
            }
            ++i;
        }
        return data;
    }

    public ArrayList getSafeData() {
        ArrayList data = new ArrayList();
        HashMap<String, Object> rowData = null;
        int i = 0;
        while (i < this.getRowCount()) {
            rowData = new HashMap<String, Object>();
            data.add(rowData);
            int j = 0;
            while (j < this.getColumnCount()) {
                Object v = this.getValue(i, j);
                if (v == null) {
                    v = this.getColumnProperty(j).getValueInsteadOfNull();
                }
                rowData.put(this.getColumnName(j), v);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public void charsetConvert(String sourceCharset, String toCharset) {
        this.setDBCharset(sourceCharset);
        this.setCharset(toCharset);
    }

    public String getCharset() {
        return this.m_Charset;
    }

    public String getDBCharset() {
        return this.m_DBCharset;
    }

    public String getRemoteFactoryURL() {
        return this.RemoteFactoryURL;
    }

    public void setCharset(String charset) {
        this.m_Charset = charset;
        if (charset.trim().equals("")) {
            this.m_Charset = null;
        }
    }

    public void setDBCharset(String dbCharset) {
        this.m_DBCharset = dbCharset;
        if (dbCharset.trim().equals("")) {
            this.m_DBCharset = null;
        }
    }

    public void setRemoteFactoryURL(String url) {
        this.RemoteFactoryURL = url;
        if (url.equals("")) {
            return;
        }
        if (!this.RemoteFactoryURL.endsWith("/") && !this.RemoteFactoryURL.endsWith("\\")) {
            this.RemoteFactoryURL = String.valueOf(this.RemoteFactoryURL) + "/";
        }
    }

    public String getDBPoolName() {
        return this.DBPoolName;
    }

    public void setDBPoolName(String dbPool) {
        this.DBPoolName = dbPool;
    }

    public boolean isCharsetAutoConvert() {
        return this.m_CharsetAutoConvert;
    }

    public void setCharsetAutoConvert(boolean auto) {
        this.m_CharsetAutoConvert = auto;
    }

    public boolean isAutoTrim() {
        return this.m_AutoTrim;
    }

    public void setAutoTrim(boolean autoTrim) {
        this.m_AutoTrim = autoTrim;
    }

    public boolean exportToImage(int row, String col, String fileName) {
        FileOutputStream fos = null;
        try {
            String s = this.getString(row, col);
            if (s.equals("")) {
                throw new Exception("\u6307\u5b9a\u7684\u6570\u636e\u4e0d\u662f\u56fe\u50cf");
            }
            if (!s.startsWith("$#{image}#$")) {
                throw new Exception("\u6307\u5b9a\u7684\u6570\u636e\u4e0d\u662f\u56fe\u50cf");
            }
            byte[] b = Base64Coder.decode(s.substring("$#{image}#$".length()).toCharArray());
            fos = new FileOutputStream(new File(fileName));
            fos.write(b);
            fos.flush();
            fos.close();
            return true;
        }
        catch (Exception e) {
            this.getError().parseError(e, this.getEvent());
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public boolean importImage(int row, String col, String fileName) {
        byte[] b = FileTools.ReadFile(fileName);
        if (b == null) {
            return false;
        }
        if (b.length == 0) {
            return false;
        }
        StringBuffer sb = new StringBuffer(1024);
        sb.append("$#{image}#$");
        sb.append(Base64Coder.encode(b));
        this.setValue(row, col, (Object)sb.toString());
        return true;
    }

    public void executeBatch(String sql) {
        this.executeBeforeUpdate(sql);
    }

    public void executeBeforeUpdate(String sql) {
        this.sqlBatch.add(sql);
    }

    public void executeAfterUpdate(String sql) {
        this.sqlBatch2.add(sql);
    }

    public String execute(String sql) {
        if (!this.RemoteFactoryURL.equals("")) {
            return this.executeRemote(sql);
        }
        this.m_Error.clear();
        this.getEvent().fireSqlPreview(sql);
        Statement cmd = null;
        try {
            try {
                sql = this.m_Connection.nativeSQL(sql);
                cmd = this.m_Connection.createStatement();
                cmd.execute(sql);
            }
            catch (SQLException e) {
                this.m_Error.parseError(e, this.getEvent());
                String string = e.getMessage();
                try {
                    cmd.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return string;
            }
        }
        finally {
            try {
                cmd.close();
            }
            catch (Exception exception) {}
        }
        return "";
    }

    public String executeRemote(String sql) {
        if (this.RemoteFactoryURL.equals("")) {
            return this.execute(sql);
        }
        RPCParameter p = new RPCParameter();
        this.m_Error.clear();
        this.getEvent().fireSqlPreview(sql);
        p.put("dbpool", this.DBPoolName);
        p.put("sql", sql);
        p.put("timeout", this.m_timeout);
        p = RPC.Call(String.valueOf(this.RemoteFactoryURL) + "servlet/jun.db.rpc.DataStoreRemoteFactory", "executeRemote", p);
        if (p.isSuccess()) {
            return "";
        }
        this.getError().parseError(p.getErrorText(), this.getEvent());
        return p.getErrorText();
    }

    public boolean clearValue(int row, int col) {
        return this.setValue(row, col, null);
    }

    public boolean clearValue(int row, String col) {
        return this.setValue(row, col, null);
    }

    public String getAsNoDataIfOnlySuchColumnsHoldData() {
        return this.m_AsNoDataIfOnlySuchColumnsHoldData;
    }

    public void setAsNoDataIfOnlySuchColumnsHoldData(String cols) {
        String[] c1 = this.m_AsNoDataIfOnlySuchColumnsHoldData.split("\\|");
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < c1.length) {
            list.add(c1[i].trim());
            ++i;
        }
        String[] ss = cols.split("\\|");
        int i2 = 0;
        while (i2 < ss.length) {
            String col = ss[i2].trim();
            if (!col.equals("")) {
                if (col.startsWith("~")) {
                    if (list.contains(col = col.substring(1))) {
                        list.remove(col);
                    }
                } else if (!list.contains(col)) {
                    list.add(col);
                }
            }
            ++i2;
        }
        StringBuffer sb = new StringBuffer();
        int n = list.size();
        int i3 = 0;
        while (i3 < n) {
            sb.append((String)list.get(i3));
            if (i3 != n - 1) {
                sb.append("|");
            }
            ++i3;
        }
        this.m_AsNoDataIfOnlySuchColumnsHoldData = sb.toString();
    }

    public boolean isTheRowHoldNoDataExceptSuchColumns(DataBuffer buffer, int row, String cols) {
        boolean ret = false;
        if (row < 0) {
            return false;
        }
        if (row >= buffer.getRowCount()) {
            return false;
        }
        if (cols.equals("")) {
            return false;
        }
        cols = "|" + cols + "|";
        int j = 0;
        while (j < buffer.getColumnCount()) {
            String vs;
            Object v;
            String colName;
            ColumnProperty CP = this.getColumnProperty(j);
            if (CP.getObjType() == 0 && cols.indexOf("|" + (colName = CP.getName()) + "|") < 0 && (v = buffer.getValue(row, j)) != null && !(vs = v.toString().trim()).equals("")) {
                Logger.info("isTheRowHoldNoDataExceptSuchColumns \u51fd\u6570\uff0c" + colName + "=" + vs + " \u8fd4\u56de\u8fd4\u56de false");
                return false;
            }
            ++j;
        }
        return true;
    }

    public boolean isTheRowHoldNoDataExceptSuchColumns(int row) {
        return this.isTheRowHoldNoDataExceptSuchColumns(this.m_PrimaryBuffer, row, this.m_AsNoDataIfOnlySuchColumnsHoldData);
    }

    public boolean isTheRowHoldNoDataExceptSuchColumns(int row, String cols) {
        return this.isTheRowHoldNoDataExceptSuchColumns(this.m_PrimaryBuffer, row, this.m_AsNoDataIfOnlySuchColumnsHoldData);
    }

    public boolean isTheRowHoldNoDataExceptSuchColumns(DataBuffer buffer, int row) {
        return this.isTheRowHoldNoDataExceptSuchColumns(buffer, row, this.m_AsNoDataIfOnlySuchColumnsHoldData);
    }

    public boolean isCloseResultsetAfterRetrieveOnce() {
        return this.m_CloseResultsetAfterRetrieveOnce;
    }

    public void setCloseResultsetAfterRetrieveOnce(boolean closeResultsetAfterRetrieveOnce) {
        this.m_CloseResultsetAfterRetrieveOnce = closeResultsetAfterRetrieveOnce;
    }

    public HashMap getColumnInfo() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("columnproperty", this.m_ColumnProperty);
        ret.put("name2index", this.m_ColumnName2Index);
        ret.put("fieldcount", new Integer(this.m_FieldCount));
        Logger.error(ret.toString());
        return ret;
    }

    private void setColumnInfo(HashMap map) {
        this.m_ColumnProperty = (ArrayList)map.get("columnproperty");
        this.m_ColumnName2Index = (Hashtable)map.get("name2index");
        this.m_FieldCount = (Integer)map.get("fieldcount");
        Logger.error("\u5b57\u6bb5\u4e2a\u6570\uff1a" + this.m_FieldCount);
        this.m_PrimaryBuffer.InitColumnCount(this.m_FieldCount);
        this.m_FilterBuffer.InitColumnCount(this.m_FieldCount);
        this.m_DeleteBuffer.InitColumnCount(this.m_FieldCount);
    }

    public Object getTag(String name) {
        return this.m_Tag.get(name);
    }

    public void setTag(String name, Object value) {
        this.m_Tag.put(name, value);
    }

    public boolean isNeedNotifyAggregateAndUnsureComputerInvalid() {
        return this.needNotifyAggregateAndUnsureComputerInvalid;
    }

    public void setNeedNotifyAggregateAndUnsureComputerInvalid(boolean needNotifyAggregateAndUnsureComputerInvalid) {
        this.needNotifyAggregateAndUnsureComputerInvalid = needNotifyAggregateAndUnsureComputerInvalid;
        if (needNotifyAggregateAndUnsureComputerInvalid) {
            this.m_PrimaryBuffer.notifyAggregateAndUnsureComputerInvalid();
        }
    }

    public boolean importUpdate() {
        boolean b = this.m_PrimaryBuffer.importUpdate();
        if (b) {
            this.resetUpdate();
        }
        return b;
    }

    public boolean isBlobUnRetrieve() {
        return this.m_blobUnRetrieve;
    }

    public void setBlobUnRetrieve(boolean unRetrieve) {
        this.m_blobUnRetrieve = unRetrieve;
    }

    public boolean isSetValueWithTrigger() {
        return this.m_SetValueWithTrigger;
    }

    public void setSetValueWithTrigger(boolean mSetValueWithTrigger) {
        this.m_SetValueWithTrigger = mSetValueWithTrigger;
    }

    public String getJSONRow(int row) {
        return this.getJSONRow(row, true);
    }

    public String getJSONRow(int row, boolean forceConvertToString) {
        return this.getJSON(row, forceConvertToString).toString();
    }

    public JSONObject getJSON(int row, boolean forceConvertToString) {
        JSONObject ret = new JSONObject();
        if (row < 0 || row > this.getRowCount() - 1) {
            return ret;
        }
        int n = this.getColumnCount();
        int i = 0;
        while (i < n) {
            Object v = forceConvertToString ? this.getString(row, i) : this.getValue(row, i);
            ret.put(this.getColumnName(i).toLowerCase(), v);
            ++i;
        }
        return ret;
    }

    public JSONObject getJSON(int row, boolean forceConvertToString, boolean useColIndex) {
        return this.getJSON(row, forceConvertToString, useColIndex, false);
    }

    public JSONObject getJSON(int row, boolean forceConvertToString, boolean useColIndex, boolean withStatus) {
        return this.getJSON(row, forceConvertToString, useColIndex, withStatus, false);
    }

    public JSONObject getJSON(int row, boolean forceConvertToString, boolean useColIndex, boolean withStatus, boolean null2nullString) {
        JSONObject ret = new JSONObject();
        if (row < 0 || row > this.getRowCount() - 1) {
            return ret;
        }
        int n = this.getColumnCount();
        int i = 0;
        while (i < n) {
            boolean isNull;
            Object v = this.getValue(row, i);
            boolean bl = isNull = v == null;
            if (forceConvertToString) {
                v = this.getString(row, i);
            }
            String colName = (useColIndex ? "c" + i : this.getColumnName(i)).toLowerCase();
            if (isNull) {
                ret.put(colName, null2nullString ? "" : null);
            } else {
                ret.put(colName, v);
            }
            if (withStatus) {
                ret.put("$colStatus_" + colName, this.m_PrimaryBuffer.getItemStatus(row, i));
                v = this.getValue(row, i, true);
                boolean bl2 = isNull = v == null;
                if (forceConvertToString && !isNull) {
                    v = this.getString(row, i, "", true);
                }
                if (isNull) {
                    ret.put("$colOriginal_" + colName, null);
                } else {
                    ret.put("$colOriginal_" + colName, v);
                }
            }
            ++i;
        }
        if (withStatus) {
            ret.put("$rowStatus", this.m_PrimaryBuffer.getRow(row).getRowStatus());
        }
        return ret;
    }

    public boolean isDataModified(int row, int col) {
        if (row < 0) {
            return false;
        }
        if (col < 0) {
            return false;
        }
        return this.getPrimaryBuffer().getItemStatus(row, col) == 1;
    }

    public boolean isDataModified(int row, String col) {
        int colIndex = this.col2Index(col);
        return this.isDataModified(row, colIndex);
    }

    public boolean isModified(int row, int col) {
        if (this.isDataModified(row, col)) {
            return true;
        }
        return this.isNewModified(row, col);
    }

    public boolean isModified(int row, String col) {
        int colIndex = this.col2Index(col);
        return this.isModified(row, colIndex);
    }

    public boolean isNew(int row, int col) {
        if (row < 0) {
            return false;
        }
        if (col < 0) {
            return false;
        }
        return this.getPrimaryBuffer().getItemStatus(row, col) == 2;
    }

    public boolean isNew(int row, String col) {
        int colIndex = this.col2Index(col);
        return this.isNew(row, colIndex);
    }

    public boolean isNewModified(int row, int col) {
        if (row < 0) {
            return false;
        }
        if (col < 0) {
            return false;
        }
        return this.getPrimaryBuffer().getItemStatus(row, col) == 3;
    }

    public boolean isNewModified(int row, String col) {
        int colIndex = this.col2Index(col);
        return this.isNewModified(row, colIndex);
    }

    public boolean isNotModified(int row, int col) {
        if (row < 0) {
            return false;
        }
        if (col < 0) {
            return false;
        }
        return this.getPrimaryBuffer().getItemStatus(row, col) == 0;
    }

    public boolean isNotModified(int row, String col) {
        int colIndex = this.col2Index(col);
        return this.isNotModified(row, colIndex);
    }

    public int getGuardLineOnRetrieve() {
        return this.guardLine;
    }

    public void setGuardLineOnRetrieve(int gl) {
        this.guardLine = gl;
    }

    public boolean isEdited(int row, int col) {
        DsItem item = ((DataBuffer_)this.getPrimaryBuffer()).getItem(row, col);
        if (item == null) {
            return false;
        }
        return item.m_isEdited == 1;
    }

    public boolean isEdited(int row, String col) {
        int colIndex = this.col2Index(col);
        return this.isEdited(row, colIndex);
    }

    public boolean columnExists(String colName) {
        String col = colName.trim().toLowerCase();
        return this.m_ColumnName2Index.containsKey(col);
    }

    public void moveDown(int row) {
        DataBuffer_ buffer = (DataBuffer_)this.getPrimaryBuffer();
        if (row >= this.getRowCount() - 1) {
            return;
        }
        if (row < 0) {
            return;
        }
        ArrayList list = buffer.GetBuffer();
        DsRow rowData = (DsRow)list.get(row);
        list.remove(row);
        list.add(row + 1, rowData);
        buffer.notifyAggregateAndUnsureComputerInvalid();
    }

    public void setBalloonTip(int row, String col, String type, String info) {
        DataBuffer_ buffer = (DataBuffer_)this.getPrimaryBuffer();
        buffer.setBalloonTip(row, col, type, info);
    }

    public String getBalloonTip(int row, String col, String type) {
        DataBuffer_ buffer = (DataBuffer_)this.getPrimaryBuffer();
        return buffer.getBalloonTip(row, col, type);
    }

    public int getGroupsRowCount() {
        return 0;
    }

    public int getGroupsRowCount(int beforeRow) {
        Hashtable table = (Hashtable)this.getFriendlyProperty("m_MapGroups");
        int ret = 0;
        for (Object k : table.keySet()) {
            if (((Number)k).intValue() >= beforeRow) continue;
            ArrayList v = (ArrayList)table.get(k);
            ret += v.size();
        }
        return ret;
    }

    public int getGroupsRowCount(int startRow, int endRow, int underGroupLevel) {
        Hashtable table = (Hashtable)this.getFriendlyProperty("m_MapGroups");
        int ret = 0;
        for (Object k : table.keySet()) {
            int row = ((Number)k).intValue();
            if (row < startRow || row > endRow) continue;
            ArrayList v = (ArrayList)table.get(k);
            int n = v.size();
            int i = 0;
            while (i < n) {
                if (((Number)v.get(i)).intValue() > underGroupLevel) {
                    ++ret;
                }
                ++i;
            }
        }
        return ret;
    }

    public boolean isAutoDeleteNoDataRow() {
        return this.m_autoDeleteNoDataRow;
    }

    public void setAutoDeleteNoDataRow(boolean autoDelete) {
        this.m_autoDeleteNoDataRow = autoDelete;
    }

    public void setAutoResetBeforeRetrieve(boolean autoReset) {
        this.m_AutoResetBeforeRetrieve = autoReset;
    }

    public boolean isAutoResetBeforeRetrieve() {
        return this.m_AutoResetBeforeRetrieve;
    }

    public void setCurrentFocusRow(int row) {
        this.m_currentFocusRow = row;
    }

    public int getCurrentFocusRow() {
        return this.m_currentFocusRow;
    }

    public void setColumnFormat(String col, String format) {
        ColumnProperty cp = this.getColumnProperty(col);
        if (cp == null) {
            return;
        }
        cp.setFormat(format);
    }

    class FutureStatement
    implements Callable {
        private Statement cmd;
        private String sql;
        private int absolute;
        private int onceRetrieveCount;
        private DataAdapter da;
        private boolean closeResultsetAfterRetrieveOnce;

        public FutureStatement(Statement cmd, String sql) {
            this(cmd, sql, 0, 0, null, true);
        }

        public FutureStatement(Statement cmd, String sql, int absolute, int onceRetrieveCount, DataAdapter da, boolean closeResultsetAfterRetrieveOnce) {
            this.cmd = cmd;
            this.sql = sql;
            this.absolute = absolute;
            this.onceRetrieveCount = onceRetrieveCount;
            this.da = da;
            this.closeResultsetAfterRetrieveOnce = closeResultsetAfterRetrieveOnce;
        }

        public Object call() throws Exception {
            if (this.cmd instanceof CallableStatement || this.sql.equals("")) {
                return ((CallableStatement)this.cmd).executeQuery();
            }
            if (this.da != null && this.da.isMySQL() && this.onceRetrieveCount > 0) {
                int fromRow = Math.max(0, this.absolute - 1);
                int toRow = this.onceRetrieveCount;
                if (!this.closeResultsetAfterRetrieveOnce) {
                    toRow = Integer.MAX_VALUE;
                }
                this.sql = String.valueOf(this.sql) + " limit " + fromRow + "," + toRow;
            }
            ResultSet rs = this.cmd.executeQuery(this.sql);
            return rs;
        }
    }
}

