/*
 * Decompiled with CFR 0.152.
 */
package jun.db.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import jun.db.core.DataStore;
import jun.db.impl.DataAdapterDefault;
import org.apache.regexp.RE;

class DataAdapterH2
extends DataAdapterDefault {
    public DataAdapterH2(DataStore ds) {
        super(ds);
        this.m_DateSeparator = ".";
        this.m_DBProvider = "H2 JDBC Driver";
        HashMap map = this.getDataTypeMap();
        map.put("varchar2", "varchar");
        map.put("number", "numeric");
    }

    public Object getDataFromResultSet(ResultSet rs, int col, int dt) throws Exception {
        if (dt == 2005) {
            String s = DataAdapterH2.getClobString(rs, col);
            return s;
        }
        return super.getDataFromResultSet(rs, col, dt);
    }

    public String getFormatedTextValue(Object v, int dataType, int decimalCount) {
        String bstr = super.getFormatedTextValue(v, dataType, decimalCount);
        if (v == null) {
            return bstr;
        }
        switch (dataType) {
            case 91: {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                bstr = "'" + sdf.format(v) + "'";
                break;
            }
            case 93: {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSS");
                bstr = "'" + sdf.format(v) + "'";
            }
        }
        return bstr;
    }

    public String toLocalSyntax(String sql) {
        String rq;
        RE re = new RE("\\s*([a-zA-Z0-9_]+)\\s*([><=!]{1,2})\\s*\\(*\\s*'([0-9]{4}\\.[0-9]{2}\\.[0-9]{2})'\\s*\\)*\\s*");
        while (re.match(sql)) {
            int i = 0;
            while (i < re.getParenCount()) {
                ++i;
            }
            rq = sql.substring(re.getParenStart(3), re.getParenEnd(3));
            rq = String.valueOf(rq.replaceAll("[.]", "-")) + " 00:00:00";
            sql = String.valueOf(sql.substring(0, re.getParenStart(3))) + rq + sql.substring(re.getParenEnd(3));
        }
        re = new RE("\\s*([a-zA-Z0-9_]+)\\s*([><=!]{1,2})\\s*\\(*\\s*('[0-9]{4}\\.[0-9]{2}\\.[0-9]{2}\\s[0-9]{2}:[0-9]{2}:[0-9]{2}')\\s*\\)*\\s*");
        while (re.match(sql)) {
            int i = 0;
            while (i < re.getParenCount()) {
                ++i;
            }
            rq = sql.substring(re.getParenStart(3), re.getParenEnd(3));
            rq = rq.replaceAll("[.]", "-");
            sql = String.valueOf(sql.substring(0, re.getParenStart(3))) + rq + sql.substring(re.getParenEnd(3));
        }
        return sql;
    }

    private String checkSequenceName(String name) {
        return name.replaceAll("[.]", "_");
    }

    private void $InitSequence(Connection con, String name, String value, int increment) {
        name = this.checkSequenceName(name);
        if (increment == -1) {
            name = String.valueOf(name) + "_negative";
        }
        value = value.trim();
        Statement st = null;
        try {
            try {
                if (value.equals("")) {
                    value = "0";
                }
                boolean initValueIsNumber = false;
                long v = 0L;
                try {
                    initValueIsNumber = Long.valueOf(value).toString().equals(value);
                    v = initValueIsNumber ? Long.valueOf(value) : DataAdapterH2._getLongFromSql(con, value);
                }
                catch (Exception e) {
                    initValueIsNumber = false;
                    v = DataAdapterH2._getLongFromSql(con, value);
                }
                st = con.createStatement();
                DataAdapterH2.SafeExecuteSQL(st, "create sequence   " + name + "  START WITH " + (v += (long)increment) + " INCREMENT BY    " + increment);
                long cv = DataAdapterH2._getLongFromSql(con, " select currval( '" + name + "') ");
                if (Math.abs(cv) < Math.abs(v)) {
                    DataAdapterH2.SafeExecuteSQL(st, "ALTER  sequence   " + name + " RESTART WITH " + v + " INCREMENT BY  " + increment);
                }
                st.close();
                st = null;
            }
            catch (Exception cee) {
                cee.printStackTrace();
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void InitNegativeSequence(Connection con, String name, String value) {
        this.$InitSequence(con, name, value, -1);
    }

    public void InitSequence(Connection con, String name, String value) {
        this.$InitSequence(con, name, value, 1);
    }

    public int NextNegativeSequence(Connection con, String name) {
        name = this.checkSequenceName(String.valueOf(name) + "_negative");
        long v = DataAdapterH2._getLongFromSql(con, " select nextval( '" + name + "') ");
        return (int)v;
    }

    public int NextSequence(Connection con, String name) {
        name = this.checkSequenceName(name);
        long v = DataAdapterH2._getLongFromSql(con, " select nextval( '" + name + "') ");
        return (int)v;
    }
}

