/*
 * Decompiled with CFR 0.152.
 */
package jun.db.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import jun.db.core.ColumnProperty;
import jun.db.core.DataAdapter;
import jun.db.core.DataStore;
import jun.db.core.ObjectTool;
import jun.db.impl.AggregateDefine;
import jun.xml.write.XmlWriter;

class ColumnProperty_
implements Serializable,
ColumnProperty {
    DataStore m_ds;
    String m_Name;
    String m_DBName;
    String m_DBTable;
    String m_DatabaseName;
    boolean m_UpdateWhereClause;
    boolean m_Updatable;
    int m_DataType;
    int m_UniformDataType;
    String m_DataTypeName;
    int m_ObjType;
    String m_Formula;
    Hashtable m_DependMap = null;
    Hashtable m_AffectMap = null;
    String m_ColumnLabel = "";
    Object m_ColumnTag = null;
    Object m_DefaultValue = null;
    String m_ColumnClassName = "";
    boolean m_IncludeUnsureFunction = false;
    String m_FillBack = "";
    String m_typeRedefine = "";
    int ColumnDisplaySize;
    int Precision;
    int Scale;
    boolean Nullable;
    HashMap m_Property = null;
    String m_format = "";
    AggregateDefine m_AggregateDefine = new AggregateDefine();
    private Object m_InsteadOfNull = null;
    private Map m_Data2ViewMap = null;

    private ColumnProperty_() {
    }

    public ColumnProperty_(DataStore ds) {
        this.m_ds = ds;
    }

    public Object getValueInsteadOfNull() {
        if (this.m_InsteadOfNull != null) {
            return this.m_InsteadOfNull;
        }
        switch (this.m_UniformDataType) {
            case 1: {
                this.m_InsteadOfNull = new Integer(0);
                break;
            }
            case 2: {
                this.m_InsteadOfNull = new BigDecimal("0");
                break;
            }
            case 3: {
                this.m_InsteadOfNull = new String("");
                break;
            }
            case 4: {
                this.m_InsteadOfNull = new Date(0L);
                break;
            }
            case 5: {
                this.m_InsteadOfNull = new String("");
                break;
            }
            case 6: {
                this.m_InsteadOfNull = new String("");
            }
        }
        return this.m_InsteadOfNull;
    }

    public boolean setValueInsteadOfNull(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            this.m_InsteadOfNull = ObjectTool.ObjectClone(obj);
            switch (this.m_UniformDataType) {
                case 1: {
                    ObjectTool.ChangeType(this.m_InsteadOfNull, "java.lang.Integer");
                    break;
                }
                case 2: {
                    ObjectTool.ChangeType(this.m_InsteadOfNull, "java.math.BigDecimal");
                    break;
                }
                case 3: {
                    ObjectTool.ChangeType(this.m_InsteadOfNull, "java.lang.String");
                    break;
                }
                case 4: {
                    ObjectTool.ChangeType(this.m_InsteadOfNull, "java.util.Date");
                    break;
                }
                case 5: {
                    ObjectTool.ChangeType(this.m_InsteadOfNull, "java.lang.String");
                    break;
                }
                case 6: {
                    ObjectTool.ChangeType(this.m_InsteadOfNull, "java.lang.String");
                }
            }
            return true;
        }
        catch (Exception e) {
            this.m_InsteadOfNull = null;
            return false;
        }
    }

    public int getUniformDataType() {
        return this.m_UniformDataType;
    }

    public void serializerToXML(XmlWriter xml) {
        try {
            xml.S("column").A("name", this.m_Name).A("dbname", this.m_DBName).A("dbtable", this.m_DBTable).A("whereclause", this.m_UpdateWhereClause).A("updatable", this.m_Updatable).A("datatype", this.m_DataType).A("uniformtype", this.m_UniformDataType).A("objecttype", this.m_ObjType).A("formula", this.m_Formula).A("depend", "").A("affect", "").A("label", this.m_ColumnLabel).A("tag", String.valueOf(this.m_ColumnTag)).A("aggregatetype", this.m_AggregateDefine.m_AggregateType).A("aggregategroupno", this.m_AggregateDefine.m_GroupNo).E();
        }
        catch (Exception e) {
            return;
        }
    }

    public String getColumnLabel() {
        return this.m_ColumnLabel;
    }

    public void setColumnLabel(String columnLabel) {
        this.m_ColumnLabel = columnLabel;
    }

    public Object getColumnTag() {
        return this.m_ColumnTag;
    }

    public void setColumnTag(Object columnTag) {
        this.m_ColumnTag = columnTag;
    }

    public boolean isUpdatable() {
        return this.m_Updatable;
    }

    public void setUpdatable(boolean updatable) {
        if (this.m_ObjType != 0) {
            return;
        }
        this.m_Updatable = updatable;
    }

    public boolean isInUpdateWhereClause() {
        return this.m_UpdateWhereClause;
    }

    public void setUpdateWhereClause(boolean updateWhereClause) {
        this.m_UpdateWhereClause = updateWhereClause;
    }

    public int getDataType() {
        return this.m_DataType;
    }

    public String getDataTypeName() {
        return this.m_DataTypeName;
    }

    public String getDBName() {
        return this.m_DBName;
    }

    public String getDBTable() {
        return this.m_DBTable;
    }

    public void setDBTable(String table) {
        this.m_DBTable = table;
    }

    public String getFormula() {
        return this.m_Formula;
    }

    public String getName() {
        return this.m_Name;
    }

    public int getObjType() {
        return this.m_ObjType;
    }

    public int getColumnDisplaySize() {
        return this.ColumnDisplaySize;
    }

    public void setColumnDisplaySize(int columnDisplaySize) {
        this.ColumnDisplaySize = columnDisplaySize;
    }

    public boolean isNullable() {
        return this.Nullable;
    }

    public void setNullable(boolean nullable) {
        this.Nullable = nullable;
    }

    public int getPrecision() {
        return this.Precision;
    }

    public void setPrecision(int precision) {
        this.Precision = precision;
    }

    public int getScale() {
        return this.Scale;
    }

    public void setScale(int scale) {
        this.Scale = scale;
    }

    public Object getDefaultValue() {
        return this.m_DefaultValue;
    }

    public void setDefaultValue(Object value) {
        this.m_DefaultValue = value;
    }

    public Object getProperty(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.getPropertyCount()) {
            return null;
        }
        if (this.m_Property == null) {
            return null;
        }
        Iterator it = this.m_Property.keySet().iterator();
        int n = 0;
        while (it.hasNext()) {
            if (n == index) {
                return this.m_Property.get(it.next().toString());
            }
            ++n;
            it.next();
        }
        return null;
    }

    public Object getProperty(String propName) {
        if (this.m_Property == null) {
            return null;
        }
        if (this.m_Property.containsKey(propName)) {
            return this.m_Property.get(propName);
        }
        return null;
    }

    public int getPropertyCount() {
        if (this.m_Property == null) {
            return 0;
        }
        return this.m_Property.size();
    }

    public void setProperty(String propName, Object value) {
        if (this.m_Property == null) {
            this.m_Property = new HashMap();
        }
        this.m_Property.put(propName, value);
    }

    public Map getData2ViewMap() {
        return this.m_Data2ViewMap;
    }

    public void setData2ViewMap(Map map) {
        this.m_Data2ViewMap = map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getViewText(Object data) {
        if (data == null) {
            return "";
        }
        String s = this.m_ds.getDataAdapter().getFormatedTextValue(data, this.m_DataType, this.Scale);
        try {
            if (this.m_Data2ViewMap == null) {
                if (data != null) return s;
                return "";
            }
            if (this.m_Data2ViewMap.containsKey(data)) {
                String ret = (String)this.m_Data2ViewMap.get(data);
                if (ret != null) return ret;
                return "";
            }
            Iterator it = this.m_Data2ViewMap.keySet().iterator();
            Object retvalue = data;
            while (it.hasNext()) {
                Object key = it.next();
                if (key == null) continue;
                if (key.equals(data)) {
                    retvalue = this.m_Data2ViewMap.get(key);
                    break;
                }
                if (!key.toString().equals(s)) continue;
                retvalue = this.m_Data2ViewMap.get(key);
                break;
            }
            if (retvalue != null) return retvalue.toString();
            return "";
        }
        catch (Exception e) {
            return "\u9519\u8bef\uff1a" + e.getMessage();
        }
    }

    public String getFillBack() {
        return this.m_FillBack;
    }

    public void setFillBack(String dbcol) {
        this.m_FillBack = dbcol;
    }

    public boolean isIncludeUnsureFunction() {
        return this.m_IncludeUnsureFunction;
    }

    public void setIncludeUnsureFunction(boolean includeUnsureFunction) {
        this.m_IncludeUnsureFunction = includeUnsureFunction;
    }

    public String getColumnClassName() {
        return this.m_ColumnClassName;
    }

    public String getDBTypeAndPrecision() {
        DataAdapter da = this.m_ds.getDataAdapter();
        try {
            return da.assembleColumnType(this.getDataTypeName(), this.getPrecision(), this.getScale(), this.getColumnTypeRedefine());
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String getColumnTypeRedefine() {
        return this.m_typeRedefine;
    }

    public void setColumnTypeRedefine(String type) {
        this.m_typeRedefine = type;
    }

    public String getDatabaseName() {
        return this.m_DatabaseName;
    }

    public void setFormat(String format) {
        this.m_format = format;
    }

    public String getFormat() {
        return this.m_format;
    }
}

