/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import java.io.DataInput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Arrays;

public final class Utils {
    public static final int ALIGN_LEFT = 10;
    public static final int ALIGN_RIGHT = 12;

    private Utils() {
    }

    public static int readLittleEndianInt(DataInput in) throws IOException {
        int bigEndian = 0;
        int shiftBy = 0;
        while (shiftBy < 32) {
            bigEndian |= (in.readUnsignedByte() & 0xFF) << shiftBy;
            shiftBy += 8;
        }
        return bigEndian;
    }

    public static short readLittleEndianShort(DataInput in) throws IOException {
        int low = in.readUnsignedByte() & 0xFF;
        int high = in.readUnsignedByte();
        return (short)(high << 8 | low);
    }

    public static byte[] trimLeftSpaces(byte[] arr) {
        StringBuffer t_sb = new StringBuffer(arr.length);
        int i = 0;
        while (i < arr.length) {
            if (arr[i] != 32) {
                t_sb.append((char)arr[i]);
            }
            ++i;
        }
        return t_sb.toString().getBytes();
    }

    public static short littleEndian(short value) {
        short num1 = value;
        int mask = 255;
        short num2 = (short)(num1 & mask);
        num2 = (short)(num2 << 8);
        mask = (short)(mask << 8);
        num2 = (short)(num2 | (num1 & mask) >> 8);
        return num2;
    }

    public static int littleEndian(int value) {
        int num1 = value;
        int mask = 255;
        int num2 = 0;
        num2 |= num1 & mask;
        int i = 1;
        while (i < 4) {
            num2 <<= 8;
            num2 |= (num1 & (mask <<= 8)) >> 8 * i;
            ++i;
        }
        return num2;
    }

    public static byte[] textPadding(String text, String characterSetName, int length) throws UnsupportedEncodingException {
        return Utils.textPadding(text, characterSetName, length, 10);
    }

    public static byte[] textPadding(String text, String characterSetName, int length, int alignment) throws UnsupportedEncodingException {
        return Utils.textPadding(text, characterSetName, length, alignment, (byte)32);
    }

    public static byte[] textPadding(String text, String characterSetName, int length, int alignment, byte paddingByte) throws UnsupportedEncodingException {
        byte[] srcByteArray = text.getBytes(characterSetName);
        byte[] dstByteArray = new byte[length];
        Arrays.fill(dstByteArray, paddingByte);
        int dstLength = 0;
        dstLength = srcByteArray.length >= length ? (length % 2 == 0 ? length : length - 1) : srcByteArray.length;
        switch (alignment) {
            case 10: {
                System.arraycopy(srcByteArray, 0, dstByteArray, 0, dstLength);
                break;
            }
            case 12: {
                System.arraycopy(srcByteArray, 0, dstByteArray, length - dstLength, dstLength);
            }
        }
        return dstByteArray;
    }

    public static byte[] doubleFormating(Double doubleNum, String characterSetName, int fieldLength, int sizeDecimalPart) throws UnsupportedEncodingException {
        int sizeWholePart = fieldLength - (sizeDecimalPart > 0 ? sizeDecimalPart + 1 : 0);
        StringBuffer format = new StringBuffer(fieldLength);
        int i = 0;
        while (i < sizeWholePart) {
            format.append("#");
            ++i;
        }
        if (sizeDecimalPart > 0) {
            format.append(".");
            i = 0;
            while (i < sizeDecimalPart) {
                format.append("0");
                ++i;
            }
        }
        DecimalFormat df = new DecimalFormat(format.toString());
        return Utils.textPadding(df.format(doubleNum).toString(), characterSetName, fieldLength, 12);
    }

    public static boolean contains(byte[] arr, byte value) {
        boolean found = false;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == value) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }
}

