/*
 * Decompiled with CFR 0.152.
 */
package excel.tab;

import excel.core.WorkSheet;
import excel.tab.TabButton;
import excel.util.Tools;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

class TabNameEdit
extends JTextField
implements FocusListener,
KeyListener {
    private WorkSheet Sheet;
    private TabButton Button;
    private boolean Escape = false;

    TabNameEdit() {
    }

    public void BeginEdit(WorkSheet sheet, TabButton button) {
        this.Sheet = sheet;
        this.Button = button;
        String s = sheet.getName();
        this.setText(s);
        this.setFont(Tools.GetFont("\u5b8b\u4f53", 12, false, false, false));
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.setSelectionStart(0);
        this.setSelectionEnd(s.length());
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.Escape) {
            return;
        }
        String s = this.getText();
        this.Sheet.setName(s);
        this.Button.remove(this);
        this.Button.repaint();
    }

    public void keyTyped(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 9: 
            case 10: {
                e.consume();
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 9: {
                this.Sheet.getWorkSheetView().requestFocusInWindow();
                break;
            }
            case 10: {
                this.Sheet.getWorkSheetView().requestFocusInWindow();
                break;
            }
            case 27: {
                this.Escape = true;
                this.Sheet.getWorkSheetView().requestFocusInWindow();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

