/*
 * Decompiled with CFR 0.152.
 */
package excel.setting;

import excel.core.Range;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import excel.core.impl.Range_;
import excel.setting.ColorMenu;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;

public class CellsBorderDraw
extends JPanel {
    WorkBook Book;
    private JComboBox cbo_style;
    private JButton jb_color;
    Object[] LineStyle;
    Object[] bw = new Object[9];
    private JComboBox cbo_border;
    private JButton jb_ok;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new CellsBorderDraw(null));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public CellsBorderDraw(WorkBook book) {
        this.Book = book;
        int i = 0;
        while (i < 9) {
            this.bw[i] = new Integer(i);
            ++i;
        }
        this.LineStyle = new Object[14];
        i = 0;
        while (i < 14) {
            this.LineStyle[i] = new Integer(i);
            ++i;
        }
        this.initGUI();
        ImageIcon[] imgBorder = new ImageIcon[]{new ImageIcon(Tools.GetImageFromURL(this, "excel/img/bs_left.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/bs_right.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/bs_top.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/bs_bottom.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/bs_innerh.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/bs_innerv.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/bs_outer.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/bs_inner.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/bs_all.gif"))};
        ComboBoxRenderer borderRender = new ComboBoxRenderer(imgBorder);
        borderRender.setPreferredSize(new Dimension(24, 24));
        this.cbo_border.setRenderer(borderRender);
        this.cbo_border.setMaximumRowCount(9);
        this.cbo_border.setFocusable(true);
        ImageIcon[] images = new ImageIcon[]{new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_0_0.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_1_1.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_2_1.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_3_1.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_4_1.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_1_2.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_2_2.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_3_2.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_4_2.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_1_3.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_2_3.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_3_3.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_4_3.gif")), new ImageIcon(Tools.GetImageFromURL(this, "excel/img/b_5_1.gif"))};
        ComboBoxRenderer renderer = new ComboBoxRenderer(images);
        renderer.setPreferredSize(new Dimension(100, 20));
        this.cbo_style.setRenderer(renderer);
        this.cbo_style.setMaximumRowCount(14);
        this.cbo_style.setFocusable(true);
        this.jb_color.setFocusable(true);
    }

    private void initGUI() {
        try {
            this.setPreferredSize(new Dimension(315, 37));
            this.setLayout(null);
            this.cbo_style = new JComboBox<Object>(this.LineStyle);
            this.add(this.cbo_style);
            this.cbo_style.setBounds(78, 5, 134, 21);
            this.jb_color = new JButton();
            this.add(this.jb_color);
            this.jb_color.setBounds(220, 6, 23, 21);
            this.jb_color.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    CellsBorderDraw.this.jb_colorActionPerformed(evt);
                }
            });
            this.cbo_border = new JComboBox<Object>(this.bw);
            this.add(this.cbo_border);
            this.cbo_border.setBounds(10, 4, 60, 21);
            this.jb_ok = new JButton();
            this.add(this.jb_ok);
            this.jb_ok.setBounds(249, 6, 60, 21);
            this.jb_ok.setText("\u786e\u5b9a");
            this.jb_ok.setFont(new Font("Dialog", 0, 12));
            this.jb_ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    CellsBorderDraw.this.jb_okActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jb_okActionPerformed(ActionEvent evt) {
        int whichSide = this.getWhichSide();
        int style = this.getBorderStyle();
        int width = this.getBorderWidth();
        Color color = this.getBorderColor();
        WorkSheet sheet = this.Book.getActiveSheet();
        if (sheet == null) {
            return;
        }
        Range r = sheet.getSelection();
        if (sheet.getMergeMap().containsValue(r)) {
            r = new Range_(r.getStartRow(), r.getStartCol(), r.getStartRow(), r.getStartCol());
        }
        sheet.setRangeBorder(r, whichSide, style, width, color);
    }

    private int getWhichSide() {
        return this.cbo_border.getSelectedIndex();
    }

    private int getBorderStyle() {
        int n = this.cbo_style.getSelectedIndex();
        if (n == 0) {
            return 0;
        }
        if (n == 13) {
            return 5;
        }
        int ret = n % 4;
        if (ret == 0) {
            ret = 4;
        }
        return ret;
    }

    private int getBorderWidth() {
        int n = this.cbo_style.getSelectedIndex();
        if (n == 0) {
            return 0;
        }
        if (n == 13) {
            return 3;
        }
        return (n - 1) / 4 + 1;
    }

    private Color getBorderColor() {
        return this.jb_color.getBackground();
    }

    private void jb_colorActionPerformed(ActionEvent evt) {
        ColorMenu m_color = new ColorMenu(" \u989c\u8272");
        JPopupMenu menu = new JPopupMenu();
        m_color.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorMenu m = (ColorMenu)e.getSource();
                Color color = m.getColor();
                CellsBorderDraw.this.jb_color.setBackground(color);
            }
        });
        menu.add(m_color);
        menu.show(this, this.jb_color.getX(), this.jb_color.getY());
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        ImageIcon[] images;

        public ComboBoxRenderer(ImageIcon[] imgs) {
            this.images = imgs;
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int selectedIndex = (Integer)value;
            if (isSelected) {
                this.setBackground(new Color(185, 205, 185));
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            ImageIcon icon = this.images[selectedIndex];
            this.setIcon(icon);
            return this;
        }
    }
}

