/*
 * Decompiled with CFR 0.152.
 */
package excel.print;

import excel.core.impl.WorkSheetView_;
import excel.core.impl.WorkSheet_;
import excel.print.PrintBook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import sos.preview.JPrintPreviewPane;
import sos.preview.PrintPreviewSupport;

public class PrintPreview
implements Printable {
    private JFrame frame;
    private JPrintPreviewPane printPreviewPane;
    private PrintBook sampleBook;
    private WorkSheetView_ View;
    PrintService Service;
    PageFormat page;
    HashPrintRequestAttributeSet config;
    private boolean needPreview = true;

    public PrintPreview(WorkSheetView_ view, boolean preview) {
        this.View = view;
        this.needPreview = preview;
    }

    public void setPrintParameter(PrintService service, PageFormat page, HashPrintRequestAttributeSet config) {
        this.Service = service;
        this.page = page;
        this.config = config;
    }

    private JPanel createZoomTab(PrintPreviewSupport support, JFrame frame) {
        final JFrame pFrame = frame;
        JPanel zoomingPanel = new JPanel();
        zoomingPanel.setLayout(new FlowLayout(3));
        JButton print = new JButton("\u6253\u5370");
        print.setName("print");
        print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PrintPreview.this.doPrint();
            }
        });
        zoomingPanel.add(print);
        JToggleButton selectionButton = new JToggleButton(new AbstractAction("\u9009\u62e9"){

            public void actionPerformed(ActionEvent event) {
                PrintPreview.this.printPreviewPane.setMode(0);
            }
        });
        selectionButton.setSelected(true);
        selectionButton.setToolTipText("<html>\u5207\u6362\u5230\u9009\u62e9\u6a21\u5f0f<blockquote><font size=2>\u5728\u9009\u62e9\u6a21\u5f0f\u4e2d\uff0c\u901a\u8fc7\u5de6\u952e\u70b9\u51fb\u53ef\u4ee5\u52a0\u4eae\u5f53\u524d\u9875.</font></blockquote></html>");
        zoomingPanel.add(selectionButton);
        JToggleButton zoomInButton = new JToggleButton(new AbstractAction("\u653e\u5927"){

            public void actionPerformed(ActionEvent event) {
                PrintPreview.this.printPreviewPane.setMode(2);
            }
        });
        zoomingPanel.add(zoomInButton);
        JToggleButton zoomOutButton = new JToggleButton(new AbstractAction("\u7f29\u5c0f"){

            public void actionPerformed(ActionEvent event) {
                PrintPreview.this.printPreviewPane.setMode(3);
            }
        });
        zoomingPanel.add(zoomOutButton);
        JToggleButton zoomButton = new JToggleButton(new AbstractAction("\u7f29\u653e"){

            public void actionPerformed(ActionEvent event) {
                PrintPreview.this.printPreviewPane.setMode(1);
            }
        });
        zoomingPanel.add(zoomButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(selectionButton);
        buttonGroup.add(zoomInButton);
        buttonGroup.add(zoomOutButton);
        buttonGroup.add(zoomButton);
        JComboBox zoomComboBox = support.getZoomComboBox(true, true);
        zoomComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                pFrame.getContentPane().doLayout();
            }
        });
        zoomComboBox.setSelectedIndex(9);
        zoomingPanel.add(zoomComboBox);
        JButton simplePage = new JButton(new AbstractAction("\u5355\u9875"){

            public void actionPerformed(ActionEvent event) {
                PrintPreview.this.printPreviewPane.setLayout(PrintPreview.this.printPreviewPane.getUtility().createMatrixLayout(PrintPreview.this.printPreviewPane, 1, 1));
            }
        });
        JButton twoPage = new JButton(new AbstractAction("\u4e24\u9875"){

            public void actionPerformed(ActionEvent event) {
                PrintPreview.this.printPreviewPane.setLayout(PrintPreview.this.printPreviewPane.getUtility().createMatrixLayout(PrintPreview.this.printPreviewPane, 1, 2));
            }
        });
        zoomingPanel.add(simplePage);
        zoomingPanel.add(twoPage);
        return zoomingPanel;
    }

    public void doPrint() {
        try {
            this.frame.setVisible(false);
            Book book = this.sampleBook.getBook();
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setPrintable(book.getPrintable(0), this.page);
            pj.setPrintService(this.Service);
            pj.print(this.config);
            WorkSheet_ sheet = (WorkSheet_)this.View.getWorkSheet();
            sheet.getWorkBook().getEM().fireAfterPrintWorkSheet(sheet);
            this.frame.dispose();
            this.frame = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        this.run(pf);
        return 1;
    }

    public void run(PageFormat pageFormat) {
        this.frame = new JFrame("\u6253\u5370\u9884\u89c8");
        this.frame.setDefaultCloseOperation(2);
        this.sampleBook = new PrintBook(this.View, this.frame);
        Rectangle2D.Double client = this.sampleBook.getPrintArea(pageFormat);
        WorkSheet_ sheet = (WorkSheet_)this.View.getWorkSheet();
        sheet.preparePageRange((int)((RectangularShape)client).getWidth(), (int)((RectangularShape)client).getHeight());
        ArrayList pageRange = sheet.getPageRange();
        int pn = pageRange.size();
        int i = 0;
        while (i < pn) {
            this.sampleBook.addPage(pageFormat);
            ++i;
        }
        Book book = this.sampleBook.getBook();
        this.printPreviewPane = new JPrintPreviewPane((Pageable)book);
        JScrollPane scrollPane = new JScrollPane((Component)this.printPreviewPane);
        PrintPreviewSupport support = new PrintPreviewSupport(this.printPreviewPane, false);
        JToolBar toolbar = new JToolBar();
        JPanel zoomingPanel = this.createZoomTab(support, this.frame);
        toolbar.add(zoomingPanel);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)scrollPane, "Center");
        this.frame.getContentPane().add((Component)toolbar, "North");
        if (this.needPreview) {
            this.frame.setExtendedState(6);
            this.frame.setVisible(true);
        } else {
            this.doPrint();
        }
    }
}

