/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import excel.jep.function.VBScript.FuncUtil;
import java.util.Date;
import java.util.Stack;
import java.util.Vector;
import jun.db.core.ObjectTool;

public class DaysBetween
extends PostfixMathCommand {
    public DaysBetween() {
        this.numberOfParameters = 2;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object p2 = inStack.pop();
        Object p1 = inStack.pop();
        inStack.push(this.daysBetween(p1, p2));
    }

    public Object daysBetween(Object p1, Object p2) throws ParseException {
        try {
            if (p1 == null || p2 == null) {
                return new Integer(0);
            }
            if (p1 instanceof Vector || p2 instanceof Vector) {
                return this.vectorDaysBetween(p1, p2);
            }
            Date big = (Date)ObjectTool.ChangeType((Object)p1, (String)"java.util.Date");
            Date small = (Date)ObjectTool.ChangeType((Object)p2, (String)"java.util.Date");
            if (big == null || small == null) {
                return new Integer(0);
            }
            long beginTime = big.getTime() / 86400000L;
            long endTime = small.getTime() / 86400000L;
            long betweenDays = beginTime - endTime;
            return new Integer((int)betweenDays);
        }
        catch (Exception e) {
            return new Integer(0);
        }
    }

    private Object vectorDaysBetween(Object p1, Object p2) throws ParseException {
        if (p1 == null) {
            p1 = new Vector();
        }
        if (p2 == null) {
            p2 = new Vector();
        }
        int c1 = 0;
        if (p1 instanceof Vector) {
            c1 = p1.size();
        }
        int c2 = 0;
        if (p2 instanceof Vector) {
            c2 = p2.size();
        }
        int cc = Math.max(c1, c2);
        Vector v1 = FuncUtil.checkVectorCount(p1, cc);
        Vector v2 = FuncUtil.checkVectorCount(p2, cc);
        Vector<Object> ret = new Vector<Object>();
        int i = 0;
        while (i < cc) {
            ret.add(this.daysBetween(v1.get(i), v2.get(i)));
            ++i;
        }
        return ret;
    }
}

