/*
 * Decompiled with CFR 0.152.
 */
package excel.jep.function.VBScript;

import excel.jep.ParseException;
import excel.jep.function.PostfixMathCommand;
import excel.jep.function.VBScript.FuncUtil;
import java.util.Date;
import java.util.Stack;
import java.util.Vector;
import jun.db.core.ObjectTool;

public class Comparative
extends PostfixMathCommand {
    int id;
    double tolerance;

    public Comparative(int id_in) {
        this.id = id_in;
        this.numberOfParameters = 2;
        this.tolerance = 1.0E-6;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        inStack.push(this.compare(param1, param2));
    }

    private Object vectorCompare(Object p1, Object p2) throws ParseException {
        if (p1 == null) {
            p1 = new Vector();
        }
        if (p2 == null) {
            p2 = new Vector();
        }
        int c1 = 0;
        if (p1 instanceof Vector) {
            c1 = p1.size();
        }
        int c2 = 0;
        if (p2 instanceof Vector) {
            c2 = p2.size();
        }
        int cc = Math.max(c1, c2);
        Vector v1 = FuncUtil.checkVectorCount(p1, cc);
        Vector v2 = FuncUtil.checkVectorCount(p2, cc);
        Vector<Object> ret = new Vector<Object>();
        int i = 0;
        while (i < cc) {
            ret.add(this.compare(v1.get(i), v2.get(i)));
            ++i;
        }
        return ret;
    }

    private Object compare(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Vector || param2 instanceof Vector) {
            return this.vectorCompare(param1, param2);
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            boolean r;
            double x = ((Number)param1).doubleValue();
            double y = ((Number)param2).doubleValue();
            switch (this.id) {
                case 0: {
                    r = x < y;
                    break;
                }
                case 1: {
                    r = x > y;
                    break;
                }
                case 2: {
                    r = x <= y;
                    break;
                }
                case 3: {
                    r = x >= y;
                    break;
                }
                case 4: {
                    r = x != y;
                    break;
                }
                case 5: {
                    r = x == y;
                    break;
                }
                default: {
                    throw new ParseException("Unknown relational operator");
                }
            }
            return new Double((double)r);
        }
        if (param1 instanceof String && param2 instanceof String) {
            boolean r;
            String x = (String)param1;
            String y = (String)param2;
            switch (this.id) {
                case 0: {
                    r = x.compareTo(y) < 0;
                    break;
                }
                case 1: {
                    r = x.compareTo(y) > 0;
                    break;
                }
                case 2: {
                    r = x.compareTo(y) <= 0;
                    break;
                }
                case 3: {
                    r = x.compareTo(y) >= 0;
                    break;
                }
                case 4: {
                    r = !x.equals(y);
                    break;
                }
                case 5: {
                    r = x.equals(y);
                    break;
                }
                default: {
                    throw new ParseException("Relational operator type error");
                }
            }
            return new Double((double)r);
        }
        if (param1 instanceof Date && param2 instanceof Date) {
            boolean r;
            Date x = null;
            Date y = null;
            try {
                x = (Date)ObjectTool.ChangeType((Object)param1, (String)"java.util.Date");
                y = (Date)ObjectTool.ChangeType((Object)param2, (String)"java.util.Date");
                if (x == null) {
                    x = new Date(0L);
                }
                if (y == null) {
                    y = new Date(0L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (this.id) {
                case 0: {
                    r = x.compareTo(y) < 0;
                    break;
                }
                case 1: {
                    r = x.compareTo(y) > 0;
                    break;
                }
                case 2: {
                    r = x.compareTo(y) <= 0;
                    break;
                }
                case 3: {
                    r = x.compareTo(y) >= 0;
                    break;
                }
                case 4: {
                    r = !x.equals(y);
                    break;
                }
                case 5: {
                    r = x.equals(y);
                    break;
                }
                default: {
                    throw new ParseException("Relational operator type error");
                }
            }
            return new Double((double)r);
        }
        return null;
    }
}

