/*
 * Decompiled with CFR 0.152.
 */
package excel.edit;

import excel.core.Cell;
import excel.core.DBBindConfig;
import excel.core.DataSourceConfig;
import excel.core.EditStyle;
import excel.core.Property;
import excel.core.RowPropertyManage;
import excel.core.impl.Cell_;
import excel.edit.BasicEdit;
import excel.edit.ListFrame;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DropDownListBox
extends BasicEdit
implements MouseMotionListener {
    public EditStyle ES;
    Map<Object, String> map;
    Map<String, Object> map2;
    Image ddlbButtonImage = null;
    HashMap<Object, Boolean> checkedMap = new HashMap();
    boolean otherChecked = false;
    String otherValue = "";
    int listCount = 0;
    Object[] showvalues;
    Object[] keyvalues;
    ListFrame listFrame = null;
    private boolean hadSetBorder = false;
    private int otherWidth = 0;

    public DropDownListBox(EditStyle es) {
        this.showDebugInfo = true;
        this.ES = es;
        this.setMargin(new Insets(0, 0, 0, 18));
        this.addMouseMotionListener(this);
    }

    void initMap() {
        if (this.map != null) {
            return;
        }
        this.debugInfo("initMap");
        this.map = this.ES.getDropDownData2ViewMapForEdit(this.currentDBRow);
        if (this.map == null) {
            this.map = new LinkedHashMap<Object, String>();
        }
        this.map2 = new LinkedHashMap<String, Object>();
        Iterator<Object> it = this.map.keySet().iterator();
        boolean includeNull = false;
        while (it.hasNext()) {
            Object key = it.next();
            String value = this.map.get(key);
            if (key == null || value == null) {
                includeNull = true;
            }
            if ("".equals(key) || "".equals(value)) {
                includeNull = true;
            }
            if (this.ES.isDropDownListEditable() && includeNull) continue;
            if (value != null) {
                this.map2.put(value.toString(), key);
                continue;
            }
            this.map2.put(null, key);
        }
        if (!includeNull && this.ES.isListShowAsDDLB() && !this.ES.isDropDownListEditable()) {
            this.map2.put("", "");
            this.map.put("", "");
        }
        this.showvalues = this.map.values().toArray();
        this.keyvalues = this.map.keySet().toArray();
        this.listCount = this.map.size();
    }

    public void calcuBuildinButtonRC() {
        this.debugInfo("calcuBuildinButtonRC");
        this.buildinButtonRC = new Rectangle(0, 0, 0, 0);
        if (!this.ES.isDropDownListEditable()) {
            return;
        }
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        if (cell.getNameOfEditButton() != null) {
            int x = this.editRC.width - 17 - 17;
            int y = (this.editRC.height - 16) / 2;
            if (y < 0) {
                y = 0;
            }
            this.buildinButtonRC = new Rectangle(x, y, 16, 16);
        }
    }

    public void paint(Graphics g) {
        if (this.ES.isListShowAsCheckBox() || this.ES.isListShowAsRadioButton()) {
            Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
            Rectangle rcClip = g.getClipBounds();
            Rectangle rc = (Rectangle)this.editRC.clone();
            int w = rc.width;
            int h = rc.height;
            rc.x = 0;
            rc.y = 0;
            DropDownListBox.adjustBounds(rc, -1);
            Property prop = cell.getProperty();
            int background_mode = prop.get("background-mode", 1);
            Color background_color = prop.get("background-color", Color.WHITE);
            if (background_mode == 0) {
                background_color = this.Sheet.getPaperColor();
            }
            if (this.mouseOnDBRow >= 0) {
                DataSourceConfig dsc;
                boolean needDrawLightBar = this.Sheet.getWorkBook().isHighlightDataSourceCurrentRow();
                DBBindConfig bind = cell.getBind();
                if (bind != null && (dsc = this.Sheet.getWorkBook().getDataSource(bind.getDataSource())) != null) {
                    boolean bl = needDrawLightBar = needDrawLightBar && dsc.isHighlightCurrentRow();
                }
                if (needDrawLightBar) {
                    background_color = new Color(0xCCCCFF);
                }
            }
            g.setColor(background_color);
            g.fillRect(0, 0, w, h);
            this.setBackground(background_color);
            Color font_color = prop.get("font-color", Color.BLACK);
            String font_name = prop.get("font-name", "\u5b8b\u4f53");
            int font_size = prop.get("font-size", 12);
            boolean font_bold = prop.get("font-bold", false);
            boolean font_italic = prop.get("font-italic", false);
            boolean font_underline = prop.get("font-underline", false);
            int align_h = prop.get("align-h", 0);
            int align_v = prop.get("align-v", 2);
            this.initMap();
            int colCount = Math.max(1, this.ES.getColumnCountOnRow());
            int rowCount = Math.max(1, (this.listCount - 1) / colCount + 1);
            int itemHeight = 0;
            Rectangle itemRC = new Rectangle();
            itemRC.width = rc.width / colCount;
            if (this.ES.isDropDownListEditable()) {
                itemHeight = rc.height / (rowCount + 1);
                if (this.otherWidth == 0) {
                    this.otherWidth = Tools.getStringBounds((Graphics2D)((Graphics2D)g), (String)"\u5176\u5b83\uff1a", (String)font_name, (int)font_size, (boolean)font_bold, (boolean)font_italic, (boolean)font_underline).width + 18;
                }
                if (!this.hadSetBorder) {
                    this.hadSetBorder = true;
                    this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(itemHeight * rowCount + 1, this.otherWidth, 2, 2), BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray)));
                }
                super.paint(g);
                Tools.DrawCheckBoxOrRadioButtonString(this, (Graphics2D)g, new Rectangle(rc.x, rc.y + itemHeight * rowCount, this.otherWidth, itemHeight - 1), "\u5176\u5b83\uff1a", background_mode, background_color, font_color, font_name, font_size, font_bold, font_italic, font_underline, align_h, align_v, this.otherChecked, false, this.ES.isListShowAsCheckBox());
            } else {
                itemHeight = rc.height / rowCount;
            }
            itemRC.height = itemHeight - 1;
            int ri = 0;
            while (ri < rowCount) {
                itemRC.y = rc.y + ri * itemHeight;
                int ci = 0;
                while (ci < colCount) {
                    itemRC.x = rc.x + ci * itemRC.width;
                    int index = ri * colCount + ci;
                    if (index > this.listCount - 1) break;
                    String tipText = Tools.$S(this.showvalues[index]);
                    boolean checked = this.checkedMap.containsKey(this.showvalues[index]);
                    Tools.DrawCheckBoxOrRadioButtonString(this, (Graphics2D)g, itemRC, tipText, background_mode, background_color, font_color, font_name, font_size, font_bold, font_italic, font_underline, align_h, align_v, checked, false, this.ES.isListShowAsCheckBox());
                    ++ci;
                }
                ++ri;
            }
            return;
        }
        super.paint(g);
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        this.drawDDLBButton((Graphics2D)g);
    }

    public void adjustEditRect() {
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        if (cell.getDecorate() != null && (this.ES.isListShowAsDDLB() || this.ES.isListShowAsDropdownCheckBox())) {
            this.editRC.width += 16;
        }
    }

    private void drawDDLBButton(Graphics2D g) {
        boolean delta = false;
        int x = this.editRC.width - 16;
        int y0 = 0;
        Cell cell = this.Sheet.cells(this.Row, this.Col);
        if (cell.getDecorate() != null) {
            x += 2;
        }
        int y = y0;
        DropDownListBox view = this;
        Image img = Tools.GetImageFromURL(view, "excel/res/decorate/normal/ddlb/ddlb_rmt.png");
        int imgH = img.getHeight(view);
        int imgW = img.getWidth(view);
        while (y < this.editRC.height / 2) {
            g.drawImage(img, x, y, view);
            y += imgH;
        }
        img = Tools.GetImageFromURL(view, "excel/res/decorate/normal/ddlb/ddlb_rmb.png");
        while (y < this.editRC.height) {
            g.drawImage(img, x, y, view);
            y += imgH;
        }
        img = Tools.GetImageFromURL(view, "excel/res/decorate/normal/ddlb/ddlb_rmm.png");
        imgH = img.getHeight(view);
        y = y0 + 4 + (this.editRC.height - 4 - 4 - imgH) / 2;
        g.drawImage(img, x, y, view);
        if (!this.ES.isDropDownListEditable()) {
            img = Tools.GetImageFromURL(view, "excel/res/cut.png");
            imgH = img.getHeight(view);
            y = y0;
        }
    }

    public void removeSelf() {
        this.debugInfo("removeSelf");
        if (this.listFrame != null) {
            this.listFrame.dispose();
        }
        this.listFrame = null;
        super.removeSelf();
    }

    public String superGetText() {
        return super.getText();
    }

    public String getText() {
        return Tools.$S(this.getWriteBackValue());
    }

    public void buildEditText(String value) {
        if (!this.ES.isDropDownListEditable()) {
            this.setEditable(false);
            this.setBackground(Color.white);
        }
        this.debugInfo("buildEditText");
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        if (!this.ES.isListShowAsDDLB()) {
            Rectangle rc = this.getBounds();
            int w = rc.width;
            int h = rc.height;
            rc.x = cell.getProperty().get("padding-left", 1) - 1;
            rc.y = cell.getProperty().get("padding-top", 1);
            rc.width -= 1 + rc.x + cell.getProperty().get("padding-right", 1);
            rc.height -= 1 + rc.y + cell.getProperty().get("padding-bottom", 1);
            this.initMap();
            int colCount = Math.max(1, Math.min(this.listCount, this.ES.getColumnCountOnRow()));
            int rowCount = Math.max(1, (this.listCount - 1) / colCount + 1);
            String SV = "," + Tools.$S(cell.getValue(this.mouseOnDBRow)) + ",";
            if (this.ES.isListShowAsRadioButton()) {
                this.checkedMap.clear();
            }
            int ri = 0;
            while (ri < rowCount) {
                int ci = 0;
                while (ci < colCount) {
                    int index = ri * colCount + ci;
                    if (index > this.listCount - 1) break;
                    String tipText = Tools.$S(this.showvalues[index]);
                    String vText = Tools.$S(this.keyvalues[index]);
                    boolean checked = false;
                    checked = this.ES.isListShowAsCheckBox() || this.ES.isListShowAsDropdownCheckBox() ? SV.indexOf("," + vText + ",") >= 0 : SV.equals("," + vText + ",");
                    if (checked) {
                        this.checkedMap.put(this.showvalues[index], true);
                    }
                    ++ci;
                }
                ++ri;
            }
            this.otherChecked = false;
            this.otherValue = "";
            if (this.ES.isDropDownListEditable()) {
                String[] ss = SV.split(",");
                int ri2 = 0;
                while (ri2 < ss.length) {
                    String t = ss[ri2].trim();
                    if (!t.equals("")) {
                        boolean exists = false;
                        int ci = 0;
                        while (ci < this.listCount) {
                            String vText = Tools.$S(this.keyvalues[ci]);
                            if (t.equals(vText)) {
                                exists = true;
                                break;
                            }
                            ++ci;
                        }
                        if (!exists) {
                            this.otherChecked = true;
                            this.otherValue = t;
                            break;
                        }
                    }
                    ++ri2;
                }
                this.setText(this.otherValue);
            }
            return;
        }
        String s = value == null ? cell.getShowText(this.mouseOnDBRow) : value;
        this.setText(s);
    }

    public Object getWriteBackValue() {
        this.debugInfo("getWriteBackValue");
        this.initMap();
        if (this.ES.isListShowAsCheckBox() || this.ES.isListShowAsDropdownCheckBox()) {
            String text;
            StringBuffer sb = new StringBuffer();
            if (this.ES.isDropDownListEditable() && this.otherChecked && (text = super.getText().trim()).length() > 0) {
                sb.append(text);
            }
            int i = 0;
            while (i < this.listCount) {
                Object showText = this.showvalues[i];
                boolean checked = this.checkedMap.containsKey(showText);
                if (checked) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(Tools.$S(this.keyvalues[i]));
                }
                ++i;
            }
            String s = sb.toString();
            Object v = this.Sheet.getWorkBook().getEM().afterEditFocusLostAndBeforeWriteBackToCell(this.Sheet, this.Sheet.cells(this.Row, this.Col), s, this.currentDBRow);
            if (v == null) {
                return null;
            }
            s = v.toString();
            return s;
        }
        if (this.ES.isListShowAsRadioButton()) {
            int i = 0;
            while (i < this.listCount) {
                Object showText = this.showvalues[i];
                boolean checked = this.checkedMap.containsKey(showText);
                if (checked) {
                    String s = Tools.$S(this.keyvalues[i]);
                    Object v = this.Sheet.getWorkBook().getEM().afterEditFocusLostAndBeforeWriteBackToCell(this.Sheet, this.Sheet.cells(this.Row, this.Col), s, this.currentDBRow);
                    if (v == null) {
                        return null;
                    }
                    s = v.toString();
                    return s;
                }
                ++i;
            }
        }
        String s = super.getText();
        Object v = this.Sheet.getWorkBook().getEM().afterEditFocusLostAndBeforeWriteBackToCell(this.Sheet, this.Sheet.cells(this.Row, this.Col), s, this.currentDBRow);
        if (v == null) {
            return null;
        }
        s = v.toString();
        if (s.equals("")) {
            return null;
        }
        if (this.map.containsKey(s)) {
            return s;
        }
        if (this.map2.containsKey(s)) {
            return this.map2.get(s);
        }
        System.out.println("\u5217\u8868\u4e2d\u65e0\u6cd5\u627e\u5230:" + s + " \u5bf9\u5e94\u7684\u6570\u636e\u503c\uff0c\u53ef\u80fd\u662f\u52a8\u6001\u6539\u53d8\u4e86\u5217\u8868\uff0c\u56e0\u6b64\u91cd\u65b0\u6784\u5efa\u4e00\u4e0b\u5217\u8868");
        this.map2 = new LinkedHashMap<String, Object>();
        for (Object key : this.map.keySet()) {
            String value = this.map.get(key);
            if (value != null) {
                this.map2.put(value.toString(), key);
                continue;
            }
            this.map2.put(null, key);
        }
        if (this.map2.containsKey(s)) {
            return this.map2.get(s);
        }
        if (this.ES.isValueMustInDDLB()) {
            return null;
        }
        System.out.println("\u5217\u8868\u91cd\u5efa\u4e86\uff0c\u3000\u4ecd\u7136\u65e0\u6cd5\u627e\u5230:" + s + " \u5bf9\u5e94\u7684\u6570\u636e\u503c\uff0c\u76f4\u63a5\u8fd4\u56de\u663e\u793a\u503c");
        return s;
    }

    public void repaintCell() {
        Cell cell = this.Sheet.Cells(this.Row, this.Col);
        cell.repaint();
    }

    public void keyPressed(KeyEvent e) {
        this.debugInfo("keyPressed  " + e.toString());
        switch (e.getKeyCode()) {
            case 38: {
                if (this.listFrame.isVisible() && this.ES.isListShowAsDDLB()) {
                    e.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DropDownListBox.this.debugInfo(" request focus");
                            try {
                                DropDownListBox.this.listFrame.dataList.requestFocus();
                                DropDownListBox.this.listFrame.LocateItem();
                                Robot robot = new Robot();
                                robot.keyPress(38);
                                robot.keyRelease(38);
                            }
                            catch (Exception e) {
                                DropDownListBox.this.debugInfo(" ddlb refreshDDLB  err:  " + e.getMessage());
                            }
                        }
                    });
                    return;
                }
            }
            case 40: {
                if (e.isControlDown()) {
                    super.keyPressed(e);
                    return;
                }
                this.refreshDDLB(true);
                break;
            }
            default: {
                super.keyPressed(e);
            }
        }
    }

    public void refreshDDLB(boolean ddlbFocus) {
        if (this.ES.isListShowAsDropdownCheckBox()) {
            this.refreshDropdownCheckBox(ddlbFocus);
        } else {
            this.refreshDropDownDDLB(ddlbFocus);
        }
    }

    public void refreshDropdownCheckBox(boolean ddlbFocus) {
        if (this.listFrame == null) {
            this.ShowDDLB();
        }
        if (this.listFrame == null) {
            return;
        }
        if (this.listFrame.modal) {
            this.listFrame = null;
            return;
        }
        if (this.ES.isDropDownListEditable()) {
            this.listFrame.resetList(super.getText());
        }
        this.resetListFrameBound(this.listFrame.ListCount);
        this.listFrame.repaint();
        final boolean ddlbFocus_ = ddlbFocus;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DropDownListBox.this.debugInfo(" request focus");
                try {
                    if (ddlbFocus_) {
                        DropDownListBox.this.listFrame.dataList.requestFocus();
                        DropDownListBox.this.listFrame.LocateItem();
                    } else {
                        DropDownListBox.this.requestFocus();
                    }
                }
                catch (Exception e) {
                    DropDownListBox.this.debugInfo(" ddlb refreshDDLB  err:  " + e.getMessage());
                }
            }
        });
    }

    public void refreshDropDownDDLB(boolean ddlbFocus) {
        if (this.listFrame == null) {
            this.ShowDDLB();
        }
        if (this.listFrame == null) {
            return;
        }
        if (this.listFrame.modal) {
            this.listFrame = null;
            return;
        }
        if (this.ES.isDropDownListEditable()) {
            this.listFrame.resetList(super.getText());
        }
        this.resetListFrameBound(this.listFrame.ListCount);
        this.listFrame.repaint();
        final boolean ddlbFocus_ = ddlbFocus;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DropDownListBox.this.debugInfo(" request focus");
                try {
                    if (ddlbFocus_) {
                        DropDownListBox.this.listFrame.dataList.requestFocus();
                        if (!DropDownListBox.this.listFrame.LocateItem()) {
                            Robot robot = new Robot();
                            robot.keyPress(40);
                            robot.keyRelease(40);
                        }
                    } else {
                        DropDownListBox.this.requestFocus();
                    }
                }
                catch (Exception e) {
                    DropDownListBox.this.debugInfo(" ddlb refreshDDLB  err:  " + e.getMessage());
                }
            }
        });
    }

    public void keyReleased(KeyEvent e) {
        this.debugInfo("keyReleased  " + e.toString());
        if (this.ES.isDropDownListEditable()) {
            this.refreshDDLB(false);
        }
        if (e.getKeyCode() == 67 && e.isControlDown() && !this.ES.isDropDownListEditable()) {
            this.copyCell();
        }
        super.keyReleased(e);
        if (this.ES.isDropDownListEditable() && (this.ES.isListShowAsCheckBox() || this.ES.isListShowAsRadioButton())) {
            if (super.getText().length() > 0) {
                if (!this.otherChecked) {
                    this.otherChecked = true;
                    if (this.ES.isListShowAsRadioButton()) {
                        this.checkedMap.clear();
                    }
                    this.repaint();
                }
            } else if (this.otherChecked) {
                this.otherChecked = false;
                this.repaint();
            }
        }
    }

    public void ShowDDLB() {
        this.debugInfo("ShowDDLB");
        if (this.ES.isListShowAsCheckBox() || this.ES.isListShowAsRadioButton()) {
            return;
        }
        this.initMap();
        if (this.map.size() == 0 && this.Sheet.getWorkBook().getWorkBookView().isInModalDialog()) {
            return;
        }
        if (this.listFrame == null) {
            Dialog pd = Tools.getDialogContainsComponent(this.View);
            this.listFrame = pd != null ? new ListFrame(this, pd) : new ListFrame(this, JOptionPane.getFrameForComponent(this.View));
        }
        this.resetListFrameBound(this.map.size());
        if (this.listFrame != null && !this.listFrame.modal) {
            if (this.ES.isListShowAsDropdownCheckBox()) {
                this.listFrame.checkboxPanel.requestFocusInWindow();
            } else {
                this.listFrame.dataList.requestFocusInWindow();
                this.listFrame.LocateItem();
            }
        }
    }

    public Font getFont() {
        if (this.Sheet == null) {
            return new Font("\u5b8b\u4f53", 0, 12);
        }
        return this.Sheet.cells(this.Row, this.Col).getFont();
    }

    public int getItemHeight() {
        return this.Sheet.cells(this.Row, this.Col).getProperty().get("font-size", 12) / 3 * 4 + 2;
    }

    public void resetListFrameBound(int ic) {
        int height;
        this.debugInfo("resetListFrameBound");
        Point p = new Point(this.getX(), this.getY());
        p = Tools.GetAbsolutePoint(this.View, p);
        --p.x;
        p.y += this.getHeight();
        p.x -= this.editRC.x - this.cellRect.x - 2;
        int ph = this.getItemHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int rr = Math.min((int)Math.max(Math.floor((p.y - this.editRC.height) / ph), (double)((int)Math.floor((screenSize.height - p.y - 64) / ph))), ic);
        int w = (int)((double)((this.cellRect.width - 1) * this.ES.getDDLBWidthPercent()) * 1.0 / 100.0);
        if (p.x + w + 1 > screenSize.width) {
            p.x -= p.x + w + 1 - screenSize.width;
        }
        int h = screenSize.height - p.y;
        int H = this.getHeight();
        if (this.ES.isListShowAsDropdownCheckBox()) {
            ic = (int)Math.ceil((double)ic * 1.0 / (double)Math.max(1, this.ES.getColumnCountOnRow()));
        }
        if (h > ic * ph) {
            height = ic * ph + 2;
        } else if (p.y - H > ic * ph) {
            height = ic * ph + 2;
            p.y = p.y - H - height;
        } else if (h > rr * ph) {
            height = rr * ph + 2;
        } else {
            p.y -= H;
            h = p.y;
            if (h > ic * ph) {
                height = ic * ph + 2;
                p.y -= height;
            } else if (h > rr * ph) {
                height = rr * ph + 2;
                p.y -= height;
            } else {
                height = h;
                p.y -= height;
            }
        }
        if (this.listFrame.modal || this.ES.isListShowAsDropdownCheckBox()) {
            height += 20;
        }
        this.listFrame.setBounds(p.x, p.y, w + 1, height);
        this.listFrame.validate();
        if (this.listFrame.checkboxPanel != null) {
            int th = ic * ph;
            this.listFrame.checkboxPanel.setPreferredSize(new Dimension(w - 20, th));
            Rectangle tc = this.listFrame.checkboxPanel.getBounds();
            tc.height = th;
            this.listFrame.checkboxPanel.setBounds(tc);
            this.listFrame.scrollPane.invalidate();
            this.listFrame.doLayout();
        }
        if (!this.listFrame.isVisible()) {
            this.listFrame.setVisible(true);
        }
    }

    public void mouseClicked(MouseEvent e) {
        Point me = e.getPoint();
        if (!e.getSource().equals(this)) {
            me.x -= this.cellRect.x;
            me.y -= this.cellRect.y;
            if (this.mouseOnDBRow > 0) {
                RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
                boolean groupRowVisible = RPM.isGroupRowVisible(this.Row);
                int dbRowHeight = RPM.getDBRowHeight(this.Row);
                me.y -= dbRowHeight * this.mouseOnDBRow;
            }
        }
        if (this.ES.isListShowAsCheckBox() || this.ES.isListShowAsRadioButton()) {
            Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
            Rectangle rc = this.getBounds();
            int w = rc.width;
            int h = rc.height;
            rc.x = cell.getProperty().get("padding-left", 1) - 1;
            rc.y = cell.getProperty().get("padding-top", 1);
            rc.width -= 1 + rc.x + cell.getProperty().get("padding-right", 1);
            rc.height -= 1 + rc.y + cell.getProperty().get("padding-bottom", 1);
            int listCount = 0;
            listCount = this.map.size();
            int colCount = Math.max(1, this.ES.getColumnCountOnRow());
            int rowCount = Math.max(1, (listCount - 1) / colCount + 1);
            Rectangle itemRC = new Rectangle();
            itemRC.width = rc.width / colCount;
            itemRC.height = rc.height / (rowCount + (this.ES.isDropDownListEditable() ? 1 : 0));
            int ri = 0;
            while (ri < rowCount) {
                itemRC.y = rc.y + ri * itemRC.height;
                int ci = 0;
                while (ci < colCount) {
                    itemRC.x = rc.x + ci * itemRC.width;
                    int index = ri * colCount + ci;
                    if (index > listCount - 1) break;
                    Object showText = this.showvalues[index];
                    boolean checked = this.checkedMap.containsKey(showText);
                    if (itemRC.contains(me)) {
                        if (this.ES.isListShowAsCheckBox()) {
                            boolean bl = checked = !checked;
                            if (checked) {
                                this.checkedMap.put(showText, true);
                            } else {
                                this.checkedMap.remove(showText);
                            }
                        } else {
                            this.checkedMap.clear();
                            this.checkedMap.put(showText, true);
                            this.otherChecked = false;
                        }
                    }
                    ++ci;
                }
                ++ri;
            }
            if (this.ES.isDropDownListEditable()) {
                itemRC.x = rc.x;
                itemRC.y = rc.y + rowCount * itemRC.height;
                itemRC.width = this.otherWidth;
                if (itemRC.contains(me)) {
                    if (this.ES.isListShowAsRadioButton()) {
                        this.otherChecked = true;
                        this.checkedMap.clear();
                    } else {
                        this.otherChecked = !this.otherChecked;
                    }
                }
            }
            this.fillBack();
            this.repaint();
        }
        if (!this.ES.isDropDownListEditable() || me.x > this.editRC.width - 17) {
            this.refreshDDLB(true);
        }
        if (this.ES.isDropDownListEditable() && me.x <= this.editRC.width - 17) {
            this.refreshDDLB(false);
        }
        if (!this.ES.isDropDownListEditable() && me.x <= this.editRC.width - 17 && me.x >= this.editRC.width - 27) {
            int cfr_ignored_0 = me.y;
        }
        super.mouseClicked(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.ES.isListShowAsCheckBox() || this.ES.isListShowAsRadioButton()) {
            this.setCursor(new Cursor(12));
            return;
        }
        if (e.getX() > this.editRC.width - 32 && e.getX() < this.editRC.width - 17 && !this.ES.isDropDownListEditable()) {
            return;
        }
        if (e.getX() > this.editRC.width - 17) {
            this.setCursor(new Cursor(12));
        } else if (this.ES.isDropDownListEditable()) {
            this.setCursor(new Cursor(2));
        } else {
            this.setCursor(new Cursor(0));
        }
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        String bn = cell.getNameOfEditButton();
        if (bn != null && this.buildinButtonRC.contains(e.getPoint())) {
            this.setCursor(new Cursor(12));
        }
    }

    public void copyCell() {
        Object v = this.getWriteBackValue();
        Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
        Object sv = this.map.get(v);
        if (sv == null) {
            sv = v;
        }
        StringSelection contents = new StringSelection(sv == null ? "" : sv.toString());
        sysc.setContents(contents, this.Sheet);
    }
}

