/*
 * Decompiled with CFR 0.152.
 */
package excel.edit;

import excel.edit.DatetimeEdit;
import excel.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DateChooser
extends JDialog
implements ItemListener,
MouseListener,
FocusListener,
KeyListener,
ActionListener {
    private static final String[] MONTHS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
    private static final String[] DAYS = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    private static final Color WEEK_DAYS_FOREGROUND = Color.black;
    private static final Color DAYS_FOREGROUND = Color.BLACK;
    private static final Color BACKGROUND = new Color(0xFFFFB4);
    private static final Color SELECTED_DAY_FOREGROUND = Color.white;
    private static final Color SELECTED_DAY_BACKGROUND = new Color(0x6C6CFF);
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final Border GRAY_BORDER = BorderFactory.createLineBorder(Color.GRAY, 1);
    private static final Border FOCUSED_BORDER = BorderFactory.createLineBorder(Color.RED, 1);
    private static final int FIRST_YEAR = 1900;
    private static final int LAST_YEAR = 2100;
    private GregorianCalendar calendar;
    private JLabel[][] days;
    private FocusablePanel daysGrid;
    private JComboBox month;
    private JComboBox year;
    private JComboBox hour;
    private JComboBox minute;
    private JComboBox second;
    private JButton ok;
    private JButton jbClose;
    private JButton jbOK;
    private JLabel jb_year_add;
    private JLabel jb_year_sub;
    private JLabel jb_month_add;
    private JLabel jb_month_sub;
    private boolean needTime = false;
    private int offset;
    private int lastDay;
    private JLabel day;
    public DatetimeEdit DE;
    private boolean okClicked;

    private void construct() {
        this.setUndecorated(true);
        this.setFocusableWindowState(false);
        Cursor hand = new Cursor(12);
        this.calendar = new GregorianCalendar();
        this.month = new JComboBox<String>(MONTHS);
        this.month.addItemListener(this);
        this.month.setFocusable(this.isModal());
        this.year = new JComboBox();
        int i = 1900;
        while (i <= 2100) {
            this.year.addItem(Integer.toString(i));
            ++i;
        }
        this.year.addItemListener(this);
        this.year.setFocusable(this.isModal());
        this.days = new JLabel[7][7];
        i = 0;
        while (i < 7) {
            this.days[0][i] = new JLabel(DAYS[i], 4);
            this.days[0][i].setForeground(WEEK_DAYS_FOREGROUND);
            ++i;
        }
        i = 1;
        while (i < 7) {
            int j = 0;
            while (j < 7) {
                this.days[i][j] = new JLabel(" ", 4);
                this.days[i][j].setPreferredSize(new Dimension(18, 18));
                this.days[i][j].setForeground(DAYS_FOREGROUND);
                this.days[i][j].setBackground(SELECTED_DAY_BACKGROUND);
                this.days[i][j].setBorder(EMPTY_BORDER);
                this.days[i][j].addMouseListener(this);
                this.days[i][j].setFocusable(false);
                ++j;
            }
            ++i;
        }
        JPanel monthYear = new JPanel();
        monthYear.setLayout(null);
        monthYear.setBackground(BACKGROUND);
        monthYear.add(this.year);
        monthYear.add(this.month);
        this.year.setBounds(1, 1, 50, 22);
        this.month.setBounds(62, 1, 38, 22);
        monthYear.setPreferredSize(new Dimension(160, 27));
        monthYear.setFocusable(false);
        this.year.setBorder(GRAY_BORDER);
        this.month.setBorder(GRAY_BORDER);
        this.jb_year_sub = new JLabel("");
        this.jb_year_sub.setBorder(null);
        this.jb_year_sub.setFocusable(this.isModal());
        this.jb_year_sub.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/img/up.gif")));
        this.jb_year_sub.setBounds(49, 1, 16, 12);
        this.jb_year_sub.setCursor(hand);
        this.jb_year_add = new JLabel("");
        this.jb_year_add.setBorder(null);
        this.jb_year_add.setFocusable(this.isModal());
        this.jb_year_add.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/img/down.gif")));
        this.jb_year_add.setBounds(49, 13, 16, 12);
        this.jb_year_add.setCursor(hand);
        this.jb_year_sub.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                DateChooser.this.yearAdd(-1);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.jb_year_add.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                DateChooser.this.yearAdd(1);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        monthYear.add(this.jb_year_add);
        monthYear.add(this.jb_year_sub);
        this.jb_month_sub = new JLabel("");
        this.jb_month_sub.setFocusable(this.isModal());
        this.jb_month_sub.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/img/up.gif")));
        this.jb_month_sub.setBounds(100, 1, 16, 12);
        this.jb_month_sub.setCursor(hand);
        this.jb_month_add = new JLabel("");
        this.jb_month_add.setFocusable(this.isModal());
        this.jb_month_add.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/img/down.gif")));
        this.jb_month_add.setBounds(100, 13, 16, 12);
        this.jb_month_add.setCursor(hand);
        this.jb_month_sub.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                DateChooser.this.monthAdd(-1);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.jb_month_add.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                DateChooser.this.monthAdd(1);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        monthYear.add(this.jb_month_add);
        monthYear.add(this.jb_month_sub);
        this.jbClose = new JButton("");
        this.jbClose.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/res/cancel.gif")));
        this.jbClose.setBounds(115, 2, 25, 22);
        this.jbClose.setFocusable(false);
        this.jbClose.addActionListener(this);
        this.jbClose.setMargin(new Insets(1, 0, 1, 0));
        this.jbClose.setBorder(GRAY_BORDER);
        this.jbClose.setFocusable(false);
        monthYear.add(this.jbClose);
        this.jbOK = new JButton("");
        this.jbOK.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/res/ok.gif")));
        this.jbOK.setBounds(142, 2, 25, 22);
        this.jbOK.setFocusable(false);
        this.jbOK.addActionListener(this);
        this.jbOK.setMargin(new Insets(1, 0, 1, 0));
        this.jbOK.setBorder(GRAY_BORDER);
        this.jbOK.setFocusable(false);
        this.jbOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DateChooser.this.okClicked = true;
                DateChooser.this.Close();
            }
        });
        monthYear.add(this.jbOK);
        this.daysGrid = new FocusablePanel(new GridLayout(7, 7, 5, 0));
        this.daysGrid.addKeyListener(this);
        this.daysGrid.setFocusable(false);
        int i2 = 0;
        while (i2 < 7) {
            int j = 0;
            while (j < 7) {
                this.daysGrid.add(this.days[i2][j]);
                ++j;
            }
            ++i2;
        }
        this.daysGrid.setBackground(BACKGROUND);
        this.daysGrid.setBorder(EMPTY_BORDER);
        JPanel daysPanel = new JPanel();
        daysPanel.setFocusable(false);
        daysPanel.setBackground(BACKGROUND);
        daysPanel.add(this.daysGrid);
        JPanel timePanel = new JPanel();
        timePanel.setLayout(null);
        timePanel.setBackground(BACKGROUND);
        timePanel.setPreferredSize(new Dimension(180, 27));
        timePanel.setFocusable(false);
        this.hour = new JComboBox();
        int i3 = 0;
        while (i3 <= 24) {
            this.hour.addItem(Integer.toString(i3));
            ++i3;
        }
        this.hour.addItemListener(this);
        this.hour.setFocusable(this.isModal());
        this.hour.setBounds(1, 1, 40, 22);
        timePanel.add(this.hour);
        JLabel l1 = new JLabel("\u65f6");
        l1.setBounds(45, 1, 16, 22);
        timePanel.add(l1);
        this.minute = new JComboBox();
        int i4 = 0;
        while (i4 <= 59) {
            this.minute.addItem(Integer.toString(i4));
            ++i4;
        }
        this.minute.addItemListener(this);
        this.minute.setFocusable(this.isModal());
        this.minute.setBounds(60, 1, 40, 22);
        timePanel.add(this.minute);
        JLabel l2 = new JLabel("\u5206");
        l2.setBounds(103, 1, 16, 22);
        timePanel.add(l2);
        this.second = new JComboBox();
        int i5 = 0;
        while (i5 <= 59) {
            this.second.addItem(Integer.toString(i5));
            ++i5;
        }
        this.second.addItemListener(this);
        this.second.setFocusable(this.isModal());
        this.second.setBounds(120, 1, 40, 22);
        timePanel.add(this.second);
        JLabel l3 = new JLabel("\u79d2");
        l3.setBounds(163, 1, 16, 22);
        timePanel.add(l3);
        Container dialog = this.getContentPane();
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createLineBorder(new Color(0x6C6CFF), 2));
        p.setLayout(new BorderLayout());
        p.setBackground(BACKGROUND);
        p.add("North", monthYear);
        p.add("Center", daysPanel);
        if (this.needTime) {
            p.add("South", timePanel);
        }
        dialog.add(p);
        this.pack();
        this.setResizable(false);
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    public void yearAdd(int n) {
        int cc = this.year.getItemCount();
        int i = this.year.getSelectedIndex();
        if ((i += n) < 0) {
            i = 0;
        }
        if (i >= cc) {
            i = cc - 1;
        }
        this.year.setSelectedIndex(i);
    }

    public void monthAdd(int n) {
        int cc = this.month.getItemCount();
        int i = this.month.getSelectedIndex();
        if ((i += n) >= 0 && i < cc) {
            this.month.setSelectedIndex(i);
            return;
        }
        if (i < 0) {
            i = 11;
            this.month.setSelectedIndex(i);
            this.yearAdd(-1);
        }
        if (i == 12) {
            i = 0;
            this.month.setSelectedIndex(i);
            this.yearAdd(1);
        }
    }

    private int getSelectedDay() {
        if (this.day == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.day.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void setSelected(JLabel newDay) {
        if (this.day != null) {
            this.day.setForeground(DAYS_FOREGROUND);
            this.day.setOpaque(false);
            this.day.setBorder(EMPTY_BORDER);
        }
        this.day = newDay;
        this.day.setForeground(SELECTED_DAY_FOREGROUND);
        this.day.setOpaque(true);
        if (this.daysGrid.hasFocus()) {
            this.day.setBorder(FOCUSED_BORDER);
        }
    }

    private void setSelected(int newDay) {
        this.setSelected(this.days[(newDay + this.offset - 1) / 7 + 1][(newDay + this.offset - 1) % 7]);
    }

    private void update() {
        int iday = this.getSelectedDay();
        int i = 0;
        while (i < 7) {
            this.days[1][i].setText(" ");
            this.days[5][i].setText(" ");
            this.days[6][i].setText(" ");
            ++i;
        }
        this.calendar.set(5, 1);
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        this.offset = this.calendar.get(7) - 1;
        this.lastDay = this.calendar.getActualMaximum(5);
        i = 0;
        while (i < this.lastDay) {
            this.days[(i + this.offset) / 7 + 1][(i + this.offset) % 7].setText(String.valueOf(i + 1));
            ++i;
        }
        if (iday != -1) {
            if (iday > this.lastDay) {
                iday = this.lastDay;
            }
            this.setSelected(iday);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jbClose) {
            this.Close();
        }
    }

    public void Close() {
        this.dispose();
        if (this.okClicked) {
            this.calendar.set(5, this.getSelectedDay());
            this.calendar.set(2, this.month.getSelectedIndex() + 0);
            this.calendar.set(1, this.year.getSelectedIndex() + 1900);
            if (this.needTime) {
                this.calendar.set(11, this.hour.getSelectedIndex());
                this.calendar.set(12, this.minute.getSelectedIndex());
                this.calendar.set(13, this.second.getSelectedIndex());
            }
            Date d = this.calendar.getTime();
            this.DE.SetDateTime(d);
            this.okClicked = false;
        }
        this.DE.requestFocusInWindow();
    }

    public void focusGained(FocusEvent e) {
        this.setSelected(this.day);
    }

    public void focusLost(FocusEvent e) {
        this.Close();
    }

    public void itemStateChanged(ItemEvent e) {
        this.update();
    }

    public void keyPressed(KeyEvent e) {
        int iday = this.getSelectedDay();
        switch (e.getKeyCode()) {
            case 37: {
                if (iday <= 1) break;
                this.setSelected(iday - 1);
                break;
            }
            case 39: {
                if (iday >= this.lastDay) break;
                this.setSelected(iday + 1);
                break;
            }
            case 38: {
                if (iday <= 7) break;
                this.setSelected(iday - 7);
                break;
            }
            case 40: {
                if (iday > this.lastDay - 7) break;
                this.setSelected(iday + 7);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (!(e.getSource() instanceof JLabel)) {
            this.Close();
            return;
        }
        JLabel day = (JLabel)e.getSource();
        if (!day.getText().equals(" ")) {
            this.setSelected(day);
        }
        if (!this.needTime) {
            this.okClicked = true;
            this.Close();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (!(e.getSource() instanceof JLabel)) {
            return;
        }
        JLabel day = (JLabel)e.getSource();
        if (!day.getText().equals(" ")) {
            day.setBorder(FOCUSED_BORDER);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (!(e.getSource() instanceof JLabel)) {
            return;
        }
        JLabel day = (JLabel)e.getSource();
        if (!day.getText().equals(" ")) {
            day.setBorder(EMPTY_BORDER);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public DateChooser(Frame pf, boolean modal) {
        this(pf, modal, false);
    }

    public DateChooser(Frame pf, boolean modal, boolean needTime) {
        super(pf, "", modal);
        this.needTime = needTime;
        this.construct();
    }

    public void select(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.calendar.setTime(date);
        int _day = this.calendar.get(5);
        int _month = this.calendar.get(2);
        int _year = this.calendar.get(1);
        int _hour = this.calendar.get(11);
        int _minute = this.calendar.get(12);
        int _second = this.calendar.get(13);
        this.hour.setSelectedIndex(_hour);
        this.minute.setSelectedIndex(_minute);
        this.second.setSelectedIndex(_second);
        this.year.setSelectedIndex(_year - 1900);
        this.month.setSelectedIndex(_month - 0);
        this.setSelected(_day);
        this.okClicked = false;
        this.setVisible(true);
        this.requestFocusInWindow();
    }

    public void select() {
        this.select(new Date());
    }

    private static class FocusablePanel
    extends JPanel {
        public FocusablePanel(LayoutManager layout) {
            super(layout);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

