/*
 * Decompiled with CFR 0.152.
 */
package excel.edit;

import excel.edit.CustomerUI;
import excel.edit.DropDownListBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class DataList
extends JList
implements KeyListener,
MouseListener,
FocusListener {
    public boolean EditGainFocus = false;
    public DropDownListBox pDDLB;
    public Window pWnd;
    public int itemHeight = 20;

    public DataList(DropDownListBox ddlb, Window pw, boolean addFocusListener, int itemHeight) {
        this.pWnd = pw;
        this.pDDLB = ddlb;
        this.itemHeight = itemHeight;
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addMouseListener(this);
        if (addFocusListener) {
            this.addFocusListener(this);
        }
        this.setBackground(new Color(245, 245, 255));
        this.setBorder(null);
        this.setUI(new CustomerUI());
        this.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ((CustomerUI)list.getUI()).setCellHeight(index, ((DataList)list).itemHeight, ((DataList)list).itemHeight);
                this.setText(value.toString());
                this.setFont(DataList.this.pDDLB.getFont());
                if (isSelected) {
                    this.setOpaque(true);
                    this.setBackground(new Color(0x6C6CFF));
                    this.setForeground(Color.white);
                } else if (cellHasFocus) {
                    this.setOpaque(true);
                    this.setBackground(new Color(10354540));
                    this.setForeground(Color.white);
                } else {
                    this.setOpaque(false);
                    this.setBackground(DataList.this.pDDLB.getBackground());
                    this.setForeground(DataList.this.pDDLB.getForeground());
                }
                return this;
            }
        });
    }

    public void keyPressed(KeyEvent e) {
    }

    private void SetValue(boolean b) {
        Object v = this.getSelectedValue();
        if (v != null) {
            this.pDDLB.setText(v.toString());
        }
        this.pWnd.setVisible(false);
        this.pWnd.dispose();
        this.pDDLB.longForFocus();
        this.pDDLB.Sheet.getWorkBook().getWorkBookView().forceCurrentEditControlGiveUpFocus();
    }

    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                this.SetValue(true);
                break;
            }
            case 27: {
                this.SetValue(false);
            }
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                break;
            }
            default: {
                this.pDDLB.refreshDDLB(false);
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.SetValue(true);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.SetValue(false);
    }
}

