/*
 * Decompiled with CFR 0.152.
 */
package excel.edit;

import excel.core.EditStyle;
import excel.core.Property;
import excel.core.impl.Cell_;
import excel.edit.DropDownListBox;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class CheckBoxPanel
extends JPanel
implements KeyListener,
MouseListener {
    DropDownListBox pDDLB;
    Window pWnd;
    EditStyle ES;
    int itemHeight = 0;

    public CheckBoxPanel(DropDownListBox ddlb, Window pw, boolean addFocusListener) {
        this.pWnd = pw;
        this.pDDLB = ddlb;
        this.ES = this.pDDLB.ES;
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.setBackground(new Color(245, 0, 0));
    }

    public void paint(Graphics g) {
        Cell_ cell = (Cell_)this.pDDLB.Sheet.Cells(this.pDDLB.Row, this.pDDLB.Col);
        Rectangle rcClip = g.getClipBounds();
        Rectangle rc = this.getBounds();
        int w = rc.width;
        int h = rc.height;
        rc.x = 0;
        rc.y = 0;
        Property prop = cell.getProperty();
        int background_mode = prop.get("background-mode", 1);
        Color background_color = prop.get("background-color", Color.WHITE);
        if (background_mode == 0) {
            background_color = this.pDDLB.Sheet.getPaperColor();
        }
        g.setColor(background_color);
        g.fillRect(0, 0, w, h);
        Color font_color = prop.get("font-color", Color.BLACK);
        String font_name = prop.get("font-name", "\u5b8b\u4f53");
        int font_size = prop.get("font-size", 12);
        boolean font_bold = prop.get("font-bold", false);
        boolean font_italic = prop.get("font-italic", false);
        boolean font_underline = prop.get("font-underline", false);
        int align_h = prop.get("align-h", 0);
        int align_v = prop.get("align-v", 2);
        this.pDDLB.initMap();
        int colCount = Math.max(1, this.ES.getColumnCountOnRow());
        int rowCount = Math.max(1, (this.pDDLB.listFrame.ListCount - 1) / colCount + 1);
        Rectangle itemRC = new Rectangle();
        itemRC.width = rc.width / colCount;
        this.itemHeight = rc.height / rowCount;
        System.out.println("============" + this.itemHeight);
        itemRC.height = this.itemHeight - 1;
        int ri = 0;
        while (ri < rowCount) {
            itemRC.y = rc.y + ri * this.itemHeight;
            int ci = 0;
            while (ci < colCount) {
                itemRC.x = rc.x + ci * itemRC.width;
                int index = ri * colCount + ci;
                if (index > this.pDDLB.listFrame.ListCount - 1) break;
                String tipText = Tools.$S(this.pDDLB.listFrame.showvalues[index]);
                Object showText = this.pDDLB.listFrame.showvalues[index];
                boolean checked = this.pDDLB.checkedMap.containsKey(showText);
                Tools.DrawCheckBoxOrRadioButtonString(this, (Graphics2D)g, itemRC, tipText, background_mode, background_color, font_color, font_name, font_size, font_bold, font_italic, font_underline, align_h, align_v, checked, false, true);
                ++ci;
            }
            ++ri;
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    private void SetValue(boolean b) {
        this.pWnd.setVisible(false);
        this.pWnd.dispose();
        this.pDDLB.longForFocus();
    }

    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                this.SetValue(true);
                break;
            }
            case 27: {
                this.SetValue(false);
            }
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                break;
            }
            default: {
                this.pDDLB.refreshDDLB(false);
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        Point me = e.getPoint();
        Cell_ cell = (Cell_)this.pDDLB.Sheet.Cells(this.pDDLB.Row, this.pDDLB.Col);
        Rectangle rc = this.getBounds();
        rc.height -= rc.y;
        rc.y -= rc.y;
        int listCount = this.pDDLB.listFrame.ListCount;
        int colCount = Math.max(1, this.ES.getColumnCountOnRow());
        int rowCount = Math.max(1, (listCount - 1) / colCount + 1);
        Rectangle itemRC = new Rectangle();
        itemRC.width = rc.width / colCount;
        itemRC.height = this.itemHeight;
        int ri = 0;
        while (ri < rowCount) {
            itemRC.y = rc.y + ri * itemRC.height;
            int ci = 0;
            while (ci < colCount) {
                itemRC.x = rc.x + ci * itemRC.width;
                int index = ri * colCount + ci;
                if (index > listCount - 1) break;
                Object showText = this.pDDLB.listFrame.showvalues[index];
                boolean checked = this.pDDLB.checkedMap.containsKey(showText);
                if (itemRC.contains(me)) {
                    if (this.ES.isListShowAsDropdownCheckBox()) {
                        boolean bl = checked = !checked;
                        if (checked) {
                            this.pDDLB.checkedMap.put(showText, checked);
                        } else {
                            this.pDDLB.checkedMap.remove(showText);
                        }
                    } else {
                        this.pDDLB.checkedMap.clear();
                        this.pDDLB.checkedMap.put(showText, true);
                    }
                }
                ++ci;
            }
            ++ri;
        }
        this.pDDLB.fillBack();
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

