/*
 * Decompiled with CFR 0.152.
 */
package excel.dragdrop;

import excel.core.WorkBookView;
import excel.dragdrop.DragAndDropDragGestureListener;
import excel.dragdrop.EnhancedTreeCellRenderer;
import excel.dragdrop.ResizeWindowBar;
import excel.dragdrop.TreeData;
import excel.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.json.JSONArray;
import org.json.JSONObject;

public class DragAndDrop
extends JDialog {
    JScrollPane jScrollPane = new JScrollPane();
    JLabel title;
    private Point origin = new Point();
    JPanel cc = new JPanel();
    ResizeWindowBar resizeBar;
    String type;

    public DragAndDrop(String type, String caption, WorkBookView v, JSONArray data, int x, int y, int w, int h) {
        super(JOptionPane.getFrameForComponent(v), false);
        this.setUndecorated(true);
        this.type = type;
        Rectangle rc = this.calcuPos(v, x, y, w, h);
        this.setBounds(rc);
        JPanel outBorder = new JPanel();
        int borderThick = 1;
        Color borderColor = new Color(0xFFFFFF);
        outBorder.setBorder(BorderFactory.createLineBorder(borderColor, borderThick));
        outBorder.setLayout(new BorderLayout());
        this.getContentPane().add((Component)outBorder, "Center");
        this.cc.setBorder(BorderFactory.createLineBorder(new Color(0x808080), 1));
        outBorder.add((Component)this.cc, "Center");
        this.cc.setLayout(new BorderLayout());
        Color titleBarColor = new Color(13481215);
        this.title = new JLabel();
        this.title.setPreferredSize(new Dimension(rc.width, 10));
        this.title.setOpaque(true);
        this.title.setBackground(titleBarColor);
        this.title.setForeground(Color.white);
        this.title.setCursor(new Cursor(13));
        this.title.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Point p = DragAndDrop.this.getLocation();
                DragAndDrop.this.setLocation(p.x + e.getX() - ((DragAndDrop)DragAndDrop.this).origin.x, p.y + e.getY() - ((DragAndDrop)DragAndDrop.this).origin.y);
            }
        });
        this.title.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ((DragAndDrop)DragAndDrop.this).origin.x = e.getX();
                ((DragAndDrop)DragAndDrop.this).origin.y = e.getY();
            }
        });
        JLabel closeButton = new JLabel();
        closeButton.setPreferredSize(new Dimension(12, 12));
        closeButton.setOpaque(true);
        closeButton.setBackground(titleBarColor);
        closeButton.setCursor(new Cursor(12));
        closeButton.setIcon(new ImageIcon(Tools.GetImageFromURL(v, "excel/res/cut_gray.gif")));
        closeButton.setToolTipText("\u5173\u95ed\u7a97\u53e3");
        closeButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DragAndDrop.this.close();
            }
        });
        JPanel titleBar = new JPanel();
        titleBar.setLayout(new BorderLayout());
        titleBar.add((Component)this.title, "Center");
        titleBar.add((Component)closeButton, "East");
        this.cc.add((Component)titleBar, "North");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(caption, true);
        root.setUserObject(caption);
        int i = 0;
        while (i < data.length()) {
            this.addSubNode(root, data.getJSONObject(i));
            ++i;
        }
        JTree jtr = new JTree(root);
        jtr.setCellRenderer(new EnhancedTreeCellRenderer(v));
        this.jScrollPane.getViewport().add(jtr);
        this.jScrollPane.setBorder(null);
        this.cc.add((Component)this.jScrollPane, "Center");
        this.resizeBar = new ResizeWindowBar(this, v);
        this.cc.add((Component)this.resizeBar, "South");
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(jtr, 3, new DragAndDropDragGestureListener());
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public void addSubNode(DefaultMutableTreeNode pnode, JSONObject data) {
        JSONArray sub = data.getJSONArray("subitems", null);
        String text = data.getString("text", "");
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(text, sub != null);
        Object value = data.getMap().get("value");
        if (value == null) {
            value = "";
        }
        value = value.toString();
        TreeData itemData = new TreeData("", "", this.type, text, (String)value);
        node.setUserObject(itemData);
        pnode.add(node);
        if (sub != null) {
            int i = 0;
            while (i < sub.length()) {
                this.addSubNode(node, sub.getJSONObject(i));
                ++i;
            }
        }
    }

    public void close() {
        this.dispose();
    }

    public Rectangle calcuPos(Component v, int X, int Y, int Width, int Height) {
        Rectangle rc = v.getBounds();
        Point p = new Point(rc.x, rc.y);
        p = Tools.GetAbsolutePoint(v, p);
        int t = 0;
        Rectangle tc = new Rectangle();
        int left = p.x;
        int right = p.x + rc.width;
        int top = p.y;
        int bottom = p.y + rc.height;
        t = X;
        tc.x = t >= 0 ? Math.min(left + t, right) : Math.max(left, Math.max(right + t, 0));
        t = Y;
        tc.y = t >= 0 ? Math.min(top + t, bottom) : Math.max(top, Math.max(bottom + t, 0));
        t = Width;
        if (t == 0) {
            tc.width = right - tc.x;
        }
        if (t > 0) {
            tc.width = Math.min(tc.x + t, right) - tc.x;
        }
        if (t < 0) {
            tc.width = Math.max(tc.x, Math.max(right + t, 0)) - tc.x;
        }
        if ((t = Height) == 0) {
            tc.height = bottom - tc.y;
        }
        if (t > 0) {
            tc.height = Math.min(tc.y + t, bottom) - tc.y;
        }
        if (t < 0) {
            tc.height = Math.max(tc.y, Math.max(bottom + t, 0)) - tc.y;
        }
        if (tc.height < 0) {
            tc.height = 0;
        }
        if (tc.width < 0) {
            tc.width = 0;
        }
        return tc;
    }
}

