/*
 * Decompiled with CFR 0.152.
 */
package excel.core.mouseaction;

import excel.core.ColumnPropertyManage;
import excel.core.Range;
import excel.core.RowPropertyManage;
import excel.core.impl.Cell_;
import excel.core.impl.Range_;
import excel.core.impl.WorkBookView_;
import excel.core.impl.WorkSheetView_;
import excel.core.impl.WorkSheet_;
import excel.core.mouseaction.ColumnHeadTool;
import excel.core.mouseaction.DrawTool;
import excel.core.mouseaction.RowHeadTool;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class SelectTool
extends DrawTool
implements Runnable {
    private Range oldSelection;
    private WorkSheetView_ view = null;
    private boolean ContinueScroll = false;
    private int outSizeX = 0;
    private int outSizeY = 0;
    private int deltaRow;
    private int deltaCol;

    public SelectTool() {
        super(0);
    }

    public void OnLButtonDown(WorkSheetView_ pView, MouseEvent e) {
        Cell_ cell;
        int col;
        int row;
        Point p;
        super.OnLButtonDown(pView, e);
        WorkSheet_ sheet = (WorkSheet_)pView.getWorkSheet();
        Rectangle rc = pView.getRectangleOfSelection();
        Rectangle rcTop = new Rectangle(rc.x, rc.y - 1, rc.width, 4);
        Rectangle rcBottom = new Rectangle(rc.x, rc.y + rc.height - 1, rc.width - 2, 4);
        Rectangle rcLeft = new Rectangle(rc.x - 1, rc.y, 4, rc.height);
        Rectangle rcRight = new Rectangle(rc.x + rc.width - 1, rc.y, 4, rc.height - 2);
        Rectangle rcResize = new Rectangle(rc.x + rc.width - 2, rc.y + rc.height - 2, 4, 4);
        this.m_mousestate = 12;
        String hCur = "cross.gif";
        if (!pView.getWorkSheet().isDesignMode()) {
            hCur = "default.gif";
        }
        if ((rcTop.contains(p = e.getPoint()) || rcBottom.contains(p) || rcLeft.contains(p) || rcRight.contains(p)) && pView.getWorkSheet().isDesignMode()) {
            hCur = "moveselection.gif";
            if (e.isControlDown()) {
                hCur = "moveselection2.gif";
            }
            this.m_mousestate = 10;
            row = pView.GetRowAtPoint(false, e.getY());
            col = pView.GetColAtPoint(false, e.getX(), row);
            this.deltaRow = row - sheet.getSelection().getStartRow();
            this.deltaCol = col - sheet.getSelection().getStartCol();
        }
        if (rcResize.contains(p)) {
            hCur = "selectionresize.gif";
            this.m_mousestate = 11;
        }
        pView.setCursor(SelectTool.GetCursor(hCur, pView));
        if (this.m_mousestate == 12) {
            row = pView.GetRowAtPoint(false, e.getY());
            col = pView.GetColAtPoint(false, e.getX(), row);
            if (e.isShiftDown()) {
                int row1 = this.oldSelection.getStartRow();
                int col1 = this.oldSelection.getStartCol();
                sheet.setSelection(new Range_(row1, col1, row, col));
            } else {
                sheet.setSelection(new Range_(row, col, row, col));
            }
        }
        this.oldSelection = sheet.getSelection();
        row = pView.GetRowAtPoint(false, e.getY());
        col = pView.GetColAtPoint(false, e.getX(), row);
        if (row >= 0 && col >= 0 && (cell = (Cell_)sheet.$Cells(row, col)) != null) {
            if (cell.isMerged()) {
                cell = (Cell_)cell.mergedBy();
            }
            cell.OnLButtonDown(pView, e);
        }
    }

    public void OnLButtonClick(WorkSheetView_ pView, MouseEvent e) {
        Cell_ cell;
        super.OnLButtonClick(pView, e);
        WorkSheet_ sheet = (WorkSheet_)pView.getWorkSheet();
        Range r = sheet.getSelection();
        sheet.isDesignMode();
        int row = pView.GetRowAtPoint(false, e.getY());
        int col = pView.GetColAtPoint(false, e.getX(), row);
        if (row >= 0 && col >= 0 && (cell = (Cell_)sheet.$Cells(row, col)) != null) {
            if (cell.isMerged()) {
                cell = (Cell_)cell.mergedBy();
            }
            cell.OnLButtonClick(pView, e);
        }
    }

    public void OnLButtonDblClk(WorkSheetView_ pView, MouseEvent e) {
        Cell_ cell;
        super.OnLButtonDblClk(pView, e);
        WorkSheet_ sheet = (WorkSheet_)pView.getWorkSheet();
        Range r = sheet.getSelection();
        int row = pView.GetRowAtPoint(false, e.getY());
        int col = pView.GetColAtPoint(false, e.getX(), row);
        if (row >= 0 && col >= 0 && (cell = (Cell_)sheet.$Cells(row, col)) != null) {
            if (cell.isMerged()) {
                cell = (Cell_)cell.mergedBy();
            }
            cell.OnLButtonDblClk(pView, e);
        }
    }

    public void OnLButtonUp(WorkSheetView_ pView, MouseEvent e) {
        Cell_ cell;
        Range r;
        super.OnLButtonUp(pView, e);
        WorkSheet_ sheet = (WorkSheet_)pView.getWorkSheet();
        if (this.m_mousestate == 10 && (r = sheet.getMovingSelection()) != null && sheet.isDesignMode()) {
            if (e.isControlDown()) {
                sheet.copy();
            } else {
                sheet.cut();
            }
            sheet.setSelection(r);
            sheet.paste();
            sheet.setMovingSelection(null);
        }
        int row = pView.GetRowAtPoint(false, e.getY());
        int col = pView.GetColAtPoint(false, e.getX(), row);
        if (row >= 0 && col >= 0 && (cell = (Cell_)sheet.$Cells(row, col)) != null) {
            if (cell.isMerged()) {
                cell = (Cell_)cell.mergedBy();
            }
            cell.OnLButtonUp(pView, e);
        }
    }

    public void OnMouseMove(WorkSheetView_ pView, MouseEvent e) {
        Cell_ cell;
        int col;
        int row;
        Point p;
        super.OnMouseMove(pView, e);
        WorkSheet_ sheet = (WorkSheet_)pView.getWorkSheet();
        if (c_IsDraging) {
            return;
        }
        Rectangle rc = pView.getRectangleOfSelection();
        Rectangle rcTop = new Rectangle(rc.x, rc.y - 1, rc.width, 4);
        Rectangle rcBottom = new Rectangle(rc.x, rc.y + rc.height - 1, rc.width - 2, 4);
        Rectangle rcLeft = new Rectangle(rc.x - 1, rc.y, 4, rc.height);
        Rectangle rcRight = new Rectangle(rc.x + rc.width - 1, rc.y, 4, rc.height - 2);
        Rectangle rcResize = new Rectangle(rc.x + rc.width - 2, rc.y + rc.height - 2, 4, 4);
        ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
        RowPropertyManage RPM = sheet.getRowPropertyManage();
        Rectangle rcLeftTopCorner = new Rectangle(0, 0, RPM.getRowHeadWidth(), CPM.getColumnHeadHeight());
        String hCur = "cross.gif";
        if (!pView.getWorkSheet().isDesignMode()) {
            hCur = "default.gif";
        }
        if ((rcTop.contains(p = e.getPoint()) || rcBottom.contains(p) || rcLeft.contains(p) || rcRight.contains(p)) && sheet.isDesignMode()) {
            hCur = "moveselection.gif";
            if (e.isControlDown()) {
                hCur = "moveselection2.gif";
            }
        }
        if (rcResize.contains(p)) {
            hCur = "selectionresize.gif";
        }
        if (rcLeftTopCorner.contains(p)) {
            hCur = "hand.gif";
        }
        pView.setCursor(SelectTool.GetCursor(hCur, pView));
        if (!pView.getWorkSheet().isDesignMode()) {
            Cell_ cell2;
            boolean canResize;
            if (((ColumnHeadTool)DrawTool.FindTool(4)).canDoResizeColumnWidth(pView, e) && !c_IsDraging) {
                row = pView.GetRowAtPoint(false, e.getY());
                col = pView.GetColAtPoint(false, e.getX(), row);
                canResize = true;
                if (row >= 0 && col >= 0 && (cell2 = (Cell_)sheet.$Cells(row, col)) != null) {
                    if (cell2.isMerged()) {
                        cell2 = (Cell_)cell2.mergedBy();
                    }
                    if (cell2.getBrickAt(e.getPoint()) != null) {
                        canResize = false;
                    }
                }
                if (canResize) {
                    DrawTool.c_drawShape = 4;
                    WorkSheetView_.columnHeadTool.m_mousestate = 9;
                    return;
                }
            }
            if (((RowHeadTool)DrawTool.FindTool(2)).canDoResizeRowHeight(pView, e) && !c_IsDraging) {
                row = pView.GetRowAtPoint(false, e.getY());
                col = pView.GetColAtPoint(false, e.getX(), row);
                canResize = true;
                if (row >= 0 && col >= 0 && (cell2 = (Cell_)sheet.$Cells(row, col)) != null) {
                    if (cell2.isMerged()) {
                        cell2 = (Cell_)cell2.mergedBy();
                    }
                    if (cell2.getBrickAt(e.getPoint()) != null) {
                        canResize = false;
                    }
                }
                if (canResize) {
                    DrawTool.c_drawShape = 2;
                    WorkSheetView_.rowHeadTool.m_mousestate = 9;
                    return;
                }
            }
        }
        if (pView.IsOnColumnHeader(p) && !c_IsDraging) {
            DrawTool.c_drawShape = 4;
            WorkSheetView_.columnHeadTool.m_mousestate = 9;
            return;
        }
        if (pView.IsOnRowHeader(p) && !c_IsDraging) {
            DrawTool.c_drawShape = 2;
            WorkSheetView_.rowHeadTool.m_mousestate = 9;
            return;
        }
        row = pView.GetRowAtPoint(false, e.getY());
        col = pView.GetColAtPoint(false, e.getX(), row);
        if (row >= 0 && col >= 0 && (cell = (Cell_)sheet.$Cells(row, col)) != null) {
            if (cell.isMerged()) {
                cell = (Cell_)cell.mergedBy();
            }
            cell.OnMouseMove(pView, e);
            if (pView.getWorkSheet().isDesignMode()) {
                String tooltip = String.valueOf(cell.getAutoTip(e)) + cell.getToolTip();
                if (tooltip.equals("")) {
                    pView.setToolTipText(null);
                } else {
                    pView.setToolTipText(tooltip);
                }
            }
        }
    }

    public void OnRButtonDown(WorkSheetView_ pView, MouseEvent e) {
        Cell_ cell;
        super.OnRButtonDown(pView, e);
        WorkSheet_ sheet = (WorkSheet_)pView.getWorkSheet();
        if (sheet.isDesignMode()) {
            ((WorkBookView_)sheet.getWorkBook().getWorkBookView()).getFuncMenu().show(pView, e.getX(), e.getY());
        }
        int row = pView.GetRowAtPoint(false, e.getY());
        int col = pView.GetColAtPoint(false, e.getX(), row);
        if (row >= 0 && col >= 0 && (cell = (Cell_)sheet.$Cells(row, col)) != null) {
            if (cell.isMerged()) {
                cell = (Cell_)cell.mergedBy();
            }
            cell.OnRButtonClick(pView, e);
        }
    }

    public void OnMouseDrag(WorkSheetView_ pView, MouseEvent e) {
        Cell_ cell;
        int col2;
        int row2;
        int col1;
        int row1;
        WorkSheet_ sheet = (WorkSheet_)pView.getWorkSheet();
        if (this.m_mousestate == 11) {
            row1 = this.oldSelection.getStartRow();
            col1 = this.oldSelection.getStartCol();
            row2 = Math.abs(e.getY() - SelectTool.c_down.y) > Math.abs(e.getX() - SelectTool.c_down.x) ? pView.GetRowAtPoint(false, e.getY()) : this.oldSelection.getEndRow();
            col2 = Math.abs(e.getY() - SelectTool.c_down.y) < Math.abs(e.getX() - SelectTool.c_down.x) ? pView.GetColAtPoint(false, e.getX(), row2) : this.oldSelection.getEndCol();
            sheet.setSelection(new Range_(row1, col1, row2, col2));
        }
        if (this.m_mousestate == 12) {
            row1 = this.oldSelection.getStartRow();
            col1 = this.oldSelection.getStartCol();
            row2 = pView.GetRowAtPoint(false, e.getY());
            col2 = pView.GetColAtPoint(false, e.getX(), row2);
            sheet.setSelection(new Range_(row1, col1, row2, col2));
        }
        if (this.m_mousestate == 10) {
            int row = pView.GetRowAtPoint(false, e.getY());
            int col = pView.GetColAtPoint(false, e.getX(), row);
            Range r = sheet.getSelection();
            int w = r.getEndCol() - r.getStartCol();
            int h = r.getEndRow() - r.getStartRow();
            int rc = sheet.getRowPropertyManage().getRowCount();
            int cc = sheet.getColumnPropertyManage().getColumnCount();
            int row12 = Math.min(Math.max(0, row - this.deltaRow), rc - 1 - h);
            int col12 = Math.min(Math.max(0, col - this.deltaCol), cc - 1 - w);
            int row22 = row12 + h;
            int col22 = col12 + w;
            sheet.setMovingSelection(new Range_(row12, col12, row22, col22));
        }
        Point p = e.getPoint();
        Rectangle client = pView.getBounds();
        this.outSizeX = 0;
        this.outSizeY = 0;
        if (p.x < 0) {
            this.outSizeX = p.x;
        }
        if (p.y < 0) {
            this.outSizeY = p.y;
        }
        if (p.x > client.width) {
            this.outSizeX = p.x - client.width;
        }
        if (p.y > client.height) {
            this.outSizeY = p.y - client.height;
        }
        super.OnMouseDrag(pView, e);
        int row = pView.GetRowAtPoint(false, e.getY());
        int col = pView.GetColAtPoint(false, e.getX(), row);
        if (row >= 0 && col >= 0 && (cell = (Cell_)sheet.$Cells(row, col)) != null) {
            if (cell.isMerged()) {
                cell = (Cell_)cell.mergedBy();
            }
            cell.OnMouseDrag(pView, e);
        }
        DrawTool.FindTool(4).OnMouseDrag(pView, e);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        if (this.view != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            this.view.getWorkSheet().getWorkBook().getWorkBookView().VScroll(this.outSizeY);
            this.view.getWorkSheet().getWorkBook().getWorkBookView().HScroll(this.outSizeX);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception var1_1) {
                // empty catch block
            }
lbl10:
            // 3 sources

            ** while (this.ContinueScroll)
        }
lbl11:
        // 1 sources

    }

    public void OnMouseEntered(WorkSheetView_ pView, MouseEvent e) {
        this.ContinueScroll = false;
    }

    public void OnMouseExited(WorkSheetView_ pView, MouseEvent e) {
        if (c_IsDraging) {
            this.ContinueScroll = true;
            this.view = pView;
            Thread AutoScroll = new Thread(this);
            AutoScroll.start();
        }
    }

    public void keyPressed(WorkSheetView_ pView, KeyEvent e) {
        super.keyPressed(pView, e);
        if (this.m_mousestate == 10) {
            String hCur = "moveselection.gif";
            if (e.isControlDown()) {
                hCur = "moveselection2.gif";
            }
            pView.setCursor(SelectTool.GetCursor(hCur, pView));
        }
    }

    public void keyReleased(WorkSheetView_ pView, KeyEvent e) {
        super.keyReleased(pView, e);
        if (this.m_mousestate == 10) {
            String hCur = "moveselection.gif";
            if (e.isControlDown()) {
                hCur = "moveselection2.gif";
            }
            pView.setCursor(SelectTool.GetCursor(hCur, pView));
        }
    }
}

