/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.brick.Brick;
import excel.brick.ScrollBar;
import excel.brick.impl.ScrollBar_;
import excel.core.Cell;
import excel.core.ColumnPropertyManage;
import excel.core.Range;
import excel.core.RowPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkBookView;
import excel.core.WorkSheet;
import excel.core.WorkSheetTabContainer;
import excel.core.WorkSheetView;
import excel.core.impl.CellPanel_;
import excel.core.impl.Range_;
import excel.core.impl.WorkBook_;
import excel.core.impl.WorkSheetView_;
import excel.core.impl.WorkSheet_;
import excel.core.mouseaction.DrawTool;
import excel.jep.function.VBScript.Round;
import excel.setting.CellsBorderDraw;
import excel.setting.ColorMenu;
import excel.tab.TabContainer;
import excel.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jun.dock.core.DockBar;
import jun.dock.core.DockContainer;
import jun.dock.core.DockFramework;
import jun.dock.impl.DockBar_;

public final class WorkBookView_
extends WorkBookView
implements ComponentListener,
AdjustmentListener,
KeyListener {
    public KeyEvent lastKeyEvent = null;
    WorkBook_ Book;
    JScrollBar vScrollBar;
    TabContainer tabContainer;
    JScrollBar hScrollBar;
    JSplitPane BottomBar;
    DockFramework df = null;
    boolean isDockMode = false;
    String howToDock = "";
    JPopupMenu FuncMenu = null;
    int SplitPercent = 75;
    Timer paintTimer = null;
    ScrollTask paintTask = null;
    JPanel toolbarContainer = new JPanel();
    private JFrame w_SetBorder = null;
    private Boolean isInModalDialog = null;

    public WorkBookView_(WorkBook book) {
        this.Book = (WorkBook_)book;
        Tools.initAllFontSon9();
        Rectangle rc = this.getBounds();
        this.setLayout(null);
        this.vScrollBar = new JScrollBar(1);
        int w = 18;
        int h = 16;
        this.vScrollBar.setBounds(0, 0, h, h);
        this.vScrollBar.addAdjustmentListener(this);
        this.hScrollBar = new JScrollBar(0);
        this.hScrollBar.setBounds(0, 0, w, w);
        this.hScrollBar.addAdjustmentListener(this);
        this.tabContainer = new TabContainer(this);
        this.toolbarContainer.setLayout(new BorderLayout());
        this.toolbarContainer.add((Component)this.tabContainer, "Center");
        this.BottomBar = new JSplitPane(1, this.toolbarContainer, this.hScrollBar);
        this.BottomBar.setContinuousLayout(true);
        this.BottomBar.setOneTouchExpandable(false);
        this.BottomBar.revalidate();
        int n = (int)((double)(rc.width * this.SplitPercent) / 100.0);
        this.BottomBar.setDividerLocation(n);
        this.BottomBar.revalidate();
        this.BottomBar.setBorder(null);
        this.add(this.BottomBar);
        this.add(this.vScrollBar);
        this.toolbarContainer.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                WorkBookView_.this.tabContainer.Layout();
            }
        });
        this.addComponentListener(this);
        this.addKeyListener(this);
        this.preLoadSomeResource();
    }

    public void preLoadSomeResource() {
        Tools.GetCursor(this, "sort.gif", new Point(7, 1));
        DrawTool.GetCursor("LT.gif", this);
        DrawTool.GetCursor("LB.gif", this);
        DrawTool.GetCursor("RT.gif", this);
        DrawTool.GetCursor("RB.gif", this);
        DrawTool.GetCursor("LT2.gif", this);
        DrawTool.GetCursor("LB2.gif", this);
        DrawTool.GetCursor("RT2.gif", this);
        DrawTool.GetCursor("RB2.gif", this);
        DrawTool.GetCursor("MOVE.gif", this);
        DrawTool.GetCursor("DEFAULT", this);
        DrawTool.GetCursor("hand.gif", this);
        DrawTool.GetCursor("cross.gif", this);
        DrawTool.GetCursor("default.gif", this);
        DrawTool.GetCursor("down.gif", this);
        DrawTool.GetCursor("right.gif", this);
        DrawTool.GetCursor("moveselection.gif", this);
        DrawTool.GetCursor("moveselection2.gif", this);
        DrawTool.GetCursor("selectionresize.gif", this);
        DrawTool.GetCursor("hand.gif", this);
        DrawTool.GetCursor("edittip.gif", this);
    }

    public void showTabOnWhereChanged() {
        if (this.Book.isShowTabOnBottom()) {
            this.remove(this.hScrollBar);
            this.BottomBar.setRightComponent(this.hScrollBar);
            this.BottomBar.setDividerSize(4);
            this.SplitPercent = 75;
        } else {
            this.BottomBar.remove(this.hScrollBar);
            this.BottomBar.setDividerSize(0);
            this.SplitPercent = 100;
            this.add(this.hScrollBar);
        }
        this.tabContainer.showTabOnWhereChanged();
        this.componentResized(null);
    }

    public WorkBook getBook() {
        return this.Book;
    }

    public WorkBook getWorkBook() {
        return this.Book;
    }

    public boolean isHScrollBarVisible() {
        return this.hScrollBar.isVisible();
    }

    public boolean isVScrollBarVisible() {
        return this.vScrollBar.isVisible();
    }

    public boolean isInModalDialog() {
        if (this.isInModalDialog != null) {
            return this.isInModalDialog;
        }
        Container ct = this;
        while (ct != null) {
            if (ct instanceof JDialog) {
                JDialog dlg = (JDialog)ct;
                this.isInModalDialog = new Boolean(dlg.isModal());
                break;
            }
            ct = ct.getParent();
        }
        if (this.isInModalDialog == null) {
            this.isInModalDialog = new Boolean(false);
        }
        return this.isInModalDialog;
    }

    public DockFramework getDockFramework() {
        return this.df;
    }

    public Rectangle getSheetRect() {
        Rectangle rc = this.getBounds();
        int x = 0;
        int y = this.Book.isShowTabOnBottom() ? 0 : (this.Book.isTabVisible() ? 18 : 0);
        int w = rc.width - (this.vScrollBar.isVisible() ? this.vScrollBar.getWidth() : 0);
        int h = rc.height - y - (this.hScrollBar.isVisible() && !this.Book.isShowTabOnBottom() && this.Book.isTabVisible() ? this.hScrollBar.getHeight() : 0) - (this.Book.isShowTabOnBottom() && this.Book.isTabVisible() ? 18 : 0);
        Rectangle sheetRC = new Rectangle(x, y, w, h);
        return sheetRC;
    }

    public void componentResized(ComponentEvent e) {
        Rectangle rc = this.getBounds();
        if (!this.isDockMode) {
            Rectangle sheetRC = this.getSheetRect();
            int i = 0;
            while (i < this.Book.getWorkSheetCount()) {
                WorkSheetView view = this.Book.getWorkSheet(i).getWorkSheetView();
                if (view.getWorkSheet().getContainerCellPanel() == null) {
                    view.setBounds(sheetRC);
                    if (this.Book.getActiveSheet().getIndex() == i && !view.getWorkSheet().isDesignMode()) {
                        if (view.includeStretchColumn()) {
                            this.hScrollBar.setVisible(false);
                            view.reCalcuColumnsWidth();
                        }
                        if (view.includeStretchRow()) {
                            this.vScrollBar.setVisible(false);
                            view.reCalcuRowsHeight();
                        }
                        ((WorkSheet_)view.getWorkSheet()).resetInnerCellPanelSize();
                    }
                }
                ++i;
            }
            if (this.vScrollBar.isVisible()) {
                this.vScrollBar.setBounds(rc.width - this.vScrollBar.getWidth(), sheetRC.y, this.vScrollBar.getWidth(), sheetRC.height);
            }
            this.BottomBar.setBounds(0, this.Book.isShowTabOnBottom() ? rc.height - 18 : 0, rc.width - (this.vScrollBar.isVisible() ? this.vScrollBar.getWidth() : 0), this.Book.isTabVisible() || this.hScrollBar.isVisible() ? this.hScrollBar.getHeight() : 0);
            if (!(this.Book.isShowTabOnBottom() && this.Book.isTabVisible() || !this.hScrollBar.isVisible())) {
                this.hScrollBar.setBounds(0, sheetRC.y + sheetRC.height, sheetRC.width, this.hScrollBar.getHeight());
            }
            this.vScrollBar.revalidate();
            this.hScrollBar.revalidate();
            this.BottomBar.revalidate();
            int n = (int)((double)(rc.width * this.SplitPercent) / 100.0);
            if (!this.Book.isTabVisible()) {
                n = 0;
                this.BottomBar.setDividerSize(0);
            }
            this.BottomBar.setDividerLocation(n);
            this.BottomBar.revalidate();
            this.ResetHScrollBarScrollRange();
            this.ResetVScrollBarScrollRange();
            this.Book.getActiveSheet().getWorkSheetView().repaint();
        } else {
            rc.x = 0;
            rc.y = 0;
            this.df.setBounds(rc);
            this.doLayout();
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public JComponent toJComponent() {
        return this;
    }

    public WorkSheetTabContainer getWorkSheetTabContainer() {
        return this.tabContainer;
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.SimulateAdjustmentValueChanged(e, e.getAdjustable().equals(this.hScrollBar));
        WorkSheetView_ view = (WorkSheetView_)this.Book.getActiveSheet().getWorkSheetView();
        view.forceCurrentEditControlGiveUpFocus();
        view.$setCurrentEditingEdit(null);
        view.requestFocusInWindow();
    }

    private boolean SimulateAdjustmentValueChanged(AdjustmentEvent e, int delta) {
        boolean wheelInner = false;
        WorkSheet sheet = this.Book.getActiveSheet();
        if (e.getAdjustable().equals(this.hScrollBar)) {
            sheet.setXOffset(e.getValue());
        } else {
            String dsn = sheet.getDataSourceNameAtCurrentMousePoint();
            if (!dsn.equals("") && this.Book.getDataSource(dsn).getDataSourceType() == 2) {
                int RC = sheet.getRowCount();
                int CC = sheet.getColumnCount();
                Brick brick = null;
                int row = 0;
                while (row < RC) {
                    int col = 0;
                    while (col < CC) {
                        Cell cell = ((WorkSheet_)sheet).$Cells(row, col);
                        if (cell != null) {
                            int bc = cell.getBrickCount();
                            int bi = 0;
                            while (bi < bc) {
                                brick = cell.getBrick(bi);
                                if (brick instanceof ScrollBar && ((ScrollBar)brick).getDataSource().equals(dsn)) {
                                    int v = delta;
                                    if (v > 0) {
                                        ((ScrollBar_)brick).moveDown(1);
                                    } else {
                                        ((ScrollBar_)brick).moveUp(1);
                                    }
                                    wheelInner = true;
                                }
                                ++bi;
                            }
                        }
                        ++col;
                    }
                    ++row;
                }
            }
            if (!wheelInner) {
                sheet.setYOffset(e.getValue());
            }
        }
        if (this.paintTimer != null && !wheelInner) {
            this.paintTimer.cancel();
            this.paintTimer = null;
            this.paintTask = null;
        }
        return wheelInner;
    }

    private void SimulateAdjustmentValueChanged(AdjustmentEvent e, boolean immediately) {
        if (immediately) {
            this.SimulateAdjustmentValueChanged(e, e.getValue());
        } else {
            if (this.paintTimer != null) {
                this.paintTask.cancel();
                this.paintTask = null;
            }
            this.paintTimer = new Timer(true);
            this.paintTask = new ScrollTask(e);
            this.paintTimer.schedule((TimerTask)this.paintTask, 20L);
        }
    }

    public void ResetHScrollBarScrollRange() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WorkBookView_.this.$ResetHScrollBarScrollRange();
            }
        });
    }

    private void $ResetHScrollBarScrollRange() {
        boolean oldVisible;
        WorkSheet sheet = this.Book.getActiveSheet();
        if (sheet == null) {
            return;
        }
        WorkSheetView view = sheet.getWorkSheetView();
        if (view == null) {
            return;
        }
        Rectangle rc = view.getBounds();
        ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
        RowPropertyManage RPM = sheet.getRowPropertyManage();
        int all = CPM.getAllColumnsWidth();
        boolean newVisible = oldVisible = this.hScrollBar.isVisible();
        if (all + RPM.getRowHeadWidth() <= rc.width) {
            newVisible = false;
            this.hScrollBar.setVisible(newVisible);
            sheet.setXOffset(0);
            this.BottomBar.setDividerSize(0);
        } else {
            newVisible = true;
            this.hScrollBar.setVisible(newVisible);
            if (this.Book.isShowTabOnBottom()) {
                this.BottomBar.setDividerSize(4);
            }
        }
        if (oldVisible != newVisible) {
            this.componentResized(null);
        }
        int oneScreen = rc.width - RPM.getRowHeadWidth() - CPM.getFixedColumnWidth();
        int UnitIncrement = 72;
        this.hScrollBar.removeAdjustmentListener(this);
        this.hScrollBar.setMinimum(0);
        int maxSize = Math.max(0, all - oneScreen + 10 - CPM.getFixedColumnWidth());
        float bl = 0.5f;
        maxSize = (int)((float)maxSize / (1.0f - bl));
        this.hScrollBar.setMaximum(maxSize);
        this.hScrollBar.setVisibleAmount((int)((float)this.hScrollBar.getMaximum() * bl));
        this.hScrollBar.setBlockIncrement(oneScreen);
        this.hScrollBar.setUnitIncrement(UnitIncrement);
        this.hScrollBar.setValue(sheet.getXOffset());
        this.hScrollBar.addAdjustmentListener(this);
        ((WorkSheet_)sheet).resetInnerCellPanelSize();
    }

    public void ResetVScrollBarScrollRange() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WorkBookView_.this.$ResetVScrollBarScrollRange();
            }
        });
    }

    private void $ResetVScrollBarScrollRange() {
        boolean oldVisible;
        WorkSheet sheet = this.Book.getActiveSheet();
        if (sheet == null) {
            return;
        }
        WorkSheetView view = sheet.getWorkSheetView();
        if (view == null) {
            return;
        }
        Rectangle rc = view.getBounds();
        ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
        RowPropertyManage RPM = sheet.getRowPropertyManage();
        int all = RPM.getAllRowsHeight();
        int oneScreen = rc.height - CPM.getColumnHeadHeight() - RPM.getFixedRowHeight();
        boolean newVisible = oldVisible = this.vScrollBar.isVisible();
        if (all + CPM.getColumnHeadHeight() <= rc.height) {
            newVisible = false;
            this.vScrollBar.setVisible(newVisible);
            sheet.setYOffset(0);
        } else {
            newVisible = true;
            this.vScrollBar.setVisible(newVisible);
        }
        if (oldVisible != newVisible) {
            this.componentResized(null);
            return;
        }
        int UnitIncrement = 21;
        this.vScrollBar.removeAdjustmentListener(this);
        this.vScrollBar.setMinimum(0);
        int maxSize = Math.max(0, all - oneScreen + 50 - RPM.getFixedRowHeight());
        float bl = (float)(10000 - maxSize) / 10000.0f;
        if (bl > 0.9f) {
            bl = 0.9f;
        }
        if (bl < 0.0f) {
            bl = 0.1f;
        }
        maxSize = (int)((float)maxSize / (1.0f - bl));
        this.vScrollBar.setMaximum(maxSize);
        this.vScrollBar.setVisibleAmount((int)((float)this.vScrollBar.getMaximum() * bl));
        this.vScrollBar.setBlockIncrement(oneScreen);
        this.vScrollBar.setUnitIncrement(UnitIncrement);
        this.vScrollBar.setValue(sheet.getYOffset());
        this.vScrollBar.addAdjustmentListener(this);
        ((WorkSheet_)sheet).resetInnerCellPanelSize();
    }

    public void VScroll(int delta) {
        AdjustmentEvent evt;
        boolean inner;
        int max;
        if (delta == 0) {
            return;
        }
        int v = this.vScrollBar.getValue();
        if ((v += delta) < 0) {
            v = 0;
        }
        if (v > (max = this.vScrollBar.getMaximum())) {
            v = max;
        }
        if (!(inner = this.SimulateAdjustmentValueChanged(evt = new AdjustmentEvent(this.vScrollBar, 0, 0, v), delta))) {
            this.vScrollBar.setValue(v);
        }
    }

    public void HScroll(int delta) {
        int max;
        if (delta == 0) {
            return;
        }
        int v = this.hScrollBar.getValue();
        if ((v += delta) < 0) {
            v = 0;
        }
        if (v > (max = this.hScrollBar.getMaximum())) {
            v = max;
        }
        this.hScrollBar.setValue(v);
        AdjustmentEvent evt = new AdjustmentEvent(this.hScrollBar, 0, 0, v);
        this.SimulateAdjustmentValueChanged(evt, delta);
    }

    public void keyPressed(KeyEvent e) {
        this.lastKeyEvent = e;
    }

    public void keyReleased(KeyEvent e) {
        this.lastKeyEvent = e;
    }

    public void keyTyped(KeyEvent e) {
        this.lastKeyEvent = e;
    }

    private JMenuItem createMenuItem(String caption, String icon, String propertyName, Object propertyValue) {
        JMenuItem ret = icon == null ? new JMenuItem(" " + caption) : new JMenuItem(" " + caption, new ImageIcon(Tools.GetImageFromURL(this, "excel/img/" + icon)));
        Dimension dim = ret.getPreferredSize();
        dim.height = 19;
        ret.setPreferredSize(dim);
        if (propertyName != null) {
            this.AddSetPropertyAction(ret, propertyName, propertyValue);
        }
        return ret;
    }

    private JMenu createMenu(String caption, String icon) {
        JMenu ret = new JMenu(" " + caption);
        if (icon != null) {
            ret.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/img/" + icon)));
        }
        Dimension dim = ret.getPreferredSize();
        dim.height = 19;
        ret.setPreferredSize(dim);
        return ret;
    }

    private void AddSetPropertyAction(AbstractButton mi, String propertyName, Object propertyValue) {
        final String propertyName_ = propertyName;
        final Object propertyValue_ = propertyValue;
        mi.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Range r = WorkBookView_.this.Book.getActiveSheet().getSelection();
                WorkBookView_.this.Book.getActiveSheet().setRangeProperty(r, propertyName_, propertyValue_);
            }
        });
    }

    private JPopupMenu createFuncMenu() {
        JPopupMenu ret = new JPopupMenu("popup");
        Tools.addContextMenu(this.Book.getActiveSheet(), ret, this.Book.contextMenuMap, 19);
        JMenuItem m_cut = this.createMenuItem("\u526a\u5207", "cut.gif", null, null);
        JMenuItem m_copy = this.createMenuItem("\u590d\u5236", "copy.gif", null, null);
        m_copy.setToolTipText("\u5728\u5de5\u4f5c\u8868\u5185\u6216\u5de5\u4f5c\u7c3f\u4e2d\u4e0d\u540c\u7684\u5de5\u4f5c\u8868\u95f4\u8fdb\u884c\u590d\u5236\u7c98\u8d34");
        JMenuItem m_paste = this.createMenuItem("\u7c98\u8d34", null, null, null);
        m_paste.setToolTipText("\u5728\u5de5\u4f5c\u8868\u5185\u6216\u5de5\u4f5c\u7c3f\u4e2d\u4e0d\u540c\u7684\u5de5\u4f5c\u8868\u95f4\u8fdb\u884c\u590d\u5236\u7c98\u8d34");
        m_cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBookView_.this.Book.getActiveSheet().cut();
            }
        });
        m_copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBookView_.this.Book.getActiveSheet().copy();
            }
        });
        m_paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBookView_.this.Book.getActiveSheet().paste();
            }
        });
        JMenu m_insert = this.createMenu("\u63d2\u5165", null);
        JMenuItem m_insert1 = this.createMenuItem("\u6d3b\u52a8\u5355\u5143\u683c\u53f3\u79fb", null, null, null);
        JMenuItem m_insert2 = this.createMenuItem("\u6d3b\u52a8\u5355\u5143\u683c\u4e0b\u79fb", null, null, null);
        JMenuItem m_insert3 = this.createMenuItem("\u63d2\u5165\u6574\u884c", null, null, null);
        JMenuItem m_insert4 = this.createMenuItem("\u540e\u63d2\u4e00\u884c", null, null, null);
        JMenuItem m_insert5 = this.createMenuItem("\u63d2\u5165\u6574\u5217", null, null, null);
        JMenuItem m_insert6 = this.createMenuItem("\u540e\u63d2\u4e00\u5217", null, null, null);
        m_insert.add(m_insert3);
        m_insert.add(m_insert5);
        m_insert3.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Range r = WorkBookView_.this.Book.getActiveSheet().getSelection();
                WorkBookView_.this.Book.getActiveSheet().insertMultiRow(r.getStartRow(), r.getEndRow());
            }
        });
        m_insert5.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Range r = WorkBookView_.this.Book.getActiveSheet().getSelection();
                WorkBookView_.this.Book.getActiveSheet().insertMultiColumn(r.getStartCol(), r.getEndCol());
            }
        });
        JMenu m_delete = this.createMenu("\u5220\u9664", null);
        JMenuItem m_delete1 = this.createMenuItem("\u53f3\u4fa7\u5355\u5143\u683c\u5de6\u79fb", null, null, null);
        JMenuItem m_delete2 = this.createMenuItem("\u4e0b\u65b9\u5355\u5143\u683c\u4e0a\u79fb", null, null, null);
        JMenuItem m_delete3 = this.createMenuItem("\u5220\u9664\u6574\u884c", null, null, null);
        JMenuItem m_delete4 = this.createMenuItem("\u5220\u9664\u6574\u5217", null, null, null);
        m_delete.add(m_delete3);
        m_delete.add(m_delete4);
        m_delete3.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Range r = WorkBookView_.this.Book.getActiveSheet().getSelection();
                WorkBookView_.this.Book.getActiveSheet().deleteMultiRow(r.getStartRow(), r.getEndRow());
            }
        });
        m_delete4.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Range r = WorkBookView_.this.Book.getActiveSheet().getSelection();
                WorkBookView_.this.Book.getActiveSheet().deleteMultiColumn(r.getStartCol(), r.getEndCol());
            }
        });
        JMenuItem m_rowHeight = this.createMenuItem("\u8bbe\u7f6e\u884c\u9ad8", null, null, null);
        JMenuItem m_colWidth = this.createMenuItem("\u8bbe\u7f6e\u5217\u5bbd", null, null, null);
        m_rowHeight.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                WorkSheet sheet = WorkBookView_.this.Book.getActiveSheet();
                RowPropertyManage RPM = sheet.getRowPropertyManage();
                Range r = sheet.getSelection();
                if (r == null) {
                    return;
                }
                Object[] message = new Object[2];
                message[0] = "\u8bf7\u8f93\u5165\u884c\u9ad8(\u50cf\u7d20)\u5982\u679c\u4ee5mm\u7ed3\u5c3e\u8868\u793a\u662f\u6beb\u7c73\uff1a";
                String defaultValue = String.valueOf(RPM.getRowHeight(r.getStartRow()));
                message[1] = new JTextField(defaultValue);
                ((JTextField)message[1]).requestFocus();
                int result = JOptionPane.showOptionDialog(WorkBookView_.this.Book.getWorkBookView(), message, "\u8bbe\u7f6e\u884c\u9ad8", 0, 1, null, null, null);
                if (result == 0) {
                    String s = ((JTextField)message[1]).getText().toLowerCase().trim();
                    int h = 20;
                    if (s.endsWith("mm")) {
                        s = s.substring(0, s.length() - 2);
                        double d = Double.valueOf(s);
                        h = (int)Round.round(d / 25.4 * 72.0, 0);
                    } else {
                        h = Integer.valueOf(s);
                    }
                    int i = r.getStartRow();
                    while (i <= r.getEndRow()) {
                        RPM.setRowHeight(i, h);
                        ++i;
                    }
                }
            }
        });
        m_colWidth.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                WorkSheet sheet = WorkBookView_.this.Book.getActiveSheet();
                ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
                Range r = sheet.getSelection();
                if (r == null) {
                    return;
                }
                Object[] message = new Object[2];
                message[0] = "\u8bf7\u8f93\u5165\u5217\u5bbd(\u50cf\u7d20)\uff1a";
                String defaultValue = String.valueOf(CPM.getColumnWidth(r.getStartCol()));
                message[1] = new JTextField(defaultValue);
                ((JTextField)message[1]).requestFocus();
                int result = JOptionPane.showOptionDialog(WorkBookView_.this.Book.getWorkBookView(), message, "\u8bbe\u7f6e\u5217\u5bbd", 0, 1, null, null, null);
                if (result == 0) {
                    String s = ((JTextField)message[1]).getText().toLowerCase().trim();
                    int h = 20;
                    if (s.endsWith("mm")) {
                        s = s.substring(0, s.length() - 2);
                        double d = Double.valueOf(s);
                        h = (int)Round.round(d / 25.4 * 72.0, 0);
                    } else {
                        h = Integer.valueOf(s);
                    }
                    int i = r.getStartCol();
                    while (i <= r.getEndCol()) {
                        CPM.setColumnWidth(i, h);
                        ++i;
                    }
                }
            }
        });
        JMenu m_style = this.createMenu("\u683c\u5f0f", null);
        JMenu m_fontname = this.createMenu("\u5b57\u4f53\u540d\u79f0", null);
        String[] fontnames = new String[]{"\u5b8b\u4f53", "\u96b6\u4e66", "\u6977\u4f53_GB2312", "\u65b9\u6b63\u8212\u4f53", "\u9ed1\u4f53", "\u534e\u6587\u5f69\u4e91", "\u534e\u6587\u4eff\u5b8b", "\u534e\u6587\u7425\u73c0", "\u534e\u6587\u96b6\u4e66", "\u534e\u6587\u65b0\u9b4f", "\u534e\u6587\u884c\u6977", "\u534e\u6587\u4e2d\u5b8b", "\u5e7c\u5706", "Arial", "Courier New", "Microsoft Sans Serif", "Times New Roman", "Tahoma", "Verdana"};
        int i = 0;
        while (i < fontnames.length) {
            JMenuItem fi = this.createMenuItem(fontnames[i], null, "font-name", fontnames[i]);
            fi.setFont(new Font(fontnames[i], 0, 13));
            m_fontname.add(fi);
            ++i;
        }
        JMenu m_fontsize = this.createMenu("\u5b57\u4f53\u5927\u5c0f", null);
        String[] fontsize = new String[]{"6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        int i2 = 0;
        while (i2 < fontsize.length) {
            JMenuItem fi = this.createMenuItem(fontsize[i2], null, "font-size", fontsize[i2]);
            m_fontsize.add(fi);
            ++i2;
        }
        JMenu m_halign = this.createMenu("\u6c34\u5e73\u5bf9\u9f50", null);
        JMenuItem m_halign1 = this.createMenuItem("\u5de6\u5bf9\u9f50", "alignleft.gif", "align-h", new Integer(0));
        JMenuItem m_halign2 = this.createMenuItem("\u6c34\u5e73\u5c45\u4e2d", "alignmiddle.gif", "align-h", new Integer(2));
        JMenuItem m_halign3 = this.createMenuItem("\u53f3\u5bf9\u9f50", "alignright.gif", "align-h", new Integer(1));
        m_halign.add(m_halign1);
        m_halign.add(m_halign2);
        m_halign.add(m_halign3);
        JMenu m_valign = this.createMenu("\u5782\u76f4\u5bf9\u9f50", null);
        JMenuItem m_valign1 = this.createMenuItem("\u9876\u7aef\u5bf9\u9f50", "aligntop.gif", "align-v", new Integer(0));
        JMenuItem m_valign2 = this.createMenuItem("\u5782\u76f4\u5c45\u4e2d", "aligncenter.gif", "align-v", new Integer(2));
        JMenuItem m_valign3 = this.createMenuItem("\u5e95\u8fb9\u5bf9\u9f50", "alignbottom.gif", "align-v", new Integer(1));
        m_valign.add(m_valign1);
        m_valign.add(m_valign2);
        m_valign.add(m_valign3);
        JMenu m_fontbold = this.createMenu("\u52a0\u7c97", null);
        JMenuItem m_fontbold1 = this.createMenuItem("\u662f", null, "font-bold", Boolean.TRUE);
        JMenuItem m_fontbold2 = this.createMenuItem("\u5426", null, "font-bold", Boolean.FALSE);
        m_fontbold.add(m_fontbold1);
        m_fontbold.add(m_fontbold2);
        JMenu m_fontitalic = this.createMenu("\u503e\u659c", null);
        JMenuItem m_fontitalic1 = this.createMenuItem("\u662f", null, "font-italic", Boolean.TRUE);
        JMenuItem m_fontitalic2 = this.createMenuItem("\u5426", null, "font-italic", Boolean.FALSE);
        m_fontitalic.add(m_fontitalic1);
        m_fontitalic.add(m_fontitalic2);
        JMenu m_fontunderline = this.createMenu("\u4e0b\u5212\u7ebf", null);
        JMenuItem m_fontunderline1 = this.createMenuItem("\u662f", null, "font-underline", Boolean.TRUE);
        JMenuItem m_fontunderline2 = this.createMenuItem("\u5426", null, "font-underline", Boolean.FALSE);
        m_fontunderline.add(m_fontunderline1);
        m_fontunderline.add(m_fontunderline2);
        JMenu m_fontwordwrap = this.createMenu("\u81ea\u52a8\u6298\u884c", null);
        JMenuItem m_fontwordwrap1 = this.createMenuItem("\u662f", null, "word-wrap", Boolean.TRUE);
        JMenuItem m_fontwordwrap2 = this.createMenuItem("\u5426", null, "word-wrap", Boolean.FALSE);
        m_fontwordwrap.add(m_fontwordwrap1);
        m_fontwordwrap.add(m_fontwordwrap2);
        m_style.add(m_fontname);
        m_style.add(m_fontsize);
        m_style.add(m_fontbold);
        m_style.add(m_fontitalic);
        m_style.add(m_fontunderline);
        m_style.add(m_fontwordwrap);
        m_style.add(m_halign);
        m_style.add(m_valign);
        JMenuItem m_merge = this.createMenuItem("\u5408\u5e76", null, null, null);
        m_merge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBookView_.this.Action_Merge();
            }
        });
        JMenuItem m_unmerge = this.createMenuItem("\u53d6\u6d88\u5408\u5e76", null, null, null);
        m_unmerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBookView_.this.Action_UnMerge();
            }
        });
        ColorMenu m_bgcolor = new ColorMenu(" \u80cc\u666f\u989c\u8272    ");
        m_bgcolor.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/img/menublack.gif")));
        m_bgcolor.setMnemonic('f');
        m_bgcolor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorMenu m = (ColorMenu)e.getSource();
                Color color = m.getColor();
                Range r = WorkBookView_.this.Book.getActiveSheet().getSelection();
                WorkBookView_.this.Book.getActiveSheet().setRangeProperty(r, "background-mode", new Integer(1));
                WorkBookView_.this.Book.getActiveSheet().setRangeProperty(r, "background-color", color);
            }
        });
        ColorMenu m_fontcolor = new ColorMenu(" \u6587\u5b57\u989c\u8272");
        m_fontcolor.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/img/menublack.gif")));
        m_fontcolor.setMnemonic('f');
        this.w_SetBorder = new JFrame();
        this.w_SetBorder.getContentPane().add(new CellsBorderDraw(this.Book));
        this.w_SetBorder.setDefaultCloseOperation(1);
        this.w_SetBorder.pack();
        m_fontcolor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorMenu m = (ColorMenu)e.getSource();
                Color color = m.getColor();
                Range r = WorkBookView_.this.Book.getActiveSheet().getSelection();
                WorkBookView_.this.Book.getActiveSheet().setRangeProperty(r, "font-color", color);
            }
        });
        JMenu m_fastborder = this.createMenu("\u5feb\u901f\u8fb9\u6846", null);
        m_fastborder.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/img/menublack.gif")));
        JMenuItem m_fastborder1 = this.createMenuItem("\u5168\u90e8\u9ed1\u8272\u8fb9\u6846", "bs_all.gif", null, null);
        JMenuItem m_fastborder2 = this.createMenuItem("\u56db\u5468\u9ed1\u8272\u8fb9\u6846", "bs_outer.gif", null, null);
        JMenuItem m_fastborder3 = this.createMenuItem("\u5e95\u8fb9\u865a\u7ebf\u8fb9\u6846", "fast_bs_bottom.gif", null, null);
        JMenuItem m_fastborder4 = this.createMenuItem("\u5168\u90e8\u65e0\u8fb9\u6846", null, null, null);
        m_fastborder1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkSheet sheet = WorkBookView_.this.Book.getActiveSheet();
                Range r = sheet.getSelection();
                if (sheet.getMergeMap().containsValue(r)) {
                    r = new Range_(r.getStartRow(), r.getStartCol(), r.getStartRow(), r.getStartCol());
                }
                sheet.setRangeBorder(r, 8, 1, 1, Color.black);
            }
        });
        m_fastborder2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkSheet sheet = WorkBookView_.this.Book.getActiveSheet();
                Range r = sheet.getSelection();
                if (sheet.getMergeMap().containsValue(r)) {
                    r = new Range_(r.getStartRow(), r.getStartCol(), r.getStartRow(), r.getStartCol());
                }
                sheet.setRangeBorder(r, 6, 1, 1, Color.black);
            }
        });
        m_fastborder3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkSheet sheet = WorkBookView_.this.Book.getActiveSheet();
                Range r = sheet.getSelection();
                if (sheet.getMergeMap().containsValue(r)) {
                    r = new Range_(r.getStartRow(), r.getStartCol(), r.getStartRow(), r.getStartCol());
                }
                sheet.setRangeBorder(r, 3, 2, 1, Color.black);
            }
        });
        m_fastborder4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkSheet sheet = WorkBookView_.this.Book.getActiveSheet();
                Range r = sheet.getSelection();
                if (sheet.getMergeMap().containsValue(r)) {
                    r = new Range_(r.getStartRow(), r.getStartCol(), r.getStartRow(), r.getStartCol());
                }
                sheet.setRangeBorder(r, 8, 0, 0, Color.black);
            }
        });
        m_fastborder.add(m_fastborder1);
        m_fastborder.add(m_fastborder2);
        m_fastborder.add(m_fastborder3);
        m_fastborder.add(m_fastborder4);
        JMenuItem m_border = this.createMenuItem("\u8fb9\u6846", null, null, null);
        m_border.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/img/menublack.gif")));
        m_border.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBookView_.this.w_SetBorder.setVisible(true);
            }
        });
        JMenu m_FocusRange = this.createMenu("\u7126\u70b9\u533a\u57df", null);
        m_FocusRange.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/img/menublack.gif")));
        JMenuItem m_FocusRangeAdd = this.createMenuItem("\u589e\u52a0\u7126\u70b9\u533a\u57df", null, null, null);
        JMenuItem m_FocusRangeDel = this.createMenuItem("\u5220\u9664\u7126\u70b9\u533a\u57df", null, null, null);
        JMenuItem m_FocusRangeNo = this.createMenuItem("\u8bbe\u7f6e\u7126\u70b9\u533a\u57df\u5e8f\u53f7", null, null, null);
        JMenuItem m_FocusRangeShow = this.createMenuItem("\u663e\u793a\u7126\u70b9\u533a\u57df", null, null, null);
        JMenuItem m_FocusRangeHide = this.createMenuItem("\u9690\u85cf\u7126\u70b9\u533a\u57df", null, null, null);
        m_FocusRange.add(m_FocusRangeAdd);
        m_FocusRange.add(m_FocusRangeDel);
        m_FocusRange.add(m_FocusRangeNo);
        m_FocusRange.add(m_FocusRangeShow);
        m_FocusRange.add(m_FocusRangeHide);
        m_FocusRangeAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBookView_.this.Book.do_addFocusRange();
            }
        });
        m_FocusRangeDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBookView_.this.Book.do_removeFocusRange();
            }
        });
        m_FocusRangeNo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBookView_.this.Book.do_setFocusRangeNo();
            }
        });
        m_FocusRangeShow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBookView_.this.Book.setFocusRangeVisible(true);
            }
        });
        m_FocusRangeHide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkBookView_.this.Book.setFocusRangeVisible(false);
            }
        });
        ret.add(m_cut);
        ret.add(m_copy);
        ret.add(m_paste);
        ret.add(m_insert);
        ret.add(m_delete);
        ret.add(m_rowHeight);
        ret.add(m_colWidth);
        ret.add(m_FocusRange);
        ret.add(m_style);
        ret.add(m_merge);
        ret.add(m_unmerge);
        ret.add(m_bgcolor);
        ret.add(m_fontcolor);
        ret.add(m_fastborder);
        ret.add(m_border);
        return ret;
    }

    public JPopupMenu getFuncMenu() {
        if (this.FuncMenu == null) {
            this.FuncMenu = this.createFuncMenu();
        }
        return this.FuncMenu;
    }

    private void Action_Merge() {
        WorkSheet sheet = this.Book.getActiveSheet();
        Range r = sheet.getSelection();
        sheet.Merge(r.getStartRow(), r.getStartCol(), r.getEndRow(), r.getEndCol());
    }

    private void Action_UnMerge() {
        WorkSheet sheet = this.Book.getActiveSheet();
        Range r = sheet.getSelection();
        sheet.UnMerge(r.getStartRow(), r.getStartCol(), r.getEndRow(), r.getEndCol());
    }

    public JPanel getToolbarPanel() {
        return this.toolbarContainer;
    }

    public void forceCurrentEditControlGiveUpFocus() {
        int i = 0;
        while (i < this.Book.getWorkSheetCount()) {
            WorkSheetView_ view = (WorkSheetView_)this.Book.getWorkSheet(i).getWorkSheetView();
            if (view != null) {
                view.forceCurrentEditControlGiveUpFocus();
            }
            ++i;
        }
    }

    public void forceCurrentEditControlFillBack() {
        int i = 0;
        while (i < this.Book.getWorkSheetCount()) {
            WorkSheetView_ view = (WorkSheetView_)this.Book.getWorkSheet(i).getWorkSheetView();
            if (view != null) {
                view.forceCurrentEditControlFillBack();
            }
            ++i;
        }
    }

    public void dock(String howto) {
        if (this.isDockMode) {
            return;
        }
        String[] s = howto.split(",");
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < s.length) {
            String t = s[i].trim().toUpperCase();
            if (!t.equals("")) {
                list.add(t);
            }
            ++i;
        }
        this.removeAll();
        this.df = new DockFramework();
        this.add((Component)this.df);
        Object MasterDockContainer = null;
        ArrayList<String> dcNameList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < list.size()) {
            int vi;
            String[] v;
            String name;
            DockContainer dc;
            DockContainer mdc;
            String t = (String)list.get(i2);
            if (t.indexOf("|") > 0) {
                String[] h = t.split("[|]");
                mdc = null;
                int hi = 0;
                while (hi < h.length) {
                    dc = null;
                    name = h[hi].trim();
                    if (!dcNameList.contains(name)) {
                        dcNameList.add(name);
                    }
                    if ((dc = this.df.findDockContainerWhichContainAppointedDockFrame(name)) == null) {
                        dc = this.df.newDockContainer(name);
                    }
                    if (hi == 0) {
                        mdc = dc;
                    } else {
                        mdc.horizontalSplit(null, dc, false);
                    }
                    ++hi;
                }
            }
            if (t.indexOf("-") > 0) {
                v = t.split("-");
                mdc = null;
                vi = 0;
                while (vi < v.length) {
                    dc = null;
                    name = v[vi].trim();
                    if (!dcNameList.contains(name)) {
                        dcNameList.add(name);
                    }
                    if ((dc = this.df.findDockContainerWhichContainAppointedDockFrame(name)) == null) {
                        dc = this.df.newDockContainer(name);
                    }
                    if (vi == 0) {
                        mdc = dc;
                    } else {
                        mdc.verticalSplit(null, dc, false);
                    }
                    ++vi;
                }
            }
            if (t.indexOf("/") > 0) {
                v = t.split("/");
                mdc = null;
                vi = 0;
                while (vi < v.length) {
                    dc = null;
                    name = v[vi].trim();
                    if (!dcNameList.contains(name)) {
                        dcNameList.add(name);
                    }
                    if ((dc = this.df.findDockContainerWhichContainAppointedDockFrame(name)) == null) {
                        dc = this.df.newDockContainer(name);
                    }
                    if (vi == 0) {
                        mdc = dc;
                    } else {
                        ArrayList BarList = dc.getDockBarFrame().getDockBarList();
                        int j = 0;
                        while (j < BarList.size()) {
                            mdc.getDockBarFrame().addBar((DockBar)((DockBar_)BarList.get(j)));
                            ++j;
                        }
                    }
                    ++vi;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < dcNameList.size()) {
            String name = (String)dcNameList.get(i2);
            JPanel sheetPanel = new JPanel();
            int si = Tools.String2Int(name);
            CellPanel_ cp = new CellPanel_(this.Book.getWorkSheet(si), sheetPanel, false, false);
            DockBar db = this.df.findDockBar(name);
            db.setBody((JComponent)sheetPanel);
            ++i2;
        }
        Rectangle rc = this.getBounds();
        this.isDockMode = true;
        this.howToDock = howto;
        this.vScrollBar.setVisible(false);
        this.hScrollBar.setVisible(false);
        this.BottomBar.setVisible(false);
        this.df.componentResized(null);
        this.invalidate();
        this.componentResized(null);
    }

    class ScrollTask
    extends TimerTask {
        AdjustmentEvent E;

        public ScrollTask(AdjustmentEvent e) {
            this.E = e;
        }

        public void run() {
            WorkBookView_.this.SimulateAdjustmentValueChanged(this.E, this.E.getValue());
            if (WorkBookView_.this.paintTimer != null) {
                WorkBookView_.this.paintTimer.cancel();
            }
            WorkBookView_.this.paintTimer = null;
        }
    }
}

