/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.core.Cell;
import excel.core.DBBindConfig;
import excel.core.Property;
import excel.core.WorkBookView;
import excel.core.WorkSheet;
import excel.core.impl.Cell_;
import excel.core.impl.WorkSheetView_;
import excel.edit.Edit;
import excel.event.adapter.WorkBookAdapter;
import excel.util.Tools;

public class WorkBookAdapterIns
extends WorkBookAdapter {
    private WorkSheetView_ View;

    public WorkBookAdapterIns(WorkSheetView_ view) {
        this.View = view;
    }

    public boolean isSendToMe(WorkSheet sheet) {
        return sheet == this.View.getWorkSheet();
    }

    public void NameChanged(WorkSheet sheet, String oldName, String newName) {
        if (!this.isSendToMe(sheet)) {
            return;
        }
        WorkBookView wbv = sheet.getWorkBook().getWorkBookView();
        if (wbv != null) {
            wbv.getWorkSheetTabContainer().Layout();
        }
    }

    public void CellValueChanged(WorkSheet sheet, Cell cell, Object oldValue, Object newValue, int innerRow) {
        if (!this.isSendToMe(sheet)) {
            return;
        }
        if (cell != null) {
            WorkSheetView_ view;
            Edit edit;
            DBBindConfig b;
            Property prop = cell.getProperty();
            boolean needResetRowHeight = false;
            needResetRowHeight = prop.get("auto-fit-height", false);
            if (!needResetRowHeight && (b = cell.getBind()) != null) {
                boolean bl = needResetRowHeight = b.getDataSourceType() == 2;
            }
            if (needResetRowHeight) {
                ((Cell_)cell).$ResetContainerRowHeight();
            }
            if (prop.get("auto-fit-width", false)) {
                ((Cell_)cell).$ResetContainerColumnWidth();
            }
            cell.repaint();
            if (cell.isEditing() && (edit = (view = (WorkSheetView_)sheet.getWorkSheetView()).$getCurrentEditingEdit()) != null) {
                edit.reloadEdit();
            }
        }
    }

    public void CellPropertyChanged(WorkSheet sheet, Cell cell, String propertyName, Object oldPropertyValue, Object newPropertyValue) {
        if (!this.isSendToMe(sheet)) {
            return;
        }
        if (cell != null) {
            if (propertyName.equals("auto-fit-height") && newPropertyValue instanceof Boolean && ((Boolean)newPropertyValue).booleanValue()) {
                ((Cell_)cell).$ResetContainerRowHeight();
            }
            if (propertyName.equals("auto-fit-width") && newPropertyValue instanceof Boolean && ((Boolean)newPropertyValue).booleanValue()) {
                ((Cell_)cell).$ResetContainerColumnWidth();
            }
            cell.repaint();
        }
    }

    public void CellNeedRecalculate(WorkSheet sheet, Cell cell) {
        if (!this.isSendToMe(sheet)) {
            return;
        }
        if (cell.getBind() != null) {
            ((Cell_)cell).backFill();
        }
        cell.repaint();
    }

    public boolean CellValueChangeAccept(WorkSheet sheet, Cell cell, Object oldValue, Object newValue) {
        if (!this.isSendToMe(sheet)) {
            return true;
        }
        return true;
    }

    public void Error(String errorInfo) {
        Tools.log("workbookAdapterIns\u4e2d\u7684Error:" + errorInfo);
    }

    public void onScroll(WorkSheet sheet, int dir) {
        super.onScroll(sheet, dir);
    }
}

