/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import com.sun.awt.AWTUtilities;
import excel.core.DataSourceConfig;
import excel.core.WorkSheet;
import excel.core.impl.WorkBook_;
import excel.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FindDialog
extends JDialog {
    JLabel title;
    JButton jb_find;
    JButton jb_next;
    JButton jb_prior;
    JButton jb_exit;
    private Point origin = new Point();
    WorkBook_ book;
    int Row = 0;
    int Col = 0;
    int innerRow = 0;
    Object cachedValue;
    JTextField sle_input;
    JCheckBox jb_case;
    JCheckBox jb_range;
    JCheckBox jb_match;
    JCheckBox jb_bind;
    JPanel cc = new JPanel();

    public FindDialog(WorkBook_ book) {
        super(JOptionPane.getFrameForComponent(book.getWorkBookView()), "\u67e5\u627e", false);
        this.setUndecorated(true);
        this.book = book;
        JPanel outBorder = new JPanel();
        Color borderColor = new Color(47676);
        int borderThick = 3;
        int width = 300;
        int height = 145;
        outBorder.setBorder(BorderFactory.createLineBorder(borderColor, borderThick));
        outBorder.setLayout(new BorderLayout());
        this.getContentPane().add((Component)outBorder, "Center");
        this.cc.setBorder(BorderFactory.createLineBorder(new Color(31784), 1));
        this.cc.setLayout(new BorderLayout());
        outBorder.add((Component)this.cc, "Center");
        this.title = new JLabel();
        this.title.setPreferredSize(new Dimension(width, 20));
        this.title.setOpaque(true);
        this.title.setBackground(new Color(13481215));
        this.title.setForeground(Color.black);
        this.title.setCursor(new Cursor(13));
        this.title.setText(" \u67e5\u627e");
        this.title.setIcon(new ImageIcon(Tools.GetImageFromURL(book.getWorkBookView(), "excel/img/search5.gif")));
        this.title.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Point p = FindDialog.this.getLocation();
                FindDialog.this.setLocation(p.x + e.getX() - ((FindDialog)FindDialog.this).origin.x, p.y + e.getY() - ((FindDialog)FindDialog.this).origin.y);
            }
        });
        this.title.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ((FindDialog)FindDialog.this).origin.x = e.getX();
                ((FindDialog)FindDialog.this).origin.y = e.getY();
            }
        });
        this.jb_find = new JButton("\u91cd\u65b0\u67e5\u627e");
        this.jb_find.setPreferredSize(new Dimension(85, 23));
        this.jb_find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.find();
            }
        });
        this.jb_next = new JButton("\u4e0b\u4e00\u4e2a");
        this.jb_next.setPreferredSize(new Dimension(85, 23));
        this.jb_next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.findNext();
            }
        });
        this.jb_prior = new JButton("\u4e0a\u4e00\u4e2a");
        this.jb_prior.setPreferredSize(new Dimension(85, 23));
        this.jb_prior.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.findPrior();
            }
        });
        this.jb_exit = new JButton("\u5173\u95ed");
        this.jb_exit.setPreferredSize(new Dimension(85, 23));
        this.jb_exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.exit();
            }
        });
        JPanel contentlbar = new JPanel();
        contentlbar.setPreferredSize(new Dimension(95, 120));
        contentlbar.setLayout(new FlowLayout());
        this.sle_input = new JTextField(){

            public void paint(Graphics g) {
                Rectangle rc = this.getBounds();
                super.paint(g);
                g.setFont(new Font("\u5b8b\u4f53", 0, 12));
                g.setColor(Color.LIGHT_GRAY);
                if (this.getText().equals("")) {
                    g.drawString("\u8f93\u5165\u8981\u67e5\u627e\u7684\u5185\u5bb9", rc.x, rc.y + 12);
                }
            }
        };
        int h = 14;
        int w = 180;
        final FindDialog self = this;
        this.sle_input.setPreferredSize(new Dimension(w, 24));
        this.sle_input.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                AWTUtilities.setWindowOpacity((Window)self, (float)1.0f);
            }
        });
        this.jb_case = new JCheckBox("\u5927\u5c0f\u5199\u654f\u611f");
        this.jb_case.setPreferredSize(new Dimension(w, h));
        this.jb_range = new JCheckBox("\u4ec5\u5728\u5f53\u524d\u5de5\u4f5c\u8868\u4e2d\u67e5\u627e");
        this.jb_range.setPreferredSize(new Dimension(w, h));
        this.jb_match = new JCheckBox("\u5b8c\u5168\u5339\u914d");
        this.jb_match.setPreferredSize(new Dimension(w, h));
        this.jb_bind = new JCheckBox("\u4ec5\u67e5\u627e\u7ed1\u5b9a\u6570\u636e\u5e93\u7684\u5355\u5143\u683c");
        this.jb_bind.setPreferredSize(new Dimension(w, h));
        this.jb_bind.setSelected(true);
        contentlbar.add(this.sle_input);
        contentlbar.add(this.jb_case);
        contentlbar.add(this.jb_range);
        contentlbar.add(this.jb_match);
        contentlbar.add(this.jb_bind);
        JPanel toolbar = new JPanel();
        this.cc.add((Component)this.title, "North");
        this.cc.add((Component)contentlbar, "Center");
        this.cc.add((Component)toolbar, "East");
        toolbar.setPreferredSize(new Dimension(95, 120));
        toolbar.setLayout(new FlowLayout());
        toolbar.add(this.jb_find);
        toolbar.add(this.jb_next);
        toolbar.add(this.jb_prior);
        toolbar.add(this.jb_exit);
        this.setSize(width, height);
        Tools.MoveToScreenCenter(this);
    }

    public void resetPosition() {
        this.book.getActiveSheet().setSelection(0, 0, 0, 0);
        DataSourceConfig[] dscs = this.book.getDataSources();
        int i = 0;
        while (i < dscs.length) {
            dscs[i].setCurrentBindRow(0);
            ++i;
        }
    }

    public void resetPositionToEnd() {
        WorkSheet sheet = this.book.getActiveSheet();
        int row = sheet.getRowCount() - 1;
        int col = sheet.getColumnCount() - 1;
        sheet.setSelection(row, col, row, col);
        DataSourceConfig[] dscs = this.book.getDataSources();
        int i = 0;
        while (i < dscs.length) {
            dscs[i].setCurrentBindRow(dscs[i].getDataStore().getRowCount() - 1);
            ++i;
        }
    }

    public void find() {
        this.resetPosition();
        this.findNext();
    }

    public void findNext() {
        boolean b = this.book.getActiveSheet().getWorkSheetView().findNext(this.sle_input.getText(), this.jb_case.isSelected(), this.jb_match.isSelected(), this.jb_bind.isSelected());
        if (!b) {
            if (!this.jb_match.isSelected()) {
                WorkSheet nextSheet = null;
                int i = this.book.getActiveSheet().getIndex() + 1;
                while (i < this.book.getWorkSheetCount()) {
                    if (this.book.getWorkSheet(i).isVisible()) {
                        nextSheet = this.book.getWorkSheet(i);
                        break;
                    }
                    ++i;
                }
                if (nextSheet != null) {
                    this.book.getActiveSheet().getWorkSheetView().splash(false);
                    this.book.setActiveSheet(nextSheet.getIndex());
                    this.find();
                    return;
                }
            }
            Tools.ShowInfo(this.book.getWorkBookView(), "\u65e0\u6cd5\u627e\u5230\u66f4\u591a\u7684\u5339\u914d\u6570\u636e");
        } else {
            AWTUtilities.setWindowOpacity((Window)this, (float)0.9f);
        }
    }

    public void findPrior() {
        boolean b = this.book.getActiveSheet().getWorkSheetView().findPrior(this.sle_input.getText(), this.jb_case.isSelected(), this.jb_match.isSelected(), this.jb_bind.isSelected());
        if (!b) {
            if (!this.jb_match.isSelected()) {
                WorkSheet nextSheet = null;
                int i = this.book.getActiveSheet().getIndex() - 1;
                while (i >= 0) {
                    if (this.book.getWorkSheet(i).isVisible()) {
                        nextSheet = this.book.getWorkSheet(i);
                        break;
                    }
                    --i;
                }
                if (nextSheet != null) {
                    this.book.getActiveSheet().getWorkSheetView().splash(false);
                    this.book.setActiveSheet(nextSheet.getIndex());
                    this.resetPositionToEnd();
                    this.findPrior();
                    return;
                }
            }
            Tools.ShowInfo(this.book.getWorkBookView(), "\u65e0\u6cd5\u627e\u5230\u66f4\u591a\u7684\u5339\u914d\u6570\u636e");
        } else {
            AWTUtilities.setWindowOpacity((Window)this, (float)0.9f);
        }
    }

    public void exit() {
        this.dispose();
        this.book.findDialog = null;
    }
}

