/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.core.Cell;
import excel.core.CellDecorate;
import excel.core.DBBindConfig;
import excel.core.EditStyle;
import excel.core.Property;
import excel.core.WorkSheetView;
import excel.util.Tools;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;

public class DecorateNormal
implements CellDecorate {
    int padding_V = 0;
    int padding_H = 0;
    String theme = "normal";

    public DecorateNormal(int ph, int pv, String theme) {
        this.padding_V = pv;
        this.padding_H = ph;
        this.theme = theme;
    }

    public void paint(Graphics2D g, Cell cell, Rectangle cellBounds) {
        Property prop = cell.getProperty();
        Rectangle cellRect = (Rectangle)cellBounds.clone();
        cellRect.y += this.padding_V + prop.get("padding-top", 1);
        cellRect.height -= this.padding_V * 2 - prop.get("padding-top", 1) - prop.get("padding-bottom", 1);
        cellRect.x += this.padding_H + prop.get("padding-left", 1);
        cellRect.width -= this.padding_H * 2 + prop.get("padding-left", 1) + prop.get("padding-right", 1);
        Tools.clip(g, cellRect, false);
        WorkSheetView view = cell.getWorkSheet().getWorkSheetView();
        DBBindConfig dbc = cell.getBind();
        if (dbc != null) {
            if (!cell.isEditable() && cell.getBind().getDataSourceType() == 2) {
                return;
            }
            if (cell.getBind().getDataSourceType() == 2) {
                return;
            }
        }
        Shape oc = g.getClip();
        Object clip = null;
        String style = "";
        style = cell.isEditable() ? "enabled" : "disabled";
        EditStyle es = cell.getEditStyle();
        if (es != null) {
            int et = es.getEditType();
            if (et == 5) {
                style = "";
            }
            if (et == 4) {
                if (es.isListShowAsCheckBox() || es.isListShowAsRadioButton()) {
                    style = "";
                } else if (cell.isEditable()) {
                    style = "ddlb";
                }
            }
        }
        if (!style.equals("")) {
            this.drawLeftTop(view, g, cell, cellRect, style);
            this.drawLeftMiddle(view, g, cell, cellRect, style);
            this.drawLeftBottom(view, g, cell, cellRect, style);
            this.drawMiddleTop(view, g, cell, cellRect, style);
            this.drawMiddleBottom(view, g, cell, cellRect, style);
            this.drawRightTop(view, g, cell, cellRect, style);
            this.drawRightMiddle(view, g, cell, cellRect, style);
            this.drawRightBottom(view, g, cell, cellRect, style);
        }
        Tools.setClip(g, oc);
    }

    private void drawLeftTop(WorkSheetView view, Graphics2D g, Cell cell, Rectangle cellRect, String style) {
        Rectangle clip = (Rectangle)cellRect.clone();
        clip.width = cellRect.width / 2;
        clip.height = cellRect.height / 2;
        Tools.clip(g, clip, false);
        int x = cellRect.x;
        int y = cellRect.y;
        g.drawImage(Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_lt.png"), x, y, view);
    }

    private void drawLeftMiddle(WorkSheetView view, Graphics2D g, Cell cell, Rectangle cellRect, String style) {
        Rectangle clip = (Rectangle)cellRect.clone();
        clip.y += 4;
        clip.width /= 2;
        clip.height = Math.max(0, clip.height - 4 - 4);
        Tools.clip(g, clip, false);
        Image normal_lm = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_lm.png");
        int imgH = normal_lm.getHeight(view);
        int x = cellRect.x;
        int y = clip.y;
        while (y < clip.y + clip.height) {
            g.drawImage(normal_lm, x, y, view);
            y += imgH;
        }
    }

    private void drawLeftBottom(WorkSheetView view, Graphics2D g, Cell cell, Rectangle cellRect, String style) {
        Rectangle clip = (Rectangle)cellRect.clone();
        clip = (Rectangle)cellRect.clone();
        clip.y = cellRect.y + cellRect.height / 2;
        clip.width = cellRect.width / 2;
        clip.height = cellRect.height + cellRect.y - clip.y;
        Tools.clip(g, clip, false);
        int x = cellRect.x;
        int y = cellRect.y + cellRect.height - 4;
        g.drawImage(Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_lb.png"), x, y, view);
    }

    private void drawMiddleTop(WorkSheetView view, Graphics2D g, Cell cell, Rectangle cellRect, String style) {
        Rectangle clip = (Rectangle)cellRect.clone();
        clip.x += 4;
        clip.width = Math.max(0, clip.width - 4 - 3);
        clip.height /= 2;
        Tools.clip(g, clip, false);
        Image img = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_mt.png");
        int imgW = img.getWidth(view);
        int x = clip.x;
        int y = clip.y;
        while (x < clip.x + clip.width) {
            g.drawImage(img, x, y, view);
            x += imgW;
        }
    }

    private void drawMiddleBottom(WorkSheetView view, Graphics2D g, Cell cell, Rectangle cellRect, String style) {
        Rectangle clip = (Rectangle)cellRect.clone();
        clip.x += 4;
        clip.y = cellRect.y + cellRect.height / 2;
        clip.width = Math.max(0, clip.width - 4 - 3);
        clip.height = cellRect.height + cellRect.y - clip.y;
        Tools.clip(g, clip, false);
        Image img = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_mb.png");
        int imgW = img.getWidth(view);
        int x = clip.x;
        int y = cellRect.y + cellRect.height - 4;
        while (x < clip.x + clip.width) {
            g.drawImage(img, x, y, view);
            x += imgW;
        }
    }

    private void drawRightTop(WorkSheetView view, Graphics2D g, Cell cell, Rectangle cellRect, String style) {
        Rectangle clip = (Rectangle)cellRect.clone();
        Image img = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_rt.png");
        int imgW = img.getWidth(view);
        int imgH = img.getHeight(view);
        clip.x = cellRect.x + cellRect.width / 2;
        clip.width = cellRect.width / 2 + 1;
        clip.height = cellRect.height / 2;
        Tools.clip(g, clip, false);
        int x = cellRect.x + cellRect.width - imgW;
        int y = cellRect.y;
        g.drawImage(img, x, y, view);
    }

    private void drawRightMiddle(WorkSheetView view, Graphics2D g, Cell cell, Rectangle cellRect, String style) {
        Image img;
        Rectangle clip = (Rectangle)cellRect.clone();
        clip.x = cellRect.x + cellRect.width / 2;
        clip.y += 4;
        clip.width = clip.width / 2 + 1;
        clip.height = Math.max(0, clip.height - 4 - 4);
        Tools.clip(g, clip, false);
        if (style.equals("ddlb")) {
            img = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_rmt.png");
            int imgH = img.getHeight(view);
            int imgW = img.getWidth(view);
            int x = cellRect.x + cellRect.width - imgW;
            int y = clip.y;
            while (y < clip.y + clip.height / 2) {
                g.drawImage(img, x, y, view);
                y += imgH;
            }
            img = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_rmb.png");
            while (y < clip.y + clip.height) {
                g.drawImage(img, x, y, view);
                y += imgH;
            }
            img = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_rmm.png");
            imgH = img.getHeight(view);
            y = cellRect.y + 4 + (cellRect.height - 4 - 4 - imgH) / 2;
            g.drawImage(img, x, y, view);
        } else {
            img = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_rm.png");
            int imgH = img.getHeight(view);
            int imgW = img.getWidth(view);
            int x = cellRect.x + cellRect.width - imgW;
            int y = clip.y;
            while (y < clip.y + clip.height) {
                g.drawImage(img, x, y, view);
                y += imgH;
            }
        }
        EditStyle es = cell.getEditStyle();
    }

    private void drawRightBottom(WorkSheetView view, Graphics2D g, Cell cell, Rectangle cellRect, String style) {
        Rectangle clip = (Rectangle)cellRect.clone();
        Image img = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_rb.png");
        int imgH = img.getHeight(view);
        int imgW = img.getWidth(view);
        clip = (Rectangle)cellRect.clone();
        clip.x = cellRect.x + cellRect.width / 2;
        clip.y = cellRect.y + cellRect.height / 2;
        clip.width = cellRect.width / 2 + 1;
        clip.height = cellRect.height + cellRect.y - clip.y;
        Tools.clip(g, clip, false);
        int x = cellRect.x + cellRect.width - imgW;
        int y = cellRect.y + cellRect.height - imgH - 1;
        g.drawImage(img, x, y, view);
    }

    public int getHPadding() {
        return this.padding_H;
    }

    public int getVPadding() {
        return this.padding_V;
    }
}

