/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.core.Cell;
import excel.core.ChangeListener;
import excel.core.DBBindConfig;
import excel.core.RowPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import excel.core.impl.Cell_;
import excel.core.impl.DataSourceConfig_;
import excel.core.impl.WorkSheetView_;
import java.awt.Rectangle;
import java.util.ArrayList;
import jun.db.core.DataStore;
import jun.db.core.DataStoreActionAdapter;
import jun.db.util.TimeMark;

public final class DataStoreEventAdapter
extends DataStoreActionAdapter {
    WorkBook Book;
    DataSourceConfig_ DSC;
    private ArrayList subscribeList = null;
    private ArrayList BindList = new ArrayList();

    public DataStoreEventAdapter(WorkBook book, DataSourceConfig_ dsc) {
        this.Book = book;
        this.DSC = dsc;
        this.DSC.DSEA = this;
    }

    public void _$DataSourceAction() {
        this.Book = null;
        this.DSC = null;
        this.BindList = null;
    }

    private void notifyChangedToSubscriber() {
        if (this.subscribeList != null) {
            int n = this.subscribeList.size();
            int i = 0;
            while (i < n) {
                ((ChangeListener)this.subscribeList.get(i)).changed();
                ++i;
            }
        }
    }

    public void addSubscriber(ChangeListener subscriber) {
        if (this.subscribeList == null) {
            this.subscribeList = new ArrayList();
        }
        this.subscribeList.add(subscriber);
    }

    public void removeSubscriber(ChangeListener subscriber) {
        if (this.subscribeList == null) {
            return;
        }
        this.subscribeList.remove(subscriber);
    }

    public void RegisterCell(Cell_ cell) {
        if (!this.BindList.contains(cell)) {
            this.BindList.add(cell);
        }
        if (this.DSC.getCurrentBindRow() < 0) {
            this.ResetCurrentBindRow();
        }
        cell.$FireSelfValueChanged(-1);
    }

    public void UnRegisterCell(Cell_ cell) {
        if (!this.BindList.contains(cell)) {
            return;
        }
        this.BindList.remove(cell);
        cell.$FireSelfValueChanged(-1);
    }

    public void UnRegisterAllCells() {
        while (this.BindList.size() > 0) {
            Cell_ cell = (Cell_)this.BindList.get(0);
            cell.clearBind();
        }
    }

    public void RepaintAllCells() {
        int bi = 0;
        while (bi < this.BindList.size()) {
            Cell_ cell = (Cell_)this.BindList.get(bi);
            cell.repaint();
            cell.repaintRowHead();
            cell.repaintAffect();
            ++bi;
        }
    }

    public void assumeAllCellsCurrentBindRowOnCellVisibleRectangle() {
        if (this.DSC.getDataSourceType() == 1) {
            return;
        }
        int currentRow = this.DSC.getCurrentBindRow();
        int bi = 0;
        while (bi < this.BindList.size()) {
            Cell_ cell = (Cell_)this.BindList.get(bi);
            int row = cell.getRowIndex();
            WorkSheet sheet = cell.getWorkSheet();
            if (cell.getBind().getDataSourceType() == 4) {
                return;
            }
            RowPropertyManage RPM = sheet.getRowPropertyManage();
            if (!RPM.isAutoAsyncHeightWithDBRowHeight(row)) {
                if (this.DSC.getDataStore().getRowCount() == 0) {
                    RPM.setRowScrolledRowCount(row, 0);
                } else {
                    int scrolledRC = RPM.getRowScrolledRowCount(row);
                    if (currentRow < scrolledRC) {
                        RPM.setRowScrolledRowCount(row, currentRow);
                    } else {
                        WorkSheetView_ view = (WorkSheetView_)sheet.getWorkSheetView();
                        if (view == null) {
                            return;
                        }
                        Rectangle rc = view.getShowRectangleOfCell(false, row, cell.getColumnIndex());
                        int dbh = RPM.getDBRowHeight(row);
                        int showRC = (int)(rc.getHeight() / (double)dbh);
                        if (currentRow >= scrolledRC + showRC - 1) {
                            scrolledRC = currentRow - showRC + 1;
                            RPM.setRowScrolledRowCount(row, scrolledRC);
                        }
                    }
                }
            }
            ++bi;
        }
    }

    public void FireAllBindCellsValueChanged(int innerRow) {
        int bi = 0;
        while (bi < this.BindList.size()) {
            Cell_ cell = (Cell_)this.BindList.get(bi);
            cell.$FireSelfValueChanged(innerRow);
            ++bi;
        }
        this.notifyChangedToSubscriber();
    }

    public void FireSheetOfAllBindCellsResetYOffset() {
        if (this.DSC.getDataSourceType() == 1) {
            return;
        }
        ArrayList<WorkSheet> sheetList = new ArrayList<WorkSheet>();
        int bi = 0;
        while (bi < this.BindList.size()) {
            Cell_ cell = (Cell_)this.BindList.get(bi);
            if (cell.getBind().getDataSourceType() == 4) {
                return;
            }
            WorkSheet sheet = cell.getWorkSheet();
            if (!sheetList.contains(sheet)) {
                sheetList.add(sheet);
                RowPropertyManage RPM = sheet.getRowPropertyManage();
                int row = cell.getRowIndex();
                if (RPM.getRowScrolledRowCount(row) > 0) {
                    RPM.setRowScrolledRowCount(row, 0);
                } else {
                    Cell fc = sheet.getFreezedCell();
                    if (fc != null && sheet.getYOffset() != 0 && fc.getRowIndex() == row) {
                        sheet.setYOffset(0);
                    }
                }
            }
            ++bi;
        }
    }

    public void FireSomeOneBindCellsValueChanged(int dbRow, String dbcol) {
        int bi = 0;
        while (bi < this.BindList.size()) {
            Cell_ cell = (Cell_)this.BindList.get(bi);
            DBBindConfig bind = cell.getBind();
            if (bind.getDBCol().equalsIgnoreCase(dbcol)) {
                cell.$FireSelfValueChanged(dbRow);
                cell.repaint();
            }
            ++bi;
        }
        this.notifyChangedToSubscriber();
    }

    public ArrayList getAllCellsWhichBindTheCol(String dbcol) {
        ArrayList<Cell_> list = new ArrayList<Cell_>();
        int bi = 0;
        while (bi < this.BindList.size()) {
            Cell_ cell = (Cell_)this.BindList.get(bi);
            DBBindConfig bind = cell.getBind();
            if (bind.getDBCol().equalsIgnoreCase(dbcol)) {
                list.add(cell);
            }
            ++bi;
        }
        return list;
    }

    public void RepaintCell(String dbcol) {
        int bi = 0;
        while (bi < this.BindList.size()) {
            Cell_ cell = (Cell_)this.BindList.get(bi);
            cell.clearInternalImage();
            DBBindConfig bind = cell.getBind();
            if (bind.getDBCol().equalsIgnoreCase(dbcol)) {
                cell.repaint();
            }
            ++bi;
        }
    }

    private void ResetCurrentBindRow() {
        if (this.DSC.getDataStore().getRowCount() == 0) {
            this.DSC.setCurrentBindRow(-1);
        } else {
            this.DSC.setCurrentBindRow(0);
        }
    }

    public void afterDeleteRow(int row) {
        int rc = this.DSC.getDataStore().getRowCount();
        if (row < rc) {
            this.DSC.setCurrentBindRow(row);
        } else {
            this.DSC.setCurrentBindRow(rc - 1);
        }
        this.FireAllBindCellsValueChanged(-1);
    }

    public void afterFilter(int primaryBufferRowCount, int filterBufferRowCount) {
        this.ResetCurrentBindRow();
        this.FireAllBindCellsValueChanged(-1);
    }

    public void afterReset() {
        this.ResetCurrentBindRow();
        this.FireAllBindCellsValueChanged(-1);
        this.FireSheetOfAllBindCellsResetYOffset();
    }

    public void afterInsertRow(int row) {
        this.DSC.setCurrentBindRow(row);
        this.FireAllBindCellsValueChanged(row);
    }

    public void afterSort() {
        this.ResetCurrentBindRow();
        this.FireAllBindCellsValueChanged(-1);
        this.FireSheetOfAllBindCellsResetYOffset();
    }

    public void computerChanged(int row, String computer) {
        this.FireSomeOneBindCellsValueChanged(row, computer);
    }

    public boolean deleteRowPermit(int row) {
        return true;
    }

    public boolean itemChangeAccept(int row, String col, Object value) {
        return true;
    }

    public void itemChanged(int row, String col, Object oldValue, Object newValue) {
        this.FireSomeOneBindCellsValueChanged(row, col);
    }

    public void retrieveEnd(int rowCount, boolean withLastSelect) {
        this.retrieveOnceMoreEnd(1, rowCount);
    }

    public void retrieveOnceMoreEnd(int retrieveTimes, int rowCount) {
        TimeMark tm = new TimeMark(true);
        this.ResetCurrentBindRow();
        tm.stamp(" retrieve end  ResetCurrentBindRow  ok");
        this.FireAllBindCellsValueChanged(-1);
        tm.stamp(" retrieve end  FireAllBindCellsValueChanged  ok");
        this.FireSheetOfAllBindCellsResetYOffset();
        tm.stamp(" retrieve end   Over");
    }

    public void loadValueFromCellDefineAsDefaultValue() {
        DataStore ds = this.DSC.getDataStore();
        int rc = ds.getRowCount();
        int bi = 0;
        while (bi < this.BindList.size()) {
            Cell_ cell = (Cell_)this.BindList.get(bi);
            DBBindConfig bind = cell.getBind();
            String dbcol = bind.getDBCol();
            String define = cell.getDefine().trim();
            if (!define.equals("")) {
                int i = 0;
                while (i < rc) {
                    int status = ds.getPrimaryBuffer().getItemStatus(i, dbcol);
                    if (status == 2 || status == -1) {
                        ds.setValue(i, dbcol, (Object)define);
                    } else if (ds.getValue(i, dbcol) == null) {
                        ds.setValue(i, dbcol, (Object)define);
                    }
                    ++i;
                }
            }
            ++bi;
        }
    }
}

