/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.core.DataSourceConfig;
import excel.core.impl.DataStoreEventAdapter;
import java.util.ArrayList;
import jun.db.core.DataStore;
import jun.db.core.DataStoreListener;

final class DataSourceConfig_
implements DataSourceConfig {
    private String Name;
    private DataStore Ds;
    private int DataSourceType;
    private String DBPool = "";
    private String Comment = "";
    private boolean BalloonTipEditable = false;
    private int RowCountEveryPageWhenPrint = -1;
    private boolean highlightCurrentRow = true;
    public int CurrentBindRow = -1;
    DataStoreEventAdapter DSEA = null;

    public DataSourceConfig_(String name, DataStore ds, int dsType) {
        this.Name = name;
        this.Ds = ds;
        this.DataSourceType = dsType;
        if (ds.getRowCount() > 0) {
            this.CurrentBindRow = 0;
        }
    }

    public void _$DataSourceConfig_() {
        this.Ds = null;
    }

    public String getName() {
        return this.Name;
    }

    public DataStore getDataStore() {
        return this.Ds;
    }

    public int getDataSourceType() {
        return this.DataSourceType;
    }

    public int getCurrentBindRow() {
        return this.CurrentBindRow;
    }

    public void setCurrentBindRow(int row) {
        this.setCurrentBindRow(row, false);
    }

    public void setCurrentBindRow(int row, boolean forceTriggerEvent) {
        forceTriggerEvent = forceTriggerEvent || this.CurrentBindRow != row;
        this.CurrentBindRow = row;
        if (!forceTriggerEvent) {
            return;
        }
        DataStoreEventAdapter dsa = (DataStoreEventAdapter)this.Ds.getEvent().findListener(this.Name);
        dsa.RepaintAllCells();
        dsa.assumeAllCellsCurrentBindRowOnCellVisibleRectangle();
        this.DSEA.Book.getEM().fireCurrentBindRowChanged(this.Name, row);
    }

    public String getDBPoolName() {
        return this.DBPool;
    }

    public void setDBPoolName(String dbpool) {
        this.DBPool = dbpool;
        this.Ds.setDBPoolName(dbpool);
    }

    public String getComment() {
        return this.Comment;
    }

    public void setComment(String comment) {
        this.Comment = comment;
    }

    public void loadValueFromCellDefineAsDefaultValue() {
        DataStoreListener listener = this.Ds.getEvent().findListener(this.Name);
        if (listener == null) {
            return;
        }
        if (listener instanceof DataStoreEventAdapter) {
            DataStoreEventAdapter action = (DataStoreEventAdapter)listener;
            action.loadValueFromCellDefineAsDefaultValue();
        }
    }

    public ArrayList getAllCellsWhichBindTheCol(String dbcol) {
        return this.DSEA.getAllCellsWhichBindTheCol(dbcol);
    }

    public void setRowCountEveryPageWhenPrint(int rc) {
        this.RowCountEveryPageWhenPrint = rc;
    }

    public int getRowCountEveryPageWhenPrint() {
        return this.RowCountEveryPageWhenPrint;
    }

    public boolean isBalloonTipEditable() {
        return this.BalloonTipEditable;
    }

    public void setBalloonTipEnable(boolean b) {
        this.BalloonTipEditable = b;
    }

    public boolean isHighlightCurrentRow() {
        return this.highlightCurrentRow;
    }

    public void setHighlightCurrentRow(boolean b) {
        this.highlightCurrentRow = b;
    }
}

