/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.barcode.BarCode;
import excel.brick.Brick;
import excel.brick.OnlyBorder;
import excel.brick.ScrollBar;
import excel.brick.impl.BasicBrick;
import excel.command.CMD_SetProperty;
import excel.command.CMD_SetValue;
import excel.command.CommandScene;
import excel.core.Cell;
import excel.core.CellDecorate;
import excel.core.ChangeListener;
import excel.core.ColumnPropertyManage;
import excel.core.DBBindConfig;
import excel.core.DataSourceConfig;
import excel.core.Depend;
import excel.core.EditStyle;
import excel.core.MergedRange;
import excel.core.Property;
import excel.core.Range;
import excel.core.Row;
import excel.core.RowCol;
import excel.core.RowPropertyManage;
import excel.core.WorkSheet;
import excel.core.WorkSheetView;
import excel.core.ZExcel;
import excel.core.impl.Affect;
import excel.core.impl.DBBindConfig_;
import excel.core.impl.DataStoreEventAdapter;
import excel.core.impl.MergedRange_;
import excel.core.impl.PropertyManage;
import excel.core.impl.Property_;
import excel.core.impl.Range_;
import excel.core.impl.RedefineBecause;
import excel.core.impl.RowPropertyManage_;
import excel.core.impl.Row_;
import excel.core.impl.WorkBook_;
import excel.core.impl.WorkSheetView_;
import excel.core.impl.WorkSheet_;
import excel.core.mouseaction.ActionTool;
import excel.edit.DatetimeEdit;
import excel.edit.Edit;
import excel.edit.NumericEdit;
import excel.jep.ASTVarNode;
import excel.jep.JEP;
import excel.jep.SimpleNode;
import excel.jep.function.VBScript.Round;
import excel.util.Tools;
import java.applet.Applet;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import jun.db.core.ColumnProperty;
import jun.db.core.DataBuffer;
import jun.db.core.DataStore;
import jun.db.core.ObjectTool;
import jun.db.util.Base64Coder;
import jun.db.util.TimeMark;
import jun.db.util.ZDataParser;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.CustomBalloonTip;
import net.java.balloontip.styles.RoundedBalloonStyle;
import org.apache.regexp.RE;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Cell_
implements Cell,
ActionTool {
    private static HashMap<String, Image> base64ImageMap = new HashMap();
    private static Color LIGHT_ROW_COLOR = new Color(255);
    private Object Define = null;
    private boolean isValid = false;
    private Object formulaValue = null;
    private int formulaIsPriority = 0;
    private Row_ pRow;
    private WorkSheet_ Sheet;
    private Property_ property = null;
    private int VT = 99;
    private ArrayList DependList = null;
    private ArrayList AffectList = null;
    private DBBindConfig Bind = null;
    private int isEditing = 0;
    private boolean Editable = false;
    private EditStyle ES = null;
    private boolean ViewAsPWD = false;
    private HashMap BrickMap = null;
    private String ToolTip = null;
    private String Balloon = null;
    private String Alias = null;
    private Object Tag = null;
    private boolean formulaNeedCache = true;
    private Image internalImage = null;
    private String innerAction = null;
    private static SimpleDateFormat m_SDF = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private static DecimalFormat m_DF = new DecimalFormat("###,###,###,###,##0.0000");
    private String editWithButtonName = null;
    private ArrayList subscribeList = null;
    private String cursorName = "auto";
    private HashMap customValue = null;
    private CellDecorate decorate = null;
    private HashMap<Integer, CustomBalloonTip> BalloonTipControlCache = null;
    public static Color BalloonTipBackgroundColor = new Color(0xFFFF90);
    public int numberViewScale = 1;

    public Cell_(WorkSheet_ sheet, Row_ row) {
        this.Sheet = sheet;
        this.pRow = row;
    }

    public void _$Cell_() {
        this.clearInternalImage();
        this.Define = null;
        this.formulaValue = null;
        this.pRow = null;
        this.Sheet = null;
        this.property = null;
        if (this.DependList != null) {
            this.DependList.clear();
        }
        if (this.AffectList != null) {
            this.AffectList.clear();
        }
        this.Bind = null;
        this.ES = null;
        this.BrickMap = null;
        this.Tag = null;
        this.decorate = null;
    }

    public Object GetValueInsteadOfNull() {
        Object m_InsteadOfNull = null;
        switch (this.VT) {
            case 1: {
                m_InsteadOfNull = new Integer(0);
                break;
            }
            case 2: {
                m_InsteadOfNull = new BigDecimal("0");
                break;
            }
            case 3: {
                m_InsteadOfNull = new String("");
                break;
            }
            case 4: {
                m_InsteadOfNull = new Date(0L);
                break;
            }
            case 5: {
                m_InsteadOfNull = new String("");
                break;
            }
            case 6: {
                m_InsteadOfNull = new String("");
                break;
            }
            case 99: {
                m_InsteadOfNull = new String("");
            }
        }
        return m_InsteadOfNull;
    }

    @Override
    public Object getValue() {
        if (this.Bind != null) {
            DataStore ds;
            DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource());
            String dbcol = this.Bind.getDBCol();
            if (dsc != null && (ds = dsc.getDataStore()).getRowCount() == 1 && this.Bind.getDataSourceType() == 1) {
                return this.getValue(0);
            }
        }
        return this.getValue(-1);
    }

    public int getValueCount() {
        Cell leftTop;
        if (this.isMerged() && this != (leftTop = this.getLeftTopCorner())) {
            return ((Cell_)leftTop).getValueCount();
        }
        if (this.Bind != null) {
            return this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource()).getDataStore().getRowCount();
        }
        if (this.isFormula()) {
            if (!this.isValid) {
                String formula = this.Define.toString().trim();
                if (formula.startsWith("=")) {
                    formula = formula.substring(1, formula.length());
                }
                if (formula.equals("")) {
                    return 0;
                }
                this.formulaValue = this.Calculate(formula, -1);
                this.isValid = true;
            }
            if (this.formulaValue instanceof Vector) {
                return ((Vector)this.formulaValue).size();
            }
            return 1;
        }
        return 1;
    }

    @Override
    public Object getValue(int dbrow) {
        Cell leftTop;
        DataSourceConfig dsc;
        if (dbrow == -99) {
            if (this.Bind != null) {
                dsc = this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource());
                dbrow = this.Bind.getDataSourceType() == 1 ? (dsc.getDataStore().getRowCount() > 0 ? 0 : -1) : (this.Bind.getDataSourceType() == 4 ? dsc.getCurrentBindRow() : -1);
            } else {
                dbrow = -1;
            }
        }
        if (this.isMerged() && this != (leftTop = this.getLeftTopCorner())) {
            return leftTop.getValue(dbrow);
        }
        if (!(this.Bind == null || this.isFormula() && dbrow < 0 || this.isFormulaContained() && dbrow < 0)) {
            dsc = this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource());
            String dbcol = this.Bind.getDBCol();
            if (dsc != null) {
                DataStore ds = dsc.getDataStore();
                if (this.Bind.getDataSourceType() == 1) {
                    if (ds.getRowCount() == 1) {
                        Object v = ds.getValue(0, dbcol);
                        return v;
                    }
                    return null;
                }
                if (this.Bind.getDataSourceType() == 4) {
                    dbrow = dsc.getCurrentBindRow();
                    if (dbrow >= 0) {
                        Object v = ds.getValue(dbrow, dbcol);
                        return v;
                    }
                    return null;
                }
                if (dbrow >= 0) {
                    if (dbrow < ds.getRowCount()) {
                        Object v = ds.getValue(dbrow, dbcol);
                        return v;
                    }
                    return null;
                }
                if (!this.Bind.getQuickFindByCol().equals("")) {
                    dbrow = ds.fastFind(this.Bind.getQuickFindByCol(), (Object)this.Bind.getQuickFindByValue());
                    if (dbrow < 0) {
                        return null;
                    }
                    Object v = ds.getValue(dbrow, dbcol);
                    return v;
                }
                Vector<Object> ret = new Vector<Object>();
                int row = 0;
                while (row < ds.getRowCount()) {
                    ret.add(ds.getValue(row, dbcol));
                    ++row;
                }
                return ret;
            }
        }
        if (this.isFormula()) {
            if (!this.isValid) {
                String formula = this.Define.toString().trim();
                if (formula.startsWith("=")) {
                    formula = formula.substring(1, formula.length());
                }
                if (formula.equals("")) {
                    return null;
                }
                this.formulaValue = this.Calculate(formula, -99);
                if (this.DependList != null || this.formulaNeedCache) {
                    this.isValid = true;
                }
            }
            if (this.formulaValue instanceof Vector) {
                if (dbrow >= ((Vector)this.formulaValue).size()) {
                    return null;
                }
                if (dbrow >= 0) {
                    return ((Vector)this.formulaValue).get(dbrow);
                }
                return this.formulaValue;
            }
            return this.formulaValue;
        }
        return this.Define;
    }

    @Override
    public String getValueString() {
        Object v = this.getValue();
        if (v == null) {
            return "";
        }
        try {
            return (String)ObjectTool.ChangeType((Object)v, (String)"java.lang.String");
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public int getValueInt() {
        Object v = this.getValue();
        if (v == null) {
            return 0;
        }
        try {
            return (Integer)ObjectTool.ChangeType((Object)v, (String)"java.lang.Integer");
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public boolean getValueBoolean() {
        Object v = this.getValue();
        if (v == null) {
            return false;
        }
        try {
            return (Boolean)ObjectTool.ChangeType((Object)v, (String)"java.lang.Boolean");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public double getValueDouble() {
        Object v = this.getValue();
        if (v == null) {
            return 0.0;
        }
        try {
            return (Double)ObjectTool.ChangeType((Object)v, (String)"java.lang.Double");
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public BigDecimal getValueNumber() {
        Object v = this.getValue();
        if (v == null) {
            return BigDecimal.valueOf(0L);
        }
        try {
            return (BigDecimal)ObjectTool.ChangeType((Object)v, (String)"java.math.BigDecimal");
        }
        catch (Exception e) {
            return BigDecimal.valueOf(0L);
        }
    }

    @Override
    public String getName() {
        if (this.pRow == null) {
            return this.getAlias();
        }
        int row = this.getRowIndex();
        int col = this.getColumnIndex();
        return String.valueOf(this.Sheet.getColumnPropertyManage().getColumnName(col)) + String.valueOf(row + 1);
    }

    @Override
    public String getShowText() {
        return this.getShowText(-1);
    }

    @Override
    public String getShowText(int row) {
        if (this.Sheet.isDesignMode() && this.Sheet.getWorkBook().isShowDefineIfInDesignMode() && (this.isFormula() || this.isFormulaContained())) {
            return this.getDefine();
        }
        Object v = this.getValue(row);
        if (Cell_.isFormulaContained(v)) {
            if (this.isValid) {
                return this.toFormatString(this.formulaValue);
            }
            String formula = v.toString().trim();
            if (formula.equals("")) {
                return null;
            }
            StringBuffer sb = new StringBuffer(formula);
            int p1 = sb.indexOf("{=");
            while (p1 >= 0) {
                int p2 = sb.indexOf("}", p1);
                if (p2 < 0) break;
                String sub = sb.substring(p1 + 2, p2);
                sb.delete(p1, p2 + 1);
                Object tv = this.Sheet.evaluate(sub);
                if (tv != null) {
                    sb.insert(p1, tv.toString());
                }
                p1 = sb.indexOf("{=");
            }
            this.formulaValue = sb.toString();
            this.isValid = true;
            return this.toFormatString(this.formulaValue);
        }
        return this.toFormatString(v);
    }

    public Object getShowTextForJEP(int row) {
        if (this.Sheet.isDesignMode() && this.Sheet.getWorkBook().isShowDefineIfInDesignMode() && (this.isFormula() || this.isFormulaContained())) {
            return this.getDefine();
        }
        Object v = this.getValue(row);
        if (Cell_.isFormulaContained(v)) {
            if (this.isValid) {
                return this.toFormatString(this.formulaValue);
            }
            String formula = v.toString().trim();
            if (formula.equals("")) {
                return null;
            }
            StringBuffer sb = new StringBuffer(formula);
            int p1 = sb.indexOf("{=");
            while (p1 >= 0) {
                int p2 = sb.indexOf("}", p1);
                if (p2 < 0) break;
                String sub = sb.substring(p1 + 2, p2);
                sb.delete(p1, p2 + 1);
                Object tv = this.Sheet.evaluate(sub);
                if (tv != null) {
                    sb.insert(p1, tv.toString());
                }
                p1 = sb.indexOf("{=");
            }
            this.formulaValue = sb.toString();
            this.isValid = true;
            return this.toFormatString(this.formulaValue);
        }
        if (v instanceof Vector) {
            Vector<String> retV = new Vector<String>();
            int i = 0;
            while (i < ((Vector)v).size()) {
                retV.add(this.toFormatString(((Vector)v).get(i)));
                ++i;
            }
            return retV;
        }
        return this.toFormatString(v);
    }

    private int $AutoHalign(int align) {
        if (align != 999) {
            return align;
        }
        if (this.ES == null) {
            return 0;
        }
        switch (this.ES.getEditType()) {
            case 1: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String toFormatString(Object v) {
        if (this.getViewAsPassword()) {
            return "***";
        }
        if (v != null && v instanceof String) {
            String s = (String)v;
            if (s.startsWith("$#{image}#$")) {
                return s;
            }
            if (s.startsWith("$#{urlimage}#$")) {
                return s;
            }
            if (s.startsWith("<url>")) {
                return s;
            }
        }
        if (this.ES == null) {
            if (v == null) {
                return "";
            }
            if (v instanceof String) {
                return (String)v;
            }
            if (this.numberViewScale == 1 || this.numberViewScale == 0) {
                if (v instanceof BigDecimal) {
                    return v.toString();
                }
                if (v instanceof Double) {
                    return m_DF.format(((Number)v).doubleValue());
                }
                if (v instanceof Float) {
                    return m_DF.format(((Number)v).doubleValue());
                }
            } else {
                if (v instanceof BigDecimal) {
                    return ((BigDecimal)v).divide(new BigDecimal(this.numberViewScale)).toString();
                }
                if (v instanceof Double) {
                    return m_DF.format(((Number)v).doubleValue() / (double)this.numberViewScale);
                }
                if (v instanceof Float) {
                    return m_DF.format(((Number)v).doubleValue() / (double)this.numberViewScale);
                }
            }
            return v.toString();
        }
        switch (this.ES.getEditType()) {
            case 0: {
                if (v == null) {
                    return "";
                }
                if (this.numberViewScale == 1 || this.numberViewScale == 0) {
                    if (v instanceof BigDecimal) {
                        return v.toString();
                    }
                    if (v instanceof Double) {
                        return m_DF.format(((Number)v).doubleValue());
                    }
                    if (v instanceof Float) {
                        return m_DF.format(((Number)v).doubleValue());
                    }
                } else {
                    if (v instanceof BigDecimal) {
                        return ((BigDecimal)v).divide(new BigDecimal(this.numberViewScale)).toString();
                    }
                    if (v instanceof Double) {
                        return m_DF.format(((Number)v).doubleValue() / (double)this.numberViewScale);
                    }
                    if (v instanceof Float) {
                        return m_DF.format(((Number)v).doubleValue() / (double)this.numberViewScale);
                    }
                }
                if (v instanceof Date) {
                    return m_SDF.format(v);
                }
                return v.toString();
            }
            case 2: {
                if (v == null) {
                    return "";
                }
                return v.toString();
            }
            case 1: {
                if (v == null) {
                    return "";
                }
                BigDecimal dv = null;
                try {
                    dv = new BigDecimal(v.toString());
                    if (this.numberViewScale > 1) {
                        dv = dv.divide(new BigDecimal(this.numberViewScale));
                    }
                }
                catch (Exception e) {
                    return v.toString();
                }
                int DecimalCount = this.ES.getDecimalCount();
                boolean ShowComma = this.ES.isShowComma();
                if (Round.round(dv.doubleValue(), DecimalCount) == 0.0 && (this.Editable ? !this.ES.isZeroVisibleWhenEditable() : !this.ES.isZeroVisibleWhenUneditable())) {
                    return "";
                }
                return NumericEdit.toString(dv.doubleValue(), NumericEdit.GetPattern(DecimalCount, '.', ShowComma, ','));
            }
            case 3: {
                if (v == null) {
                    return "";
                }
                Date dtv = null;
                try {
                    dtv = (Date)ObjectTool.ChangeType((Object)v, (String)"java.util.Date");
                }
                catch (Exception e) {
                    return v.toString();
                }
                String format = this.ES.getDatetimeFormat();
                return DatetimeEdit.Date2String(dtv, DatetimeEdit.convertMask(format));
            }
            case 5: {
                return this.ES.getCheckBoxTipText();
            }
            case 4: {
                if (v == null) {
                    return "";
                }
                if (this.ES.isShowRealData()) {
                    return v == null ? "" : v.toString();
                }
                Map map = this.ES.getDropDownData2ViewMap();
                if (map != null) {
                    if (this.ES.isListShowAsDropdownCheckBox()) {
                        String splitChar = ",";
                        String s = "";
                        if (v != null) {
                            s = v.toString();
                        }
                        String[] vs = s.split(splitChar);
                        StringBuffer sb = new StringBuffer();
                        int i = 0;
                        while (i < vs.length) {
                            Object tv;
                            if (map.containsKey(vs[i]) && (tv = map.get(vs[i])) != null) {
                                if (sb.length() > 0) {
                                    sb.append(splitChar);
                                }
                                sb.append(tv.toString());
                            }
                            ++i;
                        }
                        return sb.toString();
                    }
                    if (map.containsKey(v)) {
                        Object rets = map.get(v);
                        if (rets == null) {
                            return "";
                        }
                        return rets.toString();
                    }
                    if (v == null) {
                        return "";
                    }
                    String vs = v.toString();
                    for (Object key : map.keySet()) {
                        if (key == null || !key.toString().equals(vs)) continue;
                        Object rets = map.get(key);
                        if (rets == null) {
                            return "";
                        }
                        return rets.toString();
                    }
                }
                if (v == null) {
                    return "";
                }
                return v.toString();
            }
            case 7: {
                if (v == null) {
                    return "";
                }
                return v.toString();
            }
        }
        if (v == null) {
            return "";
        }
        return v.toString();
    }

    public String getEditText(int row) {
        if (this.Bind != null) {
            Object v = this.getValue(row);
            return this.toFormatString(v);
        }
        return this.getDefine();
    }

    public Object Calculate(String exp, int innerRow) {
        Object ret = null;
        JEP Jep = null;
        try {
            Jep = ((WorkBook_)this.Sheet.getWorkBook()).getIdleJEPInstance();
            Jep.attachWorkSheet(this.Sheet);
            Jep.setCellInnerRow(innerRow);
            Jep.attachCell(this);
            Jep.parseExpression(exp);
            Object object = ret = Jep.getValueAsObject();
            return object;
        }
        catch (Exception e) {
            System.out.println("\u516c\u5f0f\uff1a" + exp + "\r\n" + e.getMessage());
            return null;
        }
        finally {
            ((WorkBook_)this.Sheet.getWorkBook()).releaseJEPInstance(Jep);
        }
    }

    private static boolean isFormula(Object s) {
        if (s == null) {
            return false;
        }
        String t = s.toString().trim();
        return t.startsWith("=") && !t.startsWith("==");
    }

    private static boolean isFormulaContained(Object s) {
        if (s == null) {
            return false;
        }
        String t = s.toString().trim();
        StringBuffer sb = new StringBuffer(t);
        int p1 = sb.indexOf("{=");
        if (p1 < 0) {
            return false;
        }
        int p2 = sb.indexOf("}", p1);
        return p2 > p1;
    }

    private static boolean isVector(Object s) {
        if (s == null) {
            return false;
        }
        return s instanceof Vector;
    }

    private static Object ChangeType(Object value, int vt) {
        if (value == null) {
            return value;
        }
        if (value.toString().equals("")) {
            return null;
        }
        try {
            switch (vt) {
                case 99: {
                    return Cell_.AutoChangeType(value);
                }
                case 1: {
                    return ObjectTool.ChangeType((Object)value, (String)"java.lang.Long");
                }
                case 2: {
                    return ObjectTool.ChangeType((Object)value, (String)"java.math.BigDecimal");
                }
                case 4: {
                    return ObjectTool.ChangeType((Object)value, (String)"java.util.Date");
                }
            }
            return ObjectTool.ChangeType((Object)value, (String)"java.lang.String");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean ObjectEqual(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    @Override
    public void setValue(Object value) {
        this.setValue(value, -1);
    }

    @Override
    public void setValue(Object value, int dbRow) {
        Object oldValue;
        if (!(Cell_.isFormula(value) || Cell_.isFormulaContained(value) || Cell_.isVector(value))) {
            value = Cell_.ChangeType(value, this.VT);
        }
        if (dbRow < 0 ? Cell_.ObjectEqual(this.Define, value) : Cell_.ObjectEqual(oldValue = this.getValue(dbRow), value)) {
            return;
        }
        CommandScene scene = new CommandScene();
        scene.put("row", this.getRowIndex());
        scene.put("col", this.getColumnIndex());
        scene.put("cell", this);
        scene.put("value", value);
        scene.put("dbrow", dbRow);
        CMD_SetValue cmd = new CMD_SetValue(this.Sheet, scene);
        cmd.Execute();
    }

    @Override
    public int getColumnIndex() {
        if (this.pRow == null) {
            if (this.Sheet.ExpressionList == null) {
                return -1;
            }
            return this.Sheet.ExpressionList.indexOf(this);
        }
        return this.pRow.cells.indexOf(this);
    }

    @Override
    public int getRowIndex() {
        if (this.pRow == null) {
            return -9999;
        }
        return this.pRow.getRowIndex();
    }

    private boolean permitBackFill(DataStore ds, int row, String col) {
        if (!this.Sheet.isFormulaBackFillBindEnabled()) {
            return false;
        }
        if (this.isFormulaPriority()) {
            return true;
        }
        int state = ds.getPrimaryBuffer().getItemStatus(row, col);
        if (state == 1 || state == 0) {
            if (ds.getValue(row, col) == null) {
                return true;
            }
            return ds.getString(row, col).equals("");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValueToDS(Object value, int dbRow, boolean isBackFill) {
        if (this.Bind == null) {
            return;
        }
        DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource());
        boolean workBookInitOK = this.Sheet.getWorkBook().isInitOK();
        if (dsc == null) return;
        String dbcol = this.Bind.getDBCol();
        DataStore ds = dsc.getDataStore();
        if (this.Bind.getDataSourceType() == 1) {
            if (ds.getRowCount() != 1) return;
            if (!workBookInitOK && ds.getPrimaryBuffer().getItemStatus(0, dbcol) == 0) {
                return;
            }
            if (isBackFill && !this.permitBackFill(ds, 0, dbcol)) {
                return;
            }
            if (Cell_.isVector(value)) {
                Vector vec = (Vector)value;
                if (vec.size() <= 0) return;
                ds.setValue(0, dbcol, vec.get(0));
                return;
            } else {
                ds.setValue(0, dbcol, value);
            }
            return;
        } else if (this.Bind.getDataSourceType() == 4) {
            dbRow = dsc.getCurrentBindRow();
            if (dbRow < 0) return;
            if (!workBookInitOK && ds.getPrimaryBuffer().getItemStatus(dbRow, dbcol) == 0) {
                return;
            }
            if (isBackFill && !this.permitBackFill(ds, dbRow, dbcol)) {
                return;
            }
            if (Cell_.isVector(value)) {
                Vector vec = (Vector)value;
                if (vec.size() <= 0) return;
                ds.setValue(dbRow, dbcol, vec.get(dbRow));
                return;
            } else {
                ds.setValue(dbRow, dbcol, value);
            }
            return;
        } else {
            int row = dbRow;
            if (row >= 0 && row < ds.getRowCount()) {
                if (!workBookInitOK && ds.getPrimaryBuffer().getItemStatus(row, dbcol) == 0) {
                    return;
                }
                if (isBackFill && !this.permitBackFill(ds, row, dbcol)) {
                    return;
                }
                if (Cell_.isVector(value)) {
                    Vector vec = (Vector)value;
                    if (vec.size() <= 0) return;
                    ds.setValue(row, dbcol, vec.get(0));
                    return;
                } else {
                    ds.setValue(row, dbcol, value);
                }
                return;
            } else if (Cell_.isVector(value)) {
                Vector vec = (Vector)value;
                int RC = Math.min(vec.size(), ds.getRowCount());
                int i = 0;
                while (i < RC) {
                    if (!workBookInitOK && ds.getPrimaryBuffer().getItemStatus(i, dbcol) == 0) {
                        return;
                    }
                    if (!isBackFill || this.permitBackFill(ds, i, dbcol)) {
                        ds.setValue(i, dbcol, vec.get(i));
                    }
                    ++i;
                }
                return;
            } else {
                if (ds.getRowCount() <= 0) return;
                if (!workBookInitOK && ds.getPrimaryBuffer().getItemStatus(0, dbcol) == 0) {
                    return;
                }
                if (isBackFill && !this.permitBackFill(ds, 0, dbcol)) {
                    return;
                }
                ds.setValue(0, dbcol, value);
            }
        }
    }

    public void clearInternalImage() {
        if (this.internalImage == null) {
            return;
        }
        this.internalImage.flush();
        this.internalImage = null;
    }

    public boolean $setValue(Object value, int dbRow) {
        boolean accept = this.Sheet.getWorkBook().getEM().fireCellValueChangeAccept(this.Sheet, this, this.Define, value);
        if (!accept) {
            return false;
        }
        this.clearInternalImage();
        Object oldValue = this.Define;
        if (this.Bind != null && (dbRow >= 0 || Cell_.isVector(value))) {
            this.setValueToDS(value, dbRow, false);
        } else {
            if (!Cell_.isVector(value) && dbRow < 0) {
                this.Define = value;
            }
            this.ParseDependAffect();
            this.RebuildAffactOfMyDepend();
            this.setInvalid();
            this.NotifyAffectCellInvalid();
            this.Sheet.getWorkBook().getEM().fireCellValueChanged(this.Sheet, this, oldValue, this.Define, dbRow);
        }
        this.notifyChangedToSubscriber();
        return true;
    }

    private void notifyChangedToSubscriber() {
        if (this.subscribeList != null) {
            int n = this.subscribeList.size();
            int i = 0;
            while (i < n) {
                ((ChangeListener)this.subscribeList.get(i)).changed();
                ++i;
            }
        }
    }

    public void $FireSelfValueChanged(int innerRow) {
        WorkSheetView_ view;
        Edit edit;
        DataSourceConfig dsc;
        TimeMark tm = new TimeMark(false);
        tm.stamp(String.valueOf(this.getName()) + "    $FireSelfValueChanged  start ");
        this.clearInternalImage();
        if (this.Bind != null) {
            DataSourceConfig dsc2 = this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource());
            String dbcol = this.Bind.getDBCol();
            if (dsc2 != null) {
                DataStore ds = dsc2.getDataStore();
                DataBuffer primaryBuffer = ds.getPrimaryBuffer();
                boolean hadSetInvalid = false;
                int rc = ds.getRowCount();
                int i = rc - 1;
                while (i >= 0) {
                    int state = primaryBuffer.getItemStatus(i, dbcol);
                    if (state == 2) {
                        this.setInvalid();
                        hadSetInvalid = true;
                        break;
                    }
                    --i;
                }
                if (!hadSetInvalid) {
                    boolean allIsNull = true;
                    int i2 = 0;
                    while (i2 < ds.getRowCount()) {
                        if (ds.getValue(i2, dbcol) != null && !ds.getString(i2, dbcol).equals("")) {
                            allIsNull = false;
                        }
                        ++i2;
                    }
                    if (allIsNull) {
                        this.setInvalid();
                        hadSetInvalid = true;
                    }
                }
            }
        }
        tm.stamp("   setInvalid   ok ");
        this.NotifyAffectCellInvalid();
        tm.stamp("   NotifyAffectCellInvalid   ok ");
        Object newValue = null;
        if (this.Bind != null) {
            dsc = this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource());
            newValue = this.Bind.getDataSourceType() == 2 ? null : this.getValue();
        } else if (this.Bind.getDataSourceType() == 4) {
            dsc = this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource());
            newValue = this.getValue(dsc.getCurrentBindRow());
        } else {
            newValue = this.isFormula() || this.isFormulaContained() ? null : this.getValue();
        }
        this.Sheet.getWorkBook().getEM().fireCellValueChanged(this.Sheet, this, null, newValue, innerRow);
        tm.stamp("   fireCellValueChanged   ok ");
        if (this.isEditing() && (edit = (view = (WorkSheetView_)this.Sheet.getWorkSheetView()).$getCurrentEditingEdit()) != null) {
            edit.reloadEdit();
        }
        tm.stamp("   reloadEdit   ok ");
        this.notifyChangedToSubscriber();
        tm.stamp("   notifyChangedToSubscriber   ok  ===========");
    }

    private void ParseDependAffect() {
        String exp = "";
        if (this.Define != null) {
            exp = this.Define.toString();
        }
        this.ClearDepend();
        boolean isF = Cell_.isFormula(exp);
        boolean isFC = Cell_.isFormulaContained(exp);
        if (!isF && !isFC) {
            return;
        }
        ArrayList<String> formulaList = new ArrayList<String>();
        if (isF) {
            if (exp.startsWith("=")) {
                exp = exp.substring(1, exp.length());
            }
            formulaList.add(exp);
        }
        if (isFC) {
            StringBuffer sb = new StringBuffer(exp);
            int p1 = sb.indexOf("{=");
            while (p1 >= 0) {
                int p2 = sb.indexOf("}", p1);
                if (p2 < 0) break;
                String sub = sb.substring(p1 + 2, p2);
                Tools.log(" \u5b50\u516c\u5f0f\uff1a " + sub);
                sub = sub.replaceAll("&lt;", "<");
                sub = sub.replaceAll("&gt;", ">");
                sub = sub.replaceAll("&nbsp;", " ");
                sub = sub.replaceAll("&quot;", "\"");
                Tools.log(" \u5b50\u516c\u5f0f\uff1a " + sub);
                formulaList.add(sub);
                p1 = sb.indexOf("{=", p2);
            }
        }
        Property prop = this.getProperty();
        String font_color_expression = prop.get("font-color-expression", "").trim();
        String background_color_expression = prop.get("background-color-expression", "").trim();
        String display_expression = prop.get("display-expression", "").trim();
        int fi = 0;
        while (fi < formulaList.size()) {
            block16: {
                String formula = (String)formulaList.get(fi);
                JEP jep = null;
                try {
                    try {
                        jep = ((WorkBook_)this.Sheet.getWorkBook()).getIdleJEPInstance();
                        jep.attachWorkSheet(this.Sheet);
                        jep.attachCell(this);
                        jep.parseExpression(formula);
                        SimpleNode node = (SimpleNode)jep.getTopNode();
                        if (node == null) {
                            System.out.println(String.valueOf(this.getName()) + "\u516c\u5f0f\u9519\u8bef\uff1a" + formula + " \u9519\u8bef\u539f\u56e0\uff1a" + jep.getErrorInfo());
                        }
                        this.ParseDependAffect(node);
                    }
                    catch (Exception e) {
                        System.out.println(" Cell_.ParseDependAffect \u53d1\u751f\u9519\u8bef:\u5355\u5143\u683c" + this.getName() + "\u516c\u5f0f\uff1a" + formula + " \u9519\u8bef\u539f\u56e0\uff1a  " + e.getMessage());
                        if (jep != null) {
                            ((WorkBook_)this.Sheet.getWorkBook()).releaseJEPInstance(jep);
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (jep != null) {
                        ((WorkBook_)this.Sheet.getWorkBook()).releaseJEPInstance(jep);
                    }
                    throw throwable;
                }
                if (jep != null) {
                    ((WorkBook_)this.Sheet.getWorkBook()).releaseJEPInstance(jep);
                }
            }
            ++fi;
        }
    }

    private void ParseDependAffect(SimpleNode node) {
        Range range = null;
        String SheetGuid = null;
        String SheetName = null;
        Depend da = null;
        RowCol rc = null;
        ASTVarNode var = null;
        String varName = "";
        if (node instanceof ASTVarNode) {
            var = (ASTVarNode)node;
            varName = var.getName();
            switch (var.getToken().kind) {
                case 10: 
                case 11: {
                    rc = this.Sheet.cellNameToRowColumn(var.getOriginName());
                    range = new Range_(rc.row, rc.col, rc.row, rc.col);
                    break;
                }
                case 12: {
                    range = this.Sheet.rangeNameToRange(varName);
                    break;
                }
                case 13: {
                    int p = varName.indexOf("!");
                    if (p <= 0) break;
                    SheetName = varName.substring(0, p).trim();
                    WorkSheet_ otherSheet = (WorkSheet_)this.Sheet.getWorkBook().getWorkSheet(SheetName);
                    if (otherSheet == null) {
                        this.Sheet.getWorkBook().getEM().fireError("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + SheetName + "]\u4e0d\u5b58\u5728");
                        break;
                    }
                    rc = otherSheet.cellNameToRowColumn(varName.substring(p + 1, varName.length()));
                    range = new Range_(rc.row, rc.col, rc.row, rc.col);
                    break;
                }
                case 15: {
                    int p = varName.indexOf("!");
                    if (p <= 0) break;
                    SheetName = varName.substring(0, p).trim();
                    WorkSheet_ otherSheet = (WorkSheet_)this.Sheet.getWorkBook().getWorkSheet(SheetName);
                    if (otherSheet == null) {
                        this.Sheet.getWorkBook().getEM().fireError("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + SheetName + "]\u4e0d\u5b58\u5728");
                        break;
                    }
                    rc = otherSheet.cellNameToRowColumn(varName.substring(p + 1, varName.length()));
                    range = new Range_(rc.row, rc.col, rc.row, rc.col);
                    break;
                }
                case 14: {
                    int p = varName.indexOf("!");
                    if (p <= 0) break;
                    SheetName = varName.substring(0, p).trim();
                    WorkSheet_ otherSheet = (WorkSheet_)this.Sheet.getWorkBook().getWorkSheet(SheetName);
                    if (otherSheet == null) {
                        this.Sheet.getWorkBook().getEM().fireError("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + SheetName + "]\u4e0d\u5b58\u5728");
                        break;
                    }
                    range = otherSheet.rangeNameToRange(varName.substring(p + 1, varName.length()));
                }
            }
        }
        if (range != null) {
            if (range.getStartCol() < 0 || range.getEndCol() < 0) {
                Tools.log(String.valueOf(varName) + "\u4e0d\u662f\u5408\u6cd5\u7684\u5355\u5143\u683c\u540d\u6216\u522b\u540d");
            } else {
                SheetGuid = this.Sheet.getGUID();
                if (SheetName != null) {
                    WorkSheet sheet = this.Sheet.getWorkBook().getWorkSheet(SheetName);
                    if (sheet == null) {
                        this.Sheet.getWorkBook().getEM().fireError("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + SheetName + "]\u4e0d\u5b58\u5728");
                    } else {
                        SheetGuid = sheet.getGUID();
                    }
                }
                MergedRange_ mr = new MergedRange_(this.Sheet.getWorkBook().getWorkSheetByGuid(SheetGuid), range);
                da = new Depend(SheetGuid, mr, var);
                if (this.DependList == null) {
                    this.DependList = new ArrayList();
                }
                this.DependList.add(da);
            }
        }
        int cc = node.jjtGetNumChildren();
        int i = 0;
        while (i < cc) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            this.ParseDependAffect(child);
            ++i;
        }
    }

    private void ClearDepend() {
        if (this.DependList == null) {
            return;
        }
        int di = 0;
        while (di < this.DependList.size()) {
            Depend da = (Depend)this.DependList.get(di);
            WorkSheet sheet = this.Sheet;
            sheet = this.Sheet.getWorkBook().getWorkSheetByGuid(da.SheetGuid);
            if (sheet != null) {
                Range range = da.range.getMergedRange();
                String thisSheetGuid = this.Sheet.getGUID();
                int row = range.getStartRow();
                while (row <= range.getEndRow()) {
                    int col = range.getStartCol();
                    while (col <= range.getEndCol()) {
                        Cell_ cell = (Cell_)sheet.Cells(row, col);
                        if (cell != null) {
                            cell.RemoveAffect(new Affect(thisSheetGuid, cell, da.dependShowText));
                        }
                        ++col;
                    }
                    ++row;
                }
            }
            ++di;
        }
        this.DependList.clear();
        this.DependList = null;
    }

    private void RebuildAffactOfMyDepend() {
        if (this.DependList == null) {
            return;
        }
        int di = 0;
        while (di < this.DependList.size()) {
            Depend da = (Depend)this.DependList.get(di);
            WorkSheet sheet = this.Sheet;
            sheet = this.Sheet.getWorkBook().getWorkSheetByGuid(da.SheetGuid);
            if (sheet == null) {
                System.out.println("\u91cd\u5efa\u5f71\u54cd\u5173\u7cfb\u65f6\u6307\u5b9a\u7684[" + da.SheetGuid + "] \u4e0d\u5b58\u5728");
            } else {
                String thisSheetGuid = this.Sheet.getGUID();
                Range range = da.range.getMergedRange();
                if (range != null) {
                    int row = range.getStartRow();
                    while (row <= range.getEndRow()) {
                        int col = range.getStartCol();
                        while (col <= range.getEndCol()) {
                            Cell_ cell = (Cell_)((WorkSheet_)sheet).Cells(row, col);
                            if (cell != null) {
                                cell.AddAffect(new Affect(thisSheetGuid, this, da.dependShowText));
                            }
                            ++col;
                        }
                        ++row;
                    }
                }
            }
            ++di;
        }
    }

    @Override
    public void redefine(int rowOffset, int colOffset) {
        this.redefine(rowOffset, colOffset, -1, -1);
    }

    @Override
    public void redefine(int rowOffset, int colOffset, int afterRow, int afterCol) {
        if (!this.isFormula()) {
            return;
        }
        if (this.DependList == null) {
            return;
        }
        TreeMap<Integer, ASTVarNode> change = new TreeMap<Integer, ASTVarNode>();
        int di = 0;
        while (di < this.DependList.size()) {
            Depend da = (Depend)this.DependList.get(di);
            WorkSheet sheet = this.Sheet.getWorkBook().getWorkSheetByGuid(da.SheetGuid);
            if (sheet == null) {
                System.out.println("\u5728\u91cd\u5efa\u5b9a\u4e49\u65f6[" + da.SheetGuid + "] \u4e0d\u5b58\u5728");
            } else if (sheet == this.Sheet) {
                ASTVarNode var = da.node;
                int varKind = var.getToken().kind;
                if (varKind == 11 || varKind == 10) {
                    String $ = da.dependShowText ? "$" : "";
                    RowCol rc = da.rcStart();
                    int newRow = rc.row + (rc.row > afterRow ? rowOffset : 0);
                    int newCol = rc.col + (rc.col > afterCol ? colOffset : 0);
                    String newName = ZExcel.rowColToName(newRow, newCol);
                    var.setName(String.valueOf($) + newName);
                    change.put(new Integer(var.getToken().beginColumn), var);
                }
            }
            ++di;
        }
        if (change.size() == 0) {
            return;
        }
        String exp = this.Define.toString().trim();
        if (exp.startsWith("=")) {
            exp = exp.substring(1, exp.length());
        }
        StringBuffer newDefine = new StringBuffer(exp);
        ArrayList<ASTVarNode> varList = new ArrayList<ASTVarNode>();
        for (ASTVarNode var : change.values()) {
            varList.add(var);
        }
        int varCount = varList.size();
        int i = varCount - 1;
        while (i >= 0) {
            ASTVarNode var = (ASTVarNode)varList.get(i);
            int bc = var.getToken().beginColumn - 1;
            int ec = var.getToken().endColumn;
            newDefine.replace(bc, ec, var.getName());
            --i;
        }
        newDefine.insert(0, "=");
        this.setValue(newDefine.toString());
    }

    @Override
    public void redefineReplace(String cellName, String replaceToName) {
        if (!this.isFormula()) {
            return;
        }
        if (this.DependList == null) {
            return;
        }
        TreeMap<Integer, ASTVarNode> change = new TreeMap<Integer, ASTVarNode>();
        RowCol rc2 = this.Sheet.cellNameToRowColumn(cellName);
        int di = 0;
        while (di < this.DependList.size()) {
            Depend da = (Depend)this.DependList.get(di);
            WorkSheet sheet = this.Sheet.getWorkBook().getWorkSheetByGuid(da.SheetGuid);
            if (sheet == null) {
                System.out.println("\u5728\u91cd\u5efa\u5b9a\u4e49\u65f6[" + da.SheetGuid + "] \u4e0d\u5b58\u5728");
            } else if (sheet == this.Sheet) {
                ASTVarNode var = da.node;
                int varKind = var.getToken().kind;
                if (varKind == 11 || varKind == 10) {
                    String varName = var.getName();
                    RowCol rc = da.rcStart();
                    if (rc.equals(rc2)) {
                        var.setName(replaceToName);
                        change.put(new Integer(var.getToken().beginColumn), var);
                    }
                }
            }
            ++di;
        }
        if (change.size() == 0) {
            return;
        }
        String exp = this.Define.toString().trim();
        if (exp.startsWith("=")) {
            exp = exp.substring(1, exp.length());
        }
        StringBuffer newDefine = new StringBuffer(exp);
        ArrayList<ASTVarNode> varList = new ArrayList<ASTVarNode>();
        for (ASTVarNode var : change.values()) {
            varList.add(var);
        }
        int varCount = varList.size();
        int i = varCount - 1;
        while (i >= 0) {
            ASTVarNode var = (ASTVarNode)varList.get(i);
            int bc = var.getToken().beginColumn - 1;
            int ec = var.getToken().endColumn;
            newDefine.replace(bc, ec, var.getName());
            --i;
        }
        newDefine.insert(0, "=");
        this.setValue(newDefine.toString());
    }

    /*
     * Unable to fully structure code
     */
    public void RebuildDefine(WorkSheet trigger, RedefineBecause because) {
        if (!this.isFormula()) {
            return;
        }
        if (this.DependList == null) {
            return;
        }
        change = new TreeMap<Integer, ASTVarNode>();
        di = 0;
        while (di < this.DependList.size()) {
            da = (Depend)this.DependList.get(di);
            sheet = this.Sheet.getWorkBook().getWorkSheetByGuid(da.SheetGuid);
            if (sheet != null) ** GOTO lbl15
            if (because.Why() != 6) {
                System.out.println("\u5728\u91cd\u5efa\u5b9a\u4e49\u65f6[" + da.SheetGuid + "] \u4e0d\u5b58\u5728");
            } else {
                sheet = trigger;
lbl15:
                // 2 sources

                if (sheet == trigger) {
                    var = da.node;
                    varKind = var.getToken().kind;
                    varName = var.getName();
                    v0 = $ = da.dependShowText != false ? "$" : "";
                    if (because.Why() == 5 && (varKind == 13 || varKind == 14)) {
                        newName = var.getName();
                        p = newName.indexOf("!");
                        newName = String.valueOf(sheet.getName()) + newName.substring(p, newName.length());
                        var.setName(newName);
                        change.put(new Integer(var.getToken().beginColumn), var);
                    } else if (because.Why() == 6 && (varKind == 13 || varKind == 14)) {
                        newName = var.getName();
                        newName = "\"" + newName + "\u4e0d\u5b58\u5728\"";
                        var.setName(newName);
                        change.put(new Integer(var.getToken().beginColumn), var);
                    } else {
                        switch (varKind) {
                            case 10: 
                            case 11: 
                            case 13: {
                                newRow = da.range.getMergeStart().getRowIndex();
                                newCol = da.range.getMergeStart().getColumnIndex();
                                newRC = new RowCol(newRow, newCol);
                                if (newRC.equals(da.rcStart())) break;
                                if (newRow == -1 || newCol == -1) {
                                    newName = "0";
                                } else {
                                    newName = ZExcel.rowColToName(newRow, newCol);
                                    if (varKind == 13) {
                                        newName = String.valueOf(sheet.getName()) + "!" + newName;
                                    }
                                    if (varName.equalsIgnoreCase(sheet.cells(newName).getAlias())) {
                                        newName = varName;
                                    }
                                }
                                var.setName(String.valueOf($) + newName);
                                change.put(new Integer(var.getToken().beginColumn), var);
                                break;
                            }
                            case 12: 
                            case 14: {
                                newStartRow = da.range.getMergeStart().getRowIndex();
                                newStartCol = da.range.getMergeStart().getColumnIndex();
                                newEndRow = da.range.getMergeEnd().getRowIndex();
                                newEndCol = da.range.getMergeEnd().getColumnIndex();
                                newStartRC = new RowCol(newStartRow, newStartCol);
                                newEndRC = new RowCol(newEndRow, newEndCol);
                                if (newStartRC.equals(da.rcStart()) && newEndRC.equals(da.rcEnd())) break;
                                if (newStartRow == -1) {
                                    newStartRow = da.rcStart().row;
                                }
                                if (newStartCol == -1) {
                                    newStartCol = da.rcStart().col;
                                }
                                if (newEndRow == -1) {
                                    newEndRow = because.getRange().getStartRow() - 1;
                                }
                                if (newEndCol == -1) {
                                    newEndCol = because.getRange().getStartCol() - 1;
                                }
                                if (newStartRow > newEndRow || newStartCol > newEndCol) {
                                    newRangeName = "0";
                                } else {
                                    newRangeName = String.valueOf(ZExcel.rowColToName(newStartRow, newStartCol)) + ":" + ZExcel.rowColToName(newEndRow, newEndCol);
                                    if (varKind == 14) {
                                        newRangeName = String.valueOf(sheet.getName()) + "!" + newRangeName;
                                    }
                                }
                                var.setName(newRangeName);
                                change.put(new Integer(var.getToken().beginColumn), var);
                            }
                        }
                    }
                }
            }
            ++di;
        }
        if (change.size() == 0) {
            return;
        }
        exp = this.Define.toString().trim();
        if (exp.startsWith("=")) {
            exp = exp.substring(1, exp.length());
        }
        newDefine = new StringBuffer(exp);
        varList = new ArrayList<ASTVarNode>();
        for (ASTVarNode var : change.values()) {
            varList.add(var);
        }
        varCount = varList.size();
        i = varCount - 1;
        while (i >= 0) {
            var = (ASTVarNode)varList.get(i);
            bc = var.getToken().beginColumn - 1;
            ec = var.getToken().endColumn;
            newDefine.replace(bc, ec, var.getName());
            --i;
        }
        newDefine.insert(0, "=");
        this.setValue(newDefine.toString());
    }

    public void AddAffect(Affect affect) {
        if (this.AffectList == null) {
            this.AffectList = new ArrayList();
        }
        if (this.AffectList.contains(affect)) {
            return;
        }
        this.AffectList.add(affect);
    }

    public void RemoveAffect(Affect affect) {
        if (this.AffectList == null) {
            return;
        }
        if (!this.AffectList.contains(affect)) {
            return;
        }
        this.AffectList.remove(affect);
    }

    public static Object AutoChangeType(Object v) {
        RE r2;
        if (v == null) {
            return v;
        }
        String s = v.toString().trim();
        try {
            r2 = new RE("[+-]?[0-9]+");
            if (r2.match(s, 0) && s.length() <= 18 && r2.getParenStart(0) == 0 && r2.getParenEnd(0) == s.length()) {
                return new Long(s);
            }
        }
        catch (Exception r2) {
            // empty catch block
        }
        try {
            s = s.replaceAll(",", "");
            r2 = new RE("[+-]?[0-9]+\\.[0-9]*");
            if (r2.match(s, 0) && r2.getParenStart(0) == 0 && r2.getParenEnd(0) == s.length()) {
                return new BigDecimal(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public void setPoperty(String propertyName, boolean propertyValue) {
        this.setProperty(propertyName, propertyValue);
    }

    public void setPoperty(String propertyName, int propertyValue) {
        this.setProperty(propertyName, new Integer(propertyValue));
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        if (propertyName == null) {
            return;
        }
        Object oldPropertyValue = null;
        if (this.property != null) {
            oldPropertyValue = this.property.get(propertyName, (Object)null);
        }
        if (propertyValue == null && oldPropertyValue == null) {
            return;
        }
        if (propertyValue != null && oldPropertyValue != null && propertyValue.equals(oldPropertyValue)) {
            return;
        }
        CommandScene scene = new CommandScene();
        scene.put("row", this.getRowIndex());
        scene.put("col", this.getColumnIndex());
        scene.put("cell", this);
        scene.put("propertyname", propertyName);
        scene.put("propertyvalue", propertyValue);
        scene.put("oldpropertyvalue", oldPropertyValue);
        CMD_SetProperty cmd = new CMD_SetProperty(this.Sheet, scene);
        cmd.Execute();
    }

    @Override
    public void setProperty(Property newProperty) {
        if (this.property == newProperty) {
            return;
        }
        if (this.property != null) {
            PropertyManage PM = ((WorkBook_)this.Sheet.getWorkBook()).getPropertyManage();
            this.property.ReleaseRef();
            if (this.property.getRefCount() == 0) {
                PM.Remove(this.property);
            }
        }
        newProperty.AddRef();
        this.property = (Property_)newProperty;
    }

    public boolean $setProperty(String propertyName, int propertyValue) {
        return this.$setProperty(propertyName, new Integer(propertyValue));
    }

    public boolean $setProperty(String propertyName, Object propertyValue) {
        String t;
        Cell_ ce;
        Property_ tempProp;
        PropertyManage PM = ((WorkBook_)this.Sheet.getWorkBook()).getPropertyManage();
        Object oldPropertyValue = null;
        if (this.property != null) {
            oldPropertyValue = this.property.get(propertyName, (Object)null);
            if (propertyValue == null && oldPropertyValue == null) {
                return false;
            }
            if (propertyValue != null && oldPropertyValue != null && propertyValue.equals(oldPropertyValue)) {
                return false;
            }
            tempProp = (Property_)this.property.clone();
            this.property.ReleaseRef();
            if (this.property.getRefCount() == 0) {
                PM.Remove(this.property);
            }
        } else {
            tempProp = new Property_();
        }
        tempProp.put(propertyName, propertyValue);
        Property p = PM.FindProperty(tempProp);
        if (p == null) {
            PM.Add(tempProp);
            this.property = tempProp;
            this.property.AddRef();
        } else {
            this.property = (Property_)p;
            this.property.AddRef();
        }
        this.Sheet.getWorkBook().getEM().fireCellPropertyChanged(this.Sheet, this, propertyName, oldPropertyValue, propertyValue);
        if ((propertyName.equals("display-expression") || propertyName.equals("font-color-expression") || propertyName.equals("background-color-expression")) && (ce = (Cell_)this.Sheet.getExpression(t = propertyValue.toString())) != null) {
            ce.AddAffect(new Affect(this.Sheet.getGUID(), this, false));
        }
        return true;
    }

    @Override
    public Property getProperty() {
        if (this.property == null) {
            return Property_.defaultProperty;
        }
        return this.property;
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        return this.getPropertyValue(propertyName, null);
    }

    @Override
    public Object getPropertyValue(String propertyName, Object defaultValue) {
        Object _defaultValue = Property_.defaultProperty.get(propertyName, (Object)null);
        if (_defaultValue == null) {
            _defaultValue = defaultValue;
        }
        if (this.property == null) {
            return _defaultValue;
        }
        Object v = this.property.get(propertyName, _defaultValue);
        if (v == null) {
            v = _defaultValue;
        }
        if (v == null) {
            return null;
        }
        try {
            v = ObjectTool.ChangeType((Object)v, (String)_defaultValue.getClass().getName());
        }
        catch (Exception e) {
            v = defaultValue;
        }
        return v;
    }

    @Override
    public boolean isPropertyDefault(String propertyName) {
        Object defaultValue = Property_.defaultProperty.get(propertyName, (Object)null);
        Object v = this.getPropertyValue(propertyName, defaultValue);
        if (v == null) {
            return true;
        }
        return v.equals(defaultValue);
    }

    @Override
    public String getDefine() {
        if (this.Define == null) {
            return "";
        }
        return this.Define.toString();
    }

    @Override
    public int getCellValueType() {
        return this.VT;
    }

    @Override
    public void setCellValueType(int vt) {
        if (this.VT == vt) {
            return;
        }
        this.VT = vt;
    }

    public boolean isFormula() {
        return Cell_.isFormula(this.Define);
    }

    public boolean isFormulaContained() {
        return Cell_.isFormulaContained(this.Define);
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setInvalid() {
        this.setInvalid(false);
    }

    public void setInvalid(boolean onlySetState) {
        if (!this.isFormula() && !this.isFormulaContained()) {
            this.repaint();
            return;
        }
        this.isValid = false;
        this.internalImage = null;
        if (!onlySetState) {
            this.Sheet.getWorkBook().getEM().fireCellNeedRecalculate(this.Sheet, this);
        }
    }

    @Override
    public void NotifyAffectCellInvalidWhenMyEditStyleChanged() {
        this.NotifyAffectCellInvalid(true);
    }

    @Override
    public void NotifyAffectCellInvalid() {
        this.NotifyAffectCellInvalid(false);
    }

    private void NotifyAffectCellInvalid(boolean becauseOfEditStyleChanged) {
        ArrayList already = new ArrayList();
        this.NotifyAffectCellInvalid(already, true, becauseOfEditStyleChanged);
        already.clear();
        this.NotifyAffectCellInvalid(already, false, becauseOfEditStyleChanged);
        already.clear();
        already = null;
    }

    public void NotifyAffectCellInvalid(ArrayList already, boolean onlySetState, boolean becauseOfEditStyleChanged) {
        if (this.AffectList == null) {
            return;
        }
        int ai = 0;
        while (ai < this.AffectList.size()) {
            Affect affect = (Affect)this.AffectList.get(ai);
            if (!(becauseOfEditStyleChanged && !affect.editStyleChangeWillAffect || already.contains(affect))) {
                already.add(affect);
                WorkSheet sheet = this.Sheet;
                sheet = this.Sheet.getWorkBook().getWorkSheetByGuid(affect.SheetGuid);
                if (sheet == null) {
                    System.out.println("\u5728NotifyAffectCellInvalid\u6307\u5b9a\u7684[" + affect.SheetGuid + "] \u4e0d\u5b58\u5728");
                } else {
                    Cell_ cell = (Cell_)affect.cell;
                    if (cell != null) {
                        cell.setInvalid(onlySetState);
                        cell.NotifyAffectCellInvalid(already, onlySetState, becauseOfEditStyleChanged);
                    }
                }
            }
            ++ai;
        }
    }

    public void backFill() {
        if (this.isFormula()) {
            int innerRow = -1;
            Object value = this.getValue(innerRow);
            this.setValueToDS(value, -1, true);
        }
    }

    @Override
    public Range getMergedRange() {
        if (!this.Sheet.getMergeMap().containsKey(this)) {
            return null;
        }
        return ((MergedRange)this.Sheet.getMergeMap().get(this)).getMergedRange();
    }

    @Override
    public Cell mergedBy() {
        if (!this.isMerged()) {
            return null;
        }
        Range r = this.getMergedRange();
        return this.Sheet.Cells(r.getStartRow(), r.getStartCol());
    }

    @Override
    public boolean isMerged() {
        return this.Sheet.getMergeMap().containsKey(this);
    }

    @Override
    public void repaint() {
        WorkSheetView_ view = (WorkSheetView_)this.Sheet.getWorkSheetView();
        if (view == null) {
            return;
        }
        Rectangle rc = view.getShowRectangleOfCell(false, this.getRowIndex(), this.getColumnIndex());
        int delta = 5;
        rc.x -= delta;
        rc.y -= delta;
        rc.width += 2 * delta;
        rc.height += 2 * delta;
        view.repaint(rc);
    }

    public void repaintRowHead() {
        WorkSheetView_ view = (WorkSheetView_)this.Sheet.getWorkSheetView();
        if (view == null) {
            return;
        }
        Rectangle rc = view.getShowRectangleOfCell(false, this.getRowIndex(), this.getColumnIndex());
        rc.x = 0;
        rc.width = this.Sheet.getRowPropertyManage().getRowHeadWidth();
        view.repaint(rc);
    }

    public void repaintAffect() {
        if (this.AffectList == null) {
            return;
        }
        ArrayList<Cell_> already = new ArrayList<Cell_>();
        this.repaintAffect(already);
    }

    public void repaintAffect(ArrayList<Cell_> already) {
        if (this.AffectList == null) {
            return;
        }
        int ai = 0;
        while (ai < this.AffectList.size()) {
            Affect affect = (Affect)this.AffectList.get(ai);
            Cell_ cell = (Cell_)affect.cell;
            cell.repaint();
            if (!already.contains(cell)) {
                already.add(cell);
                cell.repaintAffect(already);
                cell.repaintRowHead();
            }
            ++ai;
        }
    }

    @Override
    public DBBindConfig getBind() {
        return this.Bind;
    }

    @Override
    public boolean setBind(DBBindConfig config) {
        if (config == null) {
            this.clearBind();
            return true;
        }
        return this.setBind(config.getDataSource(), config.getDBCol());
    }

    @Override
    public boolean setBind(String DataSource, String dbCol) {
        DataSourceConfig dsc;
        if (DataSource == null) {
            DataSource = "";
        }
        if (dbCol == null) {
            dbCol = "";
        }
        if ((dsc = this.Sheet.getWorkBook().getDataSource(DataSource)) == null) {
            return this.setBind(DataSource, dbCol, 1);
        }
        return this.setBind(DataSource, dbCol, dsc.getDataSourceType());
    }

    @Override
    public boolean setBind(String DataSource, String dbCol, int dsType) {
        this.clearBind();
        if (DataSource == null) {
            return false;
        }
        if (dbCol == null) {
            return false;
        }
        WorkBook_ book = (WorkBook_)this.Sheet.getWorkBook();
        DataSourceConfig dsc = book.getDataSource(DataSource);
        if (dsc == null) {
            this.Bind = null;
            return false;
        }
        DataSource = DataSource.toLowerCase().trim();
        this.Bind = new DBBindConfig_(book, DataSource, dbCol, dsType);
        ColumnProperty CP = dsc.getDataStore().getColumnProperty(this.Bind.getDBCol());
        if (CP == null) {
            this.Bind = null;
            return false;
        }
        this.VT = CP.getUniformDataType();
        DataStoreEventAdapter dsa = (DataStoreEventAdapter)dsc.getDataStore().getEvent().findListener(DataSource);
        dsa.RegisterCell(this);
        this.Sheet.getRowPropertyManage().AddBindCount(this.getRowIndex());
        return true;
    }

    public String getAppropriateFontName() {
        int type = this.getCellValueType();
        if (type == 99 && this.Bind != null) {
            DataStore ds = this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource()).getDataStore();
            type = ds.getColumnProperty(this.Bind.getDBCol()).getUniformDataType();
        }
        if (this.ES != null && this.ES.getEditType() != 2) {
            type = 99;
        }
        switch (type) {
            case 1: 
            case 2: {
                return "Times New Roman";
            }
        }
        return "\u5b8b\u4f53";
    }

    @Override
    public void clearBind() {
        if (this.Bind == null) {
            return;
        }
        WorkBook_ book = (WorkBook_)this.Sheet.getWorkBook();
        DataSourceConfig dsc = book.getDataSource(this.Bind.getDataSource());
        if (dsc == null) {
            this.Bind = null;
            return;
        }
        DataStoreEventAdapter dsa = (DataStoreEventAdapter)dsc.getDataStore().getEvent().findListener(this.Bind.getDataSource());
        dsa.UnRegisterCell(this);
        this.Sheet.getRowPropertyManage().ReleaseBindCount(this.getRowIndex());
        this.Bind = null;
    }

    public void $ResetContainerColumnWidth() {
    }

    public Point getShowTextMaxHeight() {
        int dbrh;
        Point ret = new Point();
        int row = this.getRowIndex();
        RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
        int mrc = RPM.getMaxDBRowCount(row);
        ret.x = dbrh = RPM.getDBRowHeight(row);
        ret.y = RPM.getRowHeight(row);
        int c = this.getValueCount();
        Property prop = this.getProperty();
        WorkSheetView_ view = (WorkSheetView_)this.Sheet.getWorkSheetView();
        if (view == null) {
            return ret;
        }
        Rectangle textRect = view.getShowRectangleOfCell(false, this.getRowIndex(), this.getColumnIndex());
        textRect.width = textRect.width - 2 - prop.get("padding-left", 1) - prop.get("padding-right", 1);
        int padding = 4 + prop.get("padding-top", 1) + prop.get("padding-bottom", 1);
        String font_name = prop.get("font-name", "\u5b8b\u4f53");
        if (font_name.equals("\u81ea\u52a8")) {
            font_name = this.getAppropriateFontName();
        }
        int font_size = prop.get("font-size", 12);
        boolean font_bold = prop.get("font-bold", false);
        boolean font_italic = prop.get("font-italic", false);
        boolean font_underline = prop.get("font-underline", false);
        Graphics2D g = (Graphics2D)view.getGraphics();
        int textHeight = 21;
        int i = 0;
        while (i < c) {
            String t = this.getShowText(i);
            int th = (int)Tools.MultiLineTextHeight(g, textRect.width, t, font_name, font_size, font_bold, font_italic, font_underline);
            textHeight = Math.max(textHeight, th + padding);
            ++i;
        }
        ret.x = textHeight;
        ret.y = mrc * textHeight;
        g.dispose();
        return ret;
    }

    public void $ResetContainerRowHeight() {
        boolean autoResetHeight;
        boolean autoFitTextHeight = this.getProperty().get("auto-fit-height", false);
        boolean bl = autoResetHeight = !this.isMerged();
        if (this.isMerged()) {
            Range r = this.getMergedRange();
            autoResetHeight = r.getStartRow() == r.getEndRow();
        }
        boolean enabledAutoAddScrollBar = false;
        if (!autoResetHeight && enabledAutoAddScrollBar) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RowPropertyManage RPM;
                    DataSourceConfig dsc;
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int row = Cell_.this.getRowIndex();
                    String name = String.valueOf(Cell_.this.Sheet.getGUID()) + "_autoCreatedScrollbar_" + row;
                    if (Cell_.this.Sheet.getBrick(name) == null && (dsc = (RPM = Cell_.this.Sheet.getRowPropertyManage()).getMaximalDataSourceConfig(row)) != null) {
                        String dsName = dsc.getName();
                        int CC = Cell_.this.Sheet.getColumnCount();
                        Cell cell = null;
                        int col = CC - 1;
                        while (col >= 0) {
                            DBBindConfig dbc;
                            Cell tcell = Cell_.this.Sheet.$Cells(row, col);
                            if (tcell != null && (dbc = tcell.getBind()) != null && dbc.getDataSource().equals(dsName)) {
                                cell = tcell;
                                break;
                            }
                            --col;
                        }
                        if (cell != null) {
                            ScrollBar sbb = Cell_.this.Sheet.getWorkBook().createScrollBar(name, dsName);
                            cell.setProperty("padding-right", 14);
                            sbb.setBounds(-14, 0, 0, 0);
                            int rh = RPM.getRowHeight(row);
                            RPM.setDBRowHeight(row, rh);
                            RPM.setAutoAsyncHeightWithDBRowHeight(row, false);
                            cell.addBrick(sbb);
                        }
                    }
                }
            });
        }
        if (autoResetHeight || autoFitTextHeight) {
            RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
            int row = this.getRowIndex();
            int mrc = RPM.getMaxDBRowCount(row);
            int dbrh = RPM.getDBRowHeight(row);
            int grc = 0;
            DataSourceConfig dsc = RPM.getMaximalDataSourceConfig(row);
            if (dsc != null) {
                grc = RPM.getDBGroupRowCount(row);
            }
            int grh = RPM.getGroupRowHeight(row);
            if (autoFitTextHeight) {
                Row TR = this.Sheet.getRow(row);
                int cn = TR.getCellCount();
                dbrh = 21;
                int ci = 0;
                while (ci < cn) {
                    Cell_ TD = (Cell_)TR.getCell(ci);
                    if (TD.getProperty().get("auto-fit-height", false)) {
                        Point p = TD.getShowTextMaxHeight();
                        dbrh = Math.max(dbrh, p.x);
                    }
                    ++ci;
                }
                RPM.setDBRowHeight(row, dbrh);
            }
            if (RPM.isAutoAsyncHeightWithDBRowHeight(row)) {
                this.Sheet.$setRowHeight(this.getRowIndex(), mrc * dbrh + grc * grh);
            }
        }
    }

    public void drawBackground(Graphics2D g, Rectangle cellRect) {
        WorkSheetView_ view = (WorkSheetView_)this.Sheet.getWorkSheetView();
        Rectangle viewRect = this.Sheet.getWorkSheetView().getBounds();
        Rectangle expandRect = (Rectangle)cellRect.clone();
        if (this.getRightBottomCorner().getRowIndex() == this.Sheet.getRowCount() - 1) {
            expandRect.height = viewRect.height - expandRect.y;
        }
        if (this.getRightBottomCorner().getColumnIndex() == this.Sheet.getColumnCount() - 1) {
            expandRect.width = viewRect.width - expandRect.x;
        }
        Property property = this.getProperty();
        int background_mode = property.get("background-mode", 0);
        Color background_color = property.get("background-color", Color.WHITE);
        if (background_mode == 1) {
            g.setColor(background_color);
            g.fill(expandRect);
        }
    }

    public void drawBorder(Graphics2D g, Rectangle cellRect) {
        Cell_ cell;
        Cell_ cell2;
        Cell_ cell3;
        Cell_ cell4;
        int thisRow = this.getRowIndex();
        int thisCol = this.getColumnIndex();
        WorkSheetView_ view = (WorkSheetView_)this.Sheet.getWorkSheetView();
        Property property = this.getProperty();
        if (this.Sheet.getGridLineVisible()) {
            g.setColor(this.Sheet.getGridLineColor());
            g.drawRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
        }
        int border_left_style = property.get("border-left-style", 0);
        int border_left_width = property.get("border-left-width", 0);
        Color border_left_color = property.get("border-left-color", Color.BLACK);
        if ((border_left_style == 0 || border_left_width == 0) && thisCol > 0 && (cell4 = (Cell_)this.Sheet.$Cells(thisRow, thisCol - 1)) != null) {
            Property p = cell4.getProperty();
            border_left_style = p.get("border-right-style", 0);
            border_left_width = 1;
            border_left_color = p.get("border-right-color", Color.BLACK);
        }
        view.AddDrawCellBorderLine(view.drawBorderMap, g, border_left_style, border_left_width, border_left_color, cellRect.x, cellRect.y, cellRect.x, cellRect.y + cellRect.height);
        int border_top_style = property.get("border-top-style", 0);
        int border_top_width = property.get("border-top-width", 0);
        Color border_top_color = property.get("border-top-color", Color.BLACK);
        if ((border_top_style == 0 || border_top_width == 0) && thisRow > 0 && (cell3 = (Cell_)this.Sheet.$Cells(thisRow - 1, thisCol)) != null) {
            Property p = cell3.getProperty();
            border_top_style = p.get("border-bottom-style", 0);
            border_top_width = 1;
            border_top_color = p.get("border-bottom-color", Color.BLACK);
        }
        view.AddDrawCellBorderLine(view.drawBorderMap, g, border_top_style, border_top_width, border_top_color, cellRect.x, cellRect.y, cellRect.x + cellRect.width, cellRect.y);
        int border_right_style = property.get("border-right-style", 0);
        int border_right_width = property.get("border-right-width", 0);
        Color border_right_color = property.get("border-right-color", Color.BLACK);
        if ((border_right_style == 0 || border_right_width == 0) && thisCol < this.Sheet.getColumnCount() - 1 && (cell2 = (Cell_)this.Sheet.$Cells(thisRow, thisCol + 1)) != null) {
            Property p = cell2.getProperty();
            border_right_style = p.get("border-left-style", 0);
            border_right_width = 1;
            border_right_color = p.get("border-left-color", Color.BLACK);
        }
        view.AddDrawCellBorderLine(view.drawBorderMap, g, border_right_style, border_right_width, border_right_color, cellRect.x + cellRect.width, cellRect.y, cellRect.x + cellRect.width, cellRect.y + cellRect.height);
        int border_bottom_style = property.get("border-bottom-style", 0);
        int border_bottom_width = property.get("border-bottom-width", 0);
        Color border_bottom_color = property.get("border-bottom-color", Color.BLACK);
        if ((border_bottom_style == 0 || border_bottom_width == 0) && thisRow < this.Sheet.getRowCount() - 1 && (cell = (Cell_)this.Sheet.$Cells(thisRow + 1, thisCol)) != null) {
            Property p = cell.getProperty();
            border_bottom_style = p.get("border-top-style", 0);
            border_bottom_width = 1;
            border_bottom_color = p.get("border-top-color", Color.BLACK);
        }
        view.AddDrawCellBorderLine(view.drawBorderMap, g, border_bottom_style, border_bottom_width, border_bottom_color, cellRect.x, cellRect.y + cellRect.height, cellRect.x + cellRect.width, cellRect.y + cellRect.height);
    }

    @Override
    public Color getSplitLineColor() {
        Property prop = this.getProperty();
        Color splitLineColor = null;
        if (splitLineColor == null && prop.get("border-left-style", 0) > 0) {
            splitLineColor = prop.get("border-left-color", Color.BLACK);
        }
        if (splitLineColor == null && prop.get("border-top-style", 0) > 0) {
            splitLineColor = prop.get("border-top-color", Color.BLACK);
        }
        if (splitLineColor == null && prop.get("border-right-style", 0) > 0) {
            splitLineColor = prop.get("border-right-color", Color.BLACK);
        }
        if (splitLineColor == null && prop.get("border-bottom-style", 0) > 0) {
            splitLineColor = prop.get("border-bottom-color", Color.BLACK);
        }
        if (splitLineColor == null) {
            splitLineColor = this.Sheet.getGridLineColor();
        }
        return splitLineColor;
    }

    public Rectangle getTextRectangleOfCell(Rectangle cellRect) {
        Property prop = this.getProperty();
        Rectangle bordertRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        int ph = this.decorate == null ? 0 : this.decorate.getHPadding();
        int pv = this.decorate == null ? 0 : this.decorate.getVPadding();
        textRect.x = cellRect.x + 1 + prop.get("padding-left", 1) + ph;
        textRect.y = cellRect.y + 1 + prop.get("padding-top", 1) + pv;
        textRect.width = Math.max(0, cellRect.width - 2 - prop.get("padding-left", 1) - prop.get("padding-right", 1) - ph * 2);
        textRect.height = Math.max(0, cellRect.height - 2 - prop.get("padding-top", 1) - prop.get("padding-bottom", 1) - pv * 2);
        if (!(this.decorate == null || this.ES == null || this.ES.getEditType() != 4 || this.ES.isListShowAsCheckBox() && this.ES.isListShowAsRadioButton())) {
            textRect.width -= 16;
        }
        return textRect;
    }

    private Object getExpressionValue(Object defaultValue, String font_color_expression, String convertToClass) {
        return this.getExpressionValue(defaultValue, font_color_expression, -1, convertToClass);
    }

    private Object getExpressionValue(Object defaultValue, String font_color_expression, int dbRow, String convertToClass) {
        if (font_color_expression.equals("")) {
            return defaultValue;
        }
        Cell expression = this.Sheet.getExpression(font_color_expression);
        if (expression == null) {
            return defaultValue;
        }
        Object v = null;
        v = dbRow == -1 ? expression.getValue() : expression.getValue(dbRow);
        if (v != null && v.toString().equals("")) {
            v = defaultValue;
        }
        try {
            if (v instanceof Vector) {
                return defaultValue;
            }
            v = ObjectTool.ChangeType((Object)v, (String)convertToClass);
        }
        catch (Exception e) {
            v = defaultValue;
        }
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    @Override
    public Font getFont() {
        Property prop = this.getProperty();
        Color font_color_default = prop.get("font-color", Color.BLACK);
        String font_color_expression = prop.get("font-color-expression", "");
        String background_color_expression = prop.get("background-color-expression", "");
        String font_name = prop.get("font-name", "\u5b8b\u4f53");
        if (font_name.equals("\u81ea\u52a8")) {
            font_name = this.getAppropriateFontName();
        }
        int font_size = prop.get("font-size", 12);
        boolean font_bold = prop.get("font-bold", false);
        boolean font_italic = prop.get("font-italic", false);
        boolean font_underline = prop.get("font-underline", false);
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, font_name);
        map.put(TextAttribute.SIZE, new Float(font_size));
        if (font_underline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
        if (font_bold) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (font_italic) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        return new Font(map);
    }

    public void draw(boolean isPrint, Graphics2D g, Rectangle cellRect) {
        boolean ANTIALIAS_ON;
        Rectangle textRect;
        Property prop;
        block98: {
            WorkSheetView view;
            Shape oc;
            block97: {
                prop = this.getProperty();
                Rectangle bordertRect = new Rectangle();
                textRect = this.getTextRectangleOfCell(cellRect);
                Color font_color_default = prop.get("font-color", Color.BLACK);
                String font_color_expression = prop.get("font-color-expression", "");
                String background_color_expression = prop.get("background-color-expression", "");
                boolean cellVisible = isPrint && this.isPrintable() && this.isVisible() || !isPrint && this.isVisible() || this.Sheet.isDesignMode();
                String display_expression = prop.get("display-expression", "").trim();
                Color groupRowBackground = new Color(255);
                String font_name = prop.get("font-name", "\u5b8b\u4f53");
                if (font_name.equals("\u81ea\u52a8")) {
                    font_name = this.getAppropriateFontName();
                }
                int font_size = prop.get("font-size", 12);
                boolean font_bold = prop.get("font-bold", false);
                boolean font_italic = prop.get("font-italic", false);
                boolean font_underline = prop.get("font-underline", false);
                boolean hide_if_equal_last_row = prop.get("hide-if-equal-last-row", false);
                int align_h = prop.get("align-h", 0);
                int align_v = prop.get("align-v", 2);
                boolean word_wrap = prop.get("word-wrap", false);
                ANTIALIAS_ON = false;
                if (font_size > 16 || !font_name.equals("\u5b8b\u4f53") || this.Sheet.getViewScale() != 100) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    ANTIALIAS_ON = true;
                }
                RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
                int rowIndex = this.getRowIndex();
                int dbRowHeight = RPM.getDBRowHeight(rowIndex);
                int groupRowHeight = RPM.getGroupRowHeight(rowIndex);
                boolean groupRowVisible = RPM.isGroupRowVisible(rowIndex);
                int yOffset = RPM.getRowScrolledRowCount(rowIndex) * dbRowHeight;
                Color splitLineColor = this.getSplitLineColor();
                Rectangle clipRect = g.getClipBounds();
                clipRect = clipRect.intersection(cellRect);
                oc = g.getClip();
                try {
                    try {
                        block99: {
                            boolean needDrawLightBar;
                            Tools.clip(g, cellRect);
                            if (this.Bind != null) break block99;
                            boolean visible = true;
                            Object v = this.getValue();
                            boolean isVector = v instanceof Vector;
                            if (!isVector) {
                                if (isPrint || !this.isEditing()) {
                                    Color background_color;
                                    Color font_color = (Color)this.getExpressionValue(font_color_default, font_color_expression, "java.awt.Color");
                                    if (!background_color_expression.equals("") && (background_color = (Color)this.getExpressionValue(null, background_color_expression, "java.awt.Color")) != null) {
                                        g.setColor(background_color);
                                        g.fill(cellRect);
                                    }
                                    if (!display_expression.equals("")) {
                                        visible = (Boolean)this.getExpressionValue(Boolean.TRUE, display_expression, "java.lang.Boolean");
                                    }
                                    if (visible && cellVisible) {
                                        this.drawString(0, g, textRect, v, this.getShowText(0), 0, null, font_color, font_name, font_size, font_bold, font_italic, font_underline, this.$AutoHalign(align_h), align_v, word_wrap, false, isVector);
                                    }
                                }
                                if (this.decorate != null && visible) {
                                    this.decorate.paint(g, this, cellRect);
                                }
                                break block97;
                            }
                            int dataRC = ((Vector)v).size();
                            DataSourceConfig dsc = ((RowPropertyManage_)this.Sheet.getRowPropertyManage()).getMaximalDataSourceConfig(this.getRowIndex());
                            DataStore ds = null;
                            int groupCount = 0;
                            int currentRow = -1;
                            if (dsc != null) {
                                if (dsc.getDataSourceType() == 2) {
                                    currentRow = dsc.getCurrentBindRow();
                                }
                                ds = dsc.getDataStore();
                                ArrayList cgc = (ArrayList)ds.getFriendlyProperty("m_VectorGroupCols");
                                groupCount = cgc.size();
                            } else {
                                groupRowVisible = false;
                                groupCount = 0;
                            }
                            int endRow = dataRC - 1;
                            boolean bl = needDrawLightBar = this.Sheet.getWorkBook().isHighlightDataSourceCurrentRow() && dataRC > 0 && currentRow >= 0 && currentRow < dataRC;
                            if (dsc != null) {
                                needDrawLightBar = needDrawLightBar && dsc.isHighlightCurrentRow();
                            }
                            int i = 0;
                            while (i <= endRow) {
                                block100: {
                                    block102: {
                                        block101: {
                                            Color background_color;
                                            textRect.y = cellRect.y + i * dbRowHeight + 1 - yOffset;
                                            if (groupRowVisible) {
                                                textRect.y += Tools.getGroupsRowCount(ds, i) * groupRowHeight;
                                            }
                                            textRect.height = dbRowHeight - 2;
                                            if (!isPrint && !this.isEditing()) {
                                                AlphaComposite ac;
                                                if (needDrawLightBar && currentRow == i) {
                                                    ac = AlphaComposite.getInstance(3, 0.2f);
                                                    g.setComposite(ac);
                                                    g.setColor(LIGHT_ROW_COLOR);
                                                    g.fillRect(cellRect.x, textRect.y, cellRect.width, dbRowHeight - 1);
                                                    ac = AlphaComposite.getInstance(3, 1.0f);
                                                    g.setComposite(ac);
                                                }
                                                if (i % 2 == 1 && !groupRowVisible) {
                                                    ac = AlphaComposite.getInstance(3, 0.1f);
                                                    g.setComposite(ac);
                                                    g.setColor(Color.LIGHT_GRAY);
                                                    g.fillRect(cellRect.x, textRect.y, cellRect.width, dbRowHeight - 1);
                                                    ac = AlphaComposite.getInstance(3, 1.0f);
                                                    g.setComposite(ac);
                                                }
                                            }
                                            if (textRect.y + textRect.height < clipRect.y) break block100;
                                            if (!clipRect.intersects(textRect)) break block101;
                                            if (!isPrint && this.isEditing() && i == currentRow) break block100;
                                            Object vi = ((Vector)v).get(i);
                                            Color font_color = (Color)this.getExpressionValue(font_color_default, font_color_expression, i, "java.awt.Color");
                                            if (!background_color_expression.equals("") && (background_color = (Color)this.getExpressionValue(null, background_color_expression, i, "java.awt.Color")) != null) {
                                                g.setColor(background_color);
                                                g.fillRect(cellRect.x, textRect.y - 1, cellRect.width, textRect.height + 2);
                                            }
                                            g.setColor(splitLineColor);
                                            Rectangle trc = new Rectangle(cellRect.x, textRect.y - 1, cellRect.width, textRect.height + 2);
                                            this.drawBorder(g, trc);
                                            visible = true;
                                            if (!display_expression.equals("")) {
                                                visible = (Boolean)this.getExpressionValue(Boolean.TRUE, display_expression, i, "java.lang.Boolean");
                                            }
                                            if (visible && cellVisible) {
                                                String ts = this.toFormatString(vi);
                                                this.drawString(i, g, textRect, vi, ts, 0, null, font_color, font_name, font_size, font_bold, font_italic, font_underline, this.$AutoHalign(align_h), align_v, word_wrap, false, true);
                                            }
                                            if (this.decorate != null && visible) {
                                                this.decorate.paint(g, this, textRect);
                                            }
                                            break block102;
                                        }
                                        if (textRect.y > clipRect.y + clipRect.height) break;
                                    }
                                    if (groupRowVisible) {
                                        textRect.y += dbRowHeight;
                                        textRect.height = groupRowHeight;
                                        Integer key = new Integer(i);
                                        Hashtable MapGroups = (Hashtable)ds.getFriendlyProperty("m_MapGroups");
                                        if (MapGroups.containsKey(key)) {
                                            ArrayList pVec = (ArrayList)MapGroups.get(key);
                                            int gc = pVec.size();
                                            int ti = gc - 1;
                                            while (ti >= 0) {
                                                int k = (Integer)pVec.get(ti);
                                                if (!isPrint) {
                                                    AlphaComposite ac = AlphaComposite.getInstance(3, 0.05f * (float)(groupCount - k + 1));
                                                    g.setComposite(ac);
                                                    g.setColor(groupRowBackground);
                                                    g.fillRect(textRect.x - 1, textRect.y, textRect.width + 3, groupRowHeight);
                                                    ac = AlphaComposite.getInstance(3, 1.0f);
                                                    g.setComposite(ac);
                                                }
                                                g.setColor(splitLineColor);
                                                Rectangle groupRC = new Rectangle(cellRect.x, textRect.y - 1, cellRect.width, textRect.height);
                                                this.drawBorder(g, groupRC);
                                                textRect.y += textRect.height;
                                                --ti;
                                            }
                                        }
                                    }
                                }
                                ++i;
                            }
                            this.drawBorder(g, cellRect);
                            break block97;
                        }
                        WorkBook_ book = (WorkBook_)this.Sheet.getWorkBook();
                        DataSourceConfig dsc = book.getDataSource(this.Bind.getDataSource());
                        if (this.Bind.getDataSourceType() == 1 || this.Bind.getDataSourceType() == 4) {
                            boolean visible = true;
                            int dbrow = 0;
                            if (this.Bind.getDataSourceType() == 4) {
                                dbrow = dsc.getCurrentBindRow();
                            }
                            if (isPrint || !this.isEditing()) {
                                Color background_color;
                                Color font_color = (Color)this.getExpressionValue(font_color_default, font_color_expression, dbrow, "java.awt.Color");
                                if (!background_color_expression.equals("") && (background_color = (Color)this.getExpressionValue(null, background_color_expression, dbrow, "java.awt.Color")) != null) {
                                    g.setColor(background_color);
                                    g.fill(cellRect);
                                }
                                if (!display_expression.equals("")) {
                                    visible = (Boolean)this.getExpressionValue(Boolean.TRUE, display_expression, dbrow, "java.lang.Boolean");
                                }
                                if (visible && cellVisible) {
                                    this.drawString(dbrow, g, textRect, this.getValue(dbrow), this.getShowText(dbrow), 0, null, font_color, font_name, font_size, font_bold, font_italic, font_underline, this.$AutoHalign(align_h), align_v, word_wrap, false, false);
                                }
                            }
                            if (this.decorate != null && visible) {
                                this.decorate.paint(g, this, cellRect);
                            }
                            if (this.Sheet.isBalloonVisible()) {
                                String tip = dsc.getDataStore().getBalloonTip(0, this.Bind.getDBCol(), "comment");
                                CustomBalloonTip BalloonTip2 = null;
                                if (tip != null) {
                                    BalloonTip2 = this.getBalloonTipControl(this.Bind.getDataSource(), this.Bind.getDBCol(), 0);
                                    BalloonTip2.setOffset(textRect, 10, 10);
                                    BalloonTip2.setTextContents(tip);
                                } else {
                                    this.destroyBalloonTipControl(0);
                                }
                            } else {
                                this.destroyBalloonTipControl(-1);
                            }
                        } else {
                            String dbCol = this.Bind.getDBCol();
                            String dbCol2 = "|" + dbCol.toLowerCase() + "|";
                            DataStore ds = dsc.getDataStore();
                            int dataRC = ds.getRowCount();
                            Color lineColor = this.Sheet.getGridLineColor();
                            if (dataRC == 0) {
                                this.drawString(0, g, textRect, this.getValue(0), this.getShowText(0), 0, null, font_color_default, font_name, font_size, font_bold, font_italic, font_underline, this.$AutoHalign(align_h), align_v, word_wrap, false, true);
                            } else {
                                boolean needDrawLightBar;
                                ArrayList vg = (ArrayList)ds.getFriendlyProperty("m_VectorGroups");
                                ArrayList cgc = (ArrayList)ds.getFriendlyProperty("m_VectorGroupCols");
                                int groupCount = cgc.size();
                                int groupLevel = -1;
                                int gi = 0;
                                while (gi < cgc.size()) {
                                    String groupBy = ((String)cgc.get(gi)).toLowerCase();
                                    if ((groupBy = "|" + groupBy + "|").indexOf(dbCol2) >= 0) {
                                        groupLevel = gi + 1;
                                    }
                                    ++gi;
                                }
                                int currentRow = dsc.getCurrentBindRow();
                                int endRow = dataRC - 1;
                                boolean bl = needDrawLightBar = this.Sheet.getWorkBook().isHighlightDataSourceCurrentRow() && ds.getRowCount() > 0 && currentRow >= 0 && currentRow < ds.getRowCount();
                                if (dsc != null) {
                                    needDrawLightBar = needDrawLightBar && dsc.isHighlightCurrentRow();
                                }
                                int i = 0;
                                while (i <= endRow) {
                                    textRect.y = cellRect.y + i * dbRowHeight + 1 - yOffset;
                                    if (groupRowVisible) {
                                        textRect.y += Tools.getGroupsRowCount(ds, i) * groupRowHeight;
                                    }
                                    if (!isPrint && !this.isEditing()) {
                                        if (needDrawLightBar && currentRow == i) {
                                            AlphaComposite ac = AlphaComposite.getInstance(3, 0.2f);
                                            g.setComposite(ac);
                                            g.setColor(LIGHT_ROW_COLOR);
                                            g.fillRect(cellRect.x, textRect.y, cellRect.width, dbRowHeight - 1);
                                            ac = AlphaComposite.getInstance(3, 1.0f);
                                            g.setComposite(ac);
                                        }
                                        if (i % 2 == 1 && !groupRowVisible) {
                                            AlphaComposite ac = AlphaComposite.getInstance(3, 0.1f);
                                            g.setComposite(ac);
                                            g.setColor(Color.LIGHT_GRAY);
                                            g.fillRect(cellRect.x, textRect.y, cellRect.width, dbRowHeight - 1);
                                            ac = AlphaComposite.getInstance(3, 1.0f);
                                            g.setComposite(ac);
                                        }
                                    }
                                    boolean ignoreThisRow = false;
                                    if (groupLevel == -1) {
                                        textRect.height = dbRowHeight - 2;
                                    } else {
                                        Integer I;
                                        ArrayList rowsGroup = (ArrayList)vg.get(groupLevel);
                                        int fi = rowsGroup.indexOf(I = new Integer(i));
                                        if (fi < 0) {
                                            ignoreThisRow = true;
                                        } else {
                                            int groupEndRow = ds.getRowCount() - 1;
                                            if (fi != rowsGroup.size() - 1) {
                                                groupEndRow = (Integer)rowsGroup.get(fi + 1) - 1;
                                            }
                                            textRect.height = (groupEndRow - i + 1) * dbRowHeight - 2;
                                            if (groupRowVisible) {
                                                int subGroupsRowCount = Tools.getGroupsRowCount(ds, i, groupEndRow, groupLevel);
                                                textRect.height += subGroupsRowCount * groupRowHeight;
                                            }
                                        }
                                    }
                                    if (textRect.y + textRect.height < clipRect.y && !groupRowVisible) {
                                        this.destroyBalloonTipControl(i);
                                    } else {
                                        if (clipRect.intersects(textRect) && !ignoreThisRow) {
                                            bordertRect.x = cellRect.x;
                                            bordertRect.y = textRect.y - 1;
                                            bordertRect.width = cellRect.width;
                                            bordertRect.height = textRect.height + 2;
                                            g.setColor(splitLineColor);
                                            this.drawBorder(g, bordertRect);
                                            boolean visible = true;
                                            if (isPrint || !this.isEditing() || i != currentRow) {
                                                if (groupLevel > 0) {
                                                    if (textRect.y < cellRect.y) {
                                                        textRect.height -= cellRect.y - textRect.y;
                                                        textRect.y = cellRect.y;
                                                    }
                                                    if (textRect.y + textRect.height > cellRect.y + cellRect.height) {
                                                        textRect.height = cellRect.y + cellRect.height - textRect.y - 2;
                                                    }
                                                }
                                                Color font_color = (Color)this.getExpressionValue(font_color_default, font_color_expression, i, "java.awt.Color");
                                                if (!background_color_expression.equals("")) {
                                                    Color background_color = (Color)this.getExpressionValue(null, background_color_expression, i, "java.awt.Color");
                                                    if (background_color != null) {
                                                        g.setColor(background_color);
                                                        g.fillRect(bordertRect.x, bordertRect.y, bordertRect.width, bordertRect.height);
                                                    }
                                                    g.setColor(splitLineColor);
                                                    this.drawBorder(g, bordertRect);
                                                }
                                                if (!display_expression.equals("")) {
                                                    visible = (Boolean)this.getExpressionValue(Boolean.TRUE, display_expression, i, "java.lang.Boolean");
                                                }
                                                if (visible && cellVisible) {
                                                    String st = this.getShowText(i);
                                                    if (i > 0 && hide_if_equal_last_row && this.getShowText(i - 1).equals(st)) {
                                                        st = "";
                                                    }
                                                    this.drawString(i, g, textRect, this.getValue(i), st, 0, null, font_color, font_name, font_size, font_bold, font_italic, font_underline, this.$AutoHalign(align_h), align_v, word_wrap, false, true);
                                                }
                                            }
                                            if (this.decorate != null && visible) {
                                                this.decorate.paint(g, this, bordertRect);
                                            }
                                            if (this.Sheet.isBalloonVisible()) {
                                                String tip = dsc.getDataStore().getBalloonTip(i, this.Bind.getDBCol(), "comment");
                                                CustomBalloonTip BalloonTip3 = null;
                                                if (tip != null) {
                                                    BalloonTip3 = this.getBalloonTipControl(this.Bind.getDataSource(), this.Bind.getDBCol(), i);
                                                    BalloonTip3.setOffset(textRect, 10, 10);
                                                    BalloonTip3.setTextContents(tip);
                                                } else {
                                                    this.destroyBalloonTipControl(i);
                                                }
                                            } else {
                                                this.destroyBalloonTipControl(-1);
                                            }
                                        } else if (textRect.y > clipRect.y + clipRect.height) break;
                                        if (groupRowVisible) {
                                            textRect.y += dbRowHeight;
                                            textRect.height = groupRowHeight;
                                            Integer key = new Integer(i);
                                            Hashtable MapGroups = (Hashtable)ds.getFriendlyProperty("m_MapGroups");
                                            if (MapGroups.containsKey(key)) {
                                                ArrayList pVec = (ArrayList)MapGroups.get(key);
                                                int gc = pVec.size();
                                                int ti = gc - 1;
                                                while (ti >= 0) {
                                                    int k = (Integer)pVec.get(ti);
                                                    if (k > groupLevel && groupLevel >= 0) {
                                                        textRect.y += groupRowHeight;
                                                    } else {
                                                        if (!isPrint) {
                                                            AlphaComposite ac = AlphaComposite.getInstance(3, 0.05f * (float)(groupCount - k + 1));
                                                            g.setComposite(ac);
                                                            g.setColor(groupRowBackground);
                                                            g.fillRect(textRect.x - 1, textRect.y, textRect.width + 3, textRect.height);
                                                            ac = AlphaComposite.getInstance(3, 1.0f);
                                                            g.setComposite(ac);
                                                        }
                                                        g.setColor(splitLineColor);
                                                        Rectangle groupRC = new Rectangle(cellRect.x, textRect.y - 1, cellRect.width, textRect.height);
                                                        this.drawBorder(g, groupRC);
                                                        String t = "";
                                                        String aggregateCol = String.valueOf(dbCol) + "_aggregate_" + k;
                                                        boolean existsAggregateCol = ds.columnExists(aggregateCol);
                                                        if (groupLevel == k && k > 0 && !existsAggregateCol) {
                                                            Color font_color = (Color)this.getExpressionValue(font_color_default, font_color_expression, i, "java.awt.Color");
                                                            boolean visible = true;
                                                            if (!display_expression.equals("")) {
                                                                visible = (Boolean)this.getExpressionValue(Boolean.TRUE, display_expression, i, "java.lang.Boolean");
                                                            }
                                                            if (visible && cellVisible) {
                                                                this.drawString(i, g, textRect, this.getValue(i), this.getShowText(i), 0, null, font_color, font_name, font_size, font_bold, font_italic, false, this.$AutoHalign(align_h), align_v, word_wrap, false, true);
                                                            }
                                                        }
                                                        if (existsAggregateCol) {
                                                            Object v = ds.getValue(i, aggregateCol);
                                                            Color font_color = (Color)this.getExpressionValue(font_color_default, font_color_expression, i, "java.awt.Color");
                                                            boolean visible = true;
                                                            if (!display_expression.equals("")) {
                                                                visible = (Boolean)this.getExpressionValue(Boolean.TRUE, display_expression, i, "java.lang.Boolean");
                                                            }
                                                            if (visible && cellVisible) {
                                                                this.drawString(i, g, textRect, v, this.toFormatString(v), 0, null, font_color, font_name, font_size, font_bold, font_italic, false, this.$AutoHalign(align_h), align_v, word_wrap, false, true);
                                                            }
                                                        }
                                                        textRect.y += groupRowHeight;
                                                    }
                                                    --ti;
                                                }
                                            }
                                        }
                                    }
                                    ++i;
                                }
                            }
                            this.drawBorder(g, cellRect);
                        }
                    }
                    catch (Exception book) {
                        Tools.setClip(g, oc);
                        if (!this.isVisible() && this.Sheet.isDesignMode()) {
                            view = this.Sheet.getWorkSheetView();
                            g.drawImage(Tools.GetImageFromURL(view, "excel/res/eye.gif"), cellRect.x + 1, cellRect.y + 1, view);
                        }
                        Tools.setClip(g, oc);
                        break block98;
                    }
                }
                catch (Throwable throwable) {
                    Tools.setClip(g, oc);
                    if (!this.isVisible() && this.Sheet.isDesignMode()) {
                        WorkSheetView view2 = this.Sheet.getWorkSheetView();
                        g.drawImage(Tools.GetImageFromURL(view2, "excel/res/eye.gif"), cellRect.x + 1, cellRect.y + 1, view2);
                    }
                    Tools.setClip(g, oc);
                    throw throwable;
                }
            }
            Tools.setClip(g, oc);
            if (!this.isVisible() && this.Sheet.isDesignMode()) {
                view = this.Sheet.getWorkSheetView();
                g.drawImage(Tools.GetImageFromURL(view, "excel/res/eye.gif"), cellRect.x + 1, cellRect.y + 1, view);
            }
            Tools.setClip(g, oc);
        }
        if (ANTIALIAS_ON) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.BrickMap != null) {
            for (Brick brick : this.BrickMap.values()) {
                brick.paint(isPrint, g, cellRect);
            }
        }
        if (this.ToolTip != null && !this.ToolTip.equals("") && this.Sheet.isDesignMode()) {
            g.setColor(new Color(22000));
            g.fillPolygon(new int[]{cellRect.x + cellRect.width, cellRect.x + cellRect.width, cellRect.x + cellRect.width - 6}, new int[]{cellRect.y + cellRect.height - 6, cellRect.y + cellRect.height, cellRect.y + cellRect.height}, 3);
        }
        if (this.Bind != null && this.Sheet.isDesignMode() && this.Sheet.getWorkBook().isCellShowBind()) {
            this.drawString(0, g, textRect, String.valueOf(this.Bind.getDBCol()) + "@" + this.Bind.getDataSource(), String.valueOf(this.Bind.getDBCol()) + "@" + this.Bind.getDataSource(), 0, null, new Color(39680), "\u65b0\u5b8b\u4f53", 12, false, false, false, 0, 0, false, false, false);
            g.setColor(new Color(0xF00000));
            g.fillPolygon(new int[]{cellRect.x + cellRect.width - 6, cellRect.x + cellRect.width, cellRect.x + cellRect.width}, new int[]{cellRect.y, cellRect.y, cellRect.y + 6}, 3);
        }
        if (this.Tag != null && this.Sheet.isDesignMode()) {
            g.setColor(new Color(0xF0AA00));
            g.fillPolygon(new int[]{cellRect.x + cellRect.width - 6, cellRect.x + cellRect.width, cellRect.x + cellRect.width}, new int[]{cellRect.y, cellRect.y, cellRect.y + 6}, 3);
        }
        if (prop.get("show-corner-sign", false)) {
            Color c = prop.get("show-corner-sign-color", Color.red);
            g.setColor(c);
            g.fillPolygon(new int[]{cellRect.x + cellRect.width - 6, cellRect.x + cellRect.width, cellRect.x + cellRect.width}, new int[]{cellRect.y, cellRect.y, cellRect.y + 6}, 3);
        }
    }

    public void destroyBalloonTipControl(int row) {
        if (this.BalloonTipControlCache == null) {
            return;
        }
        if (this.BalloonTipControlCache.containsKey(row)) {
            this.BalloonTipControlCache.get(row).closeBalloon();
        }
        this.BalloonTipControlCache.remove(row);
        if (row == -1) {
            for (int r : this.BalloonTipControlCache.keySet()) {
                this.BalloonTipControlCache.get(r).closeBalloon();
            }
            this.BalloonTipControlCache.clear();
        }
    }

    private CustomBalloonTip getBalloonTipControl(String dsname, String dbcol, int row) {
        if (this.BalloonTipControlCache == null) {
            this.BalloonTipControlCache = new HashMap();
        }
        if (this.BalloonTipControlCache.containsKey(row)) {
            return this.BalloonTipControlCache.get(row);
        }
        System.out.println("new ... " + row);
        final WorkSheetView view = this.Sheet.getWorkSheetView();
        CustomBalloonTip BalloonTip2 = new CustomBalloonTip(view, new JLabel(""), new Rectangle(1, 1, 100, 10), new RoundedBalloonStyle(3, 3, BalloonTipBackgroundColor, Color.DARK_GRAY), BalloonTip.Orientation.LEFT_ABOVE, BalloonTip.AttachLocation.ALIGNED, 7, 7, true);
        BalloonTip2.setTopLevelContainer(view);
        final String $dsname = dsname;
        final String $dbcol = dbcol;
        final int $innerRow = row;
        BalloonTip2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    Cell_.this.Sheet.balloonTipEdit($dsname, $dbcol, $innerRow);
                }
            }

            public void mouseEntered(MouseEvent e) {
                ((CustomBalloonTip)e.getSource()).setStyle(new RoundedBalloonStyle(3, 3, Color.yellow, Color.DARK_GRAY));
                SimpleDateFormat sdf = new SimpleDateFormat("hhmmssSSS");
                view.setLayer((CustomBalloonTip)e.getSource(), Integer.valueOf(sdf.format(new Date())), 0);
            }

            public void mouseExited(MouseEvent e) {
                ((CustomBalloonTip)e.getSource()).setStyle(new RoundedBalloonStyle(3, 3, BalloonTipBackgroundColor, Color.DARK_GRAY));
            }
        });
        this.BalloonTipControlCache.put(row, BalloonTip2);
        return BalloonTip2;
    }

    private void drawAsHTML(Graphics2D g, Rectangle rc, String s) {
        if (s.trim().equals("")) {
            return;
        }
        JTextPane textPane = new JTextPane();
        HTMLEditorKit editorKit = new HTMLEditorKit(){

            protected HTMLEditorKit.Parser getParser() {
                try {
                    Class<?> c = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                    HTMLEditorKit.Parser defaultParser = (HTMLEditorKit.Parser)c.newInstance();
                    return defaultParser;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        HTMLDocument document = (HTMLDocument)editorKit.createDefaultDocument();
        textPane = new JTextPane(document);
        textPane.setContentType("text/html");
        textPane.setBounds(rc);
        textPane.setText(s);
        BufferedImage img = new BufferedImage(textPane.getWidth(), textPane.getHeight(), 1);
        Graphics tg = img.getGraphics();
        textPane.paint(tg);
        g.drawImage(img, null, rc.x, rc.y);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        textPane = null;
        document = null;
        editorKit = null;
    }

    private void drawAsUrl(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, boolean MultiLine) {
        this.innerAction = "url";
        ZDataParser zdp = new ZDataParser(s);
        String name = zdp.get("url", "").trim();
        if (name.equals("")) {
            return;
        }
        String href = zdp.get("href", "").trim();
        if (href.equals("")) {
            return;
        }
        Tools.DrawString(g, rc, name, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, MultiLine);
    }

    private void drawAsBarCode(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, boolean MultiLine) {
        JSONObject js = new JSONObject(s);
        BarCode barcode = new BarCode();
        for (String key : js.getMap().keySet()) {
            String value = js.getString(key, "");
            barcode.setParameter(key, value);
        }
        barcode.barColor = textcolor;
        barcode.fontColor = textcolor;
        barcode.setSize(barcode.width * js.getInt("n", 1), barcode.height);
        if (barcode.autoSize) {
            BufferedImage bufferedimage = new BufferedImage(barcode.getSize().width, barcode.getSize().height, 13);
            Graphics2D graphics2d = bufferedimage.createGraphics();
            barcode.paint(graphics2d);
            barcode.invalidate();
            graphics2d.dispose();
        }
        BufferedImage bufferedimage1 = new BufferedImage(barcode.getSize().width, barcode.getSize().height, 1);
        Graphics2D graphics2d1 = bufferedimage1.createGraphics();
        barcode.paint(graphics2d1);
        Shape oc = g.getClip();
        try {
            Tools.clip(g, rc);
            g.drawImage((Image)bufferedimage1, rc.x, rc.y, null);
            Tools.setClip(g, oc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean drawAsImage(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Rectangle rect, int hAlign, int vAlign, boolean isVector) {
        if (bkMode == 1) {
            g.setColor(bkcolor);
        }
        try {
            byte[] b;
            char[] cs;
            String t;
            Image img = this.internalImage;
            if (isVector) {
                if (base64ImageMap.containsKey(s)) {
                    img = base64ImageMap.get(s);
                } else {
                    t = s.substring("$#{image}#$".length());
                    cs = t.toCharArray();
                    b = Base64Coder.decode((char[])cs);
                    if (b.length > 0) {
                        img = Toolkit.getDefaultToolkit().createImage(b);
                    }
                    if (b.length == 0) {
                        return false;
                    }
                    base64ImageMap.put(s, img);
                }
            } else if (img == null) {
                t = s.substring("$#{image}#$".length());
                cs = t.toCharArray();
                b = Base64Coder.decode((char[])cs);
                if (b.length > 0) {
                    this.internalImage = Toolkit.getDefaultToolkit().createImage(b);
                }
                if (b.length == 0) {
                    return false;
                }
                img = this.internalImage;
                cs = null;
                t = null;
            }
            Shape oc = g.getClip();
            Tools.clip(g, rc);
            if (img != null) {
                int w = img.getWidth(this.Sheet.getWorkSheetView());
                int h = img.getHeight(this.Sheet.getWorkSheetView());
                double scale = 1.0;
                double sw = Math.min((double)rect.width * 1.0 / (double)w, 1.0);
                if (this.getProperty().get("auto-fit-width", false)) {
                    sw = 1.0;
                    int delta = w - rect.width;
                    ColumnPropertyManage CPM = this.Sheet.getColumnPropertyManage();
                    int ci = this.getColumnIndex();
                    CPM.setColumnWidth(ci, CPM.getColumnWidth(ci) + delta);
                }
                double sh = Math.min((double)rect.height * 1.0 / (double)h, 1.0);
                if (this.getProperty().get("auto-fit-height", false)) {
                    sh = 1.0;
                    int delta = h - rect.height;
                    RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
                    int ri = this.getRowIndex();
                    RPM.setRowHeight(ri, RPM.getRowHeight(ri) + delta);
                }
                scale = Math.min(sw, sh);
                w = (int)((double)w * scale);
                h = (int)((double)h * scale);
                int drawPosY = rect.y;
                int drawPosX = rect.x;
                switch (vAlign) {
                    case 1: {
                        drawPosY += rect.height - h;
                        break;
                    }
                    case 2: {
                        drawPosY += (rect.height - h) / 2;
                        break;
                    }
                    default: {
                        drawPosY = rect.y;
                    }
                }
                switch (hAlign) {
                    case 1: {
                        drawPosX += rect.width - w;
                        break;
                    }
                    case 2: {
                        drawPosX += (rect.width - w) / 2;
                        break;
                    }
                    default: {
                        drawPosX = rc.x;
                    }
                }
                g.drawImage(img, drawPosX, drawPosY, w, h, this.Sheet.getWorkSheetView());
            }
            Tools.setClip(g, oc);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean drawAsURLImage(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Rectangle rect, int hAlign, int vAlign) {
        if (bkMode == 1) {
            g.setColor(bkcolor);
        }
        Image tmpImage = null;
        try {
            String url = s.substring("$#{urlimage}#$".length());
            WorkSheetView view = this.Sheet.getWorkSheetView();
            tmpImage = Tools.GetImageFromURL(view, url);
            Shape oc = g.getClip();
            Tools.clip(g, rc);
            if (tmpImage != null) {
                int w = tmpImage.getWidth(this.Sheet.getWorkSheetView());
                int h = tmpImage.getHeight(this.Sheet.getWorkSheetView());
                double scale = 1.0;
                double sw = Math.min((double)rect.width * 1.0 / (double)w, 1.0);
                if (this.getProperty().get("auto-fit-width", false)) {
                    sw = 1.0;
                    int delta = w - rect.width;
                    ColumnPropertyManage CPM = this.Sheet.getColumnPropertyManage();
                    int ci = this.getColumnIndex();
                    CPM.setColumnWidth(ci, CPM.getColumnWidth(ci) + delta);
                }
                double sh = Math.min((double)rect.height * 1.0 / (double)h, 1.0);
                if (this.getProperty().get("auto-fit-height", false)) {
                    sh = 1.0;
                    int delta = h - rect.height;
                    RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
                    int ri = this.getRowIndex();
                    RPM.setRowHeight(ri, RPM.getRowHeight(ri) + delta);
                }
                scale = Math.min(sw, sh);
                w = (int)((double)w * scale);
                h = (int)((double)h * scale);
                int drawPosY = rect.y;
                int drawPosX = rect.x;
                switch (vAlign) {
                    case 1: {
                        drawPosY += rect.height - h;
                        break;
                    }
                    case 2: {
                        drawPosY += (rect.height - h) / 2;
                        break;
                    }
                    default: {
                        drawPosY = rect.y;
                    }
                }
                switch (hAlign) {
                    case 1: {
                        drawPosX += rect.width - w;
                        break;
                    }
                    case 2: {
                        drawPosX += (rect.width - w) / 2;
                        break;
                    }
                    default: {
                        drawPosX = rc.x;
                    }
                }
                g.drawImage(tmpImage, drawPosX, drawPosY, w, h, this.Sheet.getWorkSheetView());
            }
            Tools.setClip(g, oc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void drawString(int dbrow, Graphics2D g, Rectangle rc, Object data, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, boolean MultiLine, boolean noES, boolean isVector) {
        Rectangle textRect = (Rectangle)rc.clone();
        if (s.startsWith("$#{image}#$")) {
            if (this.drawAsImage(g, rc, s, bkMode, bkcolor, rc, hAlign, vAlign, isVector)) {
                return;
            }
            s = "\u56fe\u7247\u592a\u5927";
        }
        if (s.startsWith("$#{urlimage}#$")) {
            if (this.drawAsURLImage(g, rc, s, bkMode, bkcolor, rc, hAlign, vAlign)) {
                return;
            }
            s = "\u56fe\u7247\u592a\u5927";
        }
        if (s.startsWith("<url>")) {
            this.drawAsUrl(g, textRect, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, MultiLine);
            return;
        }
        if (s.startsWith("{$zexcel_barcode:true,")) {
            this.drawAsBarCode(g, textRect, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, MultiLine);
            return;
        }
        if (this.ES != null && !noES) {
            int et = this.ES.getEditType();
            if (et == 5) {
                boolean on = this.isCheckOn(dbrow);
                Tools.DrawCheckBoxOrRadioButtonString(this.Sheet.getWorkSheetView(), g, textRect, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, on, false, true);
                return;
            }
            if (et == 4 && (this.ES.isListShowAsCheckBox() || this.ES.isListShowAsRadioButton())) {
                int colCount;
                int listCount = 0;
                Object[] showvalues = null;
                Object[] keyvalues = null;
                Map map = this.ES.getDropDownData2ViewMapForEdit(dbrow);
                if (map != null) {
                    showvalues = map.values().toArray();
                    keyvalues = map.keySet().toArray();
                    listCount = map.size();
                }
                if ((colCount = Math.max(1, this.ES.getColumnCountOnRow())) == 0) {
                    colCount = 1;
                }
                int rowCount = (listCount - 1) / colCount + 1;
                rowCount = Math.max(1, rowCount);
                Rectangle itemRC = new Rectangle();
                itemRC.width = rc.width / colCount;
                int itemHeight = 0;
                itemHeight = this.ES.isDropDownListEditable() ? rc.height / (rowCount + 1) : rc.height / rowCount;
                itemRC.height = itemHeight - 1;
                WorkSheetView view = this.getWorkSheet().getWorkSheetView();
                String sv = "," + Tools.$S(data) + ",";
                int ri = 0;
                while (ri < rowCount) {
                    itemRC.y = rc.y + ri * itemHeight;
                    int ci = 0;
                    while (ci < colCount) {
                        itemRC.x = rc.x + ci * itemRC.width;
                        int index = ri * colCount + ci;
                        if (index > listCount - 1) break;
                        String tipText = Tools.$S(showvalues[index]);
                        String vText = Tools.$S(keyvalues[index]);
                        boolean checked = false;
                        checked = this.ES.isListShowAsCheckBox() ? sv.indexOf("," + vText + ",") >= 0 : sv.equals("," + vText + ",");
                        Tools.DrawCheckBoxOrRadioButtonString(view, g, itemRC, tipText, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, checked, false, this.ES.isListShowAsCheckBox());
                        ++ci;
                    }
                    ++ri;
                }
                if (this.ES.isDropDownListEditable()) {
                    boolean otherChecked = false;
                    String otherValue = "";
                    String[] ss = sv.split(",");
                    int ri2 = 0;
                    while (ri2 < ss.length) {
                        String t = ss[ri2].trim();
                        if (!t.equals("")) {
                            boolean exists = false;
                            int ci = 0;
                            while (ci < listCount) {
                                String vText = Tools.$S(keyvalues[ci]);
                                if (t.equals(vText)) {
                                    exists = true;
                                    break;
                                }
                                ++ci;
                            }
                            if (!exists) {
                                otherChecked = true;
                                otherValue = t;
                                break;
                            }
                        }
                        ++ri2;
                    }
                    Tools.DrawCheckBoxOrRadioButtonString(view, g, new Rectangle(rc.x, rc.y + itemHeight * rowCount, rc.width, itemRC.height), "\u5176\u5b83\uff1a" + otherValue, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, otherChecked, false, this.ES.isListShowAsCheckBox());
                }
                return;
            }
            if (et == 2) {
                Tools.DrawString(g, textRect, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, true);
                return;
            }
            if (et == 7) {
                this.drawAsHTML(g, textRect, s);
                return;
            }
        }
        Tools.DrawString(g, textRect, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, MultiLine);
    }

    public boolean isCheckOn(int dbrow) {
        Object v = this.getValue(dbrow);
        if (this.ES == null) {
            return false;
        }
        if (this.ES.getEditType() != 5) {
            return false;
        }
        Object onv = this.ES.getCheckOnValue();
        return v != null && onv != null && v.toString().equals(onv.toString());
    }

    @Override
    public boolean isEditing() {
        return this.isEditing > 0;
    }

    @Override
    public void setIsEditing(boolean b) {
        this.isEditing += b ? 1 : -1;
    }

    @Override
    public boolean isEditable() {
        return this.Editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.setEditable(editable, false);
    }

    @Override
    public void setEditable(boolean editable, boolean addBorder) {
        Brick b;
        String editHightLignt = "EditableHightLight";
        this.Editable = editable;
        if (addBorder && this.decorate == null) {
            Brick[] bs = this.getBricks();
            boolean exists = false;
            int i = 0;
            while (i < bs.length) {
                if (bs[i].getName().equals(editHightLignt)) {
                    exists = true;
                    break;
                }
                ++i;
            }
            if (!exists) {
                OnlyBorder brick = this.getWorkSheet().getWorkBook().createOnlyBorderBrick(editHightLignt, new Color(16760220), 1, 1);
                brick.setBounds(1, 1, -1, -1);
                brick.setPrintable(false);
                this.addBrick(brick);
            }
        }
        if ((b = this.getBrick(editHightLignt)) != null) {
            b.setVisible(this.Editable);
        }
        this.repaint();
    }

    @Override
    public EditStyle getEditStyle() {
        return this.ES;
    }

    @Override
    public void setEditStyle(EditStyle editStyle) {
        if (this.ES == editStyle) {
            return;
        }
        this.ES = editStyle;
        if (this.ES != null && this.ES.getEditType() == 4) {
            DataSourceConfig dsc;
            Map map = this.ES.getDropDownData2ViewMap();
            if (this.Bind != null && (dsc = this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource())) != null) {
                String dbcol = this.Bind.getDBCol();
                DataStore ds = dsc.getDataStore();
                ColumnProperty CP = ds.getColumnProperty(dbcol);
                if (CP != null) {
                    CP.setData2ViewMap(map);
                }
            }
        }
        this.NotifyAffectCellInvalidWhenMyEditStyleChanged();
    }

    @Override
    public void setEditStyle(String editStyleName) {
        if (editStyleName == null) {
            this.setEditStyle((EditStyle)null);
            return;
        }
        this.setEditStyle(this.Sheet.getWorkBook().getEditStyle(editStyleName));
    }

    @Override
    public boolean getViewAsPassword() {
        return this.ViewAsPWD;
    }

    @Override
    public void setViewAsPassword(boolean b) {
        if (this.ViewAsPWD == b) {
            return;
        }
        this.ViewAsPWD = b;
        this.repaint();
    }

    @Override
    public Row getRow() {
        return this.pRow;
    }

    @Override
    public WorkSheet getWorkSheet() {
        return this.Sheet;
    }

    public void $CopyFrom(Cell_ cell, boolean aliasReplace) {
        boolean b = this.Sheet.getCommandManage().getNeedUndo();
        this.Sheet.getCommandManage().setNeedUndo(false);
        if (cell == null) {
            this.clear();
        } else {
            this.$CopyFrom(cell.getAllField(), aliasReplace);
        }
        this.Sheet.getCommandManage().setNeedUndo(b);
    }

    public void clear() {
        this.property = null;
        this.ES = null;
        this.ViewAsPWD = false;
        if (this.Bind != null) {
            this.setBind(null);
        }
        if (this.BrickMap != null) {
            this.BrickMap.clear();
            this.BrickMap = null;
        }
        this.setValue(null);
        this.setAlias(null);
        this.setTag(null);
        if (this.isMerged()) {
            this.Sheet.UnMerge(this.getMergedRange());
        }
    }

    public void $CopyFrom(CommandScene scene, boolean aliasReplace) {
        boolean b = this.Sheet.getCommandManage().getNeedUndo();
        this.Sheet.getCommandManage().setNeedUndo(false);
        if (scene == null) {
            this.clear();
        } else {
            this.VT = scene.get("VT", this.VT);
            DBBindConfig bind = (DBBindConfig)scene.get("Bind", (Object)null);
            this.setBind(bind);
            this.setEditStyle((EditStyle)scene.get("ES", (Object)null));
            this.Editable = scene.get("Editable", false);
            this.property = (Property_)scene.get("property", (Object)null);
            this.ViewAsPWD = scene.get("ViewAsPWD", false);
            this.decorate = (CellDecorate)scene.get("decorate", (Object)null);
            this.formulaIsPriority = scene.get("formulaIsPriority", 0);
            this.setValue(scene.get("Define", (Object)null));
            this.setBalloon(scene.get("balloon", ""));
            this.setAlias(scene.get("Alias", ""), aliasReplace);
            this.setTag(scene.get("Tag", (Object)null));
            if (scene.get("merged", false)) {
                int thisRow = this.getRowIndex();
                int thisCol = this.getColumnIndex();
                this.Sheet.Merge(thisRow - scene.get("mr1", 0), thisCol - scene.get("mc1", 0), thisRow - scene.get("mr2", 0), thisCol - scene.get("mc2", 0));
            }
            this.BrickMap = null;
            HashMap brickmap = (HashMap)scene.get("BrickMap");
            if (brickmap != null) {
                for (String name : brickmap.keySet()) {
                    BasicBrick brick = (BasicBrick)brickmap.get(name);
                    BasicBrick newBrick = (BasicBrick)brick.clone();
                    newBrick.setParentCell(this);
                    this.addBrick(newBrick);
                }
            }
        }
        this.Sheet.getCommandManage().setNeedUndo(b);
    }

    public CommandScene getAllField() {
        CommandScene scene = new CommandScene();
        scene.put("Define", this.Define);
        scene.put("Alias", this.getAlias());
        scene.put("Tag", this.Tag);
        scene.put("property", this.property);
        scene.put("VT", this.VT);
        scene.put("Bind", this.Bind);
        scene.put("Editable", this.Editable);
        scene.put("ES", this.ES);
        scene.put("ViewAsPWD", this.ViewAsPWD);
        scene.put("BrickMap", this.BrickMap);
        scene.put("formulaIsPriority", this.formulaIsPriority);
        scene.put("decorate", this.decorate);
        scene.put("balloon", this.Balloon);
        scene.put("tooltip", this.ToolTip);
        if (this.isMerged()) {
            scene.put("merged", true);
            Range r = this.getMergedRange();
            int thisRow = this.getRowIndex();
            int thisCol = this.getColumnIndex();
            scene.put("mr1", thisRow - r.getStartRow());
            scene.put("mc1", thisCol - r.getStartCol());
            scene.put("mr2", thisRow - r.getEndRow());
            scene.put("mc2", thisCol - r.getEndCol());
        }
        return scene;
    }

    @Override
    public Object jsGet_Value() {
        return this.getValue();
    }

    @Override
    public Object jsGet_Value(int dbrow) {
        return this.getValue(dbrow);
    }

    @Override
    public void jsSet_Value(Object value, int dbRow) {
        this.setValue(value, dbRow);
    }

    @Override
    public void jsSet_Value(Object value) {
        this.setValue(value);
    }

    @Override
    public boolean addBrick(Brick brick) {
        String name = brick.getName();
        name = name.toLowerCase().trim();
        if (this.BrickMap == null) {
            this.BrickMap = new HashMap();
        }
        if (this.BrickMap.containsKey(name)) {
            return false;
        }
        brick.setParent(this);
        brick.bind();
        this.BrickMap.put(name, brick);
        brick.afterAddToCell();
        this.repaint();
        return true;
    }

    @Override
    public boolean removeBrick(String brickName) {
        if (this.BrickMap == null) {
            return false;
        }
        if (!this.BrickMap.containsKey(brickName = brickName.toLowerCase().trim())) {
            return false;
        }
        Brick brick = (Brick)this.BrickMap.get(brickName);
        brick.unBind();
        this.BrickMap.remove(brickName);
        this.repaint();
        return true;
    }

    @Override
    public Brick getBrick(int index) {
        if (this.BrickMap == null) {
            return null;
        }
        String name = this.getBrickName(index);
        if (name == null) {
            return null;
        }
        return this.getBrick(name);
    }

    @Override
    public Brick getBrick(String name) {
        if (this.BrickMap == null) {
            return null;
        }
        name = name.toLowerCase().trim();
        return (Brick)this.BrickMap.get(name);
    }

    @Override
    public int getBrickCount() {
        if (this.BrickMap == null) {
            return 0;
        }
        return this.BrickMap.size();
    }

    @Override
    public String getBrickName(int index) {
        int n = this.getBrickCount();
        if (index < 0 || index + 1 > n) {
            return null;
        }
        int i = 0;
        for (String name : this.BrickMap.keySet()) {
            if (i == index) {
                return ((Brick)this.BrickMap.get(name)).getName();
            }
            ++i;
        }
        return null;
    }

    @Override
    public Brick[] getBricks() {
        Brick[] ret = new Brick[]{};
        int n = this.getBrickCount();
        if (n > 0) {
            ret = this.BrickMap.values().toArray(ret);
        }
        return ret;
    }

    private void $innerAction(int innerRow) {
        if (this.innerAction == null) {
            return;
        }
        if (this.Sheet.isDesignMode()) {
            return;
        }
        if (this.innerAction.equals("url")) {
            try {
                Object v = this.getValue();
                if (v == null) {
                    v = "";
                }
                boolean isVector = v instanceof Vector;
                String xmlSource = "";
                xmlSource = isVector ? ((Vector)v).get(innerRow).toString() : v.toString();
                ZDataParser zdp = new ZDataParser(xmlSource);
                String name = zdp.get("url", "");
                String href = zdp.get("href", "");
                String target = zdp.get("target", "_blank");
                if (href.startsWith("javascript:")) {
                    href = "base64\u7f16\u7801\u540e\u7684\u811a\u672c" + Base64Coder.encode((String)href);
                    this.Sheet.evaluate("evalScript(\"" + href + "\")");
                    return;
                }
                if (target.equals("worksheet")) {
                    int p = href.indexOf("!");
                    String sheetName = "";
                    String cellName = "";
                    if (p > 0) {
                        sheetName = href.substring(0, p);
                        cellName = href.substring(p + 1);
                    } else if (this.Sheet.cells(href) != null) {
                        sheetName = this.Sheet.getName();
                        cellName = href;
                    } else {
                        sheetName = href;
                        cellName = "a1";
                    }
                    WorkSheet toSheet = this.Sheet.getWorkBook().getWorkSheet(sheetName);
                    if (toSheet == null) {
                        throw new Exception("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + sheetName + "]\u4e0d\u5b58\u5728");
                    }
                    if (!toSheet.isVisible()) {
                        throw new Exception("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + sheetName + "]\u4e0d\u53ef\u89c1");
                    }
                    this.Sheet.getWorkBook().setActiveSheet(toSheet.getIndex());
                    Cell cell = toSheet.cells(cellName);
                    if (cell == null) {
                        throw new Exception("\u6307\u5b9a\u7684\u5355\u5143\u683c[" + cellName + "]\u4e0d\u5b58\u5728");
                    }
                    toSheet.setSelection(cell);
                    ((WorkSheetView_)toSheet.getWorkSheetView()).InsureSelectionOnScreen(null);
                    return;
                }
                if (target.equals("_blank")) {
                    Applet applet = Tools.ContainedByApplet(this.Sheet.getWorkSheetView());
                    if (applet != null) {
                        Tools.webEval("window.open('" + href + "')", applet);
                    }
                    return;
                }
                if (target.equals("_self")) {
                    Applet applet = Tools.ContainedByApplet(this.Sheet.getWorkSheetView());
                    if (applet != null) {
                        Tools.webEval("window.navigate('" + href + "')", applet);
                    }
                    return;
                }
                if (target.equals("_parent")) {
                    Applet applet = Tools.ContainedByApplet(this.Sheet.getWorkSheetView());
                    if (applet != null) {
                        Tools.webEval("parent.navigate('" + href + "')", applet);
                    }
                    return;
                }
                Applet applet = Tools.ContainedByApplet(this.Sheet.getWorkSheetView());
                if (applet != null) {
                    Tools.webEval("document.getElementById('" + target + "').src='" + href + "' ", applet);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void OnLButtonDown(WorkSheetView_ pView, MouseEvent e) {
        if (this.BrickMap != null) {
            Point me = e.getPoint();
            for (Brick brick : this.BrickMap.values()) {
                if (!brick.contains(me)) continue;
                brick.OnLButtonDown(pView, e);
            }
        }
    }

    @Override
    public int getInnerRowAtPoint(Point p) {
        return this.getInnerRowAtPoint(p, true);
    }

    public int getInnerRowAtPoint(Point p, boolean setAsCurrentBindRow) {
        int innerRow = -1;
        int cellRow = this.getRowIndex();
        Rectangle rect = ((WorkSheetView_)this.Sheet.getWorkSheetView()).getShowRectangleOfCell(false, cellRow, this.getColumnIndex());
        RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
        int dbRowHeight = RPM.getDBRowHeight(cellRow);
        int groupRowHeight = RPM.getGroupRowHeight(cellRow);
        boolean groupRowVisible = RPM.isGroupRowVisible(cellRow);
        int yOffset = RPM.getRowScrolledRowCount(cellRow) * dbRowHeight;
        DataSourceConfig dsc = null;
        if (this.Bind != null) {
            dsc = this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource());
            if (dsc.getDataStore().getRowCount() == 0) {
                return innerRow;
            }
            if (this.Bind.getDataSourceType() == 1) {
                return 0;
            }
            if (this.Bind.getDataSourceType() == 4) {
                return dsc.getCurrentBindRow();
            }
        } else {
            Object v = this.getValue();
            boolean isVector = v instanceof Vector;
            if (!isVector) {
                return innerRow;
            }
            dsc = ((RowPropertyManage_)this.Sheet.getRowPropertyManage()).getMaximalDataSourceConfig(this.getRowIndex());
            if (dsc == null) {
                if (rect.contains(p)) {
                    return (p.y - rect.y + yOffset) / dbRowHeight;
                }
                return 0;
            }
        }
        int dbRow = 0;
        DataStore ds = dsc.getDataStore();
        if (rect.contains(p)) {
            int totalHeight = p.y - rect.y + yOffset;
            if (groupRowVisible) {
                Hashtable MapGroups = (Hashtable)ds.getFriendlyProperty("m_MapGroups");
                int rc = ds.getRowCount();
                int height = 0;
                int i = 0;
                while (i < rc) {
                    height += dbRowHeight;
                    Integer key = new Integer(i);
                    if (MapGroups.containsKey(key)) {
                        ArrayList pVec = (ArrayList)MapGroups.get(key);
                        int gc = pVec.size();
                        height += gc * groupRowHeight;
                    }
                    if (height >= totalHeight) {
                        dbRow = i;
                        break;
                    }
                    ++i;
                }
            } else {
                dbRow = totalHeight / dbRowHeight;
            }
        }
        if (setAsCurrentBindRow && dsc.getDataSourceType() == 2) {
            dsc.setCurrentBindRow(dbRow);
        }
        innerRow = dbRow;
        return innerRow;
    }

    @Override
    public Brick getBrickAt(Point p) {
        if (this.BrickMap != null) {
            Point me = p;
            for (Brick brick : this.BrickMap.values()) {
                if (!brick.contains(me)) continue;
                return brick;
            }
        }
        return null;
    }

    @Override
    public void OnLButtonClick(WorkSheetView_ pView, MouseEvent e) {
        int innerRow = this.getInnerRowAtPoint(e.getPoint());
        if (!this.Sheet.isDesignMode()) {
            pView.$beginEdit(this.getRowIndex(), this.getColumnIndex(), null, e, innerRow);
        }
        this.$innerAction(innerRow);
        if (this.isVisible()) {
            this.Sheet.getWorkBook().getEM().fireCellClicked(this.Sheet, this, innerRow);
        }
        if (this.BrickMap != null) {
            Point me = e.getPoint();
            for (Brick brick : this.BrickMap.values()) {
                if (!brick.contains(me)) continue;
                brick.OnLButtonClick(pView, e);
            }
        }
    }

    public void OnRButtonClick(WorkSheetView_ pView, MouseEvent e) {
        int innerRow = this.getInnerRowAtPoint(e.getPoint());
        this.Sheet.getWorkBook().getEM().fireCellRightClicked(this.Sheet, this, innerRow);
    }

    @Override
    public void OnLButtonDblClk(WorkSheetView_ pView, MouseEvent e) {
        if (this.Sheet.isDesignMode()) {
            pView.$beginEdit(this.getRowIndex(), this.getColumnIndex(), null, e, -1);
        }
        int innerRow = this.getInnerRowAtPoint(e.getPoint());
        this.Sheet.getWorkBook().getEM().fireCellDblClicked(this.Sheet, this, innerRow);
        if (this.BrickMap != null) {
            Point me = e.getPoint();
            for (Brick brick : this.BrickMap.values()) {
                if (!brick.contains(me)) continue;
                brick.OnLButtonDblClk(pView, e);
            }
        }
    }

    @Override
    public void OnLButtonUp(WorkSheetView_ pView, MouseEvent e) {
        if (this.BrickMap != null) {
            Point me = e.getPoint();
            for (Brick brick : this.BrickMap.values()) {
                if (!brick.contains(me)) continue;
                brick.OnLButtonUp(pView, e);
            }
        }
    }

    @Override
    public void OnMouseMove(WorkSheetView_ pView, MouseEvent e) {
        if (this.isEditable() && !this.Sheet.isDesignMode()) {
            DBBindConfig dbc;
            pView.setCursor(Cursor.getPredefinedCursor(2));
            if (this.ES != null) {
                if (this.ES.getEditType() == 5) {
                    pView.setCursor(Cursor.getPredefinedCursor(12));
                }
                if (this.ES.getEditType() == 4) {
                    if (this.ES.isListShowAsCheckBox() || this.ES.isListShowAsRadioButton()) {
                        pView.setCursor(Cursor.getPredefinedCursor(12));
                    } else if (this.getDecorate() != null) {
                        pView.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }
            }
            if ((dbc = this.getBind()) != null && this.Sheet.getWorkBook().getDataSource(dbc.getDataSource()).getDataStore().getRowCount() == 0) {
                pView.setCursor(Tools.GetCursor(pView, "edittip.gif", new Point(2, 1)));
            }
        }
        Property prop = this.getProperty();
        boolean font_underline = prop.get("font-underline", false);
        if (this.innerAction != null || font_underline) {
            pView.setCursor(new Cursor(12));
        }
        if (this.cursorName.equals("hand")) {
            pView.setCursor(new Cursor(12));
        }
        this.BrickMouseEnterExitTest(pView, e);
        this.Sheet.getWorkBook().getEM().fireOnMouseMove(pView, this, e);
    }

    private void BrickMouseEnterExitTest(WorkSheetView_ pView, MouseEvent e) {
        if (this.BrickMap != null) {
            Point me = e.getPoint();
            for (Brick brick : this.BrickMap.values()) {
                if (brick.contains(me)) {
                    brick.OnMouseMove(pView, e);
                    if (brick.isOnFocus()) continue;
                    brick.setFocus(true);
                    brick.OnMouseEntered(pView, e);
                    continue;
                }
                if (!brick.isOnFocus()) continue;
                brick.setFocus(false);
                brick.OnMouseExited(pView, e);
            }
        }
    }

    @Override
    public void OnMouseDrag(WorkSheetView_ pView, MouseEvent e) {
        this.BrickMouseEnterExitTest(pView, e);
        if (this.BrickMap != null) {
            Point me = e.getPoint();
            for (Brick brick : this.BrickMap.values()) {
                brick.OnMouseDrag(pView, e);
            }
        }
    }

    @Override
    public void OnRButtonDown(WorkSheetView_ pView, MouseEvent e) {
        if (this.BrickMap != null) {
            Point me = e.getPoint();
            for (Brick brick : this.BrickMap.values()) {
                if (!brick.contains(me)) continue;
                brick.OnRButtonDown(pView, e);
            }
        }
    }

    @Override
    public void OnMouseEntered(WorkSheetView_ pView, MouseEvent e) {
    }

    @Override
    public void OnMouseExited(WorkSheetView_ pView, MouseEvent e) {
    }

    @Override
    public void keyPressed(WorkSheetView_ pView, KeyEvent e) {
    }

    @Override
    public void keyReleased(WorkSheetView_ pView, KeyEvent e) {
    }

    public String getAutoTip(MouseEvent e) {
        if (this.Bind != null && this.Sheet.isDesignMode() && this.Sheet.getWorkBook().isCellShowBind()) {
            StringBuffer sb = new StringBuffer(1024);
            sb.append("<html><font color=\"#6d24ff\">\u6570\u636e\u5e93\u7ed1\u5b9a\uff1a</font><br>\u6570\u636e\u6e90\uff1a<font color=blue>").append(this.Bind.getDataSource()).append("&nbsp;</font><br>\u5b57&nbsp;&nbsp;\u6bb5\uff1a<font color=blue>").append(this.Bind.getDBCol()).append("&nbsp;</font><br><br></html>");
            return sb.toString();
        }
        if (this.Tag != null && this.Sheet.isDesignMode()) {
            return this.Tag.toString();
        }
        int cellRow = this.getRowIndex();
        RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
        int dbRowHeight = RPM.getDBRowHeight(cellRow);
        int yOffset = RPM.getRowScrolledRowCount(cellRow) * dbRowHeight;
        if (this.innerAction != null) {
            String s = null;
            int innerRow = 0;
            Rectangle rect = ((WorkSheetView_)this.Sheet.getWorkSheetView()).getShowRectangleOfCell(false, cellRow, this.getColumnIndex());
            Object v = this.getValue();
            boolean isVector = v instanceof Vector;
            if (v == null) {
                v = "";
            }
            if (this.Bind == null) {
                if (!isVector) {
                    s = v.toString();
                } else {
                    int dataRC = ((Vector)v).size();
                    if (e != null) {
                        innerRow = rect.contains(e.getPoint()) ? (e.getPoint().y - rect.y + yOffset) / this.Sheet.getRowPropertyManage().getDBRowHeight(cellRow) : 0;
                    }
                }
            } else {
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(this.Bind.getDataSource());
                if (this.Bind.getDataSourceType() == 1) {
                    s = v.toString();
                } else if (this.Bind.getDataSourceType() == 4) {
                    innerRow = dsc.getCurrentBindRow();
                } else {
                    int dbRow = e != null ? (rect.contains(e.getPoint()) ? (e.getPoint().y - rect.y + yOffset) / this.Sheet.getRowPropertyManage().getDBRowHeight(cellRow) : 0) : dsc.getCurrentBindRow();
                    innerRow = dbRow;
                }
            }
            if (isVector && s == null) {
                Object innerV = ((Vector)v).get(innerRow);
                if (innerV == null) {
                    return "";
                }
                s = innerV.toString();
            }
            if (s.startsWith("<url>")) {
                ZDataParser zdp = new ZDataParser(s);
                return zdp.get("href", "");
            }
        }
        return "";
    }

    @Override
    public String getToolTip() {
        return this.ToolTip == null ? "" : this.ToolTip;
    }

    @Override
    public void setToolTip(String tip) {
        this.ToolTip = tip;
    }

    @Override
    public String getAlias() {
        return this.Alias == null ? "" : this.Alias;
    }

    @Override
    public String setAlias(String alias) {
        return this.setAlias(alias, false);
    }

    @Override
    public String setAlias(String alias, boolean replace) {
        String ret;
        if (this.Alias == null && alias == null) {
            return "";
        }
        if (this.Alias != null && alias != null && this.Alias.equals(alias)) {
            return "";
        }
        if (alias != null) {
            alias = alias.trim();
        }
        if ((ret = this.Sheet.$setCellAlias(this, alias, replace)).length() > 0) {
            return ret;
        }
        this.Alias = alias;
        return "";
    }

    @Override
    public Object getTag() {
        return this.Tag;
    }

    @Override
    public void setTag(Object tag) {
        this.Tag = tag;
    }

    @Override
    public boolean isShowAsImage() {
        String s = this.getShowText(0);
        return s.startsWith("$#{image}#$");
    }

    @Override
    public DataStore getDataStore() {
        if (this.Bind == null) {
            return null;
        }
        WorkBook_ book = (WorkBook_)this.Sheet.getWorkBook();
        DataSourceConfig dsc = book.getDataSource(this.Bind.getDataSource());
        if (dsc == null) {
            return null;
        }
        return dsc.getDataStore();
    }

    @Override
    public void beginEdit() {
        this.beginEdit(false);
    }

    @Override
    public void beginEdit(boolean splash) {
        final boolean $splash = splash;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int row = Cell_.this.getRowIndex();
                int col = Cell_.this.getColumnIndex();
                WorkSheetView_ view = (WorkSheetView_)Cell_.this.Sheet.getWorkSheetView();
                if (view != null) {
                    view.$beginEdit(row, col, null, null, -1);
                }
                if ($splash) {
                    view.$getCurrentEditingEdit().splash(true);
                }
            }
        });
    }

    @Override
    public Cell getLeftTopCorner() {
        if (!this.isMerged()) {
            return this;
        }
        Range r = this.getMergedRange();
        return this.Sheet.cells(r.getStartRow(), r.getStartCol());
    }

    @Override
    public Cell getRightBottomCorner() {
        if (!this.isMerged()) {
            return this;
        }
        Range r = this.getMergedRange();
        return this.Sheet.cells(r.getEndRow(), r.getEndCol());
    }

    public static int findFirstColumnWhichBindToSomeDataSource(WorkSheet_ sheet, int row, String dataSource, int startCol, int endCol, boolean forEdit) {
        int start = startCol;
        int end = endCol;
        if (dataSource == null) {
            dataSource = "";
        }
        int col = start;
        while (col <= end) {
            DBBindConfig bind;
            Cell cell = sheet.$Cells(row, col);
            if (cell != null && (cell.isEditable() || !forEdit) && (bind = cell.getBind()) != null) {
                if (dataSource.equals("")) {
                    return col;
                }
                if (bind.getDataSource().equalsIgnoreCase(dataSource)) {
                    return col;
                }
            }
            ++col;
        }
        return -1;
    }

    public static int findLastColumnWhichBindToSomeDataSource(WorkSheet_ sheet, int row, String dataSource, int startCol, int endCol, boolean forEdit) {
        int start = endCol;
        int end = startCol;
        if (dataSource == null) {
            dataSource = "";
        }
        int col = start;
        while (col >= end) {
            DBBindConfig bind;
            Cell cell = sheet.$Cells(row, col);
            if (cell != null && (cell.isEditable() || !forEdit) && (bind = cell.getBind()) != null) {
                if (dataSource.equals("")) {
                    return col;
                }
                if (bind.getDataSource().equalsIgnoreCase(dataSource)) {
                    return col;
                }
            }
            --col;
        }
        return -1;
    }

    @Override
    public String getNameOfEditButton() {
        if (this.editWithButtonName == null) {
            return null;
        }
        if (this.editWithButtonName.equals("")) {
            return null;
        }
        return this.editWithButtonName;
    }

    @Override
    public void setNameOfEditButton(String buttonName) {
        this.editWithButtonName = buttonName;
    }

    @Override
    public boolean defineIsFormulate() {
        return this.isFormula();
    }

    @Override
    public ArrayList getAffectList() {
        return this.AffectList;
    }

    @Override
    public ArrayList getDependList() {
        return this.DependList;
    }

    @Override
    public void addSubscriber(ChangeListener cl) {
        if (this.subscribeList == null) {
            this.subscribeList = new ArrayList();
        }
        this.subscribeList.add(cl);
    }

    @Override
    public void removeSubscriber(ChangeListener subscriber) {
        if (this.subscribeList == null) {
            return;
        }
        this.subscribeList.remove(subscriber);
    }

    @Override
    public String getCursorName() {
        return this.cursorName;
    }

    @Override
    public void setCursorName(String cursorName) {
        this.cursorName = cursorName;
    }

    @Override
    public void setCustomValue(String key, String value) {
        if (this.customValue == null) {
            this.customValue = new HashMap();
        }
        this.customValue.put(key, value);
    }

    @Override
    public String getCustomValue(String key) {
        if (this.customValue == null) {
            return null;
        }
        if (this.customValue.containsKey(key)) {
            return (String)this.customValue.get(key);
        }
        return null;
    }

    @Override
    public String[] getCustomValueNames() {
        if (this.customValue == null) {
            return new String[0];
        }
        String[] ret = new String[this.customValue.size()];
        Iterator it = this.customValue.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String k;
            ret[i] = k = (String)it.next();
            ++i;
        }
        return ret;
    }

    @Override
    public int getFormulaIsPriority() {
        return this.formulaIsPriority;
    }

    @Override
    public boolean isFormulaPriority() {
        if (this.formulaIsPriority == 1) {
            return true;
        }
        if (this.formulaIsPriority == 2) {
            return false;
        }
        if (this.formulaIsPriority == 0) {
            if (this.DependList == null) {
                return false;
            }
            if (this.DependList.size() > 0) {
                return true;
            }
        }
        return true;
    }

    @Override
    public void setFormulaIsPriority(int formulaIsPriority) {
        this.formulaIsPriority = formulaIsPriority;
    }

    @Override
    public CellDecorate getDecorate() {
        return this.decorate;
    }

    @Override
    public void setDecorate(CellDecorate decorate) {
        this.decorate = decorate;
    }

    @Override
    public boolean isVisible() {
        Property prop = this.getProperty();
        return prop.get("display", true);
    }

    @Override
    public void setVisible(boolean v) {
        this.setProperty("display", new Boolean(v));
    }

    public boolean isPrintable() {
        Property prop = this.getProperty();
        return prop.get("printable", true);
    }

    public void setPrintable(boolean v) {
        this.setProperty("printable", new Boolean(v));
    }

    @Override
    public void setHeight(int h) {
        int row = this.getRowIndex();
        if (row < 0) {
            this.setCustomValue("zexcel_cell_inner_height", "" + h);
        } else {
            this.getWorkSheet().getRowPropertyManage().setRowHeight(row, h);
        }
    }

    @Override
    public int getHeight() {
        try {
            int row = this.getRowIndex();
            if (row < 0) {
                String h = this.getCustomValue("zexcel_cell_inner_height");
                return new Integer(h);
            }
            return this.getWorkSheet().getRowPropertyManage().getRowHeight(row);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public void setWidth(int w) {
        int col = this.getColumnIndex();
        if (col < 0) {
            this.setCustomValue("zexcel_cell_inner_width", "" + w);
        } else {
            this.getWorkSheet().getColumnPropertyManage().setColumnWidth(col, w);
        }
    }

    @Override
    public int getWidth() {
        try {
            int col = this.getColumnIndex();
            if (col < 0) {
                String w = this.getCustomValue("zexcel_cell_inner_width");
                return new Integer(w);
            }
            return this.getWorkSheet().getColumnPropertyManage().getColumnWidth(col);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setBalloon(String s) {
        this.Balloon = s;
        if (s.equals("")) {
            this.Balloon = null;
        }
        this.repaint();
    }

    public String getBalloon() {
        return this.Balloon == null ? "" : this.Balloon;
    }

    @Override
    public void setNumberViewScale(int scale) {
        if (scale <= 0) {
            return;
        }
        if (this.numberViewScale == scale) {
            return;
        }
        this.numberViewScale = scale;
        this.repaint();
    }

    @Override
    public int getNumberViewScale() {
        return this.numberViewScale;
    }

    @Override
    public void setFormulaNeedCache(boolean b) {
        if (this.DependList != null) {
            Tools.log("\u672c\u5355\u5143\u683c\u516c\u5f0f\u4e2d\u5f15\u7528\u4e86\u5176\u5b83\u5355\u5143\u683c\uff0c\u56e0\u6b64\u5b83\u7684\u7f13\u5b58\u662f\u81ea\u52a8\u5904\u7406\u7684\uff0c\u4e0d\u53d7\u6b64\u53c2\u6570\u63a7\u5236\u3002\u4ec5\u7c7b\u4f3c newData() \u8fd9\u6837\u7684\u4e0d\u5f15\u7528\u5176\u5b83\u5355\u5143\u683c\u7684\u516c\u5f0f\u624d\u53d7\u5f15\u6807\u8bb0\u5f71\u54cd ");
            return;
        }
        this.formulaNeedCache = b;
        if (!b) {
            this.setInvalid();
        }
    }

    @Override
    public boolean isFormulaNeedCache() {
        if (this.DependList != null) {
            return true;
        }
        return this.formulaNeedCache;
    }
}

