/*
 * Decompiled with CFR 0.152.
 */
package excel.command;

import excel.core.Command;
import excel.core.CommandManage;
import excel.core.WorkSheet;
import java.util.Stack;

public class CommandManage_
implements CommandManage {
    private Stack UndoStack = new Stack();
    private Stack RedoStack = new Stack();
    private int level = 0;
    private boolean needUndo = true;
    private WorkSheet Owner;

    public CommandManage_(WorkSheet sheet) {
        this.Owner = sheet;
    }

    public void _$CommandManage_() {
        this.UndoStack = null;
        this.RedoStack = null;
        this.Owner = null;
    }

    public void StepIn() {
        ++this.level;
    }

    public void StepOut() {
        --this.level;
    }

    public int getLevel() {
        return this.level;
    }

    public void PushCommand(Command cmd) {
        this.UndoStack.push(cmd);
        this.RedoStack.clear();
    }

    public void Redo() {
        if (this.RedoStack.size() == 0) {
            return;
        }
        Command cmd = (Command)this.RedoStack.pop();
        boolean ok = cmd.Redo();
        if (ok) {
            this.UndoStack.push(cmd);
        }
        if (cmd.getLevel() != 1) {
            this.Redo();
        }
    }

    public void Undo() {
        if (this.UndoStack.size() == 0) {
            return;
        }
        Command cmd = (Command)this.UndoStack.pop();
        boolean ok = cmd.Undo();
        if (ok) {
            this.RedoStack.push(cmd);
        }
        if (!this.UndoStack.empty() && (cmd = (Command)this.UndoStack.peek()).getLevel() != 1) {
            this.Undo();
        }
    }

    public boolean getNeedUndo() {
        return this.needUndo && this.Owner.isDesignMode();
    }

    public void setNeedUndo(boolean b) {
        this.needUndo = b;
    }
}

