/*
 * Decompiled with CFR 0.152.
 */
package excel.command;

import excel.command.CommandScene;
import excel.core.Command;
import excel.core.CommandManage;
import excel.core.WorkSheet;
import excel.core.impl.WorkBookView_;
import excel.core.impl.WorkSheet_;

public abstract class CommandBase
implements Command {
    CommandScene Scene;
    WorkSheet_ Sheet;
    int Level;

    public void setLevel(int level) {
        this.Level = level;
    }

    public int getLevel() {
        return this.Level;
    }

    public CommandBase(WorkSheet sheet, CommandScene scene) {
        this.Sheet = (WorkSheet_)sheet;
        this.Scene = scene;
        if (sheet.getWorkBook().isUndoEnabled()) {
            this.SaveScene();
        }
    }

    public abstract boolean $Execute();

    public abstract boolean $Undo();

    public void $SaveScene() {
    }

    public final void SaveScene() {
        this.BackupXYOffset();
        this.$SaveScene();
    }

    public final boolean Execute() {
        if (!this.Sheet.getWorkBook().isUndoEnabled()) {
            return this.$Execute();
        }
        CommandManage CM = this.Sheet.getCommandManage();
        this.RestoreXYOffset();
        CM.StepIn();
        this.setLevel(CM.getLevel());
        boolean ok = this.$Execute();
        CM.StepOut();
        if (ok && CM.getNeedUndo()) {
            CM.PushCommand(this);
        }
        return ok;
    }

    public final boolean Redo() {
        if (!this.Sheet.getWorkBook().isUndoEnabled()) {
            return true;
        }
        this.RestoreXYOffset();
        return this.$Execute();
    }

    public final boolean Undo() {
        if (!this.Sheet.getWorkBook().isUndoEnabled()) {
            return true;
        }
        this.RestoreXYOffset();
        CommandManage CM = this.Sheet.getCommandManage();
        boolean b = CM.getNeedUndo();
        CM.setNeedUndo(false);
        boolean ret = this.$Undo();
        CM.setNeedUndo(b);
        return ret;
    }

    private void BackupXYOffset() {
        int xoffset = this.Sheet.getXOffset();
        int yoffset = this.Sheet.getYOffset();
        this.Scene.put("xoffset", xoffset);
        this.Scene.put("yoffset", yoffset);
    }

    private void RestoreXYOffset() {
        int xoffset = this.Scene.get("xoffset", 0);
        int yoffset = this.Scene.get("yoffset", 0);
        this.Sheet.setXOffset(xoffset);
        this.Sheet.setYOffset(yoffset);
        WorkBookView_ view = (WorkBookView_)this.Sheet.getWorkBook().getWorkBookView();
        if (view != null) {
            view.ResetHScrollBarScrollRange();
            view.ResetVScrollBarScrollRange();
        }
    }
}

