/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import excel.brick.Tree;
import excel.brick.TreeDataProvider;
import excel.brick.impl.BasicBrick;
import excel.core.Cell;
import excel.core.WorkBookView;
import excel.core.WorkSheet;
import excel.core.WorkSheetView;
import excel.dragdrop.EnhancedTreeCellRenderer;
import excel.dragdrop.TreeData;
import excel.ui.chktree.CheckBoxTreeCellRenderer;
import excel.ui.chktree.CheckBoxTreeNode;
import excel.ui.chktree.CheckBoxTreeNodeSelectionListener;
import excel.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree_
extends BasicBrick
implements Tree {
    boolean addToSheetView = false;
    JPanel panel = new JPanel();
    JTextField inputKey;
    JTree tree;
    DefaultMutableTreeNode root;
    JScrollPane jScrollPane = new JScrollPane();
    ArrayList<String> dataGroup;
    HashMap<String, JSONArray> group2Data = new HashMap();
    String currentDataGroup = "";
    WorkBookView pView = null;
    Image zoom;
    MouseAdapter mouseEvent;
    TreeDataProvider provider = null;
    String rootCaption;
    MouseListener lastMouseListener = null;
    TreeSelectionListener lastTreeSelectionListener = null;

    public JSONArray cacheData(String group) {
        JSONArray data = this.lazyLoading ? this.provider.buildLevelData(group, this.provider.parseRootValue(this.rootValue)) : this.provider.buildData(group);
        this.group2Data.put(group, data);
        return data;
    }

    public Tree_(String name, boolean multi, String rootCaption, String rootValue, TreeDataProvider provider_, WorkBookView v, boolean autoLoad, boolean lazyLoad) {
        super(name, 19);
        JSONArray data;
        this.setRootValue(rootValue);
        this.setLazyLoading(lazyLoad);
        this.provider = provider_;
        this.pView = v;
        this.rootCaption = rootCaption;
        this.dataGroup = this.provider.getGroups();
        if (this.dataGroup == null) {
            this.dataGroup = new ArrayList();
        }
        if (this.dataGroup.size() == 0) {
            this.dataGroup.add("");
        }
        this.currentDataGroup = this.dataGroup.get(0);
        if (autoLoad) {
            this.cacheData(this.currentDataGroup);
        }
        if ((data = this.group2Data.get(this.currentDataGroup)) == null) {
            data = new JSONArray();
        }
        this.isMulti = multi;
        super.setRootLabel(this.currentDataGroup);
        if (data.length() == 0) {
            autoLoad = false;
            data = new JSONArray("[  {text:\"\u6b63\u5728\u52a0\u8f7d...\", value:1,group:\"" + this.currentDataGroup + "\"  }]");
        }
        this.root = multi ? new CheckBoxTreeNode(this.currentDataGroup.equals("") ? rootCaption : this.currentDataGroup, true) : new DefaultMutableTreeNode(this.currentDataGroup.equals("") ? rootCaption : this.currentDataGroup, true);
        String rv = this.provider.parseRootValue(rootValue);
        this.root.setUserObject(new TreeData(rv, "", "", this.currentDataGroup.equals("") ? rootCaption : this.currentDataGroup, rv));
        ((TreeData)this.root.getUserObject()).expanded = true;
        int i = 0;
        while (i < data.length()) {
            this.addSubNode(this.root, data.getJSONObject(i));
            ++i;
        }
        this.tree = new JTree(this.root);
        if (autoLoad) {
            this.filter("");
        }
        if (this.isMulti) {
            this.lastMouseListener = new CheckBoxTreeNodeSelectionListener(this);
            this.tree.addMouseListener(this.lastMouseListener);
            this.tree.setCellRenderer(new CheckBoxTreeCellRenderer(v));
        } else {
            this.tree.setCellRenderer(new EnhancedTreeCellRenderer(v));
            this.lastTreeSelectionListener = new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)Tree_.this.tree.getLastSelectedPathComponent();
                    if (selNode == null) {
                        return;
                    }
                    Object v = selNode.getUserObject();
                    if (v == null) {
                        return;
                    }
                    if (v instanceof TreeData) {
                        TreeData d = (TreeData)v;
                        Tree_.this.getWorkSheetView().getWorkSheet().getWorkBook().getEM().fireOnTreeSelectionChanged(Tree_.this.getName(), d.type, d.caption, d.data);
                    }
                }
            };
            this.tree.addTreeSelectionListener(this.lastTreeSelectionListener);
        }
        if (lazyLoad) {
            this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

                public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                    DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                    if (selNode == null) {
                        return;
                    }
                    Object v = selNode.getUserObject();
                    if (v == null) {
                        return;
                    }
                    if (v instanceof TreeData) {
                        TreeData data = (TreeData)v;
                        if (!data.expanded) {
                            JSONArray sub = Tree_.this.provider.buildLevelData(Tree_.this.currentDataGroup, data.id);
                            selNode.removeAllChildren();
                            data.sourceData.put("sublist", (Object)sub);
                            if (sub != null) {
                                int i = 0;
                                while (i < sub.length()) {
                                    Tree_.this.addSubNode(selNode, sub.getJSONObject(i));
                                    ++i;
                                }
                            }
                        }
                    }
                }

                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                }
            });
        }
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                if (selNode == null) {
                    return;
                }
                Object v = selNode.getUserObject();
                if (v == null) {
                    return;
                }
                if (v instanceof TreeData) {
                    ((TreeData)v).expanded = true;
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                WorkSheet sheet;
                Cell pCell = Tree_.this.getParentCell();
                if (pCell != null && (sheet = pCell.getWorkSheet()).isDesignMode()) {
                    sheet.setSelection(pCell);
                    sheet.getWorkBook().getEM().fireCellFocusGained(sheet, pCell.getRowIndex(), pCell.getColumnIndex());
                }
            }
        });
        Border border = BorderFactory.createLineBorder(new Color(0x808080), 1);
        this.jScrollPane.getViewport().add(this.tree);
        this.jScrollPane.setBorder(border);
        this.panel.setLayout(new BorderLayout());
        this.panel.setBackground(Color.white);
        JPanel topPanel = new JPanel();
        BorderLayout bl = new BorderLayout();
        topPanel.setLayout(bl);
        bl.setHgap(4);
        topPanel.setBackground(Color.white);
        JLabel st = new JLabel("");
        st.setPreferredSize(new Dimension(2, 2));
        st.setFont(new Font("\u5b8b\u4f53", 0, 12));
        topPanel.add((Component)st, "South");
        JPanel topToolbarPanel = new JPanel();
        topToolbarPanel.setLayout(new FlowLayout());
        JLabel cb_expand = new JLabel("");
        cb_expand.setIcon(new ImageIcon(Tools.GetImageFromURL(v, "excel/res/expand.gif")));
        cb_expand.setToolTipText("\u5168\u90e8\u5c55\u5f00");
        cb_expand.setCursor(new Cursor(12));
        cb_expand.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Tree_.this.expandAll();
            }
        });
        topToolbarPanel.add(cb_expand);
        JLabel cb_collpesc = new JLabel("");
        cb_collpesc.setIcon(new ImageIcon(Tools.GetImageFromURL(v, "excel/res/collpesc.gif")));
        cb_collpesc.setToolTipText("\u5168\u90e8\u6536\u62e2");
        cb_collpesc.setCursor(new Cursor(12));
        cb_collpesc.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Tree_.this.collpescAll();
            }
        });
        topToolbarPanel.add(cb_collpesc);
        if (this.dataGroup.size() > 1) {
            JLabel cb = new JLabel("");
            cb.setIcon(new ImageIcon(Tools.GetImageFromURL(v, "excel/res/menu.gif")));
            cb.setToolTipText("\u6309\u7c7b\u578b\u8fc7\u6ee4");
            cb.setCursor(new Cursor(12));
            cb.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Point me = e.getPoint();
                    JPopupMenu popupMenu = new JPopupMenu("popup");
                    Border border = BorderFactory.createLineBorder(new Color(88, 88, 103));
                    popupMenu.setBorder(border);
                    int i = 0;
                    while (i < Tree_.this.dataGroup.size()) {
                        JMenuItem mi = new JMenuItem(Tree_.this.dataGroup.get(i));
                        mi.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                (this).Tree_.this.currentDataGroup = ((JMenuItem)e.getSource()).getText();
                                Tree_.this.filter((this).Tree_.this.inputKey.getText());
                            }
                        });
                        popupMenu.add(mi);
                        ++i;
                    }
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            });
            topToolbarPanel.add(cb);
        }
        JLabel cb_refresh = new JLabel("");
        cb_refresh.setIcon(new ImageIcon(Tools.GetImageFromURL(v, "excel/res/refresh.gif")));
        cb_refresh.setToolTipText("\u91cd\u5efa\u6811\u7ed3\u6784");
        cb_refresh.setCursor(new Cursor(12));
        cb_refresh.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Tree_.this.reLoad();
            }
        });
        topToolbarPanel.setOpaque(true);
        topToolbarPanel.setBackground(Color.white);
        topToolbarPanel.add(cb_refresh);
        topPanel.add((Component)topToolbarPanel, "East");
        this.zoom = Tools.GetImageFromURL(v, "excel/img/search5.gif");
        this.inputKey = new JTextField(){

            public void paint(Graphics g) {
                Rectangle rc = this.getBounds();
                super.paint(g);
                g.setFont(new Font("\u5b8b\u4f53", 0, 12));
                g.setColor(Color.LIGHT_GRAY);
                if (this.getText().equals("")) {
                    g.drawString("\u8f93\u5165\u5185\u5bb9\u5373\u65f6\u8fc7\u6ee4", rc.x + 3, rc.y + 14);
                }
            }
        };
        this.inputKey.setPreferredSize(new Dimension(16, 20));
        this.inputKey.setBorder(border);
        topPanel.add((Component)this.inputKey, "Center");
        this.panel.add((Component)topPanel, "North");
        this.panel.add((Component)this.jScrollPane, "Center");
        this.panel.setFocusable(true);
        this.mouseEvent = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Tree_.this.pCell.getWorkSheet().getWorkBook().getWorkBookView().forceCurrentEditControlGiveUpFocus();
                if (e.getSource() instanceof Component) {
                    ((Component)e.getSource()).requestFocus();
                }
            }
        };
        this.tree.addMouseListener(this.mouseEvent);
        this.tree.setCursor(new Cursor(0));
        this.jScrollPane.addMouseListener(this.mouseEvent);
        this.inputKey.addMouseListener(this.mouseEvent);
        this.inputKey.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String t = Tree_.this.inputKey.getText();
                Tree_.this.filter(t);
            }
        });
    }

    @Override
    public void setRootLabel(String label) {
        super.setRootLabel(label);
        this.root.setUserObject(new TreeData(this.provider.parseRootValue(this.rootValue), "", "", this.currentDataGroup.equals("") ? label : this.currentDataGroup, ""));
        ((TreeData)this.root.getUserObject()).expanded = true;
    }

    @Override
    public void unBind() {
        if (this.addToSheetView) {
            WorkSheetView v = this.getWorkSheetView();
            if (v == null) {
                return;
            }
            this.addToSheetView = false;
            v.remove(this.panel);
        }
    }

    @Override
    public void reLoad() {
        if (this.provider == null) {
            return;
        }
        this.group2Data.clear();
        this.filter(this.inputKey.getText());
    }

    @Override
    public void expandAll() {
        Tree_.expandAll(this.tree, new TreePath(this.root), true);
    }

    @Override
    public void collpescAll() {
        Tree_.expandAll(this.tree, new TreePath(this.root), false);
        this.tree.expandPath(new TreePath(this.root));
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                Tree_.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public void filter(String key) {
        JSONArray data = this.group2Data.get(this.currentDataGroup);
        if (data == null) {
            data = this.cacheData(this.currentDataGroup);
        }
        key = key.toLowerCase();
        int i = 0;
        while (i < data.length()) {
            this.checkVisible(data.getJSONObject(i), key);
            ++i;
        }
        this.root.removeAllChildren();
        this.root.setUserObject(new TreeData(this.provider.parseRootValue(this.rootValue), "", "", this.currentDataGroup.equals("") ? this.rootLabel : this.currentDataGroup, ""));
        ((TreeData)this.root.getUserObject()).expanded = true;
        i = 0;
        while (i < data.length()) {
            this.addSubNode(this.root, data.getJSONObject(i));
            ++i;
        }
        DefaultTreeModel dtm = new DefaultTreeModel(this.root);
        this.tree.setModel(dtm);
        if (!key.equals("")) {
            Tree_.expandAll(this.tree, new TreePath(this.root), true);
        }
    }

    private boolean checkVisible(JSONObject obj, String key) {
        JSONArray sub = obj.getJSONArray("subitems", null);
        String text = obj.getString("text", "");
        String id = obj.getString("id", "");
        String data = obj.getString("value", "");
        String group = obj.getString("group", "");
        String keys = obj.getString("keys", "");
        boolean visible = true;
        if (!key.equals("")) {
            boolean bl = visible = text.toLowerCase().indexOf(key) >= 0 || id.toLowerCase().indexOf(key) >= 0 || data.toLowerCase().indexOf(key) >= 0 || keys.toLowerCase().indexOf(key) >= 0;
        }
        if (sub != null) {
            int i = 0;
            while (i < sub.length()) {
                if (this.checkVisible(sub.getJSONObject(i), key)) {
                    visible = true;
                }
                ++i;
            }
        }
        obj.put("visible", visible);
        return visible;
    }

    @Override
    public void paint(boolean isPrint, Graphics2D g, Rectangle parentRC) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.addToSheetView) {
            WorkSheetView v = this.getWorkSheetView();
            if (v == null) {
                return;
            }
            this.addToSheetView = true;
            v.add(this.panel);
        }
        Rectangle rc = this.getBounds(parentRC);
        Shape oc = g.getClip();
        try {
            try {
                Tools.clip(g, rc);
                Rectangle rc2 = new Rectangle(rc.x, rc.y, rc.width + 1, rc.height + 1);
                this.panel.setBounds(rc2);
                this.panel.doLayout();
                this.panel.validate();
            }
            catch (Exception exception) {
                Tools.setClip(g, oc);
            }
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    public void addSubNode(DefaultMutableTreeNode pnode, JSONObject jsData) {
        JSONArray sub = jsData.getJSONArray("subitems", null);
        String text = jsData.getString("text", "");
        String group = jsData.getString("group", "");
        String id = jsData.getString("id", "");
        String pid = jsData.getString("pid", "");
        boolean visible = jsData.getBoolean("visible", true);
        if (!visible) {
            return;
        }
        boolean allowsChildren = sub != null;
        int childrencount = jsData.getInt("childrencount", 0);
        if (childrencount > 0) {
            allowsChildren = true;
        }
        DefaultMutableTreeNode node = this.isMulti ? new CheckBoxTreeNode(text, allowsChildren) : new DefaultMutableTreeNode(text, allowsChildren);
        Object value = jsData.getMap().get("value");
        if (value == null) {
            value = "";
        }
        value = value.toString();
        TreeData itemData = null;
        if (jsData.getMap().containsKey("innerdata")) {
            itemData = (TreeData)jsData.get("innerdata", null);
        }
        if (itemData == null) {
            itemData = new TreeData(id, pid, group, text, (String)value);
            jsData.put("innerdata", (Object)itemData);
        }
        itemData.sourceData = jsData;
        node.setUserObject(itemData);
        pnode.add(node);
        if (childrencount > 0 && sub == null) {
            DefaultMutableTreeNode tempNode = new DefaultMutableTreeNode("\u4e34\u65f6", false);
            node.add(tempNode);
        }
        if (sub != null) {
            int i = 0;
            while (i < sub.length()) {
                this.addSubNode(node, sub.getJSONObject(i));
                ++i;
            }
        }
    }

    @Override
    public String getCurrentGroup() {
        return this.currentDataGroup;
    }

    @Override
    public void setCurrentGroup(String group) {
        if (group == null) {
            return;
        }
        if (group.equals("")) {
            return;
        }
        if (group.equals(this.currentDataGroup)) {
            return;
        }
        this.currentDataGroup = group;
        this.filter(this.inputKey.getText());
    }

    @Override
    public String getFilter() {
        return this.inputKey.getText();
    }

    @Override
    public void setFilter(String key) {
        if (this.inputKey.getText().equals(key)) {
            return;
        }
        this.inputKey.setText(key);
        this.filter(key);
    }

    @Override
    public void setValue(Object v) {
        if (v == null) {
            return;
        }
        if (this.isMultiSelection()) {
            JSONArray ja;
            if (v.toString().startsWith("[")) {
                ja = new JSONArray(v.toString());
            } else {
                ja = new JSONArray();
                ja.put(v);
            }
            this.setMoreValue(ja);
        } else {
            this.setOneValue(v);
        }
        this.tree.repaint();
    }

    private void setOneValue(Object v) {
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (v == null) {
            this.tree.setSelectionPath(new TreePath(this.root));
            return;
        }
        String vs = v.toString();
        DefaultMutableTreeNode node = this.findNode(this.root, vs);
        if (node != null) {
            TreePath tp = new TreePath(node.getPath());
            this.tree.expandPath(tp);
            this.tree.setSelectionPath(tp);
        }
    }

    private void setMoreValue(JSONArray ja) {
        ArrayList<String> slist;
        ArrayList<String> list = ja.getArrayList();
        if (list.size() > 0) {
            if (list.get(0) instanceof String) {
                slist = list;
            } else {
                slist = new ArrayList<String>();
                int i = 0;
                while (i < list.size()) {
                    slist.add(list.get(i).toString());
                    ++i;
                }
            }
        } else {
            slist = list;
        }
        this.selectNode((CheckBoxTreeNode)this.root, slist);
    }

    public void selectNode(CheckBoxTreeNode parentNode, ArrayList selectedData) {
        Object v = parentNode.getUserObject();
        if (v instanceof TreeData) {
            TreeData td = (TreeData)v;
            parentNode.setSelected(selectedData.contains(td.data), true);
        }
        int n = parentNode.getChildCount();
        int i = 0;
        while (i < n) {
            CheckBoxTreeNode node = (CheckBoxTreeNode)parentNode.getChildAt(i);
            this.selectNode(node, selectedData);
            ++i;
        }
    }

    public DefaultMutableTreeNode findNode(DefaultMutableTreeNode parentNode, String data) {
        Object v = parentNode.getUserObject();
        if (v instanceof TreeData) {
            TreeData td = (TreeData)v;
            if (td.data.equals(data)) {
                return parentNode;
            }
        }
        int n = parentNode.getChildCount();
        int i = 0;
        while (i < n) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            DefaultMutableTreeNode ret = this.findNode(node, data);
            if (ret != null) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object getValue() {
        if (!this.isMulti) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (selNode == null) {
                return null;
            }
            Object v = selNode.getUserObject();
            if (v == null) {
                return null;
            }
            if (v instanceof TreeData) {
                TreeData d = (TreeData)v;
                return d.data;
            }
            return null;
        }
        CheckBoxTreeNode rootNode = (CheckBoxTreeNode)this.tree.getModel().getRoot();
        ArrayList<Object> checkedNodes = new ArrayList<Object>();
        this.getCheckedNodes(rootNode, checkedNodes);
        return checkedNodes;
    }

    public void getCheckedNodes(CheckBoxTreeNode node, List<Object> checkedNodes) {
        Object v;
        if (node.isSelected() && (v = node.getUserObject()) != null) {
            if (v instanceof TreeData) {
                TreeData d = (TreeData)v;
                checkedNodes.add(d.data);
            } else {
                checkedNodes.add(v);
            }
        }
        int cn = node.getChildCount();
        int i = 0;
        while (i < cn) {
            TreeNode treeNode = node.getChildAt(i);
            this.getCheckedNodes((CheckBoxTreeNode)treeNode, checkedNodes);
            ++i;
        }
    }

    @Override
    public void setMultiSelection(boolean m) {
        if (this.isMulti == m) {
            return;
        }
        this.isMulti = m;
        this.root = this.isMulti ? new CheckBoxTreeNode(this.currentDataGroup.equals("") ? this.rootCaption : this.currentDataGroup, true) : new DefaultMutableTreeNode(this.currentDataGroup.equals("") ? this.rootCaption : this.currentDataGroup, true);
        String rv = this.provider.parseRootValue(this.rootValue);
        this.root.setUserObject(new TreeData(rv, "", "", this.currentDataGroup.equals("") ? this.rootCaption : this.currentDataGroup, rv));
        ((TreeData)this.root.getUserObject()).expanded = true;
        if (this.lastMouseListener != null) {
            this.tree.removeMouseListener(this.lastMouseListener);
        }
        if (this.lastTreeSelectionListener != null) {
            this.tree.removeTreeSelectionListener(this.lastTreeSelectionListener);
        }
        if (this.isMulti) {
            this.lastMouseListener = new CheckBoxTreeNodeSelectionListener(this);
            this.tree.addMouseListener(this.lastMouseListener);
            this.tree.setCellRenderer(new CheckBoxTreeCellRenderer(this.pView));
        } else {
            this.tree.setCellRenderer(new EnhancedTreeCellRenderer(this.pView));
            this.lastTreeSelectionListener = new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)Tree_.this.tree.getLastSelectedPathComponent();
                    if (selNode == null) {
                        return;
                    }
                    Object v = selNode.getUserObject();
                    if (v == null) {
                        return;
                    }
                    if (v instanceof TreeData) {
                        TreeData d = (TreeData)v;
                        Tree_.this.getWorkSheetView().getWorkSheet().getWorkBook().getEM().fireOnTreeSelectionChanged(Tree_.this.getName(), d.type, d.caption, d.data);
                    }
                }
            };
            this.tree.addTreeSelectionListener(this.lastTreeSelectionListener);
        }
        this.reLoad();
    }
}

