/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.ecc;

public class BCH15_5 {
    int[][] gf16 = this.createGF16();
    boolean[] receiveData;
    int numCorrectedError;
    static String[] bitName = new String[]{"c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "d0", "d1", "d2", "d3", "d4"};

    public BCH15_5(boolean[] blArray) {
        this.receiveData = blArray;
    }

    public boolean[] correct() {
        int[] nArray = this.calcSyndrome(this.receiveData);
        int[] nArray2 = this.detectErrorBitPosition(nArray);
        boolean[] blArray = this.correctErrorBit(this.receiveData, nArray2);
        return blArray;
    }

    int[][] createGF16() {
        int n;
        this.gf16 = new int[16][4];
        int[] nArray = new int[]{1, 1, 0, 0};
        for (n = 0; n < 4; ++n) {
            this.gf16[n][n] = 1;
        }
        for (n = 0; n < 4; ++n) {
            this.gf16[4][n] = nArray[n];
        }
        for (n = 5; n < 16; ++n) {
            int n2;
            for (n2 = 1; n2 < 4; ++n2) {
                this.gf16[n][n2] = this.gf16[n - 1][n2 - 1];
            }
            if (this.gf16[n - 1][3] != 1) continue;
            for (n2 = 0; n2 < 4; ++n2) {
                this.gf16[n][n2] = (this.gf16[n][n2] + nArray[n2]) % 2;
            }
        }
        return this.gf16;
    }

    int searchElement(int[] nArray) {
        int n;
        for (n = 0; n < 15 && (nArray[0] != this.gf16[n][0] || nArray[1] != this.gf16[n][1] || nArray[2] != this.gf16[n][2] || nArray[3] != this.gf16[n][3]); ++n) {
        }
        return n;
    }

    int[] getCode(int n) {
        int[] nArray = new int[15];
        int[] nArray2 = new int[8];
        for (int i = 0; i < 15; ++i) {
            int n2;
            int n3;
            int n4 = nArray2[7];
            if (i < 7) {
                n3 = (n >> 6 - i) % 2;
                n2 = (n3 + n4) % 2;
            } else {
                n3 = n4;
                n2 = 0;
            }
            nArray2[7] = (nArray2[6] + n2) % 2;
            nArray2[6] = (nArray2[5] + n2) % 2;
            nArray2[5] = nArray2[4];
            nArray2[4] = (nArray2[3] + n2) % 2;
            nArray2[3] = nArray2[2];
            nArray2[2] = nArray2[1];
            nArray2[1] = nArray2[0];
            nArray2[0] = n2;
            nArray[14 - i] = n3;
        }
        return nArray;
    }

    int addGF(int n, int n2) {
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            int n3 = n < 0 || n >= 15 ? 0 : this.gf16[n][i];
            int n4 = n2 < 0 || n2 >= 15 ? 0 : this.gf16[n2][i];
            nArray[i] = (n3 + n4) % 2;
        }
        return this.searchElement(nArray);
    }

    int[] calcSyndrome(boolean[] blArray) {
        int n;
        int n2;
        int[] nArray = new int[5];
        int[] nArray2 = new int[4];
        for (n2 = 0; n2 < 15; ++n2) {
            if (!blArray[n2]) continue;
            for (n = 0; n < 4; ++n) {
                nArray2[n] = (nArray2[n] + this.gf16[n2][n]) % 2;
            }
        }
        n2 = this.searchElement(nArray2);
        nArray[0] = n2 >= 15 ? -1 : n2;
        nArray[1] = nArray[0] < 0 ? -1 : nArray[0] * 2 % 15;
        nArray2 = new int[4];
        for (n2 = 0; n2 < 15; ++n2) {
            if (!blArray[n2]) continue;
            for (n = 0; n < 4; ++n) {
                nArray2[n] = (nArray2[n] + this.gf16[n2 * 3 % 15][n]) % 2;
            }
        }
        n2 = this.searchElement(nArray2);
        nArray[2] = n2 >= 15 ? -1 : n2;
        nArray[3] = nArray[1] < 0 ? -1 : nArray[1] * 2 % 15;
        nArray2 = new int[4];
        for (n2 = 0; n2 < 15; ++n2) {
            if (!blArray[n2]) continue;
            for (n = 0; n < 4; ++n) {
                nArray2[n] = (nArray2[n] + this.gf16[n2 * 5 % 15][n]) % 2;
            }
        }
        n2 = this.searchElement(nArray2);
        nArray[4] = n2 >= 15 ? -1 : n2;
        return nArray;
    }

    int[] calcErrorPositionVariable(int[] nArray) {
        int[] nArray2 = new int[4];
        nArray2[0] = nArray[0];
        int n = (nArray[0] + nArray[1]) % 15;
        int n2 = this.addGF(nArray[2], n);
        n2 = n2 >= 15 ? -1 : n2;
        n = (nArray[2] + nArray[1]) % 15;
        int n3 = this.addGF(nArray[4], n);
        n3 = n3 >= 15 ? -1 : n3;
        nArray2[1] = n3 < 0 && n2 < 0 ? -1 : (n3 - n2 + 15) % 15;
        n = (nArray[1] + nArray2[0]) % 15;
        int n4 = this.addGF(nArray[2], n);
        n = (nArray[0] + nArray2[1]) % 15;
        nArray2[2] = this.addGF(n4, n);
        return nArray2;
    }

    int[] detectErrorBitPosition(int[] nArray) {
        int[] nArray2 = this.calcErrorPositionVariable(nArray);
        int[] nArray3 = new int[4];
        if (nArray2[0] == -1) {
            return nArray3;
        }
        if (nArray2[1] == -1) {
            nArray3[0] = 1;
            nArray3[1] = nArray2[0];
            return nArray3;
        }
        for (int i = 0; i < 15; ++i) {
            int n;
            int n2 = i * 3 % 15;
            int n3 = i * 2 % 15;
            int n4 = i;
            int n5 = (nArray2[0] + n3) % 15;
            int n6 = this.addGF(n2, n5);
            int n7 = this.addGF(n6, n = this.addGF(n5 = (nArray2[1] + n4) % 15, nArray2[2]));
            if (n7 < 15) continue;
            nArray3[0] = nArray3[0] + 1;
            nArray3[nArray3[0]] = i;
        }
        return nArray3;
    }

    boolean[] correctErrorBit(boolean[] blArray, int[] nArray) {
        for (int i = 1; i <= nArray[0]; ++i) {
            blArray[nArray[i]] = !blArray[nArray[i]];
        }
        this.numCorrectedError = nArray[0];
        return blArray;
    }

    public int getNumCorrectedError() {
        return this.numCorrectedError;
    }
}

