/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.geom;

import jp.sourceforge.qrcode.util.QRCodeUtility;

public class Point {
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int TOP = 8;
    int x;
    int y;

    public Point() {
        this.x = 0;
        this.y = 0;
    }

    public Point(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public void set(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public static Point getCenter(Point point, Point point2) {
        return new Point((point.getX() + point2.getX()) / 2, (point.getY() + point2.getY()) / 2);
    }

    public boolean equals(Point point) {
        return this.x == point.x && this.y == point.y;
    }

    public int distanceOf(Point point) {
        int n = point.getX();
        int n2 = point.getY();
        return QRCodeUtility.sqrt((this.x - n) * (this.x - n) + (this.y - n2) * (this.y - n2));
    }
}

