/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;
import sos.preview.FitAllLayoutFormat;
import sos.preview.FitLayoutFormat;
import sos.preview.JPrintPreviewPane;
import sos.preview.JPrintPreviewPaneUtilities;
import sos.preview.MatrixLayoutFormat;
import sos.preview.SeparatorComboBoxModel;
import sos.preview.SeparatorListCellRenderer;
import sos.preview.Utility;
import sos.preview.ZoomLayoutFormat;

public class PrintPreviewSupport {
    public static final int ZOOM = 0;
    public static final int ZOOM_IN_OUT = 1;
    public static final int ZOOM_IN_OUT_TOGGLE = 2;
    public static final int ZOOM_TOGGLE = 3;
    private static NumberFormat zoomFormat;
    private JPrintPreviewPane printPreviewPane;
    private boolean large;
    private int currentPageIndex;
    private NumberFormatter formatter;
    private PageableFactory pageableFactory;
    private JButton printButton;
    private Action printAction;
    private JButton printAllButton;
    private Action printAllAction;
    private Action pageSetupAction;
    private JButton pageSetupButton;
    private Action closeAction;
    private JButton closeButton;
    private Action zoomToggleAction;
    private JToggleButton zoomToggleButton;
    private Action zoomInAction;
    private JButton zoomInButton;
    private Action zoomInToggleAction;
    private JToggleButton zoomInToggleButton;
    private Action zoomOutAction;
    private JButton zoomOutButton;
    private Action zoomOutToggleAction;
    private JToggleButton zoomOutToggleButton;
    private ButtonGroup zoomInOutToggleGroup;
    private JFormattedTextField pageField;
    private Action nextPageAction;
    private JButton nextPageButton;
    private Action previousPageAction;
    private JButton previousPageButton;
    private Action firstPageAction;
    private JButton firstPageButton;
    private Action lastPageAction;
    private JButton lastPageButton;
    private JComboBox zoomComboBox;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrintPreviewSupport(JPrintPreviewPane jprintpreviewpane, boolean flag) {
        block7: {
            Enumeration<String> enumeration;
            ResourceBundle resourcebundle1;
            zoomFormat = NumberFormat.getPercentInstance();
            if (zoomFormat instanceof DecimalFormat) {
                DecimalFormat decimalformat = (DecimalFormat)zoomFormat;
                decimalformat.setMaximumFractionDigits(0);
            }
            UIDefaults uidefaults = UIManager.getDefaults();
            try {
                ResourceBundle resourcebundle = ResourceBundle.getBundle("sos.preview.PrintPreview", Locale.getDefault(), ClassLoader.getSystemClassLoader());
                uidefaults.addResourceBundle("sos.preview.PrintPreview");
                break block7;
            }
            catch (Exception exception) {
                Locale locale = Locale.getDefault();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("sos.preview.JPrintPreviewPane");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                resourcebundle1 = ResourceBundle.getBundle("sos.preview.PrintPreview", locale, clazz.getClassLoader());
                enumeration = resourcebundle1.getKeys();
            }
            while (enumeration.hasMoreElements()) {
                String s = enumeration.nextElement();
                Object obj = resourcebundle1.getObject(s);
                uidefaults.put(s, obj);
            }
        }
        this.currentPageIndex = 0;
        this.printPreviewPane = jprintpreviewpane;
        this.large = flag;
        PropertyChangeListener propertychangelistener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertychangeevent) {
                block23: {
                    String s;
                    block24: {
                        block22: {
                            s = propertychangeevent.getPropertyName();
                            if (!"scale".equals(s)) break block22;
                            if (PrintPreviewSupport.this.zoomComboBox == null || !PrintPreviewSupport.this.zoomComboBox.isEditable()) {
                                return;
                            }
                            LayoutManager layoutmanager = PrintPreviewSupport.this.printPreviewPane.getLayout();
                            PrintPreviewSupport.this.zoomComboBox.setSelectedItem(layoutmanager);
                            break block23;
                        }
                        if (!"mode".equals(s)) break block24;
                        Integer integer = (Integer)propertychangeevent.getOldValue();
                        int i = integer;
                        Integer integer1 = (Integer)propertychangeevent.getNewValue();
                        int k = integer1;
                        switch (i) {
                            case 1: {
                                if (PrintPreviewSupport.this.zoomToggleButton == null) break;
                                PrintPreviewSupport.this.zoomToggleButton.setSelected(false);
                                break;
                            }
                            case 2: {
                                if (PrintPreviewSupport.this.zoomInToggleButton == null) break;
                                PrintPreviewSupport.this.zoomInToggleButton.setSelected(false);
                                break;
                            }
                            case 3: {
                                if (PrintPreviewSupport.this.zoomOutToggleButton == null) break;
                                PrintPreviewSupport.this.zoomOutToggleButton.setSelected(false);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("Unrecognized print preview mode: " + i));
                            }
                            case 0: 
                        }
                        switch (k) {
                            case 1: {
                                if (PrintPreviewSupport.this.zoomToggleButton != null) {
                                    PrintPreviewSupport.this.zoomToggleButton.setSelected(true);
                                    break;
                                }
                                break block23;
                            }
                            case 2: {
                                if (PrintPreviewSupport.this.zoomInToggleButton != null) {
                                    PrintPreviewSupport.this.zoomInToggleButton.setSelected(true);
                                    break;
                                }
                                break block23;
                            }
                            case 3: {
                                if (PrintPreviewSupport.this.zoomOutToggleButton != null) {
                                    PrintPreviewSupport.this.zoomOutToggleButton.setSelected(true);
                                    break;
                                }
                                break block23;
                            }
                            default: {
                                throw new AssertionError((Object)("Unrecognized print preview mode: " + k));
                            }
                            case 0: {
                                break;
                            }
                        }
                        break block23;
                    }
                    if ("pageable".equals(s)) {
                        Pageable pageable = (Pageable)propertychangeevent.getNewValue();
                        int j = pageable.getNumberOfPages();
                        if (j <= PrintPreviewSupport.this.currentPageIndex) {
                            PrintPreviewSupport.this.setCurrentPageIndex(-1);
                        }
                        if (PrintPreviewSupport.this.formatter != null) {
                            PrintPreviewSupport.this.formatter.setMaximum(new Integer(j));
                        }
                    } else if ("layout".equals(s)) {
                        if (PrintPreviewSupport.this.zoomComboBox == null) {
                            return;
                        }
                        Object obj = propertychangeevent.getNewValue();
                        PrintPreviewSupport.this.zoomComboBox.setSelectedItem(obj);
                    }
                }
            }
        };
        jprintpreviewpane.addPropertyChangeListener(propertychangelistener);
    }

    private void addPrintButton(JToolBar jtoolbar, boolean flag) {
        JButton jbutton = flag ? this.getPrintButton() : this.getPrintAllButton();
        jtoolbar.add(jbutton);
    }

    private Action createAction(String s) {
        try {
            String s1 = "sos.preview.PrintPreviewSupport$" + s + "Action";
            Class<?> class1 = Class.forName(s1);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("sos.preview.PrintPreviewSupport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor<?> constructor = class1.getDeclaredConstructor(classArray);
            Action action = (Action)constructor.newInstance(this);
            String s2 = "get" + s + "Text";
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("sos.preview.PrintPreviewSupport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method method = clazz2.getDeclaredMethod(s2, null);
            String s3 = (String)method.invoke((Object)this, null);
            action.putValue("Name", s3);
            String s4 = "get" + s + "Icon";
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("sos.preview.PrintPreviewSupport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method method1 = clazz3.getDeclaredMethod(s4, null);
            Icon icon = (Icon)method1.invoke((Object)this, null);
            action.putValue("SmallIcon", icon);
            String s5 = "get" + s + "ToolTip";
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("sos.preview.PrintPreviewSupport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method method2 = clazz4.getDeclaredMethod(s5, null);
            String s6 = (String)method2.invoke((Object)this, null);
            action.putValue("ShortDescription", s6);
            String s7 = "get" + s + "Mnemonic";
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = class$1 = Class.forName("sos.preview.PrintPreviewSupport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method method3 = clazz5.getDeclaredMethod(s7, null);
            Integer integer = (Integer)method3.invoke((Object)this, null);
            action.putValue("MnemonicKey", integer);
            return action;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    protected JButton createButton(Action action) {
        return new JButton(action);
    }

    protected Action createFirstPageAction() {
        Action action = this.createAction("FirstPage");
        action.setEnabled(false);
        return action;
    }

    protected Action createLastPageAction() {
        Action action = this.createAction("LastPage");
        Pageable pageable = this.printPreviewPane.getPageable();
        int i = pageable.getNumberOfPages();
        if (i <= 1) {
            action.setEnabled(false);
        }
        return action;
    }

    protected Action createNextPageAction() {
        Action action = this.createAction("NextPage");
        Pageable pageable = this.printPreviewPane.getPageable();
        int i = pageable.getNumberOfPages();
        if (i <= 1) {
            action.setEnabled(false);
        }
        return action;
    }

    protected JFormattedTextField createPageField() {
        Pageable pageable = this.printPreviewPane.getPageable();
        NumberFormat numberformat = NumberFormat.getIntegerInstance();
        this.formatter = new NumberFormatter(numberformat);
        this.formatter.setMinimum(new Integer(1));
        this.formatter.setMaximum(new Integer(pageable.getNumberOfPages()));
        final JFormattedTextField field = new JFormattedTextField(this.formatter);
        field.setHorizontalAlignment(0);
        field.setValue(new Integer(1));
        field.setColumns(4);
        field.setMaximumSize(field.getPreferredSize());
        field.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusevent) {
                SwingUtilities.invokeLater(new Runnable(this, field){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ JFormattedTextField val$field;
                    {
                        this.this$1 = var1_1;
                        this.val$field = jFormattedTextField;
                    }

                    public void run() {
                        this.val$field.selectAll();
                    }
                });
            }
        });
        field.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        field.getActionMap().put("check", new AbstractAction(){

            public void actionPerformed(ActionEvent actionevent) {
                if (!field.isEditValid()) {
                    LookAndFeel lookandfeel = UIManager.getLookAndFeel();
                    lookandfeel.provideErrorFeedback(field);
                    field.selectAll();
                } else {
                    try {
                        field.commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
        field.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertychangeevent) {
                Number number = (Number)propertychangeevent.getNewValue();
                int i = number.intValue();
                PrintPreviewSupport.this.setCurrentPageIndex(i - 1);
                PrintPreviewSupport.this.printPreviewPane.centerPage(PrintPreviewSupport.this.currentPageIndex);
            }
        });
        String s = this.getPageFieldToolTip();
        field.setToolTipText(s);
        return field;
    }

    protected Action createPageSetupAction(PageableFactory pageablefactory) {
        this.pageableFactory = pageablefactory;
        return this.createAction("PageSetup");
    }

    public static JPanel createNavigationPanel(PageableFactory pageablefactory, boolean flag, Action action, boolean flag1) throws NullPointerException {
        PageFormat pageformat = new PageFormat();
        Pageable pageable = pageablefactory.createPageable(pageformat);
        return PrintPreviewSupport.createNavigationPanel(flag, pageable, pageablefactory, action, flag1);
    }

    public static JPanel createNavigationPanel(Pageable pageable, boolean flag, Action action, boolean flag1) {
        return PrintPreviewSupport.createNavigationPanel(flag, pageable, null, action, flag1);
    }

    private static JPanel createNavigationPanel(boolean flag, Pageable pageable, PageableFactory pageablefactory, Action action, boolean flag1) {
        JPanel jpanel = new JPanel(new BorderLayout());
        JPrintPreviewPane jprintpreviewpane = new JPrintPreviewPane(pageable);
        JPrintPreviewPaneUtilities printpreviewpaneui = jprintpreviewpane.getUtility();
        LayoutManager layoutmanager = printpreviewpaneui.createMatrixLayout(jprintpreviewpane, 1, 1);
        jprintpreviewpane.setLayout(layoutmanager);
        jprintpreviewpane.setPageNumbersAreShown(false);
        jprintpreviewpane.setPageSelectionAllowed(false);
        PrintPreviewSupport printpreviewsupport = new PrintPreviewSupport(jprintpreviewpane, flag1);
        JToolBar jtoolbar = new JToolBar();
        printpreviewsupport.addPrintButton(jtoolbar, flag);
        jtoolbar.addSeparator();
        if (pageablefactory != null) {
            JButton jbutton = printpreviewsupport.getPageSetupButton(pageablefactory);
            jtoolbar.add(jbutton);
            jtoolbar.addSeparator();
        }
        JButton jbutton1 = printpreviewsupport.getFirstPageButton();
        jbutton1.setText("");
        jtoolbar.add(jbutton1);
        JButton jbutton2 = printpreviewsupport.getPreviousPageButton();
        jbutton2.setText("");
        jtoolbar.add(jbutton2);
        jtoolbar.addSeparator();
        JFormattedTextField jformattedtextfield = printpreviewsupport.getPageField();
        jtoolbar.add(jformattedtextfield);
        jtoolbar.addSeparator();
        JButton jbutton3 = printpreviewsupport.getNextPageButton();
        jbutton3.setText("");
        jtoolbar.add(jbutton3);
        JButton jbutton4 = printpreviewsupport.getLastPageButton();
        jbutton4.setText("");
        jtoolbar.add(jbutton4);
        jtoolbar.addSeparator();
        JButton jbutton5 = printpreviewsupport.getCloseButton(action);
        jtoolbar.add(jbutton5);
        jpanel.add((Component)jtoolbar, "First");
        JScrollPane jscrollpane = new JScrollPane(jprintpreviewpane, 21, 31);
        jpanel.add((Component)jscrollpane, "Center");
        return jpanel;
    }

    protected Action createPreviousPageAction() {
        Action action = this.createAction("PreviousPage");
        action.setEnabled(false);
        return action;
    }

    protected Action createPrintAction() {
        return this.createAction("Print");
    }

    protected Action createPrintAllAction() {
        return this.createAction("PrintAll");
    }

    protected JToggleButton createToggleButton(Action action) {
        return new JToggleButton(action);
    }

    public static JPanel createZoomPanel(PageableFactory pageablefactory, boolean flag, int i, Action action, boolean flag1) throws IllegalArgumentException, NullPointerException {
        PageFormat pageformat = new PageFormat();
        Pageable pageable = pageablefactory.createPageable(pageformat);
        return PrintPreviewSupport.createZoomPanel(flag, pageable, pageablefactory, action, flag1, i);
    }

    public static JPanel createZoomPanel(Pageable pageable, boolean flag, int i, Action action, boolean flag1) throws IllegalArgumentException, NullPointerException {
        return PrintPreviewSupport.createZoomPanel(flag, pageable, null, action, flag1, i);
    }

    private static JPanel createZoomPanel(boolean flag, Pageable pageable, PageableFactory pageablefactory, Action action, boolean flag1, int i) {
        JPanel jpanel = new JPanel(new BorderLayout());
        JPrintPreviewPane jprintpreviewpane = new JPrintPreviewPane(pageable);
        JPrintPreviewPaneUtilities printpreviewpaneui = jprintpreviewpane.getUtility();
        LayoutManager layoutmanager = printpreviewpaneui.createMatrixLayout(jprintpreviewpane, 1, 1);
        jprintpreviewpane.setLayout(layoutmanager);
        PrintPreviewSupport printpreviewsupport = new PrintPreviewSupport(jprintpreviewpane, flag1);
        JToolBar jtoolbar = new JToolBar();
        printpreviewsupport.addPrintButton(jtoolbar, flag);
        jtoolbar.addSeparator();
        if (pageablefactory != null) {
            JButton jbutton = printpreviewsupport.getPageSetupButton(pageablefactory);
            jtoolbar.add(jbutton);
            jtoolbar.addSeparator();
        }
        switch (i) {
            case 0: {
                jprintpreviewpane.setMode(1);
                break;
            }
            case 3: {
                JToggleButton jtogglebutton = printpreviewsupport.getZoomToggleButton();
                jtogglebutton.setText("");
                jtoolbar.add(jtogglebutton);
                jtoolbar.addSeparator();
                break;
            }
            case 2: {
                JToggleButton jtogglebutton1 = printpreviewsupport.getZoomInToggleButton();
                jtogglebutton1.setText("");
                jtogglebutton1.doClick();
                jtoolbar.add(jtogglebutton1);
                JToggleButton jtogglebutton2 = printpreviewsupport.getZoomOutToggleButton();
                jtogglebutton2.setText("");
                jtoolbar.add(jtogglebutton2);
                jtoolbar.addSeparator();
                break;
            }
            case 1: {
                JButton jbutton1 = printpreviewsupport.getZoomInButton();
                jbutton1.setText("");
                jtoolbar.add(jbutton1);
                JButton jbutton2 = printpreviewsupport.getZoomOutButton();
                jbutton2.setText("");
                jtoolbar.add(jbutton2);
                jtoolbar.addSeparator();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid zoomFlavor " + i);
            }
        }
        JComboBox jcombobox = printpreviewsupport.getZoomComboBox(true, true);
        jtoolbar.add(jcombobox);
        jtoolbar.addSeparator();
        JButton jbutton3 = printpreviewsupport.getCloseButton(action);
        jtoolbar.add(jbutton3);
        jpanel.add((Component)jtoolbar, "First");
        JScrollPane jscrollpane = new JScrollPane(jprintpreviewpane);
        jpanel.add((Component)jscrollpane, "Center");
        return jpanel;
    }

    protected JComboBox createZoomComboBox(boolean flag, boolean flag1) {
        final JComboBox<Object> comboBox = new JComboBox<Object>(new SeparatorComboBoxModel());
        comboBox.setEditable(flag);
        String s = this.getZoomComboBoxToolTipText();
        comboBox.setToolTipText(s);
        LinkedHashMap linkedhashmap = new LinkedHashMap();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("sos.preview.ZoomLayout");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        linkedhashmap.put(clazz, new ZoomLayoutFormat(zoomFormat));
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("sos.preview.MatrixLayout");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        linkedhashmap.put(clazz2, MatrixLayoutFormat.getInstance());
        FitLayoutFormat fl = FitLayoutFormat.getInstance();
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("sos.preview.FitLayout");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        linkedhashmap.put(clazz3, fl);
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("sos.preview.FitAllLayout");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        linkedhashmap.put(clazz4, FitAllLayoutFormat.getInstance());
        LayoutCellRenderer layoutcellrenderer = new LayoutCellRenderer(linkedhashmap);
        comboBox.setRenderer(new SeparatorListCellRenderer(layoutcellrenderer));
        ZoomFormatter zoomformatter = new ZoomFormatter(linkedhashmap);
        comboBox.setEditor(new ZoomComboBoxEditor(zoomformatter));
        HashMap hashmap = new HashMap();
        comboBox.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusevent) {
                SwingUtilities.invokeLater(new Runnable(this, comboBox){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ JComboBox val$comboBox;
                    {
                        this.this$1 = var1_1;
                        this.val$comboBox = jComboBox;
                    }

                    public void run() {
                        ComboBoxEditor comboboxeditor = this.val$comboBox.getEditor();
                        comboboxeditor.selectAll();
                    }
                });
            }
        });
        List list = this.getZoomLayouts();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            comboBox.addItem(iterator.next());
        }
        if (flag1) {
            comboBox.addItem(SeparatorListCellRenderer.SEPARATOR);
            List list1 = this.getSpecialLayouts();
            Iterator iterator1 = list1.iterator();
            while (iterator1.hasNext()) {
                comboBox.addItem(iterator1.next());
            }
        }
        comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemevent) {
                if (itemevent.getStateChange() == 1) {
                    Object obj = itemevent.getItem();
                    LayoutManager layoutmanager = (LayoutManager)obj;
                    PrintPreviewSupport.this.printPreviewPane.setLayout(layoutmanager);
                }
            }
        });
        comboBox.setMaximumSize(comboBox.getMinimumSize());
        return comboBox;
    }

    protected Action createZoomInAction() {
        return this.createAction("ZoomIn");
    }

    protected Action createZoomInToggleAction() {
        return this.createAction("ZoomInToggle");
    }

    protected Action createZoomOutAction() {
        return this.createAction("ZoomOut");
    }

    protected Action createZoomOutToggleAction() {
        return this.createAction("ZoomOutToggle");
    }

    protected Action createZoomToggleAction() {
        return this.createAction("ZoomToggle");
    }

    public JButton getCloseButton(Action action) {
        Object obj2;
        Object obj1;
        if (this.closeButton != null) {
            return this.closeButton;
        }
        Object obj = action.getValue("Name");
        if (obj == null) {
            String s = this.getCloseText();
            action.putValue("Name", s);
        }
        if ((obj1 = action.getValue("MnemonicKey")) == null) {
            int i = this.getCloseMnemonic();
            Integer integer = new Integer(i);
            action.putValue("MnemonicKey", integer);
        }
        if ((obj2 = action.getValue("ShortDescription")) == null) {
            String s1 = this.getCloseToolTip();
            action.putValue("ShortDescription", s1);
        }
        this.closeAction = action;
        this.closeButton = this.createButton(action);
        return this.closeButton;
    }

    public int getCloseMnemonic() {
        return 67;
    }

    public String getCloseText() {
        return this.lookupResource("close");
    }

    public String getCloseToolTip() {
        return this.lookupResource("close_tooltip");
    }

    public Action getFirstPageAction() {
        if (this.firstPageAction != null) {
            return this.firstPageAction;
        }
        this.firstPageAction = this.createFirstPageAction();
        return this.firstPageAction;
    }

    public JButton getFirstPageButton() {
        if (this.firstPageButton != null) {
            return this.firstPageButton;
        }
        Action action = this.getFirstPageAction();
        this.firstPageButton = this.createButton(action);
        return this.firstPageButton;
    }

    public Icon getFirstPageIcon() {
        return this.loadIcon("toolbarButtonGraphics/media/Rewind16.gif", "toolbarButtonGraphics/media/Rewind24.gif");
    }

    public int getFirstPageMnemonic() {
        return 36;
    }

    public String getFirstPageText() {
        return this.lookupResource("first_page");
    }

    public String getFirstPageToolTip() {
        return this.lookupResource("first_page_tooltip");
    }

    public boolean getLargeIconsAreUsed() {
        return this.large;
    }

    public Action getLastPageAction() {
        if (this.lastPageAction != null) {
            return this.lastPageAction;
        }
        this.lastPageAction = this.createLastPageAction();
        return this.lastPageAction;
    }

    public JButton getLastPageButton() {
        if (this.lastPageButton != null) {
            return this.lastPageButton;
        }
        Action action = this.getLastPageAction();
        this.lastPageButton = this.createButton(action);
        return this.lastPageButton;
    }

    public Icon getLastPageIcon() {
        return this.loadIcon("toolbarButtonGraphics/media/FastForward16.gif", "toolbarButtonGraphics/media/FastForward24.gif");
    }

    public int getLastPageMnemonic() {
        return 35;
    }

    public String getLastPageText() {
        return this.lookupResource("last_page");
    }

    public String getLastPageToolTip() {
        return this.lookupResource("last_page_tooltip");
    }

    public Action getNextPageAction() {
        if (this.nextPageAction != null) {
            return this.nextPageAction;
        }
        this.nextPageAction = this.createNextPageAction();
        return this.nextPageAction;
    }

    public JButton getNextPageButton() {
        if (this.nextPageButton != null) {
            return this.nextPageButton;
        }
        Action action = this.getNextPageAction();
        this.nextPageButton = this.createButton(action);
        return this.nextPageButton;
    }

    public Icon getNextPageIcon() {
        return this.loadIcon("toolbarButtonGraphics/media/StepForward16.gif", "toolbarButtonGraphics/media/StepForward24.gif");
    }

    public int getNextPageMnemonic() {
        return 39;
    }

    public String getNextPageText() {
        return this.lookupResource("next_page");
    }

    public String getNextPageToolTip() {
        return this.lookupResource("next_page_tooltip");
    }

    private PageableFactory getPageableFactory() {
        return this.pageableFactory;
    }

    public JFormattedTextField getPageField() {
        if (this.pageField != null) {
            return this.pageField;
        }
        this.pageField = this.createPageField();
        return this.pageField;
    }

    public String getPageFieldToolTip() {
        return this.lookupResource("page_field_tooltip");
    }

    public Action getPageSetupAction(PageableFactory pageablefactory) {
        if (this.pageSetupAction != null) {
            return this.pageSetupAction;
        }
        this.pageSetupAction = this.createPageSetupAction(pageablefactory);
        return this.pageSetupAction;
    }

    public JButton getPageSetupButton(PageableFactory pageablefactory) {
        if (this.pageSetupButton != null) {
            return this.pageSetupButton;
        }
        Action action = this.getPageSetupAction(pageablefactory);
        this.pageSetupButton = this.createButton(action);
        return this.pageSetupButton;
    }

    public Icon getPageSetupIcon() {
        return this.loadIcon("toolbarButtonGraphics/general/PageSetup16.gif", "toolbarButtonGraphics/general/PageSetup24.gif");
    }

    public int getPageSetupMnemonic() {
        return 71;
    }

    public String getPageSetupText() {
        return this.lookupResource("page_setup");
    }

    public String getPageSetupToolTip() {
        return this.lookupResource("page_setup_tooltip");
    }

    public Action getPreviousPageAction() {
        if (this.previousPageAction != null) {
            return this.previousPageAction;
        }
        this.previousPageAction = this.createPreviousPageAction();
        return this.previousPageAction;
    }

    public JButton getPreviousPageButton() {
        if (this.previousPageButton != null) {
            return this.previousPageButton;
        }
        Action action = this.getPreviousPageAction();
        this.previousPageButton = this.createButton(action);
        return this.previousPageButton;
    }

    public Icon getPreviousPageIcon() {
        return this.loadIcon("toolbarButtonGraphics/media/StepBack16.gif", "toolbarButtonGraphics/media/StepBack24.gif");
    }

    public int getPreviousPageMnemonic() {
        return 37;
    }

    public String getPreviousPageText() {
        return this.lookupResource("previous_page");
    }

    public String getPreviousPageToolTip() {
        return this.lookupResource("previous_page_tooltip");
    }

    public JPrintPreviewPane getPrintPreviewPane() {
        return this.printPreviewPane;
    }

    public Action getPrintAction() {
        if (this.printAction != null) {
            return this.printAction;
        }
        this.printAction = this.createPrintAction();
        return this.printAction;
    }

    public JButton getPrintButton() {
        if (this.printButton != null) {
            return this.printButton;
        }
        Action action = this.getPrintAction();
        this.printButton = this.createButton(action);
        return this.printButton;
    }

    public Action getPrintAllAction() {
        if (this.printAllAction != null) {
            return this.printAllAction;
        }
        this.printAllAction = this.createPrintAllAction();
        return this.printAllAction;
    }

    public JButton getPrintAllButton() {
        if (this.printAllButton != null) {
            return this.printAllButton;
        }
        Action action = this.getPrintAllAction();
        this.printAllButton = this.createButton(action);
        return this.printAllButton;
    }

    public Icon getPrintAllIcon() {
        return this.loadIcon("toolbarButtonGraphics/general/Print16.gif", "toolbarButtonGraphics/general/Print24.gif");
    }

    public int getPrintAllMnemonic() {
        return 80;
    }

    public String getPrintAllText() {
        return this.lookupResource("print_all");
    }

    public String getPrintAllToolTip() {
        return this.lookupResource("print_all_tooltip");
    }

    public Icon getPrintIcon() {
        return this.loadIcon("toolbarButtonGraphics/general/Print16.gif", "toolbarButtonGraphics/general/Print24.gif");
    }

    public int getPrintMnemonic() {
        return 80;
    }

    public String getPrintText() {
        return this.lookupResource("print");
    }

    public String getPrintToolTip() {
        return this.lookupResource("print_tooltip");
    }

    public List getSpecialLayouts() {
        ArrayList<LayoutManager> arraylist = new ArrayList<LayoutManager>(4);
        JPrintPreviewPane jprintpreviewpane = this.getPrintPreviewPane();
        JPrintPreviewPaneUtilities printpreviewpaneui = jprintpreviewpane.getUtility();
        LayoutManager layoutmanager = printpreviewpaneui.createFitAllLayout(jprintpreviewpane);
        arraylist.add(layoutmanager);
        LayoutManager layoutmanager1 = printpreviewpaneui.createFitLayout(jprintpreviewpane);
        arraylist.add(layoutmanager1);
        LayoutManager layoutmanager2 = printpreviewpaneui.createMatrixLayout(jprintpreviewpane, 1, 1);
        arraylist.add(layoutmanager2);
        LayoutManager layoutmanager3 = printpreviewpaneui.createMatrixLayout(jprintpreviewpane, 1, 2);
        arraylist.add(layoutmanager3);
        return arraylist;
    }

    public JComboBox getZoomComboBox(boolean flag, boolean flag1) {
        if (this.zoomComboBox != null) {
            return this.zoomComboBox;
        }
        this.zoomComboBox = this.createZoomComboBox(flag, flag1);
        return this.zoomComboBox;
    }

    public String getZoomComboBoxToolTipText() {
        return this.lookupResource("zoom_combobox_tooltip");
    }

    public Action getZoomInAction() {
        if (this.zoomInAction != null) {
            return this.zoomInAction;
        }
        this.zoomInAction = this.createZoomInAction();
        return this.zoomInAction;
    }

    public JButton getZoomInButton() {
        if (this.zoomInButton != null) {
            return this.zoomInButton;
        }
        Action action = this.getZoomInAction();
        this.zoomInButton = this.createButton(action);
        return this.zoomInButton;
    }

    public Icon getZoomInIcon() {
        return this.loadIcon("sos/preview/res/zoomin.gif", "sos/preview/res/zoomin.gif");
    }

    public int getZoomInMnemonic() {
        return 521;
    }

    public String getZoomInText() {
        return this.lookupResource("zoom_in");
    }

    public String getZoomInToolTip() {
        return this.lookupResource("zoom_in_tooltip");
    }

    public Action getZoomInToggleAction() {
        if (this.zoomInToggleAction != null) {
            return this.zoomInToggleAction;
        }
        this.zoomInToggleAction = this.createZoomInToggleAction();
        return this.zoomInToggleAction;
    }

    public JToggleButton getZoomInToggleButton() {
        if (this.zoomInToggleButton != null) {
            return this.zoomInToggleButton;
        }
        Action action = this.getZoomInToggleAction();
        this.zoomInToggleButton = this.createToggleButton(action);
        if (this.zoomInOutToggleGroup == null) {
            this.zoomInOutToggleGroup = new ButtonGroup();
        }
        this.zoomInOutToggleGroup.add(this.zoomInToggleButton);
        return this.zoomInToggleButton;
    }

    public Icon getZoomInToggleIcon() {
        return this.loadIcon("sos/preview/res/zoomin.gif", "sos/preview/res/zoomin.gif");
    }

    public int getZoomInToggleMnemonic() {
        return 521;
    }

    public String getZoomInToggleText() {
        return this.lookupResource("zoom_in_toggle");
    }

    public String getZoomInToggleToolTip() {
        return this.lookupResource("zoom_in_toggle_tooltip");
    }

    public List getZoomLayouts() {
        ArrayList<LayoutManager> arraylist = new ArrayList<LayoutManager>(7);
        JPrintPreviewPane jprintpreviewpane = this.getPrintPreviewPane();
        JPrintPreviewPaneUtilities printpreviewpaneui = jprintpreviewpane.getUtility();
        arraylist.add(printpreviewpaneui.createZoomLayout(jprintpreviewpane, 4.0));
        arraylist.add(printpreviewpaneui.createZoomLayout(jprintpreviewpane, 2.0));
        arraylist.add(printpreviewpaneui.createZoomLayout(jprintpreviewpane, 1.5));
        arraylist.add(printpreviewpaneui.createZoomLayout(jprintpreviewpane, 1.0));
        arraylist.add(printpreviewpaneui.createZoomLayout(jprintpreviewpane, 0.75));
        arraylist.add(printpreviewpaneui.createZoomLayout(jprintpreviewpane, 0.5));
        arraylist.add(printpreviewpaneui.createZoomLayout(jprintpreviewpane, 0.25));
        return arraylist;
    }

    public Action getZoomOutAction() {
        if (this.zoomOutAction != null) {
            return this.zoomOutAction;
        }
        this.zoomOutAction = this.createZoomOutAction();
        return this.zoomOutAction;
    }

    public JButton getZoomOutButton() {
        if (this.zoomOutButton != null) {
            return this.zoomOutButton;
        }
        Action action = this.getZoomOutAction();
        this.zoomOutButton = this.createButton(action);
        return this.zoomOutButton;
    }

    public Icon getZoomOutIcon() {
        return this.loadIcon("sos/preview/res/zoomout.gif", "sos/preview/res/zoomout.gif");
    }

    public int getZoomOutMnemonic() {
        return 45;
    }

    public String getZoomOutText() {
        return this.lookupResource("zoom_out");
    }

    public String getZoomOutToolTip() {
        return this.lookupResource("zoom_out_tooltip");
    }

    public Action getZoomOutToggleAction() {
        if (this.zoomOutToggleAction != null) {
            return this.zoomOutToggleAction;
        }
        this.zoomOutToggleAction = this.createZoomOutToggleAction();
        return this.zoomOutToggleAction;
    }

    public JToggleButton getZoomOutToggleButton() {
        if (this.zoomOutToggleButton != null) {
            return this.zoomOutToggleButton;
        }
        Action action = this.getZoomOutToggleAction();
        this.zoomOutToggleButton = this.createToggleButton(action);
        if (this.zoomInOutToggleGroup == null) {
            this.zoomInOutToggleGroup = new ButtonGroup();
        }
        this.zoomInOutToggleGroup.add(this.zoomOutToggleButton);
        return this.zoomOutToggleButton;
    }

    public Icon getZoomOutToggleIcon() {
        return this.loadIcon("sos/preview/res/zoomout.gif", "sos/preview/res/zoomout.gif");
    }

    public int getZoomOutToggleMnemonic() {
        return 45;
    }

    public String getZoomOutToggleText() {
        return this.lookupResource("zoom_out_toggle");
    }

    public String getZoomOutToggleToolTip() {
        return this.lookupResource("zoom_out_toggle_tooltip");
    }

    public Action getZoomToggleAction() {
        if (this.zoomToggleAction != null) {
            return this.zoomToggleAction;
        }
        this.zoomToggleAction = this.createZoomToggleAction();
        return this.zoomToggleAction;
    }

    public JToggleButton getZoomToggleButton() {
        if (this.zoomToggleButton != null) {
            return this.zoomToggleButton;
        }
        Action action = this.getZoomToggleAction();
        this.zoomToggleButton = this.createToggleButton(action);
        return this.zoomToggleButton;
    }

    public Icon getZoomToggleIcon() {
        return this.loadIcon("sos/preview/res/zoom.gif", "sos/preview/res/zoom.gif");
    }

    public int getZoomToggleMnemonic() {
        return 90;
    }

    public String getZoomToggleText() {
        return this.lookupResource("zoom_toggle");
    }

    public String getZoomToggleToolTip() {
        return this.lookupResource("zoom_toggle_tooltip");
    }

    protected void handlePrinterException(PrinterException printerexception) {
        JOptionPane.showMessageDialog(this.getPrintPreviewPane(), printerexception.getLocalizedMessage(), this.lookupResource("printing_error"), 0);
    }

    private Icon loadIcon(String s, String s1) {
        String s2 = this.getLargeIconsAreUsed() ? s1 : s;
        return Utility.loadIcon(this, s2);
    }

    private String lookupResource(String s) {
        return UIManager.getString(s);
    }

    private void setCurrentPageIndex(int i) {
        this.currentPageIndex = i;
        Pageable pageable = this.printPreviewPane.getPageable();
        int j = pageable.getNumberOfPages() - 1;
        if (this.firstPageAction != null) {
            this.firstPageAction.setEnabled(i > 0);
        }
        if (this.previousPageAction != null) {
            this.previousPageAction.setEnabled(i > 0);
        }
        if (this.lastPageAction != null) {
            this.lastPageAction.setEnabled(i < j);
        }
        if (this.nextPageAction != null) {
            this.nextPageAction.setEnabled(i < j);
        }
        if (this.pageField != null) {
            this.pageField.setValue(new Integer(i + 1));
        }
    }

    protected class FirstPageAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            if (PrintPreviewSupport.this.currentPageIndex <= 0) {
                return;
            }
            PrintPreviewSupport.this.setCurrentPageIndex(0);
            PrintPreviewSupport.this.printPreviewPane.centerPage(PrintPreviewSupport.this.currentPageIndex);
        }

        protected FirstPageAction() {
        }
    }

    protected class LastPageAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            Pageable pageable = PrintPreviewSupport.this.printPreviewPane.getPageable();
            int i = pageable.getNumberOfPages();
            if (PrintPreviewSupport.this.currentPageIndex >= i - 1) {
                return;
            }
            PrintPreviewSupport.this.setCurrentPageIndex(i - 1);
            PrintPreviewSupport.this.printPreviewPane.centerPage(PrintPreviewSupport.this.currentPageIndex);
        }

        protected LastPageAction() {
        }
    }

    class LayoutCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Map formatMap;

        public Component getListCellRendererComponent(JList jlist, Object obj, int i, boolean flag, boolean flag1) {
            LayoutManager layoutmanager = (LayoutManager)obj;
            Class<?> class1 = layoutmanager.getClass();
            Format format = (Format)this.formatMap.get(class1);
            String s = format != null ? format.format(obj) : String.valueOf(obj);
            this.setText(s);
            this.setFont(jlist.getFont());
            if (flag) {
                this.setBackground(jlist.getSelectionBackground());
                this.setForeground(jlist.getSelectionForeground());
            } else {
                this.setBackground(jlist.getBackground());
                this.setForeground(jlist.getForeground());
            }
            return this;
        }

        LayoutCellRenderer(Map map) {
            this.formatMap = map;
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        }
    }

    protected class NextPageAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            Pageable pageable = PrintPreviewSupport.this.printPreviewPane.getPageable();
            int i = pageable.getNumberOfPages();
            if (PrintPreviewSupport.this.currentPageIndex >= i - 1) {
                return;
            }
            PrintPreviewSupport.this.setCurrentPageIndex(PrintPreviewSupport.this.currentPageIndex + 1);
            PrintPreviewSupport.this.printPreviewPane.centerPage(PrintPreviewSupport.this.currentPageIndex);
        }

        protected NextPageAction() {
        }
    }

    protected class PageSetupAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            PageFormat pageformat;
            JPrintPreviewPane jprintpreviewpane = PrintPreviewSupport.this.getPrintPreviewPane();
            Pageable pageable = jprintpreviewpane.getPageable();
            int i = pageable.getNumberOfPages();
            if (i <= 0) {
                return;
            }
            int j = jprintpreviewpane.getSelectedPageIndex();
            if (j < 0) {
                j = 0;
            }
            if ((pageformat = jprintpreviewpane.pageSetup(j)) == null) {
                return;
            }
            PageableFactory pageablefactory = PrintPreviewSupport.this.getPageableFactory();
            if (pageablefactory == null) {
                return;
            }
            Pageable pageable1 = pageablefactory.createPageable(pageformat);
            jprintpreviewpane.setPageable(pageable1);
        }

        protected PageSetupAction() {
        }
    }

    public static interface PageableFactory {
        public Pageable createPageable(PageFormat var1);
    }

    protected class PreviousPageAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            if (PrintPreviewSupport.this.currentPageIndex <= 0) {
                return;
            }
            PrintPreviewSupport.this.setCurrentPageIndex(PrintPreviewSupport.this.currentPageIndex - 1);
            PrintPreviewSupport.this.printPreviewPane.centerPage(PrintPreviewSupport.this.currentPageIndex);
        }

        protected PreviousPageAction() {
        }
    }

    protected class PrintAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            try {
                PrintPreviewSupport.this.printPreviewPane.print();
            }
            catch (PrinterException printerexception) {
                PrintPreviewSupport.this.handlePrinterException(printerexception);
            }
        }

        protected PrintAction() {
        }
    }

    protected class PrintAllAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            try {
                PrintPreviewSupport.this.printPreviewPane.printAll();
                if (PrintPreviewSupport.this.closeAction != null) {
                    PrintPreviewSupport.this.closeAction.actionPerformed(null);
                }
            }
            catch (PrinterException printerexception) {
                PrintPreviewSupport.this.handlePrinterException(printerexception);
            }
        }

        protected PrintAllAction() {
        }
    }

    class ZoomComboBoxEditor
    implements ComboBoxEditor {
        private JFormattedTextField textField;

        public void addActionListener(ActionListener actionlistener) {
            this.textField.addActionListener(actionlistener);
        }

        public Component getEditorComponent() {
            return this.textField;
        }

        public Object getItem() {
            if (this.textField.isEditValid()) {
                return this.textField.getValue();
            }
            return null;
        }

        public void removeActionListener(ActionListener actionlistener) {
            this.textField.removeActionListener(actionlistener);
        }

        public void selectAll() {
            this.textField.selectAll();
            this.textField.requestFocus();
        }

        public void setItem(Object obj) {
            this.textField.setValue(obj);
        }

        ZoomComboBoxEditor(JFormattedTextField.AbstractFormatter abstractformatter) {
            this.textField = new JFormattedTextField(abstractformatter);
        }
    }

    class ZoomFormatter
    extends JFormattedTextField.AbstractFormatter {
        private Map formatMap;

        public Object stringToValue(String s) throws ParseException {
            Collection collection = this.formatMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Format format = (Format)iterator.next();
                Object obj = format.parseObject(s);
                if (obj == null) continue;
                return obj;
            }
            throw new ParseException(s, 0);
        }

        public String valueToString(Object obj) throws ParseException {
            if (obj == null) {
                return "";
            }
            Class<?> class1 = obj.getClass();
            Format format = (Format)this.formatMap.get(class1);
            String s = format != null ? format.format(obj) : String.valueOf(obj);
            return s;
        }

        ZoomFormatter(Map map) {
            this.formatMap = map;
        }
    }

    protected class ZoomInAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            PrintPreviewSupport.this.printPreviewPane.zoomIn();
        }

        protected ZoomInAction() {
        }
    }

    protected class ZoomInToggleAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            Object obj = actionevent.getSource();
            if (!(obj instanceof AbstractButton)) {
                return;
            }
            AbstractButton abstractbutton = (AbstractButton)obj;
            if (abstractbutton.isSelected()) {
                PrintPreviewSupport.this.printPreviewPane.setMode(2);
            } else {
                PrintPreviewSupport.this.printPreviewPane.setMode(0);
            }
        }

        protected ZoomInToggleAction() {
        }
    }

    protected class ZoomOutAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            PrintPreviewSupport.this.printPreviewPane.zoomOut();
        }

        protected ZoomOutAction() {
        }
    }

    protected class ZoomOutToggleAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            Object obj = actionevent.getSource();
            if (!(obj instanceof AbstractButton)) {
                return;
            }
            AbstractButton abstractbutton = (AbstractButton)obj;
            if (abstractbutton.isSelected()) {
                PrintPreviewSupport.this.printPreviewPane.setMode(3);
            } else {
                PrintPreviewSupport.this.printPreviewPane.setMode(0);
            }
        }

        protected ZoomOutToggleAction() {
        }
    }

    protected class ZoomToggleAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            int i = PrintPreviewSupport.this.printPreviewPane.getMode();
            if (i == 1) {
                PrintPreviewSupport.this.printPreviewPane.setMode(0);
            } else {
                PrintPreviewSupport.this.printPreviewPane.setMode(1);
            }
        }

        protected ZoomToggleAction() {
        }
    }
}

