/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.text.Collator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import sos.preview.JPrintPreviewPaneUtilities;
import sos.preview.MatrixLayout;

public class MatrixLayoutFormat
extends Format {
    private Collator collator;
    private NumberFormat rowFormat;
    private NumberFormat columnFormat;

    public MatrixLayoutFormat() {
        this(NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance(), Collator.getInstance());
    }

    public MatrixLayoutFormat(Locale locale) {
        this(NumberFormat.getNumberInstance(locale), NumberFormat.getNumberInstance(locale), Collator.getInstance(locale));
    }

    private MatrixLayoutFormat(NumberFormat numberformat, NumberFormat numberformat1, Collator collator1) {
        this.rowFormat = numberformat;
        this.columnFormat = numberformat1;
        this.collator = collator1;
        collator1.setStrength(1);
    }

    public StringBuffer format(Object obj, StringBuffer stringbuffer, FieldPosition fieldposition) {
        String s;
        if (!(obj instanceof MatrixLayout)) {
            throw new IllegalArgumentException("Cannot format object.");
        }
        MatrixLayout matrixlayout = (MatrixLayout)obj;
        int i = matrixlayout.getRowCount();
        int j = matrixlayout.getColumnCount();
        if (i == 1 && j == 1) {
            s = UIManager.getString("one_page_layout_name");
        } else if (i == 1 && j == 2) {
            s = UIManager.getString("two_page_layout_name");
        } else {
            String s1 = UIManager.getString("matrix_layout_name");
            Object[] aobj = new Object[]{new Integer(i), new Integer(j)};
            s = MessageFormat.format(s1, aobj);
        }
        stringbuffer.append(s);
        return stringbuffer;
    }

    public static Locale[] getAvailableLocales() {
        return new Locale[]{Locale.US};
    }

    public static MatrixLayoutFormat getInstance() {
        return new MatrixLayoutFormat();
    }

    public static MatrixLayoutFormat getInstance(Locale locale) {
        return new MatrixLayoutFormat(locale);
    }

    public Object parseObject(String s, ParsePosition parseposition) {
        Pattern pattern;
        Matcher matcher;
        String s1 = UIManager.getString("one_page_layout_name");
        String s2 = UIManager.getString("two_page_layout_name");
        if (s1 != null && this.collator.compare(s1, s) == 0) {
            parseposition.setIndex(s.length());
            return this.createLayout(1, 1);
        }
        if (s2 != null && this.collator.compare(s2, s) == 0) {
            parseposition.setIndex(s.length());
            return this.createLayout(1, 2);
        }
        String s3 = UIManager.getString("matrix_layout_regular_expression");
        if (s3 != null && (matcher = (pattern = Pattern.compile(s3)).matcher(s)).matches()) {
            String s4 = matcher.group(1);
            String s5 = matcher.group(3);
            int i = Integer.parseInt(s4);
            int j = Integer.parseInt(s5);
            if (i > 0 && j > 0) {
                parseposition.setIndex(s.length());
                return this.createLayout(i, j);
            }
        }
        return null;
    }

    private MatrixLayout createLayout(int i, int j) {
        int k = UIManager.getInt(JPrintPreviewPaneUtilities.HORIZONTAL_ALIGNMENT);
        int l = UIManager.getInt(JPrintPreviewPaneUtilities.VERTICAL_ALIGNMENT);
        int i1 = UIManager.getInt(JPrintPreviewPaneUtilities.HORIZONTAL_SPACING);
        int j1 = UIManager.getInt(JPrintPreviewPaneUtilities.VERTICAL_SPACING);
        int k1 = UIManager.getInt(JPrintPreviewPaneUtilities.LEFT_MARGIN);
        int l1 = UIManager.getInt(JPrintPreviewPaneUtilities.RIGHT_MARGIN);
        int i2 = UIManager.getInt(JPrintPreviewPaneUtilities.TOP_MARGIN);
        int j2 = UIManager.getInt(JPrintPreviewPaneUtilities.BOTTOM_MARGIN);
        return new MatrixLayout(i, j, k, l, i1, j1, k1, l1, i2, j2);
    }
}

