/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import sos.preview.LayoutSupport;
import sos.preview.Utility;
import sos.preview.core.ScalingLayoutManager;
import sos.preview.core.ScrollableLayoutManager;

public class MatrixLayout
implements ScrollableLayoutManager,
ScalingLayoutManager,
Serializable {
    private static final int DEFAULT_HORIZONTAL_SPACING = 10;
    private static final int DEFAULT_VERTICAL_SPACING = 10;
    private static final int DEFAULT_MINIMUM_LEFT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_RIGHT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_TOP_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_BOTTOM_MARGIN = 10;
    private static final int DEFAULT_HORIZONTAL_ALIGNMENT = 0;
    private static final int DEFAULT_VERTICAL_ALIGNMENT = 0;
    private int numColumns;
    private int numRows;
    private int minLeftMargin;
    private int minRightMargin;
    private int minTopMargin;
    private int minBottomMargin;
    private int horizontalSpacing;
    private int verticalSpacing;
    private int horizontalAlignment;
    private int verticalAlignment;

    public MatrixLayout(int i, int j) throws IllegalArgumentException {
        this(i, j, 0, 0, 10, 10, 10, 10, 10, 10);
    }

    public MatrixLayout(int i, int j, int k, int l) throws IllegalArgumentException {
        this(i, j, k, l, 10, 10, 10, 10);
    }

    public MatrixLayout(int i, int j, int k, int l, int i1, int j1, int k1, int l1) throws IllegalArgumentException {
        this(i, j, 0, 0, k, l, i1, j1, k1, l1);
    }

    public MatrixLayout(int i, int j, int k, int l, int i1, int j1, int k1, int l1, int i2, int j2) throws IllegalArgumentException {
        if (i < 1) {
            throw new IllegalArgumentException("numRows must be greater than 0");
        }
        if (j < 1) {
            throw new IllegalArgumentException("numColumns must be greater than 0");
        }
        Utility.checkHorizontalAlignment(k);
        Utility.checkVerticalAlignment(l);
        Utility.checkSpacing(i1, j1);
        Utility.checkMargins(k1, l1, i2, j2);
        this.numRows = i;
        this.numColumns = j;
        this.horizontalAlignment = k;
        this.verticalAlignment = l;
        this.horizontalSpacing = i1;
        this.verticalSpacing = j1;
        this.minLeftMargin = k1;
        this.minRightMargin = l1;
        this.minTopMargin = i2;
        this.minBottomMargin = j2;
    }

    public void addLayoutComponent(String s, Component component) {
    }

    private double doScaleComponents(Container container, boolean flag) {
        int l2;
        int k1;
        Container container1 = container.getParent();
        Dimension dimension = container1.getSize();
        Insets insets = container.getInsets();
        int i = (int)dimension.getWidth() - insets.left - insets.right;
        int j = (int)dimension.getHeight() - insets.top - insets.bottom;
        int k = container.getComponentCount();
        if (k == 0) {
            return 1.0;
        }
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        double d = layoutsupport.getMaximumFixedWidth();
        double d1 = layoutsupport.getMaximumFixedHeight();
        double d2 = layoutsupport.getMaximumPreferredScaleableWidth();
        double d3 = layoutsupport.getMaximumPreferredScaleableHeight();
        double d4 = ((double)(i - this.minLeftMargin - this.minRightMargin - (this.numColumns - 1) * this.horizontalSpacing) - (double)this.numColumns * d) / (double)this.numColumns;
        double d5 = ((double)(j - this.minTopMargin - this.minBottomMargin - (this.numRows - 1) * this.verticalSpacing) - (double)this.numRows * d1) / (double)this.numRows;
        double d6 = d4 / d2;
        double d7 = d5 / d3;
        double d8 = Math.min(d6, d7);
        if (!flag) {
            return d8;
        }
        double d9 = d1 + d3 * d8;
        double d10 = d + d2 * d8;
        int l = (int)(((double)j - (double)this.numRows * d9 - (double)((this.numRows - 1) * this.verticalSpacing)) / 2.0);
        double d11 = (double)(2 * l) + (double)this.numRows * d9 + (double)((this.numRows - 1) * this.verticalSpacing);
        int i1 = k / (this.numColumns * this.numRows);
        if (k % (this.numColumns * this.numRows) != 0) {
            ++i1;
        }
        double d12 = d11 * (double)i1;
        int j1 = i - this.numColumns * (int)d10 - (this.numColumns - 1) * this.horizontalSpacing - this.minLeftMargin - this.minRightMargin;
        int l1 = k1 = j1 / 2;
        if (j1 % 2 != 0) {
            ++l1;
        }
        int i2 = this.minLeftMargin + k1;
        int j2 = this.minRightMargin + l1;
        int k2 = j - this.numRows * (int)d9 - (this.numRows - 1) * this.verticalSpacing - this.minTopMargin - this.minBottomMargin;
        int i3 = l2 = k2 / 2;
        if (k2 % 2 != 0) {
            ++i3;
        }
        int j3 = this.minTopMargin + l2;
        int k3 = this.minBottomMargin + i3;
        layoutsupport.layoutComponents(this.numRows, this.numColumns, (int)d10, (int)d9, d8, this.horizontalSpacing, this.verticalSpacing, i2, j2, j3, k3, this.horizontalAlignment, this.verticalAlignment);
        return d8;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MatrixLayout)) {
            return false;
        }
        MatrixLayout matrixlayout = (MatrixLayout)obj;
        return this.getRowCount() == matrixlayout.getRowCount() && this.getColumnCount() == matrixlayout.getColumnCount() && this.minLeftMargin == matrixlayout.minLeftMargin && this.minRightMargin == matrixlayout.minRightMargin && this.minTopMargin == matrixlayout.minTopMargin && this.minBottomMargin == matrixlayout.minBottomMargin && this.horizontalSpacing == matrixlayout.horizontalSpacing && this.verticalSpacing == matrixlayout.verticalSpacing && this.horizontalAlignment == matrixlayout.horizontalAlignment && this.verticalAlignment == matrixlayout.verticalAlignment;
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public Dimension getPreferredScrollableViewportSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public int hashCode() {
        return this.getRowCount() * 31 + this.getColumnCount() * 31 + Utility.computeHashCode(this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    public double preferredScale(Container container) {
        Container container1 = container.getParent();
        if (container1 == null) {
            return 0.0;
        }
        Dimension dimension = container1.getSize();
        double d = dimension.getWidth();
        double d1 = dimension.getHeight();
        if (d == 0.0 || d1 == 0.0) {
            return 1.0;
        }
        Insets insets = container1.getInsets();
        double d2 = dimension.getWidth() - (double)insets.left - (double)insets.right;
        double d3 = dimension.getHeight() - (double)insets.top - (double)insets.bottom;
        int i = container.getComponentCount();
        if (i == 0) {
            return 1.0;
        }
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        double d4 = layoutsupport.getMaximumFixedWidth();
        double d5 = layoutsupport.getMaximumFixedHeight();
        double d6 = layoutsupport.getMaximumPreferredScaleableWidth();
        double d7 = layoutsupport.getMaximumPreferredScaleableHeight();
        double d8 = (d2 - (double)this.minLeftMargin - (double)this.minRightMargin - (double)((this.numColumns - 1) * this.horizontalSpacing) - (double)this.numColumns * d4) / (double)this.numColumns;
        double d9 = (d3 - (double)this.minTopMargin - (double)this.minBottomMargin - (double)((this.numRows - 1) * this.verticalSpacing) - (double)this.numRows * d5) / (double)this.numRows;
        double d10 = d8 / d6;
        double d11 = d9 / d7;
        double d12 = Math.min(d10, d11);
        return d12;
    }

    public int getRowCount() {
        return this.numRows;
    }

    public int getScrollableBlockIncrement(Container container, Rectangle rectangle, int i, int j) {
        if (i == 0) {
            int k = rectangle.x % rectangle.width;
            if (k == 0) {
                return rectangle.width;
            }
            if (j < 0) {
                return k;
            }
            return rectangle.width - k;
        }
        int l = rectangle.y % rectangle.height;
        if (l == 0) {
            return rectangle.height;
        }
        if (j < 0) {
            return l;
        }
        return rectangle.height - l;
    }

    public boolean getScrollableTracksViewportHeight(Container container) {
        ComponentOrientation componentorientation = container.getComponentOrientation();
        return !componentorientation.isHorizontal();
    }

    public boolean getScrollableTracksViewportWidth(Container container) {
        ComponentOrientation componentorientation = container.getComponentOrientation();
        return componentorientation.isHorizontal();
    }

    public int getScrollableUnitIncrement(Container container, Rectangle rectangle, int i, int j) {
        return this.getScrollableBlockIncrement(container, rectangle, i, j);
    }

    private Dimension idealPreferredLayoutSize(Container container) {
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        return layoutsupport.getDimensions(1.0, this.numRows, this.numColumns, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    public void layoutContainer(Container container) {
        this.scaleComponents(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        Container container1 = container.getParent();
        if (container1 == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = container1.getSize();
        double d = dimension.getWidth();
        double d1 = dimension.getHeight();
        if (d == 0.0 || d1 == 0.0) {
            return this.idealPreferredLayoutSize(container);
        }
        Insets insets = container1.getInsets();
        double d2 = dimension.getWidth() - (double)insets.left - (double)insets.right;
        double d3 = dimension.getHeight() - (double)insets.top - (double)insets.bottom;
        int i = container.getComponentCount();
        if (i == 0) {
            return dimension;
        }
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        double d4 = layoutsupport.getMaximumFixedWidth();
        double d5 = layoutsupport.getMaximumFixedHeight();
        double d6 = layoutsupport.getMaximumPreferredScaleableWidth();
        double d7 = layoutsupport.getMaximumPreferredScaleableHeight();
        double d8 = (d2 - (double)this.minLeftMargin - (double)this.minRightMargin - (double)((this.numColumns - 1) * this.horizontalSpacing) - (double)this.numColumns * d4) / (double)this.numColumns;
        double d9 = (d3 - (double)this.minTopMargin - (double)this.minBottomMargin - (double)((this.numRows - 1) * this.verticalSpacing) - (double)this.numRows * d5) / (double)this.numRows;
        double d10 = d8 / d6;
        double d11 = d9 / d7;
        double d12 = Math.min(d10, d11);
        double d13 = d5 + d7 * d12;
        int j = (int)((d3 - (double)this.numRows * d13 - (double)((this.numRows - 1) * this.verticalSpacing)) / 2.0);
        double d14 = (double)(2 * j) + (double)this.numRows * d13 + (double)((this.numRows - 1) * this.verticalSpacing);
        int k = i / (this.numColumns * this.numRows);
        if (i % (this.numColumns * this.numRows) != 0) {
            ++k;
        }
        double d15 = d14 * (double)k;
        return new Dimension((int)d2, (int)d15);
    }

    public void removeLayoutComponent(Component component) {
    }

    public double scaleComponents(Container container) {
        return this.doScaleComponents(container, true);
    }
}

