/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.print.Pageable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import sos.preview.FitAllLayout;
import sos.preview.FitLayout;
import sos.preview.JPrintPreviewPane;
import sos.preview.MatrixLayout;
import sos.preview.Utility;
import sos.preview.ZoomLayout;

public class JPrintPreviewPaneUtilities {
    protected JPrintPreviewPane printPreviewPane;
    private PropertyChangeListener propertyChangeListener;
    private MouseInputListener mouseInputListener;
    private ListSelectionListener selectionListener;
    int horizontalAlignment;
    int verticalAlignment;
    int horizontalSpacing;
    int verticalSpacing;
    int leftMargin;
    int rightMargin;
    int topMargin;
    int bottomMargin;
    public static final Object FOREGROUND_KEY = "sos.preview.JPrintPreviewPane.foreground";
    public static final Object BACKGROUND_KEY = "sos.preview.JPrintPreviewPane.background";
    public static final Object BOTTOM_MARGIN = "sos.preview.JPrintPreviewPane.bottomMargin";
    public static final Object LEFT_MARGIN = "sos.preview.JPrintPreviewPane.leftMargin";
    public static final Object HORIZONTAL_ALIGNMENT = "sos.preview.JPrintPreviewPane.horizontalAlignment";
    public static final Object HORIZONTAL_SPACING = "sos.preview.JPrintPreviewPane.horizontalSpacing";
    public static final Object RIGHT_MARGIN = "sos.preview.JPrintPreviewPane.rightMargin";
    public static final Object SELECTION_BACKGROUND_KEY = "sos.preview.JPrintPreviewPane.selectionBackground";
    public static final Object SELECTION_FOREGROUND_KEY = "sos.preview.JPrintPreviewPane.selectionForeground";
    public static final Object TOP_MARGIN = "sos.preview.JPrintPreviewPane.topMargin";
    public static final Object VERTICAL_ALIGNMENT = "sos.preview.JPrintPreviewPane.verticalAlignment";
    public static final Object VERTICAL_SPACING = "sos.preview.JPrintPreviewPane.verticalSpacing";

    public JPrintPreviewPaneUtilities(JComponent jcomponent) {
        Utility.initDefault(BACKGROUND_KEY, new ColorUIResource(Color.gray.brighter()));
        Utility.initDefault(SELECTION_BACKGROUND_KEY, null);
        Utility.initDefault(SELECTION_FOREGROUND_KEY, new ColorUIResource(Color.blue));
        Integer integer = new Integer(0);
        Utility.initDefault(HORIZONTAL_ALIGNMENT, integer);
        Utility.initDefault(VERTICAL_ALIGNMENT, integer);
        Integer integer1 = new Integer(10);
        Utility.initDefault(HORIZONTAL_SPACING, integer1);
        Utility.initDefault(VERTICAL_SPACING, integer1);
        Utility.initDefault(LEFT_MARGIN, integer1);
        Utility.initDefault(RIGHT_MARGIN, integer1);
        Utility.initDefault(TOP_MARGIN, integer1);
        Utility.initDefault(BOTTOM_MARGIN, integer1);
        this.printPreviewPane = (JPrintPreviewPane)jcomponent;
        this.installDefaults();
        this.installListeners();
    }

    public LayoutManager createFitAllLayout(JPrintPreviewPane jprintpreviewpane) {
        return new FitAllLayout(this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    public LayoutManager createFitLayout(JPrintPreviewPane jprintpreviewpane) {
        int i = jprintpreviewpane.getComponentOrientation().isHorizontal() ? this.verticalSpacing : this.horizontalSpacing;
        return new FitLayout(2, this.horizontalAlignment, this.verticalAlignment, i, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    public LayoutManager createMatrixLayout(JPrintPreviewPane jprintpreviewpane, int i, int j) {
        return new MatrixLayout(i, j, this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected Cursor createSelectionCursor() {
        Cursor cursor = Cursor.getPredefinedCursor(0);
        return cursor;
    }

    protected ListSelectionListener createSelectionListener() {
        return new SelectionHandler();
    }

    protected MouseInputListener createSelectionMouseInputListener() {
        return new SelectionMouseHandler();
    }

    public LayoutManager createZoomLayout(JPrintPreviewPane jprintpreviewpane, double d) {
        return new ZoomLayout(d, this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    protected Cursor createZoomCursor() {
        Point point = new Point(8, 8);
        return Utility.loadCursor(this, "sos/preview/res/zoom.gif", point, "Zoom");
    }

    protected Cursor createZoomInCursor() {
        Point point = new Point(8, 8);
        return Utility.loadCursor(this, "sos/preview/res/zoomin.gif", point, "Zoom In");
    }

    protected Cursor createZoomOutCursor() {
        Point point = new Point(8, 8);
        return Utility.loadCursor(this, "sos/preview/res/zoomout.gif", point, "Zoom Out");
    }

    protected MouseInputListener createZoomMouseInputListener() {
        return new ZoomMouseHandler();
    }

    protected MouseInputListener createZoomInMouseInputListener() {
        return new ZoomInMouseHandler();
    }

    protected MouseInputListener createZoomOutMouseInputListener() {
        return new ZoomOutMouseHandler();
    }

    protected void installDefaults() {
        Color color2;
        Utility.installDefaultBackground(this.printPreviewPane, BACKGROUND_KEY);
        Color color = this.printPreviewPane.getSelectionBackground();
        if (color == null || color instanceof UIResource) {
            Color color1 = UIManager.getColor(SELECTION_BACKGROUND_KEY);
            this.printPreviewPane.setSelectionBackground(color1);
        }
        if ((color2 = this.printPreviewPane.getSelectionForeground()) == null || color2 instanceof UIResource) {
            Color color3 = UIManager.getColor(SELECTION_FOREGROUND_KEY);
            this.printPreviewPane.setSelectionForeground(color3);
        }
        this.horizontalAlignment = UIManager.getInt(HORIZONTAL_ALIGNMENT);
        this.verticalAlignment = UIManager.getInt(VERTICAL_ALIGNMENT);
        this.horizontalSpacing = UIManager.getInt(HORIZONTAL_SPACING);
        this.horizontalSpacing = Math.max(0, this.horizontalSpacing);
        this.verticalSpacing = UIManager.getInt(VERTICAL_SPACING);
        this.verticalSpacing = Math.max(0, this.verticalSpacing);
        this.leftMargin = UIManager.getInt(LEFT_MARGIN);
        this.leftMargin = Math.max(0, this.leftMargin);
        this.rightMargin = UIManager.getInt(RIGHT_MARGIN);
        this.rightMargin = Math.max(0, this.rightMargin);
        this.topMargin = UIManager.getInt(TOP_MARGIN);
        this.topMargin = Math.max(0, this.topMargin);
        this.bottomMargin = UIManager.getInt(BOTTOM_MARGIN);
        this.bottomMargin = Math.max(0, this.bottomMargin);
    }

    protected void installListeners() {
        this.installMouseListeners();
        this.selectionListener = this.createSelectionListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        ListSelectionModel listselectionmodel = this.printPreviewPane.getPageSelectionModel();
        if (listselectionmodel != null) {
            listselectionmodel.addListSelectionListener(this.selectionListener);
        }
        this.printPreviewPane.addPropertyChangeListener(this.propertyChangeListener);
    }

    private void installMouseListeners() {
        Cursor cursor;
        int i = this.printPreviewPane.getMode();
        switch (i) {
            case 0: {
                this.mouseInputListener = this.createSelectionMouseInputListener();
                cursor = this.createSelectionCursor();
                break;
            }
            case 1: {
                this.mouseInputListener = this.createZoomMouseInputListener();
                cursor = this.createZoomCursor();
                break;
            }
            case 2: {
                this.mouseInputListener = this.createZoomInMouseInputListener();
                cursor = this.createZoomInCursor();
                break;
            }
            case 3: {
                this.mouseInputListener = this.createZoomOutMouseInputListener();
                cursor = this.createZoomOutCursor();
                break;
            }
            default: {
                throw new AssertionError((Object)"Unrecognized print preview pane mode.");
            }
        }
        this.printPreviewPane.addMouseListener(this.mouseInputListener);
        this.printPreviewPane.addMouseMotionListener(this.mouseInputListener);
        this.installPageCursor(cursor);
    }

    private void installPageCursor(Cursor cursor) {
        Pageable pageable = this.printPreviewPane.getPageable();
        int i = pageable.getNumberOfPages();
        int j = 0;
        while (j < i) {
            Component component = this.printPreviewPane.getPageComponent(j);
            component.setCursor(cursor);
            ++j;
        }
    }

    protected void uninstallDefaults() {
        Color color1;
        Utility.uninstallDefaultBackground(this.printPreviewPane);
        Color color = this.printPreviewPane.getSelectionBackground();
        if (color instanceof UIResource) {
            this.printPreviewPane.setSelectionBackground(null);
        }
        if ((color1 = this.printPreviewPane.getSelectionForeground()) instanceof UIResource) {
            this.printPreviewPane.setSelectionForeground(null);
        }
    }

    protected void uninstallListeners() {
        ListSelectionModel listselectionmodel = this.printPreviewPane.getPageSelectionModel();
        if (listselectionmodel != null) {
            listselectionmodel.removeListSelectionListener(this.selectionListener);
        }
        this.printPreviewPane.removeMouseListener(this.mouseInputListener);
        this.printPreviewPane.removeMouseMotionListener(this.mouseInputListener);
        this.printPreviewPane.removePropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallUI(JComponent jcomponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
    }

    class PropertyHandler
    implements PropertyChangeListener {
        PropertyHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertychangeevent) {
            String s = propertychangeevent.getPropertyName();
            Object obj = propertychangeevent.getOldValue();
            Object obj1 = propertychangeevent.getNewValue();
            if ("mode".equals(s)) {
                JPrintPreviewPaneUtilities.this.printPreviewPane.removeMouseListener(JPrintPreviewPaneUtilities.this.mouseInputListener);
                JPrintPreviewPaneUtilities.this.printPreviewPane.removeMouseMotionListener(JPrintPreviewPaneUtilities.this.mouseInputListener);
                JPrintPreviewPaneUtilities.this.installMouseListeners();
            } else if ("layout".equals(s)) {
                JPrintPreviewPaneUtilities.this.printPreviewPane.revalidate();
                JPrintPreviewPaneUtilities.this.printPreviewPane.repaint();
            } else if ("pageable".equals(s)) {
                Cursor cursor;
                JPrintPreviewPaneUtilities.this.printPreviewPane.revalidate();
                JPrintPreviewPaneUtilities.this.printPreviewPane.repaint();
                ListSelectionModel listselectionmodel = JPrintPreviewPaneUtilities.this.printPreviewPane.getPageSelectionModel();
                if (listselectionmodel != null) {
                    listselectionmodel.clearSelection();
                }
                int i = JPrintPreviewPaneUtilities.this.printPreviewPane.getMode();
                switch (i) {
                    case 0: {
                        cursor = JPrintPreviewPaneUtilities.this.createSelectionCursor();
                        break;
                    }
                    case 1: {
                        cursor = JPrintPreviewPaneUtilities.this.createZoomCursor();
                        break;
                    }
                    case 2: {
                        cursor = JPrintPreviewPaneUtilities.this.createZoomInCursor();
                        break;
                    }
                    case 3: {
                        cursor = JPrintPreviewPaneUtilities.this.createZoomOutCursor();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unrecognized print preview pane mode.");
                    }
                }
                JPrintPreviewPaneUtilities.this.installPageCursor(cursor);
            } else if ("selectionForeground".equals(s)) {
                JPrintPreviewPaneUtilities.this.printPreviewPane.repaint();
            } else if ("selectionBackground".equals(s)) {
                JPrintPreviewPaneUtilities.this.printPreviewPane.repaint();
            } else if ("marginsAreShown".equals(s)) {
                JPrintPreviewPaneUtilities.this.printPreviewPane.repaint();
            } else if ("pageNumberRenderer".equals(s)) {
                JPrintPreviewPaneUtilities.this.printPreviewPane.revalidate();
                JPrintPreviewPaneUtilities.this.printPreviewPane.repaint();
            } else if ("pageNumbersAreShown".equals(s)) {
                JPrintPreviewPaneUtilities.this.printPreviewPane.revalidate();
                JPrintPreviewPaneUtilities.this.printPreviewPane.repaint();
            } else if ("selectionModel".equals(s)) {
                ListSelectionModel listselectionmodel2;
                ListSelectionModel listselectionmodel1 = (ListSelectionModel)obj;
                if (listselectionmodel1 != null) {
                    listselectionmodel1.removeListSelectionListener(JPrintPreviewPaneUtilities.this.selectionListener);
                }
                if ((listselectionmodel2 = (ListSelectionModel)obj1) != null) {
                    listselectionmodel2.addListSelectionListener(JPrintPreviewPaneUtilities.this.selectionListener);
                }
                JPrintPreviewPaneUtilities.this.printPreviewPane.repaint();
            } else if ("pageSelectionAllowed".equals(s)) {
                JPrintPreviewPaneUtilities.this.printPreviewPane.repaint();
            }
        }
    }

    public class SelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listselectionevent) {
            int i = listselectionevent.getFirstIndex();
            int j = listselectionevent.getLastIndex();
            RepaintManager repaintmanager = RepaintManager.currentManager(JPrintPreviewPaneUtilities.this.printPreviewPane);
            int k = i;
            while (k <= j) {
                Component component = JPrintPreviewPaneUtilities.this.printPreviewPane.getComponent(k);
                int l = component.getX();
                int i1 = component.getY();
                int j1 = component.getWidth();
                int k1 = component.getHeight();
                repaintmanager.addDirtyRegion(JPrintPreviewPaneUtilities.this.printPreviewPane, l, i1, j1, k1);
                ++k;
            }
            repaintmanager.paintDirtyRegions();
        }
    }

    class SelectionMouseHandler
    extends MouseInputAdapter {
        private boolean selectedOnPress;

        public void mouseClicked(MouseEvent mouseevent) {
            int k;
            if (!JPrintPreviewPaneUtilities.this.printPreviewPane.isEnabled()) {
                return;
            }
            if (mouseevent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseevent)) {
                return;
            }
            if (mouseevent.isShiftDown() || mouseevent.isControlDown()) {
                return;
            }
            int i = mouseevent.getClickCount();
            if (i != 2) {
                return;
            }
            int j = mouseevent.getX();
            int l = JPrintPreviewPaneUtilities.this.printPreviewPane.getPageIndexAt(j, k = mouseevent.getY());
            if (l < 0) {
                return;
            }
            LayoutManager layoutmanager = JPrintPreviewPaneUtilities.this.printPreviewPane.getLayout();
            if (!Utility.isOnePageLayout(layoutmanager)) {
                LayoutManager layoutmanager1 = JPrintPreviewPaneUtilities.this.createMatrixLayout(JPrintPreviewPaneUtilities.this.printPreviewPane, 1, 1);
                JPrintPreviewPaneUtilities.this.printPreviewPane.setLayout(layoutmanager1);
                JPrintPreviewPaneUtilities.this.printPreviewPane.doLayout();
            }
            JPrintPreviewPaneUtilities.this.printPreviewPane.centerPage(l);
        }

        public void mouseDragged(MouseEvent mouseevent) {
            int j;
            if (!JPrintPreviewPaneUtilities.this.printPreviewPane.getPageSelectionAllowed()) {
                return;
            }
            ListSelectionModel listselectionmodel = JPrintPreviewPaneUtilities.this.printPreviewPane.getPageSelectionModel();
            if (mouseevent.isConsumed()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseevent)) {
                return;
            }
            if (!JPrintPreviewPaneUtilities.this.printPreviewPane.isEnabled()) {
                return;
            }
            if (mouseevent.isShiftDown() || mouseevent.isControlDown()) {
                return;
            }
            int i = mouseevent.getX();
            int k = JPrintPreviewPaneUtilities.this.printPreviewPane.getPageIndexAt(i, j = mouseevent.getY());
            if (k < 0) {
                return;
            }
            listselectionmodel.setSelectionInterval(k, k);
        }

        public void mousePressed(MouseEvent mouseevent) {
            if (!JPrintPreviewPaneUtilities.this.printPreviewPane.getPageSelectionAllowed()) {
                return;
            }
            ListSelectionModel listselectionmodel = JPrintPreviewPaneUtilities.this.printPreviewPane.getPageSelectionModel();
            if (mouseevent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.updateSelection(mouseevent, listselectionmodel);
        }

        public void mouseReleased(MouseEvent mouseevent) {
            if (!JPrintPreviewPaneUtilities.this.printPreviewPane.getPageSelectionAllowed()) {
                return;
            }
            ListSelectionModel listselectionmodel = JPrintPreviewPaneUtilities.this.printPreviewPane.getPageSelectionModel();
            if (this.selectedOnPress) {
                if (!SwingUtilities.isLeftMouseButton(mouseevent)) {
                    return;
                }
                listselectionmodel.setValueIsAdjusting(false);
            } else {
                this.updateSelection(mouseevent, listselectionmodel);
            }
        }

        private void updateSelection(MouseEvent mouseevent, ListSelectionModel listselectionmodel) {
            int j;
            int i;
            int k;
            if (!SwingUtilities.isLeftMouseButton(mouseevent)) {
                return;
            }
            if (!JPrintPreviewPaneUtilities.this.printPreviewPane.isEnabled()) {
                return;
            }
            if (!JPrintPreviewPaneUtilities.this.printPreviewPane.hasFocus() && JPrintPreviewPaneUtilities.this.printPreviewPane.isRequestFocusEnabled()) {
                JPrintPreviewPaneUtilities.this.printPreviewPane.requestFocus();
            }
            if ((k = JPrintPreviewPaneUtilities.this.printPreviewPane.getPageIndexAt(i = mouseevent.getX(), j = mouseevent.getY())) < 0) {
                listselectionmodel.clearSelection();
                return;
            }
            boolean flag = mouseevent.getID() == 501;
            listselectionmodel.setValueIsAdjusting(flag);
            int l = listselectionmodel.getAnchorSelectionIndex();
            if (mouseevent.isControlDown()) {
                if (listselectionmodel.isSelectedIndex(k)) {
                    listselectionmodel.removeSelectionInterval(k, k);
                } else {
                    listselectionmodel.addSelectionInterval(k, k);
                }
            } else if (mouseevent.isShiftDown() && l != -1) {
                listselectionmodel.setSelectionInterval(l, k);
            } else {
                listselectionmodel.setSelectionInterval(k, k);
            }
        }

        SelectionMouseHandler() {
        }
    }

    class ZoomInMouseHandler
    extends MouseInputAdapter {
        public void mouseClicked(MouseEvent mouseevent) {
            Point point = mouseevent.getPoint();
            JPrintPreviewPaneUtilities.this.printPreviewPane.zoomIn(point);
        }

        ZoomInMouseHandler() {
        }
    }

    class ZoomMouseHandler
    extends MouseInputAdapter {
        public void mouseClicked(MouseEvent mouseevent) {
            Point point = mouseevent.getPoint();
            if (SwingUtilities.isRightMouseButton(mouseevent)) {
                JPrintPreviewPaneUtilities.this.printPreviewPane.zoomOut(point);
            } else {
                JPrintPreviewPaneUtilities.this.printPreviewPane.zoomIn(point);
            }
        }

        ZoomMouseHandler() {
        }
    }

    class ZoomOutMouseHandler
    extends MouseInputAdapter {
        public void mouseClicked(MouseEvent mouseevent) {
            Point point = mouseevent.getPoint();
            JPrintPreviewPaneUtilities.this.printPreviewPane.zoomOut(point);
        }

        ZoomOutMouseHandler() {
        }
    }
}

