/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.LinkedList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import sos.preview.DefaultPageNumberRenderer;
import sos.preview.DefaultZoomFunction;
import sos.preview.JPrintPreviewPage;
import sos.preview.JPrintPreviewPaneUtilities;
import sos.preview.MatrixLayout;
import sos.preview.Utility;
import sos.preview.core.PageNumberRenderer;
import sos.preview.core.ScalingLayoutManager;
import sos.preview.core.ScrollableLayoutManager;
import sos.preview.core.ZoomFunction;

public class JPrintPreviewPane
extends JComponent
implements Scrollable {
    JPrintPreviewPaneUtilities utility;
    private static final String uiClassID = "PrintPreviewPaneUI";
    public static final int SELECTION_MODE = 0;
    public static final int ZOOM_MODE = 1;
    public static final int ZOOM_IN_MODE = 2;
    public static final int ZOOM_OUT_MODE = 3;
    public static final String LAYOUT_PROPERTY = "layout";
    public static final String MARGINS_ARE_SHOWN_PROPERTY = "marginsAreShown";
    public static final String MODE_PROPERTY = "mode";
    public static final String PAGEABLE_PROPERTY = "pageable";
    public static final String PAGE_NUMBER_RENDERER_PROPERTY = "pageNumberRenderer";
    public static final String PAGE_NUMBERS_ARE_SHOWN_PROPERTY = "pageNumbersAreShown";
    public static final String PAGE_SELECTION_ALLOWED_PROPERTY = "pageSelectionAllowed";
    public static final String SCALE_PROPERTY = "scale";
    public static final String SELECTION_BACKGROUND_PROPERTY = "selectionBackground";
    public static final String SELECTION_FOREGROUND_PROPERTY = "selectionForeground";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String ZOOM_FUNCTION_PROPERTY = "zoomFunctionProperty";
    private Pageable pageable;
    private PageNumberRenderer pageNumberRenderer;
    private boolean pageNumbersAreShown;
    private boolean marginsAreShown = true;
    private ListSelectionModel selectionModel;
    private int mode;
    private Color selectionBackground;
    private Color selectionForeground;
    private double scale;
    private boolean pageSelectionAllowed;
    private ZoomFunction zoomFunction;
    private LinkedList zoomStack = new LinkedList();
    private int zoomIndex;

    public JPrintPreviewPane() {
        this(new Book());
    }

    public JPrintPreviewPane(Pageable pageable1) throws NullPointerException {
        this(pageable1, new MatrixLayout(1, 1));
    }

    public JPrintPreviewPane(Pageable pageable1, LayoutManager layoutmanager) throws NullPointerException {
        Utility.checkNull(pageable1, PAGEABLE_PROPERTY);
        this.pageable = pageable1;
        this.installChildren();
        this.setLayout(layoutmanager);
        this.selectionModel = this.createPageSelectionModel();
        this.pageNumberRenderer = this.createPageNumberRenderer();
        this.mode = 0;
        this.pageSelectionAllowed = true;
        this.pageNumbersAreShown = true;
        this.zoomFunction = this.createDefaultZoomFunction();
        this.utility = new JPrintPreviewPaneUtilities(this);
    }

    public void paint(Graphics g) {
        g.setColor(new Color(11185333));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g);
    }

    private Point calculateCenter() {
        Rectangle rectangle = this.getVisibleRect();
        double d = rectangle.getCenterX();
        double d1 = rectangle.getCenterY();
        return new Point((int)d, (int)d1);
    }

    public void centerPage(int i) throws IllegalArgumentException {
        Rectangle rectangle;
        Component component = this.getPageComponent(i);
        Rectangle rectangle1 = this.getVisibleRect();
        double d = rectangle1.getWidth();
        double d1 = rectangle1.getHeight();
        LayoutManager layoutmanager = this.getLayout();
        if (Utility.isOnePageLayout(layoutmanager)) {
            rectangle = this.getComponentOrientation().isHorizontal() ? new Rectangle(0, (int)((double)i * d1), (int)d, (int)d1) : new Rectangle((int)((double)i * d), 0, (int)d, (int)d1);
        } else {
            Rectangle rectangle2 = component.getBounds();
            double d2 = rectangle2.getCenterX();
            double d3 = rectangle2.getCenterY();
            double d4 = d2 - d / 2.0;
            double d5 = d3 - d1 / 2.0;
            rectangle = new Rectangle((int)d4, (int)d5, (int)d, (int)d1);
        }
        this.scrollRectToVisible(rectangle);
    }

    protected ZoomFunction createDefaultZoomFunction() {
        return new DefaultZoomFunction();
    }

    protected Component createPageComponent(Printable printable, PageFormat pageformat, int i) {
        return new JPrintPreviewPage(this, printable, pageformat, i);
    }

    protected PageNumberRenderer createPageNumberRenderer() {
        return new DefaultPageNumberRenderer();
    }

    protected ListSelectionModel createPageSelectionModel() {
        return new DefaultListSelectionModel();
    }

    private LayoutManager createZoomLayout(double d) {
        return this.utility.createZoomLayout(this, d);
    }

    public void doLayout() {
        double d;
        LayoutManager layoutmanager = this.getLayout();
        if (layoutmanager instanceof ScalingLayoutManager) {
            ScalingLayoutManager scalinglayoutmanager = (ScalingLayoutManager)layoutmanager;
            d = scalinglayoutmanager.scaleComponents(this);
        } else {
            super.doLayout();
            d = 1.0;
        }
        this.setScale(d);
    }

    private void doSetLayout(LayoutManager layoutmanager, boolean flag) {
        LayoutManager layoutmanager1 = this.getLayout();
        if (layoutmanager.equals(layoutmanager1)) {
            return;
        }
        super.setLayout(layoutmanager);
        if (flag) {
            this.resetZoomLayouts(layoutmanager);
        }
        this.firePropertyChange(LAYOUT_PROPERTY, layoutmanager1, layoutmanager);
    }

    public void ensurePageIsVisible(int i) throws IllegalArgumentException {
        Component component = this.getPageComponent(i);
        Rectangle rectangle = component.getBounds();
        this.scrollRectToVisible(rectangle);
    }

    private Point findNearestComponentPoint(Point point) {
        double d = Double.MAX_VALUE;
        Point point1 = null;
        Component component = this.findComponentAt(point);
        if (component != null && component != this) {
            return point;
        }
        double d1 = point.getX();
        double d2 = point.getY();
        Pageable pageable1 = this.getPageable();
        int i = pageable1.getNumberOfPages();
        int j = 0;
        while (j < i) {
            double d11;
            double d10;
            double d12;
            double d8;
            Component component1 = this.getPageComponent(j);
            double d3 = component1.getX();
            double d4 = component1.getY();
            double d5 = component1.getWidth();
            double d6 = component1.getHeight();
            double d7 = Math.abs(d1 - d3);
            double d9 = Math.min(d7, d8 = Math.abs(d1 - d3 + d5));
            double d13 = d9 * d9 + (d12 = Math.min(d10 = Math.abs(d2 - d4), d11 = Math.abs(d2 - d4 + d6))) * d12;
            double d14 = Math.sqrt(d13);
            if (d14 < d) {
                d = d14;
                if (point1 == null) {
                    point1 = new Point();
                }
                double d15 = d1 >= d3 && d1 < d3 + d5 ? d1 : (d1 < d3 ? d3 : d3 + d5 - 1.0);
                double d16 = d2 >= d4 && d2 < d4 + d6 ? d2 : (d2 < d4 ? d4 : d4 + d6 - 1.0);
                point1.setLocation(d15, d16);
            }
            ++j;
        }
        return point1;
    }

    public boolean getMarginsAreShown() {
        return this.marginsAreShown;
    }

    public int getMode() {
        return this.mode;
    }

    public Component getPageComponent(int i) throws IndexOutOfBoundsException {
        return this.getComponent(i);
    }

    public int getPageIndexAt(Point point) throws NullPointerException {
        int i = (int)point.getX();
        int j = (int)point.getY();
        return this.getPageIndexAt(i, j);
    }

    public int getPageIndexAt(int i, int j) {
        Component component = this.getComponentAt(i, j);
        if (component == null || component == this) {
            return -1;
        }
        return this.getPageIndexOf(component);
    }

    private int getPageIndexOf(Component component) {
        if (component instanceof JPrintPreviewPage) {
            JPrintPreviewPage jprintpreviewpage = (JPrintPreviewPage)component;
            int i = jprintpreviewpage.getPageIndex();
            return i;
        }
        Component[] acomponent = this.getComponents();
        int j = 0;
        while (j < acomponent.length) {
            if (acomponent[j] == component) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public PageNumberRenderer getPageNumberRenderer() {
        return this.pageNumberRenderer;
    }

    public boolean getPageNumbersAreShown() {
        return this.pageNumbersAreShown;
    }

    public boolean getPageSelectionAllowed() {
        return this.pageSelectionAllowed;
    }

    public ListSelectionModel getPageSelectionModel() {
        return this.selectionModel;
    }

    public Dimension getPreferredScrollableViewportSize() {
        LayoutManager layoutmanager = this.getLayout();
        if (layoutmanager instanceof ScrollableLayoutManager) {
            ScrollableLayoutManager scrollablelayoutmanager = (ScrollableLayoutManager)layoutmanager;
            return scrollablelayoutmanager.getPreferredScrollableViewportSize(this);
        }
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getLayout().preferredLayoutSize(this);
        return dimension;
    }

    public double getScale() {
        return this.scale;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int i, int j) {
        LayoutManager layoutmanager = this.getLayout();
        if (layoutmanager instanceof ScrollableLayoutManager) {
            ScrollableLayoutManager scrollablelayoutmanager = (ScrollableLayoutManager)layoutmanager;
            return scrollablelayoutmanager.getScrollableBlockIncrement(this, rectangle, i, j);
        }
        return this.getHeight();
    }

    public boolean getScrollableTracksViewportHeight() {
        LayoutManager layoutmanager = this.getLayout();
        if (layoutmanager instanceof ScrollableLayoutManager) {
            ScrollableLayoutManager scrollablelayoutmanager = (ScrollableLayoutManager)layoutmanager;
            return scrollablelayoutmanager.getScrollableTracksViewportHeight(this);
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        LayoutManager layoutmanager = this.getLayout();
        if (layoutmanager instanceof ScrollableLayoutManager) {
            ScrollableLayoutManager scrollablelayoutmanager = (ScrollableLayoutManager)layoutmanager;
            return scrollablelayoutmanager.getScrollableTracksViewportWidth(this);
        }
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int i, int j) {
        LayoutManager layoutmanager = this.getLayout();
        if (layoutmanager instanceof ScrollableLayoutManager) {
            ScrollableLayoutManager scrollablelayoutmanager = (ScrollableLayoutManager)layoutmanager;
            return scrollablelayoutmanager.getScrollableUnitIncrement(this, rectangle, i, j);
        }
        return 10;
    }

    public int getSelectedPageIndex() {
        if (!this.getPageSelectionAllowed()) {
            return -1;
        }
        ListSelectionModel listselectionmodel = this.getPageSelectionModel();
        return listselectionmodel.getMinSelectionIndex();
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    private LayoutManager getZoomInLayout() {
        LayoutManager layoutmanager;
        if (this.zoomStack.size() > this.zoomIndex + 1) {
            layoutmanager = (LayoutManager)this.zoomStack.get(this.zoomIndex + 1);
        } else {
            double d = this.getScale();
            ZoomFunction zoomfunction = this.getZoomFunction();
            double d1 = zoomfunction.zoomIn(d);
            if (d1 == d) {
                return this.getLayout();
            }
            layoutmanager = this.createZoomLayout(d1);
            this.zoomStack.addLast(layoutmanager);
        }
        ++this.zoomIndex;
        return layoutmanager;
    }

    private LayoutManager getZoomOutLayout() {
        LayoutManager layoutmanager;
        if (this.zoomIndex > 0) {
            --this.zoomIndex;
            layoutmanager = (LayoutManager)this.zoomStack.get(this.zoomIndex);
        } else {
            double d = this.getScale();
            ZoomFunction zoomfunction = this.getZoomFunction();
            double d1 = zoomfunction.zoomOut(d);
            if (d1 == d) {
                return this.getLayout();
            }
            layoutmanager = this.createZoomLayout(d1);
            this.zoomStack.addFirst(layoutmanager);
        }
        return layoutmanager;
    }

    public JPrintPreviewPaneUtilities getUtility() {
        return this.utility;
    }

    public ZoomFunction getZoomFunction() {
        return this.zoomFunction;
    }

    private void installChildren() {
        int i = this.pageable.getNumberOfPages();
        int j = 0;
        while (j < i) {
            Printable printable = this.pageable.getPrintable(j);
            PageFormat pageformat = this.pageable.getPageFormat(j);
            Component component = this.createPageComponent(printable, pageformat, j);
            this.add(component);
            ++j;
        }
    }

    public boolean isPageSelected(int i) {
        if (!this.getPageSelectionAllowed()) {
            return false;
        }
        ListSelectionModel listselectionmodel = this.getPageSelectionModel();
        return listselectionmodel.isSelectedIndex(i);
    }

    public PageFormat pageSetup(int i) throws IllegalArgumentException {
        Pageable pageable1 = this.getPageable();
        if (i < -1 || i >= pageable1.getNumberOfPages()) {
            throw new IllegalArgumentException("pageIndex out of range");
        }
        PageFormat pageformat = i == -1 ? new PageFormat() : pageable1.getPageFormat(i);
        PrinterJob printerjob = PrinterJob.getPrinterJob();
        printerjob.setPageable(pageable1);
        PageFormat pageformat1 = printerjob.pageDialog(pageformat);
        if (pageformat1 == pageformat) {
            return null;
        }
        return pageformat1;
    }

    public boolean print() throws PrinterException {
        PrinterJob printerjob = PrinterJob.getPrinterJob();
        Pageable pageable1 = this.getPageable();
        printerjob.setPageable(pageable1);
        if (!printerjob.printDialog()) {
            return false;
        }
        printerjob.print();
        return true;
    }

    public void printAll() throws PrinterException {
        PrinterJob printerjob = PrinterJob.getPrinterJob();
        Pageable pageable1 = this.getPageable();
        printerjob.setPageable(pageable1);
        printerjob.print();
    }

    private void resetZoomLayouts(LayoutManager layoutmanager) {
        this.zoomStack.clear();
        this.zoomStack.addLast(layoutmanager);
        this.zoomIndex = 0;
    }

    public void setLayout(LayoutManager layoutmanager) {
        if (layoutmanager == this.getLayout()) {
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        if (rectangle.getX() == 0.0 && rectangle.getY() == 0.0) {
            this.doSetLayout(layoutmanager, true);
            return;
        }
        Point point = this.calculateCenter();
        Point point1 = this.findNearestComponentPoint(point);
        if (point1 == null) {
            this.doSetLayout(layoutmanager, true);
            return;
        }
        Component component = this.findComponentAt(point1);
        if (component == null || component == this) {
            this.doSetLayout(layoutmanager, true);
            return;
        }
        double d = point.getX();
        double d1 = point.getY();
        Rectangle rectangle1 = component.getBounds();
        double d2 = rectangle1.getWidth();
        double d3 = rectangle1.getHeight();
        double d4 = rectangle1.getX();
        double d5 = rectangle1.getY();
        this.doSetLayout(layoutmanager, true);
        Dimension dimension = this.getSize();
        Dimension dimension1 = this.getPreferredSize();
        this.setSize(dimension1);
        this.doLayout();
        Rectangle rectangle2 = component.getBounds();
        double d6 = rectangle2.getWidth();
        double d7 = rectangle2.getHeight();
        double d8 = rectangle2.getX();
        double d9 = rectangle2.getY();
        double d10 = (d6 * (d - d4) + d2 * d8) / d2;
        double d11 = (d7 * (d1 - d5) + d3 * d9) / d3;
        double d12 = rectangle.getWidth();
        double d13 = rectangle.getHeight();
        double d14 = d10 - d12 / 2.0;
        double d15 = d11 - d13 / 2.0;
        if (rectangle.getY() + rectangle.getHeight() > dimension1.getHeight()) {
            d15 = d15 + rectangle.getY() + rectangle.getHeight() - dimension1.getHeight();
        }
        if (rectangle.getX() + rectangle.getWidth() > dimension1.getWidth()) {
            d14 = d14 + rectangle.getX() + rectangle.getWidth() - dimension1.getWidth();
        }
        Rectangle rectangle3 = new Rectangle((int)d14, (int)d15, (int)d12, (int)d13);
        this.scrollRectToVisible(rectangle3);
    }

    public void setMarginsAreShown(boolean flag) {
        boolean flag1 = this.marginsAreShown;
        this.marginsAreShown = flag;
        this.firePropertyChange(MARGINS_ARE_SHOWN_PROPERTY, flag1, flag);
    }

    public void setMode(int i) throws IllegalArgumentException {
        if (i != 0 && i != 1 && i != 2 && i != 3) {
            throw new IllegalArgumentException("illegal print preview mode");
        }
        int j = this.mode;
        this.mode = i;
        this.firePropertyChange(MODE_PROPERTY, j, i);
    }

    public void setPageable(Pageable pageable1) throws NullPointerException {
        Utility.checkNull(pageable1, PAGEABLE_PROPERTY);
        Pageable pageable2 = this.pageable;
        this.pageable = pageable1;
        this.uninstallChildren();
        this.installChildren();
        this.firePropertyChange(PAGEABLE_PROPERTY, pageable2, pageable1);
    }

    public void setPageNumberRenderer(PageNumberRenderer pagenumberrenderer) {
        PageNumberRenderer pagenumberrenderer1 = this.pageNumberRenderer;
        this.pageNumberRenderer = pagenumberrenderer;
        this.firePropertyChange(PAGE_NUMBER_RENDERER_PROPERTY, pagenumberrenderer1, pagenumberrenderer);
    }

    public void setPageNumbersAreShown(boolean flag) {
        boolean flag1 = this.pageNumbersAreShown;
        this.pageNumbersAreShown = flag;
        this.firePropertyChange(PAGE_NUMBERS_ARE_SHOWN_PROPERTY, flag1, flag);
    }

    public void setPageSelectionAllowed(boolean flag) {
        boolean flag1 = this.pageSelectionAllowed;
        this.pageSelectionAllowed = flag;
        this.firePropertyChange(PAGE_SELECTION_ALLOWED_PROPERTY, flag1, flag);
    }

    public void setPageSelectionModel(ListSelectionModel listselectionmodel) {
        Utility.checkNull(listselectionmodel, SELECTION_MODEL_PROPERTY);
        ListSelectionModel listselectionmodel1 = this.selectionModel;
        this.selectionModel = listselectionmodel;
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, listselectionmodel1, listselectionmodel);
    }

    private void setScale(double d) {
        double d1 = this.scale;
        this.scale = d;
        this.firePropertyChange(SCALE_PROPERTY, d1, d);
    }

    public void setSelectionBackground(Color color) {
        Color color1 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange(SELECTION_BACKGROUND_PROPERTY, color1, color);
    }

    public void setSelectionForeground(Color color) {
        Color color1 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange(SELECTION_FOREGROUND_PROPERTY, color1, color);
    }

    public void setZoomFunction(ZoomFunction zoomfunction) throws NullPointerException {
        Utility.checkNull(zoomfunction, "zoomFunction");
        ZoomFunction zoomfunction1 = this.zoomFunction;
        this.zoomFunction = zoomfunction;
        this.resetZoomLayouts(this.getLayout());
        this.firePropertyChange(ZOOM_FUNCTION_PROPERTY, zoomfunction1, zoomfunction);
    }

    private void uninstallChildren() {
        this.removeAll();
    }

    public boolean zoom(double d) throws IllegalArgumentException {
        Point point = this.calculateCenter();
        Point point1 = this.findNearestComponentPoint(point);
        if (point1 == null) {
            return false;
        }
        return this.zoom(d, point1);
    }

    public boolean zoom(double d, Point point) throws IllegalArgumentException, NullPointerException {
        if (d <= 0.0) {
            throw new IllegalArgumentException("scale must be positive");
        }
        Component component = this.findComponentAt(point);
        if (component == null || component == this) {
            return false;
        }
        LayoutManager layoutmanager = this.createZoomLayout(d);
        return this.zoom(layoutmanager, point, component, true);
    }

    private boolean zoom(LayoutManager layoutmanager, Point point, Component component, boolean flag) {
        Rectangle rectangle = this.getVisibleRect();
        double d = point.getX();
        double d1 = point.getY();
        Rectangle rectangle1 = component.getBounds();
        double d2 = rectangle1.getWidth();
        double d3 = rectangle1.getHeight();
        double d4 = rectangle1.getX();
        double d5 = rectangle1.getY();
        this.doSetLayout(layoutmanager, flag);
        Dimension dimension = this.getSize();
        Dimension dimension1 = this.getPreferredSize();
        this.setSize(dimension1);
        this.doLayout();
        Rectangle rectangle2 = component.getBounds();
        double d6 = rectangle2.getWidth();
        double d7 = rectangle2.getHeight();
        double d8 = rectangle2.getX();
        double d9 = rectangle2.getY();
        double d10 = (d6 * (d - d4) + d2 * d8) / d2;
        double d11 = (d7 * (d1 - d5) + d3 * d9) / d3;
        double d12 = rectangle.getWidth();
        double d13 = rectangle.getHeight();
        double d14 = d10 - d12 / 2.0;
        double d15 = d11 - d13 / 2.0;
        if (rectangle.getY() + rectangle.getHeight() > dimension1.getHeight()) {
            d15 = d15 + rectangle.getY() + rectangle.getHeight() - dimension1.getHeight();
        }
        if (rectangle.getX() + rectangle.getWidth() > dimension1.getWidth()) {
            d14 = d14 + rectangle.getX() + rectangle.getWidth() - dimension1.getWidth();
        }
        Rectangle rectangle3 = new Rectangle((int)d14, (int)d15, (int)d12, (int)d13);
        this.scrollRectToVisible(rectangle3);
        return true;
    }

    public boolean zoomIn() {
        Point point = this.calculateCenter();
        Point point1 = this.findNearestComponentPoint(point);
        if (point1 == null) {
            return false;
        }
        return this.zoomIn(point1);
    }

    public void zoomIn(int i) throws IllegalArgumentException {
        Component component = this.getPageComponent(i);
        Rectangle rectangle = component.getBounds();
        int j = (int)rectangle.getCenterX();
        int k = (int)rectangle.getCenterY();
        Point point = new Point(j, k);
        this.zoomIn(point);
    }

    public boolean zoomIn(Point point) throws NullPointerException {
        Component component = this.findComponentAt(point);
        if (component == null || component == this) {
            return false;
        }
        LayoutManager layoutmanager = this.getZoomInLayout();
        return this.zoom(layoutmanager, point, component, false);
    }

    public boolean zoomOut() {
        Point point = this.calculateCenter();
        Point point1 = this.findNearestComponentPoint(point);
        if (point1 == null) {
            return false;
        }
        return this.zoomOut(point1);
    }

    public void zoomOut(int i) throws IllegalArgumentException {
        Component component = this.getPageComponent(i);
        Rectangle rectangle = component.getBounds();
        int j = (int)rectangle.getCenterX();
        int k = (int)rectangle.getCenterY();
        Point point = new Point(j, k);
        this.zoomOut(point);
    }

    public boolean zoomOut(Point point) throws NullPointerException {
        Component component = this.findComponentAt(point);
        if (component == null || component == this) {
            return false;
        }
        LayoutManager layoutmanager = this.getZoomOutLayout();
        return this.zoom(layoutmanager, point, component, false);
    }
}

