/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import sos.preview.JPrintPreviewPane;
import sos.preview.Utility;
import sos.preview.core.PageNumberRenderer;
import sos.preview.core.Scaleable;

public class JPrintPreviewPage
extends JPanel
implements Scaleable {
    private Printable printable;
    private PageFormat pageFormat;
    private int pageIndex;
    private JPrintPreviewPane printPreviewPane;
    private CellRendererPane rendererPane;
    private int borderThickness;
    private int shadowThickness;
    private Color shadowColor;
    private Color marginColor;
    private Stroke marginStroke;
    public static final Object BORDER_THICKNESS_KEY = "sos.preview.JPrintPreviewPage.borderThickness";
    public static final Object SHADOW_THICKNESS_KEY = "sos.preview.JPrintPreviewPage.shadowThickness";
    public static final Object BACKGROUND_KEY = "sos.preview.JPrintPreviewPage.background";
    public static final Object FOREGROUND_KEY = "sos.preview.JPrintPreviewPage.foreground";
    public static final Object SHADOW_COLOR_KEY = "sos.preview.JPrintPreviewPage.shadowColor";
    public static final Object MARGIN_COLOR_KEY = "sos.preview.JPrintPreviewPage.marginColor";
    public static final Object MARGIN_STROKE_KEY = "sos.preview.JPrintPreviewPage.marginStroke";
    private static final Map hints = new HashMap();

    public JPrintPreviewPage(JPrintPreviewPane jprintpreviewpane, Printable printable, PageFormat pageformat, int i) {
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Utility.initDefault(BORDER_THICKNESS_KEY, new Integer(1));
        Utility.initDefault(SHADOW_THICKNESS_KEY, new Integer(3));
        Utility.initDefault(BACKGROUND_KEY, new ColorUIResource(Color.white));
        Utility.initDefault(FOREGROUND_KEY, new ColorUIResource(Color.black));
        Utility.initDefault(SHADOW_COLOR_KEY, new ColorUIResource(Color.black.brighter()));
        Utility.initDefault(MARGIN_COLOR_KEY, new ColorUIResource(Color.gray));
        Utility.initDefault(MARGIN_STROKE_KEY, new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{5.0f}, 0.0f));
        this.printPreviewPane = jprintpreviewpane;
        this.printable = printable;
        this.pageFormat = pageformat;
        this.pageIndex = i;
        this.installDefaults();
        this.installChildren();
    }

    public double getFixedHeight() {
        Insets insets = this.getInsets();
        double d = 0.0;
        JPrintPreviewPane jprintpreviewpane = this.getJPrintPreviewPane();
        if (jprintpreviewpane.getPageNumbersAreShown()) {
            int i = this.getPageIndex();
            boolean flag = jprintpreviewpane.isPageSelected(i);
            int j = i + 1;
            PageNumberRenderer pagenumberrenderer = jprintpreviewpane.getPageNumberRenderer();
            Component component = pagenumberrenderer.getPageNumberRendererComponent(jprintpreviewpane, j, flag, this.isFocusOwner());
            Dimension dimension = component.getPreferredSize();
            d = dimension.getHeight();
        }
        return (double)(this.borderThickness + this.borderThickness + this.shadowThickness) + d + (double)insets.top + (double)insets.bottom;
    }

    public double getFixedWidth() {
        Insets insets = this.getInsets();
        return this.borderThickness + this.borderThickness + this.shadowThickness + insets.left + insets.right;
    }

    public Dimension getPreferredSize() {
        JPrintPreviewPage jprintpreviewpage = this;
        PageFormat pageformat = jprintpreviewpage.getPageFormat();
        double d = pageformat.getWidth();
        double d1 = pageformat.getHeight();
        Insets insets = jprintpreviewpage.getInsets();
        double d2 = d + (double)insets.left + (double)insets.right + (double)this.borderThickness + (double)this.borderThickness + (double)this.shadowThickness;
        double d3 = d1 + (double)insets.top + (double)insets.bottom + (double)this.borderThickness + (double)this.borderThickness + (double)this.shadowThickness;
        JPrintPreviewPane jprintpreviewpane = jprintpreviewpage.getJPrintPreviewPane();
        double d4 = d2;
        double d5 = d3;
        if (jprintpreviewpane.getPageNumbersAreShown()) {
            int i = jprintpreviewpage.getPageIndex();
            boolean flag = jprintpreviewpane.isPageSelected(i);
            PageNumberRenderer pagenumberrenderer = jprintpreviewpane.getPageNumberRenderer();
            int j = i + 1;
            Component component = pagenumberrenderer.getPageNumberRendererComponent(jprintpreviewpane, j, flag, jprintpreviewpage.isFocusOwner());
            Dimension dimension = component.getPreferredSize();
            d4 = Math.max(d2, dimension.getWidth());
            d5 = d3 + dimension.getHeight();
        }
        return new Dimension((int)d4, (int)d5);
    }

    public JPrintPreviewPane getJPrintPreviewPane() {
        return this.printPreviewPane;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public Printable getPrintable() {
        return this.printable;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public Dimension getScaleablePreferredSize() {
        PageFormat pageformat = this.getPageFormat();
        double d = pageformat.getWidth();
        double d1 = pageformat.getHeight();
        return new Dimension((int)d, (int)d1);
    }

    protected void installDefaults() {
        this.borderThickness = UIManager.getInt(BORDER_THICKNESS_KEY);
        this.borderThickness = Math.max(0, this.borderThickness);
        this.shadowThickness = UIManager.getInt(SHADOW_THICKNESS_KEY);
        this.shadowThickness = Math.max(0, this.shadowThickness);
        this.shadowColor = UIManager.getColor(SHADOW_COLOR_KEY);
        this.marginColor = UIManager.getColor(MARGIN_COLOR_KEY);
        this.marginStroke = (Stroke)UIManager.get(MARGIN_STROKE_KEY);
        Utility.installDefaultBackground(this, BACKGROUND_KEY);
        Utility.installDefaultForeground(this, FOREGROUND_KEY);
    }

    private void installChildren() {
        this.rendererPane = new CellRendererPane();
        this.add(this.rendererPane);
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        PageFormat pageformat = this.getPageFormat();
        g2.addRenderingHints(hints);
        double pageWidth = pageformat.getWidth();
        double pageHeight = pageformat.getHeight();
        double viewWidth = this.getWidth();
        double viewHeight = this.getHeight();
        Insets insets = this.getInsets();
        JPrintPreviewPane jprintpreviewpane = this.getJPrintPreviewPane();
        double pageNumberHeight = 0.0;
        double viewHeightExceptPageNumber = viewHeight;
        Component component = null;
        int i = this.getPageIndex();
        boolean flag = jprintpreviewpane.isPageSelected(i);
        int j = i + 1;
        if (jprintpreviewpane.getPageNumbersAreShown()) {
            PageNumberRenderer pagenumberrenderer = jprintpreviewpane.getPageNumberRenderer();
            component = pagenumberrenderer.getPageNumberRendererComponent(jprintpreviewpane, j, flag, this.isFocusOwner());
            Dimension dimension = component.getPreferredSize();
            pageNumberHeight = dimension.getHeight();
            viewHeightExceptPageNumber = viewHeight - pageNumberHeight;
        }
        double pageViewWidth = viewWidth - (double)insets.left - (double)insets.right - (double)this.borderThickness - (double)this.borderThickness - (double)this.shadowThickness;
        double pageViewHeight = viewHeightExceptPageNumber - (double)insets.top - (double)insets.bottom - (double)this.borderThickness - (double)this.borderThickness - (double)this.shadowThickness;
        double hScale = pageViewWidth / pageWidth;
        double vScale = pageViewHeight / pageHeight;
        double viewScale = Math.min(hScale, vScale);
        double realViewWidth = pageWidth * viewScale;
        double realViewHeight = pageHeight * viewScale;
        double hDelta = (pageViewWidth - realViewWidth) / 2.0;
        double vDelta = (pageViewHeight - realViewHeight) / 2.0;
        int leftBlank = (int)((double)insets.left + hDelta);
        int topBlank = (int)((double)insets.top + vDelta);
        int i1 = (int)(realViewWidth + (double)this.borderThickness + (double)this.borderThickness + (double)this.shadowThickness);
        int j1 = (int)(realViewHeight + (double)this.borderThickness + (double)this.borderThickness + (double)this.shadowThickness);
        Color color = this.getForeground();
        Color color1 = this.getBackground();
        Color color2 = g2.getColor();
        g2.setColor(this.shadowColor);
        g2.fillRect(leftBlank + this.shadowThickness, topBlank + this.shadowThickness, i1 - this.shadowThickness, j1 - this.shadowThickness);
        if (flag) {
            g2.setColor(jprintpreviewpane.getSelectionForeground());
        } else {
            g2.setColor(color);
        }
        g2.fillRect(leftBlank, topBlank, i1 - this.shadowThickness, j1 - this.shadowThickness);
        g2.setColor(color1);
        g2.fillRect(leftBlank + this.borderThickness, topBlank + this.borderThickness, i1 - this.borderThickness - this.borderThickness - this.shadowThickness, j1 - this.borderThickness - this.borderThickness - this.shadowThickness);
        g2.setColor(color2);
        if (jprintpreviewpane.getPageNumbersAreShown()) {
            Rectangle rectangle = new Rectangle(insets.left, insets.top + j1, (int)(viewWidth - (double)insets.left - (double)insets.right), (int)pageNumberHeight);
            this.rendererPane.paintComponent(g2, component, this, rectangle);
        }
        try {
            g2.translate(leftBlank + this.borderThickness, topBlank + this.borderThickness);
            int scaledLeftBlank = (int)(pageformat.getImageableX() * viewScale);
            int scaledTopBlank = (int)(pageformat.getImageableY() * viewScale);
            int scaledPageWidth = (int)(pageformat.getImageableWidth() * viewScale);
            int scaledPageHeight = (int)(pageformat.getImageableHeight() * viewScale);
            Graphics2D g3 = (Graphics2D)g2.create();
            g3.clip(new Rectangle(scaledLeftBlank, scaledTopBlank, scaledPageWidth, scaledPageHeight));
            g3.scale(viewScale, viewScale);
            Printable printable = this.getPrintable();
            printable.print(g3, pageformat, i);
            Container p = jprintpreviewpane.getParent().getParent();
            JScrollPane sp = (JScrollPane)p;
            g3.dispose();
            if (jprintpreviewpane.getMarginsAreShown()) {
                this.paintMargins(g2, scaledLeftBlank, scaledTopBlank, scaledPageWidth, scaledPageHeight);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void paintMargins(Graphics2D graphics2d, int x, int y, int w, int h) {
        graphics2d.setColor(Color.green);
        graphics2d.setStroke(this.marginStroke);
        graphics2d.drawRect(x, y, w, h);
    }
}

