/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import sos.preview.LayoutSupport;
import sos.preview.Utility;
import sos.preview.core.ScalingLayoutManager;
import sos.preview.core.ScrollableLayoutManager;

public class FitLayout
implements ScrollableLayoutManager,
ScalingLayoutManager,
Serializable {
    private static final int DEFAULT_SPACING = 10;
    private static final int DEFAULT_LEFT_MARGIN = 10;
    private static final int DEFAULT_RIGHT_MARGIN = 10;
    private static final int DEFAULT_TOP_MARGIN = 10;
    private static final int DEFAULT_BOTTOM_MARGIN = 10;
    private static final int DEFAULT_HORIZONTAL_ALIGNMENT = 0;
    private static final int DEFAULT_VERTICAL_ALIGNMENT = 0;
    private int axis;
    private int spacing;
    private int leftMargin;
    private int rightMargin;
    private int topMargin;
    private int bottomMargin;
    private int horizontalAlignment;
    private int verticalAlignment;

    public FitLayout(int i) throws IllegalArgumentException {
        this(i, 0, 0, 10, 10, 10, 10, 10);
    }

    public FitLayout(int i, int j, int k) throws IllegalArgumentException {
        this(i, j, k, 10, 10, 10, 10, 10);
    }

    public FitLayout(int i, int j, int k, int l, int i1, int j1) throws IllegalArgumentException {
        this(i, 0, 0, j, k, l, i1, j1);
    }

    public FitLayout(int i, int j, int k, int l, int i1, int j1, int k1, int l1) throws IllegalArgumentException {
        if (i != 0 && i != 1 && i != 3 && i != 2) {
            throw new IllegalArgumentException("Invalid axis");
        }
        Utility.checkHorizontalAlignment(j);
        Utility.checkVerticalAlignment(k);
        Utility.checkSpacing(l, l);
        Utility.checkMargins(i1, j1, k1, l1);
        this.axis = i;
        this.horizontalAlignment = j;
        this.verticalAlignment = k;
        this.spacing = l;
        this.leftMargin = i1;
        this.rightMargin = j1;
        this.topMargin = k1;
        this.bottomMargin = l1;
    }

    public void addLayoutComponent(String s, Component component) {
    }

    private double doScaleComponents(Container container, boolean flag) {
        Dimension dimension = container.getSize();
        int i = container.getComponentCount();
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        double d = layoutsupport.getMaximumFixedWidth();
        double d1 = layoutsupport.getMaximumFixedHeight();
        double d2 = layoutsupport.getMaximumPreferredScaleableWidth();
        double d3 = layoutsupport.getMaximumPreferredScaleableHeight();
        if (this.isHorizontal(container)) {
            double d4 = d + d2;
            int j = (int)dimension.getWidth();
            double d6 = j - this.leftMargin - this.rightMargin;
            double d8 = d6 / d4;
            if (flag) {
                int l = (int)d6;
                int j1 = (int)(d1 + d3 * d8);
                layoutsupport.layoutComponents(i, 1, l, j1, d8, 0, this.spacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.horizontalAlignment, this.verticalAlignment);
            }
            return d8;
        }
        double d5 = d1 + d3;
        int k = (int)dimension.getHeight();
        double d7 = k - this.topMargin - this.bottomMargin;
        double d9 = d7 / d5;
        if (flag) {
            int i1 = (int)(d + d2 * d9);
            int k1 = (int)d7;
            layoutsupport.layoutComponents(1, i, i1, k1, d9, this.spacing, 0, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.horizontalAlignment, this.verticalAlignment);
        }
        return d9;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FitLayout)) {
            return false;
        }
        FitLayout fitlayout = (FitLayout)obj;
        return this.getAxis() == fitlayout.getAxis() && this.leftMargin == fitlayout.leftMargin && this.rightMargin == fitlayout.rightMargin && this.topMargin == fitlayout.topMargin && this.bottomMargin == fitlayout.bottomMargin && this.spacing == fitlayout.spacing && this.horizontalAlignment == fitlayout.horizontalAlignment && this.verticalAlignment == fitlayout.verticalAlignment;
    }

    public int getAxis() {
        return this.axis;
    }

    public Dimension getPreferredScrollableViewportSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public int hashCode() {
        return this.getAxis() * 31 + Utility.computeHashCode(this.horizontalAlignment, this.verticalAlignment, this.spacing, this.spacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    public double preferredScale(Container container) {
        double d4;
        Container container1 = container.getParent();
        if (container1 == null) {
            return 0.0;
        }
        Dimension dimension = container1.getSize();
        int i = (int)dimension.getWidth();
        int j = (int)dimension.getHeight();
        if (i == 0 || j == 0) {
            return 1.0;
        }
        int k = container.getComponentCount();
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        double d = layoutsupport.getMaximumFixedWidth();
        double d1 = layoutsupport.getMaximumFixedHeight();
        double d2 = layoutsupport.getMaximumPreferredScaleableWidth();
        double d3 = layoutsupport.getMaximumPreferredScaleableHeight();
        if (this.isHorizontal(container)) {
            double d5 = d + d2;
            double d7 = i - this.leftMargin - this.rightMargin;
            d4 = d7 / d5;
        } else {
            double d6 = d1 + d3;
            double d8 = j - this.topMargin - this.bottomMargin;
            d4 = d8 / d6;
        }
        return d4;
    }

    public int getScrollableBlockIncrement(Container container, Rectangle rectangle, int i, int j) {
        return i != 0 ? rectangle.height : rectangle.width;
    }

    public boolean getScrollableTracksViewportHeight(Container container) {
        return !this.isHorizontal(container);
    }

    public boolean getScrollableTracksViewportWidth(Container container) {
        return this.isHorizontal(container);
    }

    public int getScrollableUnitIncrement(Container container, Rectangle rectangle, int i, int j) {
        return 20;
    }

    private Dimension idealPreferredLayoutSize(Container container) {
        int i = container.getComponentCount();
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        if (this.isHorizontal(container)) {
            return layoutsupport.getDimensions(1.0, i, 1, 0, this.spacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
        }
        return layoutsupport.getDimensions(1.0, 1, i, this.spacing, 0, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    private boolean isHorizontal(Container container) {
        ComponentOrientation componentorientation = container.getComponentOrientation();
        boolean flag = this.axis == 0 || this.axis == 3 && !componentorientation.isHorizontal() || this.axis == 2 && componentorientation.isHorizontal();
        return flag;
    }

    public void layoutContainer(Container container) {
        this.scaleComponents(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        int i = container.getComponentCount();
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        if (this.isHorizontal(container)) {
            return layoutsupport.getDimensions(0.05, i, 1, 0, this.spacing, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
        }
        return layoutsupport.getDimensions(0.05, 1, i, this.spacing, 0, this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
    }

    public Dimension preferredLayoutSize(Container container) {
        Container container1 = container.getParent();
        if (container1 == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = container1.getSize();
        int i = (int)dimension.getWidth();
        int j = (int)dimension.getHeight();
        if (i == 0 || j == 0) {
            return this.idealPreferredLayoutSize(container);
        }
        int k = container.getComponentCount();
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        double d = layoutsupport.getMaximumFixedWidth();
        double d1 = layoutsupport.getMaximumFixedHeight();
        double d2 = layoutsupport.getMaximumPreferredScaleableWidth();
        double d3 = layoutsupport.getMaximumPreferredScaleableHeight();
        if (this.isHorizontal(container)) {
            double d4 = d + d2;
            double d6 = i - this.leftMargin - this.rightMargin;
            double d8 = d6 / d4;
            int l = (int)(d1 + d3 * d8);
            int j1 = this.topMargin + this.bottomMargin + k * l + (k - 1) * this.spacing;
            j1 = Math.max(j1, j);
            return new Dimension(i, j1);
        }
        double d5 = d1 + d3;
        double d7 = j - this.topMargin - this.bottomMargin;
        double d9 = d7 / d5;
        int i1 = (int)(d + d2 * d9);
        int k1 = this.leftMargin + this.rightMargin + k * i1 + (k - 1) * this.spacing;
        k1 = Math.max(k1, i);
        return new Dimension(k1, j);
    }

    public void removeLayoutComponent(Component component) {
    }

    public double scaleComponents(Container container) {
        return this.doScaleComponents(container, true);
    }
}

