/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import sos.preview.LayoutSupport;
import sos.preview.Utility;
import sos.preview.core.ScalingLayoutManager;
import sos.preview.core.ScrollableLayoutManager;

public class FitAllLayout
implements ScrollableLayoutManager,
ScalingLayoutManager,
Serializable {
    private static final int DEFAULT_HORIZONTAL_SPACING = 10;
    private static final int DEFAULT_VERTICAL_SPACING = 10;
    private static final int DEFAULT_MINIMUM_LEFT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_RIGHT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_TOP_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_BOTTOM_MARGIN = 10;
    private static final int DEFAULT_HORIZONTAL_ALIGNMENT = 0;
    private static final int DEFAULT_VERTICAL_ALIGNMENT = 0;
    private int horizontalSpacing;
    private int verticalSpacing;
    private int minLeftMargin;
    private int minRightMargin;
    private int minTopMargin;
    private int minBottomMargin;
    private int horizontalAlignment;
    private int verticalAlignment;

    public FitAllLayout() {
        this(0, 0, 10, 10, 10, 10, 10, 10);
    }

    public FitAllLayout(int i, int j) throws IllegalArgumentException {
        this(i, j, 10, 10, 10, 10, 10, 10);
    }

    public FitAllLayout(int i, int j, int k, int l, int i1, int j1) throws IllegalArgumentException {
        this(0, 0, i, j, k, l, i1, j1);
    }

    public FitAllLayout(int i, int j, int k, int l, int i1, int j1, int k1, int l1) throws IllegalArgumentException {
        Utility.checkHorizontalAlignment(i);
        Utility.checkVerticalAlignment(j);
        Utility.checkSpacing(k, l);
        Utility.checkMargins(i1, j1, k1, l1);
        this.horizontalAlignment = i;
        this.verticalAlignment = j;
        this.horizontalSpacing = k;
        this.verticalSpacing = l;
        this.minLeftMargin = i1;
        this.minRightMargin = j1;
        this.minTopMargin = k1;
        this.minBottomMargin = l1;
    }

    public void addLayoutComponent(String s, Component component) {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FitAllLayout)) {
            return false;
        }
        FitAllLayout fitalllayout = (FitAllLayout)obj;
        return this.minLeftMargin == fitalllayout.minLeftMargin && this.minRightMargin == fitalllayout.minRightMargin && this.minTopMargin == fitalllayout.minTopMargin && this.minBottomMargin == fitalllayout.minBottomMargin && this.horizontalSpacing == fitalllayout.horizontalSpacing && this.verticalSpacing == fitalllayout.verticalSpacing && this.horizontalAlignment == fitalllayout.horizontalAlignment && this.verticalAlignment == fitalllayout.verticalAlignment;
    }

    public Dimension getPreferredScrollableViewportSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public int hashCode() {
        return Utility.computeHashCode(this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    public double preferredScale(Container container) {
        Container container1 = container.getParent();
        if (container1 == null) {
            return 0.0;
        }
        Dimension dimension = container1.getSize();
        double d = dimension.getWidth();
        double d1 = dimension.getHeight();
        if (d == 0.0 || d1 == 0.0) {
            return 1.0;
        }
        Insets insets = container.getInsets();
        int i = (int)d - insets.left - insets.right;
        int j = (int)d1 - insets.top - insets.bottom;
        int k = container.getComponentCount();
        if (k == 0) {
            return 1.0;
        }
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        double d2 = layoutsupport.getMaximumFixedWidth();
        double d3 = layoutsupport.getMaximumFixedHeight();
        double d4 = layoutsupport.getMaximumPreferredScaleableWidth();
        double d5 = layoutsupport.getMaximumPreferredScaleableHeight();
        boolean flag = true;
        boolean flag1 = true;
        double d6 = 0.0;
        int j1 = 1;
        while (j1 <= k) {
            double d8;
            double d10;
            double d7;
            double d9;
            double d11;
            int k1 = k / j1;
            if (k % j1 != 0) {
                ++k1;
            }
            if ((d11 = Math.min(d9 = (d7 = ((double)(i - this.minLeftMargin - this.minRightMargin - (j1 - 1) * this.horizontalSpacing) - (double)j1 * d2) / (double)j1) / d4, d10 = (d8 = ((double)(j - this.minTopMargin - this.minBottomMargin - (k1 - 1) * this.verticalSpacing) - (double)k1 * d3) / (double)k1) / d5)) > d6) {
                int l = j1;
                int i1 = k1;
                d6 = d11;
            }
            ++j1;
        }
        return d6;
    }

    public int getScrollableBlockIncrement(Container container, Rectangle rectangle, int i, int j) {
        return 0;
    }

    public boolean getScrollableTracksViewportHeight(Container container) {
        return true;
    }

    public boolean getScrollableTracksViewportWidth(Container container) {
        return true;
    }

    public int getScrollableUnitIncrement(Container container, Rectangle rectangle, int i, int j) {
        return 0;
    }

    private Dimension idealPreferredLayoutSize(Container container) {
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        return layoutsupport.getLinearDimensions(1.0, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    public void layoutContainer(Container container) {
        this.scaleComponents(container);
    }

    public double scaleComponents(Container container) {
        return this.doScaleComponents(container, true);
    }

    private double doScaleComponents(Container container, boolean flag) {
        int l3;
        int k2;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int i = (int)dimension.getWidth() - insets.left - insets.right;
        int j = (int)dimension.getHeight() - insets.top - insets.bottom;
        int k = container.getComponentCount();
        if (k == 0) {
            return 1.0;
        }
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        double d = layoutsupport.getMaximumFixedWidth();
        double d1 = layoutsupport.getMaximumFixedHeight();
        double d2 = layoutsupport.getMaximumPreferredScaleableWidth();
        double d3 = layoutsupport.getMaximumPreferredScaleableHeight();
        int l = 1;
        int i1 = 1;
        double d4 = 0.0;
        int j1 = 1;
        while (j1 <= k) {
            double d6;
            double d8;
            double d5;
            double d7;
            double d9;
            int k1 = k / j1;
            if (k % j1 != 0) {
                ++k1;
            }
            if ((d9 = Math.min(d7 = (d5 = ((double)(i - this.minLeftMargin - this.minRightMargin - (j1 - 1) * this.horizontalSpacing) - (double)j1 * d) / (double)j1) / d2, d8 = (d6 = ((double)(j - this.minTopMargin - this.minBottomMargin - (k1 - 1) * this.verticalSpacing) - (double)k1 * d1) / (double)k1) / d3)) > d4) {
                l = j1;
                i1 = k1;
                d4 = d9;
            }
            ++j1;
        }
        if (!flag) {
            return d4;
        }
        int l1 = (int)(d + d2 * d4);
        int i2 = (int)(d1 + d3 * d4);
        int j2 = i - l * l1 - (l - 1) * this.horizontalSpacing - this.minLeftMargin - this.minRightMargin;
        int l2 = k2 = j2 / 2;
        if (j2 % 2 != 0) {
            ++l2;
        }
        int i3 = this.minLeftMargin + k2;
        int j3 = this.minRightMargin + l2;
        int k3 = j - i1 * i2 - (i1 - 1) * this.verticalSpacing - this.minTopMargin - this.minBottomMargin;
        int i4 = l3 = k3 / 2;
        if (k3 % 2 != 0) {
            ++k3;
        }
        int j4 = this.minTopMargin + l3;
        int k4 = this.minBottomMargin + i4;
        layoutsupport.layoutComponents(i1, l, l1, i2, d4, this.horizontalSpacing, this.verticalSpacing, i3, j3, j4, k4, this.horizontalAlignment, this.verticalAlignment);
        return d4;
    }

    public Dimension minimumLayoutSize(Container container) {
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        return layoutsupport.getLinearDimensions(0.01, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    public Dimension preferredLayoutSize(Container container) {
        Container container1 = container.getParent();
        if (container1 == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = container1.getSize();
        double d = dimension.getWidth();
        double d1 = dimension.getHeight();
        if (d == 0.0 || d1 == 0.0) {
            return this.idealPreferredLayoutSize(container);
        }
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
    }
}

