/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import sos.preview.core.ZoomFunction;

public class DefaultZoomFunction
implements ZoomFunction {
    private double jump;
    private double minimumScale;
    private double maximumScale;

    public DefaultZoomFunction() {
        this(0.25, 0.01, Double.MAX_VALUE);
    }

    public DefaultZoomFunction(double d) throws IllegalArgumentException {
        this(0.25, 0.01, Double.MAX_VALUE);
    }

    public DefaultZoomFunction(double d, double d1) throws IllegalArgumentException {
        this(d, d1, Double.MAX_VALUE);
    }

    public DefaultZoomFunction(double d, double d1, double d2) throws IllegalArgumentException {
        if (d < 0.0) {
            throw new IllegalArgumentException("jump cannot be negative");
        }
        if (d1 < 0.0) {
            throw new IllegalArgumentException("minimumScale cannot be negative");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("maximumScale cannot be negative");
        }
        if (d2 < d1) {
            throw new IllegalArgumentException("maximumScale cannot be less than minimumScale");
        }
        this.minimumScale = d1;
        this.maximumScale = d2;
        this.jump = d;
    }

    public double zoomIn(double d) {
        double d1 = d * (1.0 + this.jump);
        return Math.min(this.maximumScale, d1);
    }

    public double zoomOut(double d) {
        double d1 = d / (1.0 + this.jump);
        return Math.max(this.minimumScale, d1);
    }
}

