/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.flow.applet;

import excel.brick.Brick;
import excel.brick.Chart;
import excel.core.Cell;
import excel.core.ColumnPropertyManage;
import excel.core.DBBindConfig;
import excel.core.DataSourceConfig;
import excel.core.EditStyle;
import excel.core.Property;
import excel.core.Range;
import excel.core.RowPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import excel.core.impl.RowPropertyManage_;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import jun.db.core.DataStore;
import jun.db.util.Base64Coder;
import jun.xml.write.XmlWriter;
import wiseoa.flow.applet.StringZIP;
import wiseoa.flow.applet.ZExcelTool;

public class WorkBookUI2XML {
    private WorkBook book;

    public WorkBookUI2XML(WorkBook book_) {
        this.book = book_;
    }

    public String UI2XML(String theme, int hPadding, int vPadding) {
        StringWriter w = null;
        String lineSeparator = "\n";
        try {
            w = new StringWriter();
            XmlWriter xml = new XmlWriter((Writer)w);
            ((Writer)w).write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            ((Writer)w).write(lineSeparator);
            xml.S("workbook").A("version", "1.0").A("sheetcount", this.book.getWorkSheetCount()).A("gui", "true").A("theme", theme).A("hpadding", hPadding).A("vpadding", vPadding);
            int i = 0;
            while (i < this.book.getWorkSheetCount()) {
                WorkSheet sheet = this.book.getWorkSheet(i);
                ((Writer)w).write(lineSeparator);
                xml.S("worksheet").A("index", i).A("rowcount", String.valueOf(sheet.getRowCount())).A("columncount", String.valueOf(sheet.getColumnCount())).A("guid", sheet.getGUID()).A("code", sheet.getCode()).A("name", sheet.getName()).A("mode", "run").A("rowheadervisible", "true").A("columnheadervisible", "true").A("gridlinevisible", sheet.getGridLineVisible()).A("gridlinecolor", ZExcelTool.Color2Hex(sheet.getGridLineColor())).A("visible", sheet.isVisible());
                RowPropertyManage RPM = sheet.getRowPropertyManage();
                int ri = 0;
                while (ri < sheet.getRowCount()) {
                    int h = RPM.getRowHeight(ri);
                    int dbr = RPM.getMaxDBRowCount(ri);
                    int dbrh = RPM.getDBRowHeight(ri);
                    if (h != 21 || dbrh != h || !RPM.isColumnScrollEnabled(ri)) {
                        ((Writer)w).write(lineSeparator);
                        xml.S("row").A("index", String.valueOf(ri)).A("height", String.valueOf(h)).A("dbrowcount", dbr).A("dbrowheight", String.valueOf(dbrh)).A("columnscrollenabled", RPM.isColumnScrollEnabled(ri)).E();
                    }
                    ++ri;
                }
                ri = 0;
                while (ri < sheet.getRowCount()) {
                    int dbr = Math.max(1, (RPM.getDBRowHeight(ri) > 0 ? RPM.getMaxDBRowCount(ri) : 0) + (RPM.isGroupRowVisible(ri) ? RPM.getDBGroupRowCount(ri) : 0));
                    ((Writer)w).write(lineSeparator);
                    xml.S("innerrow").A("index", String.valueOf(ri)).A("count", String.valueOf(dbr)).E();
                    ++ri;
                }
                ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
                int ci = 0;
                while (ci < sheet.getColumnCount()) {
                    int cw = CPM.getColumnWidth(ci);
                    if (cw != 72) {
                        ((Writer)w).write(lineSeparator);
                        xml.S("column").A("index", String.valueOf(ci)).A("width", String.valueOf(cw)).E();
                    }
                    ++ci;
                }
                int row = 0;
                while (row < sheet.getRowCount()) {
                    int col = 0;
                    while (col < sheet.getColumnCount()) {
                        if (!sheet.isCellNull(row, col)) {
                            Cell cell = sheet.Cells(row, col);
                            ((Writer)w).write(lineSeparator);
                            this.SaveCell(xml, cell);
                        }
                        ++col;
                    }
                    ++row;
                }
                xml.E();
                ++i;
            }
            xml.E();
            ((Writer)w).close();
        }
        catch (Exception e) {
            System.out.println("\u4fdd\u5b58\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
            e.printStackTrace();
            return "";
        }
        return StringZIP.zip(((Object)w).toString());
    }

    private void SaveCell(XmlWriter xml, Cell cell) throws Exception {
        String tip;
        int k;
        int ti;
        int gc;
        ArrayList pVec;
        Hashtable MapGroups;
        Integer key;
        String t;
        Cell mcell;
        boolean multiLine = false;
        int rowCount = 0;
        if (cell.isMerged() && cell != (mcell = cell.mergedBy())) {
            return;
        }
        if (!cell.isVisible()) {
            return;
        }
        String groupRowNo = "";
        String innerRowHeight = "";
        String datatype = "99";
        StringBuffer s = new StringBuffer(1024);
        String cellValue = "";
        DBBindConfig dbc = cell.getBind();
        if (dbc != null) {
            DataSourceConfig dsc = this.book.getDataSource(dbc.getDataSource());
            datatype = "" + dsc.getDataStore().getColumnProperty(dbc.getDBCol()).getUniformDataType();
            RowPropertyManage RPM = cell.getWorkSheet().getRowPropertyManage();
            int rowIndex = cell.getRowIndex();
            int dbRowHeight = RPM.getDBRowHeight(rowIndex);
            int groupRowHeight = RPM.getGroupRowHeight(rowIndex);
            boolean groupRowVisible = RPM.isGroupRowVisible(rowIndex);
            boolean showDetail = dbRowHeight > 0;
            innerRowHeight = "" + dbRowHeight;
            if (dbc.getDataSourceType() == 1 || dbc.getDataSourceType() == 4) {
                rowCount = 1;
                cellValue = Base64Coder.encode((String)cell.getValueString());
                s.append(Base64Coder.encode((String)cell.getShowText(dsc.getCurrentBindRow())));
            } else {
                multiLine = true;
                String dbCol = dbc.getDBCol();
                String dbCol2 = "|" + dbCol.toLowerCase() + "|";
                ArrayList<Object> cellValueList = new ArrayList<Object>();
                DataStore ds = dsc.getDataStore();
                ArrayList<Integer> rowHeightList = new ArrayList<Integer>();
                ArrayList<Integer> groupRowList = new ArrayList<Integer>();
                ArrayList vg = (ArrayList)ds.getFriendlyProperty("m_VectorGroups");
                ArrayList cgc = (ArrayList)ds.getFriendlyProperty("m_VectorGroupCols");
                int groupCount = cgc.size();
                int groupLevel = -1;
                int gi = 0;
                while (gi < cgc.size()) {
                    String groupBy = ((String)cgc.get(gi)).toLowerCase();
                    if ((groupBy = "|" + groupBy + "|").indexOf(dbCol2) >= 0) {
                        groupLevel = gi + 1;
                    }
                    ++gi;
                }
                HashMap<Integer, String> dataMap = new HashMap<Integer, String>();
                int dataIndex = 0;
                int nn22 = 0;
                while (nn22 < ds.getRowCount()) {
                    t = cell.getShowText(nn22);
                    if (showDetail) {
                        dataMap.put(new Integer(dataIndex), t);
                        ++dataIndex;
                        cellValueList.add(cell.getValue(nn22));
                        rowHeightList.add(new Integer(dbRowHeight));
                    }
                    if (groupRowVisible) {
                        key = new Integer(nn22);
                        MapGroups = (Hashtable)ds.getFriendlyProperty("m_MapGroups");
                        if (MapGroups.containsKey(key)) {
                            pVec = (ArrayList)MapGroups.get(key);
                            gc = pVec.size();
                            ti = gc - 1;
                            while (ti >= 0) {
                                k = (Integer)pVec.get(ti);
                                groupRowList.add(new Integer(dataIndex));
                                rowHeightList.add(new Integer(groupRowHeight));
                                if (groupLevel == k) {
                                    if (k > 0) {
                                        dataMap.put(new Integer(dataIndex), t);
                                        ++dataIndex;
                                        cellValueList.add(cell.getValue(nn22));
                                    } else {
                                        dataMap.put(new Integer(dataIndex), "");
                                        ++dataIndex;
                                        cellValueList.add("");
                                    }
                                } else {
                                    String aggregateCol = String.valueOf(dbCol) + "_aggregate_" + k;
                                    if (ds.columnExists(aggregateCol)) {
                                        Object v = ds.getValue(nn22, aggregateCol);
                                        t = cell.toFormatString(v);
                                        dataMap.put(new Integer(dataIndex), t);
                                        ++dataIndex;
                                        cellValueList.add(v);
                                    } else {
                                        dataMap.put(new Integer(dataIndex), "");
                                        ++dataIndex;
                                        cellValueList.add("");
                                    }
                                }
                                --ti;
                            }
                        }
                    }
                    rowCount = dataMap.size();
                    ++nn22;
                }
                try {
                    s.append(WorkBookUI2XML.Object2Base64String(dataMap));
                    cellValue = WorkBookUI2XML.Object2Base64String(cellValueList);
                    groupRowNo = WorkBookUI2XML.Object2Base64String(groupRowList);
                    innerRowHeight = WorkBookUI2XML.Object2Base64String(rowHeightList);
                }
                catch (Exception nn22) {}
            }
        } else if (cell.getValue() instanceof Vector) {
            boolean haveGroupRow;
            Vector vv = (Vector)cell.getValue();
            ArrayList cellValueList = new ArrayList();
            ArrayList<Integer> rowHeightList = new ArrayList<Integer>();
            ArrayList<Integer> groupRowList = new ArrayList<Integer>();
            HashMap<Integer, String> dataMap = new HashMap<Integer, String>();
            RowPropertyManage RPM = cell.getWorkSheet().getRowPropertyManage();
            int rowIndex = cell.getRowIndex();
            int dbRowHeight = RPM.getDBRowHeight(rowIndex);
            int groupRowHeight = RPM.getGroupRowHeight(rowIndex);
            boolean groupRowVisible = RPM.isGroupRowVisible(rowIndex);
            boolean showDetail = dbRowHeight > 0;
            innerRowHeight = "" + dbRowHeight;
            DataSourceConfig dsc = ((RowPropertyManage_)cell.getWorkSheet().getRowPropertyManage()).getMaximalDataSourceConfig(cell.getRowIndex());
            boolean bl = haveGroupRow = dsc != null;
            if (haveGroupRow && dsc.getDataSourceType() == 1) {
                haveGroupRow = false;
            }
            if (!haveGroupRow) {
                int nn = 0;
                while (nn < vv.size()) {
                    Object v = vv.get(nn);
                    if (v != null) {
                        datatype = v.getClass().toString();
                    }
                    String t2 = cell.getShowText(nn);
                    dataMap.put(new Integer(nn), t2);
                    cellValueList.add(v);
                    rowHeightList.add(new Integer(dbRowHeight));
                    ++nn;
                }
            } else {
                DataStore ds = dsc.getDataStore();
                ArrayList vg = (ArrayList)ds.getFriendlyProperty("m_VectorGroups");
                ArrayList cgc = (ArrayList)ds.getFriendlyProperty("m_VectorGroupCols");
                int groupCount = cgc.size();
                int dataIndex = 0;
                multiLine = true;
                int nn = 0;
                while (nn < vv.size()) {
                    Object v = vv.get(nn);
                    if (v != null) {
                        datatype = v.getClass().toString();
                    }
                    t = cell.getShowText(nn);
                    if (showDetail) {
                        dataMap.put(new Integer(dataIndex), t);
                        ++dataIndex;
                        cellValueList.add(v);
                        rowHeightList.add(new Integer(dbRowHeight));
                    }
                    if (groupRowVisible) {
                        key = new Integer(nn);
                        MapGroups = (Hashtable)ds.getFriendlyProperty("m_MapGroups");
                        if (MapGroups.containsKey(key)) {
                            pVec = (ArrayList)MapGroups.get(key);
                            gc = pVec.size();
                            ti = gc - 1;
                            while (ti >= 0) {
                                k = (Integer)pVec.get(ti);
                                groupRowList.add(new Integer(dataIndex));
                                rowHeightList.add(new Integer(groupRowHeight));
                                dataMap.put(new Integer(dataIndex), "");
                                ++dataIndex;
                                cellValueList.add("");
                                --ti;
                            }
                        }
                    }
                    ++nn;
                }
            }
            rowCount = dataMap.size();
            try {
                s.append(WorkBookUI2XML.Object2Base64String(dataMap));
                cellValue = WorkBookUI2XML.Object2Base64String(cellValueList);
                groupRowNo = WorkBookUI2XML.Object2Base64String(groupRowList);
                innerRowHeight = WorkBookUI2XML.Object2Base64String(rowHeightList);
            }
            catch (Exception exception) {}
        } else {
            Object v = cell.getValue();
            if (v != null) {
                datatype = v.getClass().toString();
            }
            cellValue = Base64Coder.encode((String)cell.getValueString());
            s.append(Base64Coder.encode((String)cell.getShowText()));
        }
        xml.S("cell").A("row", String.valueOf(cell.getRowIndex())).A("col", String.valueOf(cell.getColumnIndex())).A("value", cellValue).A("text", s.toString()).A("multiline", multiLine).A("grouprowno", groupRowNo).A("datatype", datatype).A("rowcount", rowCount).A("innerrowheight", innerRowHeight).A("property", cell.getProperty().getGUID());
        if (cell.isMerged()) {
            Range r = cell.getMergedRange();
            xml.A("rowspan", String.valueOf(r.getEndRow() - r.getStartRow() + 1));
            xml.A("colspan", String.valueOf(r.getEndCol() - r.getStartCol() + 1));
        }
        Brick[] bs = cell.getBricks();
        int bi = 0;
        while (bi < bs.length) {
            if (bs[bi] instanceof Chart) {
                Chart chart = (Chart)bs[bi];
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(bo);
                BufferedImage img = chart.getImage();
                if (img == null) {
                    System.out.println("chart \u4fdd\u5b58\u6210\u56fe\u7247\u5931\u8d25");
                } else {
                    ImageIO.write((RenderedImage)img, "jpg", bos);
                    bos.flush();
                    bos.close();
                    byte[] bytes = bo.toByteArray();
                    String imgS = new String(Base64Coder.encode((byte[])bytes));
                    xml.A("chart", "$#{image}#$" + imgS);
                    break;
                }
            }
            ++bi;
        }
        String alias = cell.getAlias();
        if (!alias.equals("")) {
            xml.A("alias", alias);
        }
        if (!(tip = cell.getToolTip()).equals("")) {
            xml.A("tooltip", tip);
        }
        Property p = cell.getProperty();
        Object[] objs = p.getPropertyNames().toArray();
        for (Object pn : p.getPropertyNames()) {
            Object v;
            String propName = String.valueOf(pn);
            if (propName.equals("font-color")) {
                boolean groupRowHeight = false;
            }
            if (cell.isPropertyDefault(propName) || (v = cell.getPropertyValue(propName)) == null) continue;
            if (v instanceof Color) {
                xml.A(String.valueOf(pn), ZExcelTool.Color2Hex((Color)v));
                continue;
            }
            xml.A(String.valueOf(pn), v.toString());
        }
        EditStyle es = cell.getEditStyle();
        if (es != null) {
            switch (es.getEditType()) {
                case 0: {
                    xml.A("edittype", "normal");
                    break;
                }
                case 2: {
                    xml.A("edittype", "multiline");
                    break;
                }
                case 1: {
                    xml.A("edittype", "numeric");
                    xml.A("show-comma", es.isShowComma());
                    xml.A("decimal-count", es.getDecimalCount());
                    break;
                }
                case 3: {
                    xml.A("edittype", "datetime");
                    xml.A("datetime-format", es.getDatetimeFormat());
                    break;
                }
                case 4: {
                    xml.A("edittype", "ddlb");
                    String name = es.getName();
                    name = es.getDDLBName();
                    xml.A("editstyle", name);
                    xml.A("ddlb-editable", es.isDropDownListEditable());
                    if (es.isListShowAsCheckBox()) {
                        xml.A("ddlb-style", "checkbox");
                    }
                    if (es.isListShowAsRadioButton()) {
                        xml.A("ddlb-style", "radio");
                    }
                    xml.A("columncount", es.getColumnCountOnRow());
                    break;
                }
                case 5: {
                    xml.A("edittype", "checkbox");
                    xml.A("checkbox-tip-text", es.getCheckBoxTipText());
                    xml.A("check-on-value", es.getCheckOnValue().toString());
                    xml.A("check-off-value", es.getCheckOffValue().toString());
                    break;
                }
                case 7: {
                    xml.A("edittype", "richedit");
                }
            }
        }
        xml.E();
    }

    private static String Object2Base64String(Object obj) throws Exception {
        ByteArrayOutputStream bao = new ByteArrayOutputStream(1024);
        ObjectOutputStream oo = new ObjectOutputStream(bao);
        oo.writeObject(obj);
        oo.flush();
        oo.close();
        byte[] b = bao.toByteArray();
        return new String(Base64Coder.encode((byte[])b));
    }
}

