/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.flow.applet;

import appletrpc.RPC;
import appletrpc.RPCParameter;
import excel.core.Cell;
import excel.core.DBBindConfig;
import excel.core.DataSourceConfig;
import excel.core.RowPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import jun.db.core.DataStore;
import wiseoa.flow.applet.CoordinateConfigForImportExcelData;

public class ImportDataFromExcel {
    public static void importDataFromExcel(String HomeURL, WorkBook book, String fileName) throws Exception {
        HashMap coordinateMap = new HashMap();
        int i = 0;
        while (i < book.getWorkSheetCount()) {
            WorkSheet sheet = book.getWorkSheet(i);
            if (sheet.isVisible()) {
                ArrayList<CoordinateConfigForImportExcelData> configs = new ArrayList<CoordinateConfigForImportExcelData>();
                coordinateMap.put(sheet.getName(), configs);
                RowPropertyManage RPM = sheet.getRowPropertyManage();
                HashMap<Integer, Integer> multiRowMap = new HashMap<Integer, Integer>();
                int ri = 0;
                while (ri < sheet.getRowCount()) {
                    int dbr = Math.max(1, RPM.getMaxDBRowCount(ri));
                    multiRowMap.put(new Integer(ri), new Integer(dbr));
                    ++ri;
                }
                int row = 0;
                while (row < sheet.getRowCount()) {
                    int col = 0;
                    while (col < sheet.getColumnCount()) {
                        Cell mcell;
                        Cell cell;
                        if (!(sheet.isCellNull(row, col) || (cell = sheet.Cells(row, col)).isMerged() && cell != (mcell = cell.mergedBy()))) {
                            DBBindConfig dbc;
                            System.out.println("row=" + row + "  col=" + col + " editable: " + cell.isEditable());
                            if (cell.isEditable() && (dbc = cell.getBind()) != null) {
                                DataSourceConfig dsc = book.getDataSource(dbc.getDataSource());
                                if (dbc.getDataSourceType() == 1 || dbc.getDataSourceType() == 4) {
                                    int excelRow = ImportDataFromExcel.toExcelRowNo(multiRowMap, row) + 0;
                                    configs.add(new CoordinateConfigForImportExcelData(row, col, 0, excelRow));
                                } else {
                                    DataStore ds = dsc.getDataStore();
                                    int rowCount = Math.max(1, ds.getRowCount());
                                    int firstExcelRow = ImportDataFromExcel.toExcelRowNo(multiRowMap, row) + 0;
                                    int nn = 0;
                                    while (nn < ds.getRowCount()) {
                                        int excelRow = firstExcelRow + nn;
                                        configs.add(new CoordinateConfigForImportExcelData(row, col, nn, excelRow));
                                        ++nn;
                                    }
                                }
                            }
                        }
                        ++col;
                    }
                    ++row;
                }
            }
            ++i;
        }
        RPCParameter p = new RPCParameter();
        p.put("map", coordinateMap);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        File theFile = new File(fileName);
        FileInputStream fis = null;
        try {
            int actually;
            fis = new FileInputStream(theFile);
            int once = 32768;
            byte[] buffer = new byte[once];
            while ((actually = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, actually);
            }
            fis.close();
            bos.flush();
            bos.close();
            byte[] b = bos.toByteArray();
            p.put("excel", b);
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception dbc) {}
            try {
                bos.close();
            }
            catch (Exception dbc) {}
        }
        p = RPC.Call(String.valueOf(HomeURL) + "servlet/wiseoa.flow.appletrpc.LoadFlowFormConfig", "readDataFromExcel", p);
        if (!p.Success) {
            throw new Exception(p.ErrorText);
        }
        coordinateMap = (HashMap)p.get("map");
        for (String sheetName : coordinateMap.keySet()) {
            WorkSheet sheet = book.getWorkSheet(sheetName);
            ArrayList configs = (ArrayList)coordinateMap.get(sheetName);
            int i2 = 0;
            while (i2 < configs.size()) {
                CoordinateConfigForImportExcelData cfg = (CoordinateConfigForImportExcelData)configs.get(i2);
                Object v = cfg.value;
                if (!(v == null || v instanceof String && ((String)v).equals(""))) {
                    Cell cell = sheet.Cells(cfg.row, cfg.col);
                    DBBindConfig dbc = cell.getBind();
                    DataStore ds = book.getDataSource(dbc.getDataSource()).getDataStore();
                    ds.setValue(cfg.dbrow, dbc.getDBCol(), v);
                }
                ++i2;
            }
        }
    }

    static int toExcelRowNo(HashMap multiRowMap, int row) {
        int ret = 0;
        int i = 0;
        while (i < row) {
            ret = multiRowMap.containsKey(new Integer(i)) ? (ret += ((Integer)multiRowMap.get(new Integer(i))).intValue()) : ++ret;
            ++i;
        }
        return ret;
    }
}

