/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.flow.applet;

import excel.core.Cell;
import excel.core.ColumnPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import excel.core.ZExcel;
import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import jun.db.impl.DataStoreFactory;
import org.kxml.Attribute;
import org.kxml.kdom.Document;
import org.kxml.kdom.Element;
import org.kxml.parser.KXML;

public class ExcelTool {
    public static final String ns = "urn:schemas-microsoft-com:office:spreadsheet";

    public static WorkBook InitUI(KXML xml, String HomeURL) {
        HashMap<String, Element> styleMap = new HashMap<String, Element>();
        WorkBook book = null;
        try {
            Document document = new Document();
            document.parse(xml);
            Element uiConfig = document.getElement(ns, "Workbook");
            Element[] sheetsE = uiConfig.getElements(ns, "Worksheet");
            int sheetCount = sheetsE.length;
            int[] RC = new int[sheetCount];
            int[] CC = new int[sheetCount];
            String[] GUIDS = new String[sheetCount];
            String[] CodeS = new String[sheetCount];
            int si = 0;
            while (si < sheetCount) {
                int index = si;
                Element sheetE = sheetsE[si];
                Element tableE = sheetE.getElement(ns, "Table");
                int src = tableE.getAttributeValue(ns, "ExpandedRowCount", 100);
                int scc = tableE.getAttributeValue(ns, "ExpandedColumnCount", 100);
                if (index >= 0 && index < sheetCount) {
                    RC[index] = src;
                    CC[index] = scc;
                    GUIDS[index] = DataStoreFactory.newGUID();
                    CodeS[index] = null;
                }
                ++si;
            }
            book = ZExcel.newWorkBook((int)sheetCount, (boolean)true, (int[])RC, (int[])CC, (String[])GUIDS, (String[])CodeS);
            Element stylesRootE = uiConfig.getElement(ns, "Styles");
            if (stylesRootE != null) {
                Element[] stylesE = stylesRootE.getElements(ns, "Style");
                int ei = 0;
                while (ei < stylesE.length) {
                    Element styleE = stylesE[ei];
                    styleMap.put(styleE.getAttributeValue(ns, "ID", ""), styleE);
                    ++ei;
                }
            }
            int si2 = 0;
            while (si2 < sheetCount) {
                int index = si2;
                Element sheetE = sheetsE[si2];
                WorkSheet sheet = book.getWorkSheet(index);
                sheet.setName(sheetE.getAttributeValue(ns, "Name", ""));
                sheet.setIsDesignMode(true);
                ExcelTool.InitColumnWidth(sheet, sheetE);
                ExcelTool.InitSheetRows(book, sheet, sheetE, HomeURL, styleMap);
                ++si2;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return book;
    }

    public static void InitColumnWidth(WorkSheet sheet, Element sheetE) {
        Element tableE = sheetE.getElement(ns, "Table");
        if (tableE == null) {
            return;
        }
        Element[] colsE = tableE.getElements(ns, "Column");
        int col = 0;
        ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
        int ei = 0;
        while (ei < colsE.length) {
            Element colE = colsE[ei];
            ++col;
            col = colE.getAttributeValue(ns, "Index", col);
            String w = colE.getAttributeValue(ns, "Width", "0");
            double f = (double)Double.valueOf(w).floatValue() * 4.0 / 3.0;
            System.out.print("width'" + f);
            if (f > 0.0) {
                CPM.setColumnWidth(col - 1, (int)f);
            }
            ++ei;
        }
    }

    public static void InitSheetRows(WorkBook book, WorkSheet sheet, Element sheetE, String HomeURL, HashMap styleMap) {
        Element tableE = sheetE.getElement(ns, "Table");
        if (tableE == null) {
            return;
        }
        Element[] rowsE = tableE.getElements(ns, "Row");
        int row = 0;
        int ei = 0;
        while (ei < rowsE.length) {
            Element rowE = rowsE[ei];
            ++row;
            row = ExcelTool.InitSheetCells(row, book, sheet, rowE, HomeURL, styleMap);
            ++ei;
        }
    }

    public static int InitSheetCells(int row, WorkBook book, WorkSheet sheet, Element rowE, String HomeURL, HashMap styleMap) {
        int height;
        Element[] cellsE = rowE.getElements(ns, "Cell");
        row = rowE.getAttributeValue(ns, "Index", row);
        String hs = rowE.getAttributeValue(ns, "Height", "");
        if (!hs.equals("") && (height = (int)(Double.valueOf(hs) * 4.0 / 3.0)) > 0) {
            sheet.getRowPropertyManage().setRowHeight(row - 1, height);
        }
        int col = 0;
        int ei = 0;
        while (ei < cellsE.length) {
            Element cellE = cellsE[ei];
            ++col;
            col = ExcelTool.InitSheetCell(row, col, book, sheet, cellE, HomeURL, styleMap);
            ++ei;
        }
        return row;
    }

    public static int InitSheetCell(int row, int col, WorkBook book, WorkSheet sheet, Element cellE, String HomeURL, HashMap styleMap) {
        int mr = 0;
        int mc = 0;
        try {
            String f;
            Cell cell;
            col = cellE.getAttributeValue(ns, "Index", col);
            if (row == 1 && col == 14) {
                boolean bl = true;
            }
            if ((cell = sheet.Cells(row - 1, col - 1)) == null) {
                return col;
            }
            Element dataE = cellE.getElement(ns, "Data");
            if (dataE != null) {
                cell.setValue((Object)dataE.getText());
            }
            if (!(f = cellE.getAttributeValue(ns, "Formula", "")).equals("")) {
                cell.setValue((Object)("?" + f));
            }
            Vector attrs = cellE.getAttributes();
            int ai = 0;
            while (ai < attrs.size()) {
                Attribute attr = (Attribute)attrs.get(ai);
                String attrName = attr.getName().trim();
                String attrValue = attr.getValue();
                if (!attrName.equals("Index")) {
                    Element styleE;
                    if (attrName.equals("MergeAcross") || attrName.equals("MergeDown")) {
                        mc = Math.min(cellE.getAttributeValue(ns, "MergeAcross", 0), sheet.getColumnCount() - 1);
                        mr = Math.min(cellE.getAttributeValue(ns, "MergeDown", 0), sheet.getRowCount() - 1);
                        sheet.Merge(row - 1, col - 1, row - 1 + mr, col - 1 + mc);
                    }
                    if (attrName.equals("StyleID") && (styleE = (Element)styleMap.get(attrValue)) != null) {
                        Element bordersRootE;
                        String c;
                        Element bkE;
                        Element fontE = styleE.getElement(ns, "Font");
                        if (fontE != null) {
                            Vector fattrs = fontE.getAttributes();
                            int fi = 0;
                            while (fi < fattrs.size()) {
                                Attribute fattr = (Attribute)fattrs.get(fi);
                                String fattrName = fattr.getName().trim();
                                String fattrValue = fattr.getValue();
                                if (fattrName.equals("FontName")) {
                                    cell.setProperty("font-name", (Object)fattrValue);
                                }
                                if (fattrName.equals("Size")) {
                                    cell.setProperty("font-size", (Object)new Integer((int)((double)Double.valueOf(fattrValue).intValue() / 3.0 * 4.0)));
                                }
                                if (fattrName.equals("Color")) {
                                    cell.setProperty("font-color", (Object)fattrValue);
                                }
                                if (fattrName.equals("Bold")) {
                                    cell.setProperty("font-bold", (Object)new Boolean(fattrValue.equals("1")));
                                }
                                if (fattrName.equals("Italic")) {
                                    cell.setProperty("font-italic", (Object)new Boolean(fattrValue.equals("1")));
                                }
                                if (fattrName.equals("Underline")) {
                                    cell.setProperty("font-underline", (Object)new Boolean(!fattrValue.equals("")));
                                }
                                ++fi;
                            }
                        }
                        if ((bkE = styleE.getElement(ns, "Interior")) != null && !(c = bkE.getAttributeValue(ns, "Color", "")).equals("")) {
                            cell.setProperty("background-mode", (Object)new Integer(1));
                            cell.setProperty("background-color", (Object)ExcelTool.Hex2Color(c));
                        }
                        if ((bordersRootE = styleE.getElement(ns, "Borders")) != null) {
                            Element[] bordersE = bordersRootE.getElements(ns, "Border");
                            int bi = 0;
                            while (bi < bordersE.length) {
                                Element borderE = bordersE[bi];
                                String LineStyle = borderE.getAttributeValue(ns, "LineStyle", "0");
                                int style = 0;
                                if (LineStyle.equals("Continuous")) {
                                    style = 1;
                                }
                                if (LineStyle.equals("Dot")) {
                                    style = 2;
                                }
                                if (LineStyle.equals("Dash")) {
                                    style = 3;
                                }
                                if (LineStyle.equals("DashDotDot")) {
                                    style = 4;
                                }
                                if (LineStyle.equals("Double")) {
                                    style = 5;
                                }
                                int Weight = borderE.getAttributeValue(ns, "Weight", 1);
                                String Position = borderE.getAttributeValue(ns, "Position", "").toLowerCase();
                                String Color2 = borderE.getAttributeValue(ns, "Color", "");
                                cell.setProperty("border-" + Position + "-width", (Object)new Integer(Weight));
                                cell.setProperty("border-" + Position + "-style", (Object)new Integer(style));
                                if (!Color2.equals("")) {
                                    cell.setProperty("border-" + Position + "-color", (Object)ExcelTool.Hex2Color(Color2));
                                }
                                ++bi;
                            }
                        }
                    }
                }
                ++ai;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return col + mc;
    }

    public static String Color2Hex(Color c) {
        String r = "00" + Integer.toString(c.getRed(), 16);
        r = r.substring(r.length() - 2, r.length());
        String g = "00" + Integer.toString(c.getGreen(), 16);
        g = g.substring(g.length() - 2, g.length());
        String b = "00" + Integer.toString(c.getBlue(), 16);
        b = b.substring(b.length() - 2, b.length());
        return "#" + r + g + b;
    }

    public static Color Hex2Color(String c) {
        try {
            Color color = Color.decode(c);
            return color;
        }
        catch (Exception e) {
            return Color.BLACK;
        }
    }
}

