/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.NoSuchKeyException;
import com.ice.jni.registry.NoSuchValueException;
import com.ice.jni.registry.RegistryException;
import com.ice.jni.registry.RegistryValue;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class RegistryKey {
    public static final int ACCESS_DEFAULT = 0;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    public static final int ACCESS_EXECUTE = 3;
    public static final int ACCESS_ALL = 4;
    protected int hKey;
    protected String name;
    protected boolean created;

    public RegistryKey(int hKey, String name) {
        this.hKey = hKey;
        this.name = name;
        this.created = false;
    }

    public RegistryKey(int hKey, String name, boolean created) {
        this.hKey = hKey;
        this.name = name;
        this.created = created;
    }

    public void finalize() {
        if (this.name.indexOf("\\") > 0) {
            try {
                this.closeKey();
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
    }

    public String getName() {
        int index = this.name.lastIndexOf("\\");
        if (index < 0) {
            return this.name;
        }
        return this.name.substring(index + 1);
    }

    public String getFullName() {
        return this.name;
    }

    public boolean wasCreated() {
        return this.created;
    }

    public void setCreated(boolean created) {
        this.created = created;
    }

    public RegistryKey openSubKey(String subkey) throws NoSuchKeyException, RegistryException {
        return this.openSubKey(subkey, 1);
    }

    public RegistryKey createSubKey(String subkey, String className) throws RegistryException {
        return this.createSubKey(subkey, "", 2);
    }

    public void setValue(RegistryValue value) throws RegistryException {
        this.setValue(value.getName(), value);
    }

    public native RegistryKey openSubKey(String var1, int var2) throws NoSuchKeyException, RegistryException;

    public native RegistryKey connectRegistry(String var1) throws NoSuchKeyException, RegistryException;

    public native RegistryKey createSubKey(String var1, String var2, int var3) throws RegistryException;

    public native void closeKey() throws RegistryException;

    public native void deleteSubKey(String var1) throws NoSuchKeyException, RegistryException;

    public native void deleteValue(String var1) throws NoSuchValueException, RegistryException;

    public native void flushKey() throws RegistryException;

    public native void setValue(String var1, RegistryValue var2) throws RegistryException;

    public native RegistryValue getValue(String var1) throws NoSuchValueException, RegistryException;

    public native String getStringValue(String var1) throws NoSuchValueException, RegistryException;

    public native String getDefaultValue() throws NoSuchValueException, RegistryException;

    public native boolean hasDefaultValue() throws RegistryException;

    public native boolean hasOnlyDefaultValue() throws RegistryException;

    public native int getNumberSubkeys() throws RegistryException;

    public native int getMaxSubkeyLength() throws RegistryException;

    public native String regEnumKey(int var1) throws RegistryException;

    public native int getNumberValues() throws RegistryException;

    public native int getMaxValueDataLength() throws RegistryException;

    public native int getMaxValueNameLength() throws RegistryException;

    public native String regEnumValue(int var1) throws RegistryException;

    public native int incrDoubleWord(String var1) throws NoSuchValueException, RegistryException;

    public native int decrDoubleWord(String var1) throws NoSuchValueException, RegistryException;

    public static native String expandEnvStrings(String var0);

    public Enumeration keyElements() throws RegistryException {
        RegistryKey registryKey = this;
        registryKey.getClass();
        return registryKey.new RegistryKeyEnumerator(this);
    }

    public Enumeration valueElements() throws RegistryException {
        RegistryKey registryKey = this;
        registryKey.getClass();
        return registryKey.new RegistryValueEnumerator(this);
    }

    public void export(PrintWriter out, boolean descend) throws NoSuchKeyException, RegistryException {
        out.println("[" + this.getFullName() + "]");
        Enumeration enume = this.valueElements();
        int idx = 0;
        while (enume.hasMoreElements()) {
            String valueName = (String)enume.nextElement();
            RegistryValue value = this.getValue(valueName);
            value.export(out);
            ++idx;
        }
        out.println("");
        if (descend) {
            enume = this.keyElements();
            idx = 0;
            while (enume.hasMoreElements()) {
                String keyName = (String)enume.nextElement();
                RegistryKey subKey = this.openSubKey(keyName);
                subKey.export(out, descend);
                subKey.closeKey();
                ++idx;
            }
        }
    }

    class RegistryKeyEnumerator
    implements Enumeration {
        RegistryKey key;
        int currIndex;
        int numSubKeys;

        public RegistryKeyEnumerator(RegistryKey key) throws RegistryException {
            this.key = key;
            this.currIndex = 0;
            this.numSubKeys = key.getNumberSubkeys();
        }

        public boolean hasMoreElements() {
            return this.currIndex < this.numSubKeys;
        }

        public Object nextElement() {
            String result = null;
            try {
                result = this.key.regEnumKey(this.currIndex++);
            }
            catch (RegistryException ex) {
                throw new NoSuchElementException(ex.getMessage());
            }
            return result;
        }
    }

    class RegistryValueEnumerator
    implements Enumeration {
        RegistryKey key;
        int currIndex;
        int numValues;

        public RegistryValueEnumerator(RegistryKey key) throws RegistryException {
            this.key = key;
            this.currIndex = 0;
            this.numValues = key.getNumberValues();
        }

        public boolean hasMoreElements() {
            return this.currIndex < this.numValues;
        }

        public Object nextElement() {
            String result = null;
            try {
                result = this.key.regEnumValue(this.currIndex++);
            }
            catch (RegistryException ex) {
                throw new NoSuchElementException(ex.getMessage());
            }
            return result;
        }
    }
}

