/*
 * Decompiled with CFR 0.152.
 */
package appletrpc;

import appletrpc.RPCParameter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import wiseoa.Encoding;
import wiseoa.mail.jstl.System_BaseInfo;
import wiseoa.util.FF;

public abstract class RemoteCaller
extends HttpServlet {
    public int getTimeout(String funcname, RPCParameter param) {
        return 7200;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpServletRequest request = req;
        HttpServletResponse response = res;
        request.setCharacterEncoding("UTF-8");
        FF.setResponseContentType((HttpServletResponse)response);
        RPCParameter ret = new RPCParameter();
        try {
            try {
                GZIPInputStream gs = new GZIPInputStream((InputStream)req.getInputStream());
                ObjectInputStream p = new ObjectInputStream(new BufferedInputStream(gs));
                RPCParameter param = (RPCParameter)p.readObject();
                param.putRequestAndRequest(req, res);
                String funcName = (String)p.readObject();
                p.close();
                if (funcName == null) {
                    throw new Exception("\u8bf7\u6307\u5b9a\u51fd\u6570\u540d");
                }
                Class[] paracs = new Class[1];
                RPCParameter[] params = new RPCParameter[1];
                paracs[0] = Class.forName("appletrpc.RPCParameter");
                params[0] = param;
                Method m = ((Object)((Object)this)).getClass().getMethod(funcName, paracs);
                ExecutorService executor = Executors.newSingleThreadExecutor();
                FutureStatement futureCmd = new FutureStatement(m, (Object)this, params);
                Future future = executor.submit(futureCmd);
                int timeout = this.getTimeout(funcName, param);
                try {
                    try {
                        ret = timeout > 0 ? (RPCParameter)future.get(timeout, TimeUnit.SECONDS) : (RPCParameter)future.get();
                    }
                    catch (InterruptedException e) {
                        future.cancel(true);
                        throw e;
                    }
                    catch (ExecutionException e) {
                        future.cancel(true);
                        throw e;
                    }
                    catch (TimeoutException e) {
                        RemoteCaller.print(String.valueOf(FF.Get_yyyyMMdd_HHmm_FormatedDate((Object)new Date())) + ":" + ((Object)((Object)this)).getClass().getName() + "." + funcName + "\u6267\u884c\u8d85\u65f6((RemoteCaller Timeout=" + timeout + " \uff0c\u7cfb\u7edf\u5f3a\u5236\u7ec8\u6b62");
                        future.cancel(true);
                        throw new Exception(String.valueOf(funcName) + "\u6267\u884c\u8d85\u65f6");
                    }
                }
                finally {
                    executor.shutdown();
                }
            }
            catch (Exception e) {
                ret.Success = false;
                ret.ErrorText = e.getMessage();
                GZIPOutputStream gos = new GZIPOutputStream((OutputStream)res.getOutputStream());
                ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(gos));
                os.writeObject(ret);
                os.flush();
                gos.close();
            }
        }
        finally {
            GZIPOutputStream gos = new GZIPOutputStream((OutputStream)res.getOutputStream());
            ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(gos));
            os.writeObject(ret);
            os.flush();
            gos.close();
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public static void print(Object obj) {
        if (obj == null) {
            obj = "null";
        }
        String logFile = String.valueOf(System_BaseInfo.GetFileRoot()) + "/logs/timeoutLog/" + FF.date2String((Object)new Date(), (String)"yyyy-MM-dd") + ".txt";
        RemoteCaller.print(logFile, obj);
    }

    public static void print(String logFile, Object obj) {
        if (obj == null) {
            obj = "null";
        }
        FF.log((Object)obj);
        if (obj instanceof Exception) {
            FF.SaveToFile((String)logFile, (String)(" ===\u53d1\u751f\u5f02\u5e38==== " + obj.getClass().getName()), (boolean)true);
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(new File(Encoding.FileName4ReadWrite((String)logFile)), true));
                ((Exception)obj).printStackTrace(ps);
                ps.flush();
                ps.close();
            }
            catch (Exception exception) {}
        } else {
            FF.SaveToFile((String)logFile, (String)obj.toString(), (boolean)true);
        }
    }

    class FutureStatement
    implements Callable {
        private Method method;
        private Object owner;
        private RPCParameter[] params;

        public FutureStatement(Method method, Object owner, RPCParameter[] params) {
            this.method = method;
            this.owner = owner;
            this.params = params;
        }

        public Object call() throws Exception {
            RPCParameter ret = (RPCParameter)this.method.invoke(this.owner, (Object[])this.params);
            return ret;
        }
    }
}

