/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JFrame;

public class SoundRec
extends JFrame
implements WindowListener,
ActionListener,
ItemListener {
    boolean freeTrial;
    boolean debug = false;
    protected boolean running;
    ByteArrayOutputStream out;
    AudioInputStream ais;
    AudioFormat format;
    String audioFmt;
    boolean signed = true;
    boolean bigEndian = true;
    int sampleRate = 22050;
    int sampleSizeInBits = 16;
    int channels = 1;
    String formatStr = "WAV";
    TargetDataLine line;
    SourceDataLine sourceLine;
    Label writeMessage;
    Label fTrial = new Label("www.imageviewer.co.uk");
    Label saveLabel = new Label("Save as: ");
    TextField save = new TextField("myfile");
    boolean playPressed = false;
    boolean stopPressed = false;
    boolean recordPressed = false;
    DecimalFormat df = new DecimalFormat("00");
    DecimalFormat df2 = new DecimalFormat("00,000,000");
    long msecCurrent;
    long msecElapsed;
    int minElapsed;
    Date date = new Date();
    long msecStart;
    Button capture = new Button("Record");
    Button stop = new Button("Stop");
    Button record = new Button("Save");
    Button play = new Button("Play");
    Choice formatChoice = new Choice();
    Choice hertz = new Choice();
    Choice bits = new Choice();
    Choice chanel = new Choice();
    Panel northPanel = new Panel();
    Panel centerPanel = new Panel();
    Panel southPanel = new Panel();

    public SoundRec() {
        this.setTitle("Java Sound Recorder");
        this.formatChoice.add("WAV");
        this.formatChoice.add("AU");
        this.formatChoice.add("AIFF");
        this.formatChoice.add("SND");
        this.formatChoice.select("WAV");
        this.hertz.add("8000");
        this.hertz.add("11025");
        this.hertz.add("12000");
        this.hertz.add("16000");
        this.hertz.add("22050");
        this.hertz.add("24000");
        this.hertz.add("32000");
        this.hertz.add("44100");
        this.hertz.add("48000");
        this.hertz.select("22050");
        this.bits.add("8");
        this.bits.add("16");
        this.bits.select("16");
        this.chanel.add("Stereo");
        this.chanel.add("Mono");
        this.chanel.select("Mono");
        this.capture.setEnabled(true);
        this.stop.setEnabled(false);
        this.play.setEnabled(false);
        this.record.setEnabled(false);
        this.capture.addActionListener(this);
        this.northPanel.add(this.capture);
        this.stop.addActionListener(this);
        this.northPanel.add(this.stop);
        this.play.addActionListener(this);
        this.northPanel.add(this.play);
        this.formatChoice.addItemListener(this);
        this.northPanel.add(this.formatChoice);
        this.hertz.addItemListener(this);
        this.northPanel.add(this.hertz);
        this.bits.addItemListener(this);
        this.northPanel.add(this.bits);
        this.chanel.addItemListener(this);
        this.northPanel.add(this.chanel);
        this.record.addActionListener(this);
        this.northPanel.add(this.record);
        this.add((Component)this.northPanel, "North");
        this.centerPanel.add(this.saveLabel);
        this.centerPanel.add(this.save);
        this.save.setBackground(Color.white);
        this.saveLabel.setFont(new Font("Monospaced", 1, 14));
        this.saveLabel.setForeground(new Color(0, 255, 0));
        this.writeMessage = new Label();
        this.centerPanel.add(this.writeMessage);
        this.writeMessage.setText("           Java Sound Recorder                ");
        this.add((Component)this.centerPanel, "Center");
        this.setBackground(new Color(0, 0, 128));
        this.capture.setBackground(Color.black);
        this.capture.setForeground(new Color(0, 255, 0));
        this.stop.setBackground(Color.black);
        this.stop.setForeground(new Color(0, 255, 0));
        this.play.setBackground(Color.black);
        this.play.setForeground(new Color(0, 255, 0));
        this.record.setBackground(Color.black);
        this.record.setForeground(new Color(0, 255, 0));
        this.writeMessage.setFont(new Font("Monospaced", 1, 14));
        this.writeMessage.setForeground(new Color(0, 255, 0));
        this.addWindowListener(this);
        this.add((Component)this.southPanel, "South");
        this.fTrial.setFont(new Font("Serif", 2, 12));
        this.fTrial.setForeground(Color.cyan);
        this.setBounds(100, 100, 585, 130);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public void actionPerformed(ActionEvent actionevent) {
        if (actionevent.getSource() == this.capture) {
            this.capture.setEnabled(false);
            this.stop.setEnabled(true);
            this.play.setEnabled(false);
            this.captureAudio();
        }
        if (actionevent.getSource() == this.stop) {
            this.capture.setEnabled(true);
            this.stop.setEnabled(false);
            this.play.setEnabled(true);
            this.record.setEnabled(true);
            this.running = false;
            this.stopPressed = true;
            this.playPressed = false;
        }
        if (actionevent.getSource() == this.play) {
            this.stop.setEnabled(true);
            this.playAudio();
            this.stopPressed = false;
        }
        if (actionevent.getSource() == this.record) {
            this.recordAudio();
        }
    }

    public void itemStateChanged(ItemEvent itemevent) {
        if (itemevent.getSource() == this.formatChoice) {
            String s;
            this.formatStr = s = this.formatChoice.getSelectedItem();
            if (this.debug) {
                System.out.println("formatListener(): " + this.formatStr);
            }
        }
        if (itemevent.getSource() == this.hertz) {
            String s1 = this.hertz.getSelectedItem();
            this.sampleRate = Integer.parseInt(s1);
            if (this.debug) {
                System.out.println("hertzListener(): " + this.sampleRate);
            }
        }
        if (itemevent.getSource() == this.bits) {
            String s2 = this.bits.getSelectedItem();
            this.sampleSizeInBits = Integer.parseInt(s2);
            if (this.debug) {
                System.out.println("bitsListener(): " + this.sampleSizeInBits);
            }
        }
        if (itemevent.getSource() == this.chanel) {
            String s3 = this.chanel.getSelectedItem();
            this.channels = s3.equals("Stereo") ? 2 : 1;
            if (this.debug) {
                System.out.println("chanelListener(): " + this.channels);
            }
        }
    }

    public void windowClosing(WindowEvent windowevent) {
        this.dispose();
    }

    public void windowOpened(WindowEvent windowevent) {
    }

    public void windowIconified(WindowEvent windowevent) {
    }

    public void windowDeiconified(WindowEvent windowevent) {
    }

    public void windowActivated(WindowEvent windowevent) {
    }

    public void windowDeactivated(WindowEvent windowevent) {
    }

    public void windowClosed(WindowEvent windowevent) {
    }

    void captureAudio() {
        this.writeMessage.setText("           Java Sound Recorder                ");
        try {
            this.format = this.getFormat();
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.format);
            if (this.line != null) {
                this.line.close();
            }
            try {
                this.line = (TargetDataLine)AudioSystem.getLine(info);
                this.line.open(this.format);
                this.line.start();
            }
            catch (IllegalArgumentException illegalargumentexception) {
                this.writeMessage.setText("Unknown Format.");
                if (this.debug) {
                    System.err.println("Unknown Format: " + illegalargumentexception);
                }
                return;
            }
            this.date = new Date();
            this.msecStart = this.date.getTime();
            Runnable runnable = new Runnable(){
                int bufferSize;
                byte[] buffer;
                {
                    this.bufferSize = (int)SoundRec.this.format.getSampleRate() * SoundRec.this.format.getFrameSize();
                    this.buffer = new byte[this.bufferSize];
                }

                public void run() {
                    int i = 0;
                    SoundRec.this.out = new ByteArrayOutputStream();
                    SoundRec.this.running = true;
                    try {
                        while (SoundRec.this.running) {
                            int j = SoundRec.this.line.read(this.buffer, 0, this.buffer.length);
                            if (j <= 0) continue;
                            SoundRec.this.out.write(this.buffer, 0, j);
                            SoundRec.this.msecCurrent = new Date().getTime();
                            SoundRec.this.msecElapsed = SoundRec.this.msecCurrent - SoundRec.this.msecStart;
                            SoundRec.this.writeMessage.setText("Bytes: " + SoundRec.this.df2.format(this.bufferSize * ++i) + " - Time: " + SoundRec.this.df.format(SoundRec.this.msecElapsed / 1000L / 60L) + ":" + SoundRec.this.df.format(SoundRec.this.msecElapsed / 1000L % 60L));
                        }
                        SoundRec.this.out.close();
                        SoundRec.this.writeMessage.setText("Finished recording. ");
                        return;
                    }
                    catch (IOException ioexception) {
                        SoundRec.this.writeMessage.setText("I/O problems: ");
                        if (SoundRec.this.debug) {
                            System.err.println("I/O problems: " + ioexception);
                        }
                        return;
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            return;
        }
        catch (LineUnavailableException lineunavailableexception) {
            this.writeMessage.setText("Line unavailable: ");
            if (this.debug) {
                System.err.println("Line unavailable: " + lineunavailableexception);
            }
            return;
        }
    }

    private void playAudio() {
        try {
            if (this.playPressed) {
                return;
            }
            this.playPressed = true;
            this.writeMessage.setText("Now playing ... ");
            byte[] abyte0 = this.out.toByteArray();
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
            AudioFormat final_audioformat = this.getFormat();
            try {
                this.ais = new AudioInputStream(bytearrayinputstream, final_audioformat, abyte0.length / final_audioformat.getFrameSize());
            }
            catch (Exception exception) {
                this.writeMessage.setText("Unknown Format: ");
                if (this.debug) {
                    System.err.println("Unknown Format: " + exception);
                }
                return;
            }
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, final_audioformat);
            if (this.sourceLine != null) {
                this.sourceLine.close();
            }
            this.sourceLine = (SourceDataLine)AudioSystem.getLine(info);
            this.sourceLine.open(final_audioformat);
            this.sourceLine.start();
            this.date = new Date();
            this.msecStart = this.date.getTime();
            Runnable runnable = new Runnable(final_audioformat){
                int bufferSize;
                byte[] buffer;
                {
                    this.bufferSize = (int)audioFormat.getSampleRate() * audioFormat.getFrameSize();
                    this.buffer = new byte[this.bufferSize];
                }

                public void run() {
                    int i = 0;
                    try {
                        int j;
                        while ((j = SoundRec.this.ais.read(this.buffer, 0, this.buffer.length)) != -1) {
                            if (SoundRec.this.stopPressed) {
                                SoundRec.this.stopPressed = false;
                                break;
                            }
                            if (j <= 0) continue;
                            SoundRec.this.sourceLine.write(this.buffer, 0, j);
                            SoundRec.this.msecCurrent = new Date().getTime();
                            SoundRec.this.msecElapsed = SoundRec.this.msecCurrent - SoundRec.this.msecStart;
                            SoundRec.this.writeMessage.setText("Bytes: " + SoundRec.this.df2.format(this.bufferSize * ++i) + " - Time: " + SoundRec.this.df.format(SoundRec.this.msecElapsed / 1000L / 60L) + ":" + SoundRec.this.df.format(SoundRec.this.msecElapsed / 1000L % 60L));
                        }
                        SoundRec.this.sourceLine.drain();
                        SoundRec.this.sourceLine.close();
                        SoundRec.this.playPressed = false;
                        SoundRec.this.writeMessage.setText("Finished playing. ");
                        return;
                    }
                    catch (IOException ioexception) {
                        SoundRec.this.writeMessage.setText("I/O problems: ");
                        if (SoundRec.this.debug) {
                            System.err.println("I/O problems: " + ioexception);
                        }
                        return;
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            return;
        }
        catch (LineUnavailableException _ex) {
            this.writeMessage.setText("Please close other audio device.");
            if (this.debug) {
                System.err.println("Please close other audio device.");
            }
            this.playPressed = false;
            return;
        }
    }

    private void recordAudio() {
        if (this.recordPressed) {
            return;
        }
        this.recordPressed = true;
        this.writeMessage.setText("Saving audio to file ... ");
        byte[] abyte0 = this.out.toByteArray();
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
        AudioFormat audioformat = this.getFormat();
        try {
            this.ais = new AudioInputStream(bytearrayinputstream, audioformat, abyte0.length / audioformat.getFrameSize());
        }
        catch (Exception exception) {
            this.writeMessage.setText("Unknown Format.");
            if (this.debug) {
                System.err.println("Unknown Format: " + exception);
            }
            return;
        }
        if (this.debug) {
            System.out.println("recordAudio(): sampleRate: " + this.sampleRate + " sampleSizeInBits: " + this.sampleSizeInBits + " channels: " + this.channels);
        }
        String s = "c:/" + this.save.getText().trim() + "." + this.formatStr;
        this.createAudioFile(this.ais, s);
    }

    private AudioFormat getFormat() {
        return new AudioFormat(this.sampleRate, this.sampleSizeInBits, this.channels, this.signed, this.bigEndian);
    }

    public void createAudioFile(AudioInputStream audioinputstream, String s) {
        if (this.debug) {
            System.out.println("createAudioFile(): " + s);
        }
        StringTokenizer stringtokenizer = new StringTokenizer(s, ".");
        stringtokenizer.nextToken();
        String s1 = stringtokenizer.nextToken();
        AudioFileFormat.Type type = null;
        if (s1.equalsIgnoreCase("AU")) {
            type = AudioFileFormat.Type.AU;
        } else if (s1.equalsIgnoreCase("WAV")) {
            type = AudioFileFormat.Type.WAVE;
        } else if (s1.equalsIgnoreCase("AIFF")) {
            type = AudioFileFormat.Type.AIFF;
        } else if (s1.equalsIgnoreCase("SND")) {
            type = AudioFileFormat.Type.SND;
        } else {
            if (this.debug) {
                System.out.println("Could not get output type from extension \"" + s1 + "\".");
            }
            return;
        }
        try {
            AudioSystem.write(audioinputstream, type, new File(s));
            if (this.debug) {
                System.out.println("Audio stream written to file " + s);
            }
            this.writeMessage.setText("Audio saved as \"" + s + "\"");
            this.recordPressed = false;
            return;
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("I/O problems. " + exception);
            }
            this.writeMessage.setText("I/O problems. Please restart program.");
            return;
        }
    }

    public static void main(String[] args) {
        new SoundRec();
    }
}

