/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.client.ChatApplet;
import IM.client.LeftRightBorder;
import IM.client.StateBar;
import IM.client.TitleBar;
import IM.util.Tools;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SkinFrame
extends JFrame
implements ComponentListener {
    TitleBar titlePanel;
    ChatApplet chatApplet;
    Color BorderColor = new Color(28, 65, 146);
    JPanel CustomPanel = new JPanel();
    StateBar statebar;
    Dimension size = null;
    private boolean autoHide = false;
    protected BufferedImage screenShot = null;

    public SkinFrame(ChatApplet parentApplet, String title, boolean large) {
        this.captureScreenShot();
        this.chatApplet = parentApplet;
        Tools.initAllFontSon9();
        Container c = this.getContentPane();
        BorderLayout bl = new BorderLayout();
        bl.setHgap(0);
        bl.setVgap(0);
        c.setLayout(bl);
        this.titlePanel = new TitleBar(title, this, this.chatApplet);
        this.titlePanel.setBackground(this.BorderColor);
        c.add((Component)this.titlePanel, "North");
        JPanel jpMiddle = new JPanel();
        jpMiddle.setLayout(new BorderLayout());
        LeftRightBorder leftBorder = new LeftRightBorder("IM/res/skin/border_left.gif", this, this.chatApplet);
        LeftRightBorder rightBorder = new LeftRightBorder("IM/res/skin/border_right.gif", this, this.chatApplet);
        jpMiddle.add((Component)leftBorder, "West");
        jpMiddle.add((Component)rightBorder, "East");
        this.CustomPanel.setLayout(new BorderLayout());
        jpMiddle.add((Component)this.CustomPanel, "Center");
        this.setIconImage(Tools.GetImageFromURL(this.chatApplet, "IM/res/chat.gif"));
        c.add((Component)jpMiddle, "Center");
        this.statebar = new StateBar("Wisesoft", this, this.chatApplet, large);
        c.add((Component)this.statebar, "South");
        this.size = this.getSize();
        this.addComponentListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                SkinFrame.this.onMouseEntered();
            }

            public void mouseExited(MouseEvent e) {
                SkinFrame.this.onMouseExited();
            }
        });
    }

    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
    }

    public void onMouseEntered() {
        if (this.autoHide) {
            int cfr_ignored_0 = this.getLocationOnScreen().y;
        }
    }

    public void onMouseExited() {
        if (this.autoHide && this.getLocationOnScreen().y == 0) {
            this.size = this.getSize();
            Dimension d = new Dimension();
            d.width = this.size.width;
            d.height = 15;
            this.setSize(d);
        }
    }

    public void SendCommand(String cmd) {
        if (cmd == null) {
            return;
        }
        if (cmd.equals("min")) {
            this.setState(1);
            this.setExtendedState(1);
        }
        if (cmd.equals("max")) {
            if (this.getExtendedState() == 6) {
                this.setState(0);
                this.setExtendedState(0);
            } else {
                this.setExtendedState(6);
            }
        }
        if (cmd.equals("close")) {
            this.dispose();
        }
        if (cmd.equals("hide")) {
            this.hide();
        }
    }

    public void setVisible(boolean isVisible) {
        this.captureScreenShot();
        super.setVisible(isVisible);
    }

    private void captureScreenShot() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        try {
            Robot robot = new Robot();
            Rectangle rect = new Rectangle(0, 0, screenWidth, screenHeight);
            this.screenShot = robot.createScreenCapture(rect);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public void setTransparent(JComponent c, Graphics g, int x, int y, int w, int h) {
        Point p = new Point(x, y);
        SwingUtilities.convertPointToScreen(p, c);
        if (p.x + w > this.screenShot.getWidth()) {
            w = this.screenShot.getWidth() - p.x;
        }
        if (p.y + h > this.screenShot.getHeight()) {
            h = this.screenShot.getHeight() - p.y;
        }
        if (w <= 0 || h <= 0) {
            return;
        }
        BufferedImage i = this.screenShot.getSubimage(Math.max(0, p.x), Math.max(0, p.y), w, h);
        ImageIcon icon = new ImageIcon(i);
        Point p2 = new Point(Math.max(0, p.x), Math.max(0, p.y));
        SwingUtilities.convertPointFromScreen(p2, c);
        icon.paintIcon(c, g, p2.x, p2.y);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
        this.repaint();
    }

    public void componentResized(ComponentEvent e) {
        this.repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void repaint() {
        super.repaint();
        this.getContentPane().invalidate();
        this.getContentPane().validate();
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.setTransparent(this.titlePanel, g, 0, 0, 1, 4);
        this.setTransparent(this.titlePanel, g, 1, 0, 1, 2);
        this.setTransparent(this.titlePanel, g, 2, 0, 1, 1);
        int w = this.getWidth();
        this.setTransparent(this.titlePanel, g, w - 1, 0, 2, 4);
        this.setTransparent(this.titlePanel, g, w - 2, 0, 1, 2);
        this.setTransparent(this.titlePanel, g, w - 3, 0, 1, 1);
        int h = this.getHeight();
        this.setTransparent(this.titlePanel, g, 0, h - 2, 1, 2);
        this.setTransparent(this.titlePanel, g, 1, h - 1, 1, 1);
        this.setTransparent(this.titlePanel, g, w - 2, h - 1, 2, 1);
        this.setTransparent(this.titlePanel, g, w - 1, h - 2, 1, 1);
    }

    public boolean isAutoHide() {
        return this.autoHide;
    }

    public void setAutoHide(boolean autoHide) {
        this.autoHide = autoHide;
    }
}

