/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.util.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;

public class SimpleBrowser {
    private static void testDOMAPI(WebBrowser webBrowser) {
        System.out.println("===========================================================");
        System.out.println("=== Test setContent()/getContent()/executeScript() APIs ===");
        System.out.println("===========================================================");
        String HTML_CONTENT = "<html><head><script>var counter = 100;function scriptMethod() { alert('scriptMethod() within the loaded page'); }</script></head><title>Test Page for JDIC Browser Component</title><body><div id='theDiv'>This page content is set using setContent() API</div></body></html>";
        System.out.println("===============================");
        System.out.println("=== To test executeScript() ===");
        System.out.println("===============================");
        String jscript = "alert(\"alert 'statement' test\");document.bgColor='blue';";
        String result = webBrowser.executeScript(jscript);
        System.out.println("Execution of: " + jscript + " returns: " + result);
        System.out.println("============================");
        System.out.println("=== To test getContent() ===");
        System.out.println("============================");
        String content = webBrowser.getContent();
        System.out.println("getContent() returns: " + content);
        System.out.println("============================");
        System.out.println("=== To test setContent() ===");
        System.out.println("============================");
        System.out.println("To setContent(): " + HTML_CONTENT);
        webBrowser.setContent(HTML_CONTENT);
        jscript = "scriptMethod();";
        System.out.println("Execute JavaScript method within the current page ...");
        result = webBrowser.executeScript(jscript);
        String retContent = webBrowser.getContent();
        System.out.println("getContent() returns: " + retContent);
        if (retContent != null && retContent.length() == HTML_CONTENT.length()) {
            System.out.println("=== SUCCEED: getContent() correctly returns the content set by setContent() !!!");
        } else {
            System.out.println("=== ERROR: getContent() doesn't return the content set by setContent() ???");
        }
    }

    public static void main(String[] args) {
        WebBrowser.setDebug((boolean)true);
        JFrame frame = new JFrame("JDIC API Demo - SimpleBrowser");
        frame.setDefaultCloseOperation(2);
        WebBrowser webBrowser = new WebBrowser();
        webBrowser.addWebBrowserListener(new WebBrowserListener(){
            boolean isFirstPage = true;

            public void initializationCompleted(WebBrowserEvent arg0) {
            }

            public void windowClose(WebBrowserEvent arg0) {
            }

            public void downloadStarted(WebBrowserEvent event) {
            }

            public void downloadCompleted(WebBrowserEvent event) {
            }

            public void downloadProgress(WebBrowserEvent event) {
            }

            public void downloadError(WebBrowserEvent event) {
            }

            public void documentCompleted(WebBrowserEvent event) {
            }

            public void titleChange(WebBrowserEvent event) {
            }

            public void statusTextChange(WebBrowserEvent event) {
            }
        });
        Tools.ShowInfo(frame, "aa");
        try {
            webBrowser.setURL(new URL("http://zengjun3:8080/wiseoa"));
        }
        catch (Exception e) {
            Tools.ShowInfo(frame, e.getMessage());
            return;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setPreferredSize(new Dimension(700, 500));
        panel.add((Component)webBrowser, "Center");
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
    }
}

