/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.client.ChatApplet;
import IM.client.ChatForm;
import IM.util.Tools;
import IM.util.ZDataParser;
import appletrpc.RPCParameter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jun.db.impl.DataStoreFactory;

public class SendFileTask
extends Thread {
    String FullName;
    String FileName;
    int SendToWhom;
    String guid;
    ChatForm CF;
    private volatile boolean Halted = false;
    long IgnoreSize = 0L;
    public static final int FileIDLen = 4096;

    public SendFileTask(String ffn, String fn, int towhom, ChatForm cf) {
        this.CF = cf;
        this.guid = DataStoreFactory.newGUID();
        this.FullName = ffn;
        this.FileName = fn;
        this.SendToWhom = towhom;
    }

    public void run() {
        int once = ChatApplet.FileBlockSize;
        byte[] buffer = new byte[once];
        try {
            System.out.println("\u5f00\u59cb\u4f20\u6587\u4ef6");
            File theFile = new File(this.FullName);
            FileInputStream fis = new FileInputStream(theFile);
            long fileSize = theFile.length();
            ZDataParser zdp = new ZDataParser();
            zdp.put("guid", this.guid);
            zdp.put("filename", this.FullName);
            zdp.put("lastmodified", theFile.lastModified());
            zdp.put("filesize", fileSize);
            zdp.put("over", 0);
            byte[] tempB = zdp.toString().getBytes();
            if (tempB.length > 4096) {
                throw new Exception("\u6587\u4ef6\u8def\u5f84\u592a\u957f\uff0c\u65e0\u6cd5\u4f20\u8f93");
            }
            byte[] fileID = new byte[4096];
            int i = 0;
            while (i < fileID.length) {
                fileID[i] = 0;
                ++i;
            }
            i = 0;
            while (i < tempB.length) {
                fileID[i] = tempB[i];
                ++i;
            }
            boolean readOver = false;
            long hadRead = 0L;
            Date startTime = new Date();
            long timeCost = 0L;
            fis.skip(this.IgnoreSize);
            while (!readOver && !this.isHalted()) {
                int actually = fis.read(buffer);
                if (actually <= 0) {
                    readOver = true;
                    break;
                }
                String servletURL = String.valueOf(this.CF.chatApplet.HomeURL) + "servlet/IM.server.FileTransfer";
                URL url = new URL(servletURL);
                URLConnection urlcon = url.openConnection();
                urlcon.setRequestProperty("Content-Type", "application/octet-stream");
                urlcon.setDoOutput(true);
                urlcon.setUseCaches(false);
                BufferedOutputStream bos = new BufferedOutputStream(new GZIPOutputStream(urlcon.getOutputStream()));
                bos.write(fileID);
                bos.write(buffer, 0, actually);
                int percent = (int)(((hadRead += (long)actually) + this.IgnoreSize) * 100L / fileSize);
                timeCost = (new Date().getTime() - startTime.getTime()) / 1000L;
                if (timeCost <= 0L) {
                    timeCost = 1L;
                }
                String speed = String.valueOf(Tools.FileSize(hadRead / timeCost)) + "/s";
                this.CF.ShowFileTransferProgress(this.guid, percent, speed);
                bos.flush();
                bos.close();
                GZIPInputStream gs = new GZIPInputStream(urlcon.getInputStream());
                ObjectInputStream p = new ObjectInputStream(new BufferedInputStream(gs));
                RPCParameter ret = (RPCParameter)p.readObject();
                p.close();
                SendFileTask.sleep(10L);
            }
            fis.close();
            if (readOver) {
                this.SendOverSign();
            }
            if (!this.isHalted()) {
                this.CF.ShowFileTransferOver(this.guid, true, timeCost);
            }
        }
        catch (Exception e) {
            this.SendOverSign();
            System.out.println("\u53d1\u9001\u6587\u4ef6\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    public void SendOverSign() {
        ZDataParser zdp = new ZDataParser();
        zdp.put("guid", this.guid);
        zdp.put("filename", this.FullName);
        zdp.put("over", 1);
        byte[] tempB = zdp.toString().getBytes();
        byte[] fileID = new byte[4096];
        int i = 0;
        while (i < fileID.length) {
            fileID[i] = 0;
            ++i;
        }
        i = 0;
        while (i < tempB.length) {
            fileID[i] = tempB[i];
            ++i;
        }
        try {
            String servletURL = String.valueOf(this.CF.chatApplet.HomeURL) + "servlet/IM.server.FileTransfer";
            URL url = new URL(servletURL);
            URLConnection urlcon = url.openConnection();
            urlcon.setRequestProperty("Content-Type", "application/octet-stream");
            urlcon.setDoOutput(true);
            urlcon.setUseCaches(false);
            GZIPOutputStream gos = new GZIPOutputStream(urlcon.getOutputStream());
            BufferedOutputStream bos = new BufferedOutputStream(gos);
            bos.write(fileID);
            bos.flush();
            bos.close();
            GZIPInputStream gs = new GZIPInputStream(urlcon.getInputStream());
            ObjectInputStream p = new ObjectInputStream(new BufferedInputStream(gs));
            RPCParameter ret = (RPCParameter)p.readObject();
            p.close();
        }
        catch (Exception e) {
            System.out.println("\u53d1\u9001\u7ed3\u675f\u6807\u5fd7\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    public synchronized boolean isHalted() {
        return this.Halted;
    }

    public synchronized void Halt() {
        this.Halted = true;
    }
}

