/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.client.ChatApplet;
import IM.client.ChatForm;
import IM.util.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;

class PaletteGrid
extends JDialog {
    ChatApplet chatApplet;
    ChatForm pForm;
    private int selected;
    private int rows;
    private int cols;
    private int gap;
    private int margin;
    private int cellSize;
    private Color[] palette;
    private int[] levels;

    public PaletteGrid(ChatApplet applet, ChatForm cf) {
        int[] nArray = new int[6];
        nArray[1] = 51;
        nArray[2] = 102;
        nArray[3] = 153;
        nArray[4] = 204;
        nArray[5] = 255;
        this.levels = nArray;
        this.setUndecorated(true);
        this.chatApplet = applet;
        this.pForm = cf;
        this.selected = 0;
        this.gap = 4;
        this.margin = 0;
        this.cellSize = 24;
        this.cols = 4;
        this.rows = 4;
        this.cols = 18;
        this.rows = 12;
        this.cellSize = 7;
        this.gap = 0;
        this.setWebPalette();
        this.enableEvents(16L);
        this.setSize(new Dimension(18 * this.cellSize + 1, 12 * this.cellSize + 1));
        Image img = Tools.GetImageFromURL(this, "IM/res/straw.gif");
        this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(1, 14), ""));
    }

    public void setWebPalette() {
        int i = 0;
        this.palette = new Color[216];
        int j = 0;
        while (j < 6) {
            int k = 0;
            while (k < 3) {
                int i1 = 0;
                while (i1 < 6) {
                    this.palette[i++] = new Color(this.levels[j], this.levels[k], this.levels[i1]);
                    ++i1;
                }
                ++k;
            }
            ++j;
        }
        int l = 0;
        while (l < 6) {
            int j1 = 3;
            while (j1 < 6) {
                int k1 = 0;
                while (k1 < 6) {
                    this.palette[i++] = new Color(this.levels[l], this.levels[j1], this.levels[k1]);
                    ++k1;
                }
                ++j1;
            }
            ++l;
        }
    }

    public void setPalette(Color[] acolor) {
        this.palette = acolor;
        this.repaint();
    }

    public Color[] getPalette() {
        return this.palette;
    }

    public Color getColor() {
        return this.palette[this.selected];
    }

    public Color getColorAt(int i, int j) {
        int k = i * this.cols + j;
        if (k >= 0 && k < this.palette.length) {
            return this.palette[k];
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return new Dimension(2 * this.margin + this.cols * (this.cellSize + this.gap) - this.gap, 2 * this.margin + this.rows * (this.cellSize + this.gap) - this.gap);
    }

    public void paint(Graphics g) {
        int i = 0;
        while (i < this.rows) {
            int j = this.margin + i * (this.cellSize + this.gap);
            int k = 0;
            while (k < this.cols) {
                int l = this.margin + k * (this.cellSize + this.gap);
                Color color = this.getColorAt(i, k);
                if (color != null) {
                    g.setColor(color);
                    g.fillRect(l, j, this.cellSize, this.cellSize);
                    g.setColor(Color.black);
                    g.drawRect(l, j, this.cellSize, this.cellSize);
                }
                ++k;
            }
            ++i;
        }
    }

    protected void doMouseEvent(MouseEvent mouseevent) {
        int l;
        int i = mouseevent.getX();
        int j = mouseevent.getY();
        int k = (j - this.margin) / (this.cellSize + this.gap);
        Color color = this.getColorAt(k, l = (i - this.margin) / (this.cellSize + this.gap));
        if (color != null) {
            Color color1 = this.getColor();
            this.selected = k * this.cols + l;
            this.pForm.drawPanel.setForeground(this.getColor());
            this.dispose();
            this.pForm.pg = null;
        }
    }

    protected void processMouseEvent(MouseEvent mouseevent) {
        switch (mouseevent.getID()) {
            case 501: {
                this.doMouseEvent(mouseevent);
                this.enableEvents(48L);
                break;
            }
            case 502: {
                this.doMouseEvent(mouseevent);
                this.enableEvents(16L);
            }
        }
        super.processMouseEvent(mouseevent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseevent) {
        switch (mouseevent.getID()) {
            case 506: {
                this.doMouseEvent(mouseevent);
            }
        }
        super.processMouseMotionEvent(mouseevent);
    }
}

