/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JXTrayIcon
extends TrayIcon {
    private JPopupMenu menu;
    private static JDialog dialog = new JDialog(null, "TrayDialog");
    private static PopupMenuListener popupListener;

    static {
        dialog.setUndecorated(true);
        dialog.setAlwaysOnTop(true);
        popupListener = new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                dialog.setVisible(false);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                dialog.setVisible(false);
            }
        };
    }

    public JXTrayIcon(Image image) {
        super(image);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JXTrayIcon.this.showJPopupMenu(e);
            }

            public void mouseReleased(MouseEvent e) {
                JXTrayIcon.this.showJPopupMenu(e);
            }
        });
    }

    private void showJPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger() && this.menu != null) {
            Dimension size = this.menu.getPreferredSize();
            dialog.setLocation(e.getX(), e.getY() - size.height);
            dialog.setVisible(true);
            this.menu.show(dialog.getContentPane(), 0, 0);
            dialog.toFront();
        }
    }

    public JPopupMenu getJPopupMenu() {
        return this.menu;
    }

    public void setJPopupMenu(JPopupMenu menu) {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(popupListener);
        }
        this.menu = menu;
        menu.addPopupMenuListener(popupListener);
    }

    private static void createGui() {
        JXTrayIcon tray = new JXTrayIcon(JXTrayIcon.createImage());
        tray.setJPopupMenu(JXTrayIcon.createJPopupMenu());
        try {
            SystemTray.getSystemTray().add(tray);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JXTrayIcon.createGui();
            }
        });
    }

    static Image createImage() {
        BufferedImage i = new BufferedImage(32, 32, 2);
        Graphics2D g2 = (Graphics2D)i.getGraphics();
        g2.setColor(Color.RED);
        g2.fill(new Ellipse2D.Float(0.0f, 0.0f, i.getWidth(), i.getHeight()));
        g2.dispose();
        return i;
    }

    static JPopupMenu createJPopupMenu() {
        JPopupMenu m = new JPopupMenu();
        m.add(new JMenuItem("Item 1"));
        m.add(new JMenuItem("Item 2"));
        JMenu submenu = new JMenu("Submenu");
        submenu.add(new JMenuItem("item 1"));
        submenu.add(new JMenuItem("item 2"));
        submenu.add(new JMenuItem("item 3"));
        m.add(submenu);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        m.add(exitItem);
        return m;
    }
}

