/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;

public class IconMenuItem
extends JMenuItem {
    JLabel m_icon;
    JLabel m_caption;

    public IconMenuItem(String caption, ImageIcon icon, Action action) {
        this.setLayout(new BorderLayout());
        this.m_icon = new JLabel(icon);
        this.m_caption = new JLabel(caption);
        this.setToolTipText(caption.trim());
        this.add((Component)this.m_icon, "West");
        this.add((Component)this.m_caption, "Center");
        if (action != null) {
            this.addActionListener(action);
        }
        this.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!IconMenuItem.this.getEnabled()) {
                    return;
                }
                IconMenuItem.this.m_caption.setForeground(Color.black);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (!IconMenuItem.this.getEnabled()) {
                    return;
                }
                this.mouseExited(e);
            }

            public void mouseEntered(MouseEvent e) {
                if (!IconMenuItem.this.getEnabled()) {
                    return;
                }
                IconMenuItem.this.m_caption.setForeground(Color.white);
            }

            public void mouseExited(MouseEvent e) {
                if (!IconMenuItem.this.getEnabled()) {
                    return;
                }
                IconMenuItem.this.m_caption.setForeground(Color.black);
            }
        });
    }

    public void setText(String text) {
        if (this.m_caption != null) {
            this.m_caption.setText(text);
        }
        this.setToolTipText(text.trim());
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.m_caption.setEnabled(b);
        this.m_icon.setEnabled(b);
        if (!b) {
            this.m_caption.setForeground(Color.gray);
        }
        if (b) {
            this.m_caption.setForeground(Color.black);
        }
    }

    public boolean getEnabled() {
        return this.isEnabled();
    }
}

