/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.util.Tools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class DrawPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int LINES = 0;
    public static final int POINTS = 1;
    int mode = 1;
    Vector lines = new Vector();
    Vector colors = new Vector();
    int x1;
    int y1;
    int x2;
    int y2;

    public DrawPanel() {
        this.setBackground(Color.white);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        Image img = Tools.GetImageFromURL(this, "IM/res/pen.gif");
        this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(7, 0), ""));
    }

    public void Clear() {
        this.lines.clear();
        this.colors.clear();
        this.repaint();
    }

    public void setDrawMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        e.consume();
        switch (this.mode) {
            case 0: {
                this.x2 = e.getX();
                this.y2 = e.getY();
                break;
            }
            default: {
                this.colors.addElement(this.getForeground());
                this.lines.addElement(new Rectangle(this.x1, this.y1, e.getX(), e.getY()));
                this.x1 = e.getX();
                this.y1 = e.getY();
            }
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        e.consume();
        switch (this.mode) {
            case 0: {
                this.x1 = e.getX();
                this.y1 = e.getY();
                this.x2 = -1;
                break;
            }
            default: {
                this.colors.addElement(this.getForeground());
                this.lines.addElement(new Rectangle(e.getX(), e.getY(), -1, -1));
                this.x1 = e.getX();
                this.y1 = e.getY();
                this.repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        e.consume();
        switch (this.mode) {
            case 0: {
                this.colors.addElement(this.getForeground());
                this.lines.addElement(new Rectangle(this.x1, this.y1, e.getX(), e.getY()));
                this.x2 = -1;
                break;
            }
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void paint(Graphics g) {
        this.paint(g, true);
    }

    public void paint(Graphics g, boolean drawBorder) {
        int np = this.lines.size();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.getForeground());
        int i = 0;
        while (i < np) {
            Rectangle p = (Rectangle)this.lines.elementAt(i);
            g.setColor((Color)this.colors.elementAt(i));
            if (p.width != -1) {
                g.drawLine(p.x, p.y, p.width, p.height);
            } else {
                g.drawLine(p.x, p.y, p.x, p.y);
            }
            ++i;
        }
        if (this.mode == 0) {
            g.setColor(this.getForeground());
            if (this.x2 != -1) {
                g.drawLine(this.x1, this.y1, this.x2, this.y2);
            }
        }
        if (drawBorder) {
            this.paintBorder(g);
        }
    }

    public byte[] ExportToImage() {
        byte[] ret = null;
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics graphics = img.getGraphics();
        this.paint(graphics, false);
        try {
            try {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(bo);
                ImageIO.write((RenderedImage)img, "png", bos);
                bos.flush();
                bos.close();
                ret = bo.toByteArray();
            }
            catch (Exception e) {
                ret = null;
                graphics.dispose();
            }
        }
        finally {
            graphics.dispose();
        }
        return ret;
    }
}

